//*@@@+++@@@@******************************************************************
//
// Microsoft Windows Media
// Copyright (C) Microsoft Corporation. All rights reserved.
//
//*@@@---@@@@******************************************************************
/*
 ***********************************************************************
 * Copyright 2005-2010 by Freescale Semiconductor, Inc.
 * All modifications are confidential and proprietary information
 * of Freescale Semiconductor, Inc.
 ***********************************************************************
 */
#include "asf.h"
#include "rawio.h"
//#include "preset.h"
#ifdef NETWORK_OUT
#include "network_info.h"
#include "rawip.h"
#endif
#include <time.h>
#ifdef UNDER_CE
#include "Winbase.h"
#endif
//#include "macros.h"
//extern U32 WMAE_packet_byte_length;
//extern I32 g_asf_packet_size;
//extern I32 g_asf_payload_length;
const struct netasf_tag {
  //  char networkpad[28];
  asf_header_type asf_header;
} netasfh =

{
  {
    { // Header Object
      { ASF_GUID_HEADER_OBJECT,  	/*Obj GUID */
        ASF_8( sizeof( struct s_asf_header_type )
             - sizeof( struct s_data_obj ) ) },/*Obj Size */
      5,0,0,0,				/* # of Header Objs */
      1,				/* Reserved 1 */
      2,				/* Reserved 2 */
    },

    { // File Properties Object
      { ASF_GUID_PREFIX_file_header,  	/*Obj GUID */
        ASF_8( sizeof( struct s_file_obj ) ) },  /*Obj Size */
      ASF_FILE_ID,              	/* File ID */
      0,0,0,0,0,0,0,0,			/* file_size */
      128,55,212,18,22,128,147,0, 	/* creation_time   Here just chose one arbitrary date_time*/
      7,0,0,0,0,0,0,0,			/* num_packets */
      0,0,0,0,0,0,0,0,     		/* play duration  */
      0,0,0,0,0,0,0,0,	        	/* send duration */
      0,0,0,0,0,0,0,0,			/* preroll = 0 */
      2,0,0,0,				/* flags bit 1-broadcast, 2-seekable */
      0x78,5,0,0,			/* min_packet_size = 1400 */
      0x78,5,0,0,			/* max_packet_size = 1400 */
      0,0,0,0x0,			/* max_bitrate */
    },

    { // Stream Properites Object
      { ASF_GUID_STREAM_PROP_OBJECT,	    /* Obj GUID */
        ASF_8( sizeof( struct s_stream_obj ) ) },  /* Obj Size */
      ASF_GUID_STREAM_PROP_OBJECT_TYPE, /* Stream type (Audio)   I made change here --Wei*/
      ASF_GUID_ERROR_CORRECT_OBJECT,    /* concealment   I changed from no Correction to Audio_Spread --Wei*/
      0,0,0,0,0,0,0,0,		        /* time offset */
      28,0,0,0,			        /* type specific data size =  */
      8,0,0,0,                          /* Error Correction Data Length */
      1,0,		        	/* stream_number0 = 1,  */
      0,0,0,0,			        /* reserved */

      { /* Audio media type      Inside stream properties obj */
	97,1,                          /* Codec ID / Format tag   = WAVE_FORMAT_WMAUDIO2 */
	0,0,			       /* Number of channels */
	0,0,0,0,		       /* Samples Per Second */
	0,0,0,0,		       /* Bytes Per Second  */
	0,0,			       /* Block Alignment   */
	0,0,			       /* Bits per Sample */
	10,0,                	       /* Codec Specific Data Size*/
	0,0,0,0,            	       /* Samples Per Block */
	0,0,			       /* Encode Options   */
	0,0,0,0,		       /* Super Block Alignment */
      },

      {	/* Error Correction Data: Spread Audio  Inside stream properties obj */
	1,		               /* number of packets audio spreads over =1 */
	0,0,                           /* Virtual Packet Length */
	0,0,                	       /* Virtual Chunk Length  */
	1,0,	                       /* Silence Data lenght =1 */
	0,                             /* Silence Data */
      },
    },

    { // Header Extension Object (this useless but mandatory)
      { ASF_Header_ExtentionObject,     /*Obj GUID */
        ASF_8( sizeof( struct s_ext_obj ) ) },/*Obj Size */
      ASF_GUID_Reserved1,
      6,0,				/* 2bytes shall be set to 6 */
      0,0,0,0,			        /* extention data size */
    },

    { // Codec List Object
      { ASF_GUID_CODEC_LIST_OBJECT,       /*Obj GUID */
        ASF_8( sizeof( struct s_codec_obj ) ) },/*Obj Size */
      ASF_CODEC_LIST_Reserved,            /* Reserved */
      1,0,0,0,				  /* Number of Entries */
      2,0,			          /* Codec Type =2 */
      26, 0x00,                         /* Codec Name Length =25 *2 bytes*/
      { 0 /*ASF_CODEC_NAME*/ },                     /* "W i n d o w s   M e d i a   A u d i o   V 8   " */

      26, 0x00,                         /* Codec Description Length = 26 *2 bytes */
      { 0 /*ASF_CODEC_DESCRIP*/ },                  /* "1 4 0   k b p s ,   4 4   k H z ,   s t e r e o   " */

      0x02, 0x00,                         /* Codec Information Length =2*/
      0x61, 0x01,                         /* Codec Information */
    },

    { // Content Description Object
      { ASF_GUID_CONT_DESC_OBJECT,                   /* Obj GUID */
        ASF_8( sizeof( struct s_cont_desc_obj ) ) }, /* Obj Size */
        ASF_2(0),                                    /* Title length */
        ASF_2(0),                                    /* Author length */
        ASF_2(0),                                    /* Copyright length */
        ASF_2(0),                                    /* Description length */
        ASF_2(0),                                    /* Rating length */
    },

    { // Data Object
      { ASF_GUID_DATA_OBJECT,    	/* Obj GUID */
	0, },            /* Obj Size  = sizeof(Data Obj Header) + numberof(packet) * sizeof(packet)*/
      ASF_FILE_ID,                      /* Should be the same as fileh.streamid */
      0,0,0,0,0,0,0,0,		        /* number of data packets, not need for broadcast */
      1,1,			        /* reserved the value shall be 0x11 */
    },
  },
};

//Int media_offset=0;
//I64 asf_packet_count=0;
//unsigned char wma_packet_id=1;
//I64 wma_packet_count=0;

//int nAudioSampleperSec;
//Int nMaxBitRate;
//I64 nSendTime=0;
//I16 nDuration;

//extern  U32 g_space_in_packet;
//unsigned char *pasfpackh;
extern RawFileIO *pRawOutput;
//extern int rlc_count, invq_count, diff_count;

//extern word *g_wszTitle;        // Cont Desc: Title
//extern word *g_wszAuthor;       // Cont Desc: Author
//extern word *g_wszCopyright;    // Cont Desc: Copyright
//extern word *g_wszDescription;  // Cont Desc: Description
//extern word *g_wszRating;       // Cont Desc: Rating

//extern word g_cTitle;              // length of Title
//extern word g_cAuthor;             // length of Author
//extern word g_cCopyright;          // length of Copyright
//extern word g_cDescription;        // length of Description
//extern word g_cRating;             // length of Rating

//I64 nAudioDelayBuffer = 3000;
//I64 presentation_time=  3000;
//I64 nAudioSamplesDone=0;
//I64 nAudioSamplesperSec_inv=97391548;   // 0.32 format 1000/44100  (sampling rate 44.1kHz)
//FILE * fp1;

//void sturctSizeInfo()
//{
//    printf("s_asf_header_type: %d\n", sizeof( struct s_asf_header_type ));
//    printf("s_data_obj: %d\n", sizeof( struct s_data_obj ));
//    printf("s_file_obj: %d\n", sizeof( struct s_file_obj ));
//    printf("s_stream_obj: %d\n", sizeof( struct s_stream_obj ));
//    printf("s_ext_obj: %d\n", sizeof( struct s_ext_obj ));
//    printf("s_codec_obj: %d\n", sizeof( struct s_codec_obj ));
//    printf("s_cont_desc_obj: %d\n", sizeof( struct s_cont_desc_obj ));
//}


void *ASF_MemCopy(void *pDest, const void *pSrc, size_t count)
{
	size_t iCount;

	char *pDestination = (char*) pDest;

	char *pSource = (char*) pSrc;

	for(iCount=0; iCount<count; iCount++)
	{
		pDestination[iCount] = pSource[iCount];
	}

	return pDest;
}

static void charStr2WordStr(word PACKED *pDst, char *pSrc)
{
    ASF_INT32 i=0;

    while(pSrc[i] != '\0')
    {
        pDst[i] = (word)pSrc[i];
        i++;
    }
    pDst[i] = (word)'\0';
}

void add_asf_header(ASFParams *pAsfParams, ASF_INT16 padding_length, ASF_INT32 nAudioSamplesDone, unsigned char* asf_payload_addr)
{
  ASF_UINT32 nPacketLength = pAsfParams->WMAE_packet_byte_length;

  // asf_pkt_header is pointing to the destination packet where the header should be written
  //asf_packet_header_type* asf_pkt_header = (asf_packet_header_type*) (asf_payload_addr-ASF_HEADER);
  asf_packet_header_type* asf_pkt_header = (asf_packet_header_type*) (asf_payload_addr);
  asf_pkt_header->error_corr_flags   = 0x82;  	/* Error Corr Flags: 0x82 (Err Corr Presents, Correction Data Length=2) */
  asf_pkt_header->error_corr_data[0] = 0x00;  	/* Correction Data: 1st byte : 0 */
  asf_pkt_header->error_corr_data[1] = 0x00;  	/* Correction Data: (No correction)  2nd byte: 0 */
  asf_pkt_header->length_type_flags = 0x10;   	/* Lenght Type Flages: 0x10  00010000  No packet len ; No Sequ type; Padding length in 2 bytes */
  asf_pkt_header->property_flags = 0x5d;	/* Property Flags  */
  asf_pkt_header->stream_id = 1;		/* Stream ID               */
  asf_pkt_header->replicated_len = 8;		/* Replicated Data Length  */

  asf_pkt_header->media_obj_id=pAsfParams->wma_packet_id;
  ASFPUT4(&asf_pkt_header->pres_time,pAsfParams->presentation_time);
  ASFPUT2(&asf_pkt_header->padding_length,padding_length);
  ASFPUT4(&asf_pkt_header->media_obj_size,nPacketLength);
  ASFPUT2(&asf_pkt_header->duration,pAsfParams->nDuration);
  ASFPUT4(&asf_pkt_header->send_time,(ASF_INT32)pAsfParams->nSendTime);
  ASFPUT4(&asf_pkt_header->offset,pAsfParams->media_offset);

  pAsfParams->asf_packet_count++;
}

qword get_asf_file_header_size ( asf_header_type *pasfh )
{
    // Note that the 'len' fields in all objects (except the header object
    // should be set correctly before calling this function.
    qword file_len, stream_len,ext_len,codec_len,cont_desc_len;
    ASF_MemCopy (&file_len,(const void *)&pasfh->file_obj.fheader.len,sizeof(qword));
    ASF_MemCopy (&stream_len,(const void *)&pasfh->stream_obj.sheader.len,sizeof(qword));
    ASF_MemCopy (&ext_len,(const void *)&pasfh->ext_obj.extheader.len,sizeof(qword));
    ASF_MemCopy (&codec_len,(const void *)&pasfh->codec_obj.codecheader.len,sizeof(qword));
    ASF_MemCopy (&cont_desc_len,(const void *)&pasfh->cont_desc_obj.contdescheader.len,sizeof(qword));
    return sizeof(pasfh->header_obj)+file_len+stream_len+ext_len+codec_len+cont_desc_len;
    //return sizeof (pasfh->header_obj) +
    //       pasfh->file_obj.fheader.len +
    //       pasfh->stream_obj.sheader.len +
    //       pasfh->ext_obj.extheader.len +
    //       pasfh->codec_obj.codecheader.len +
    //       pasfh->cont_desc_obj.contdescheader.len;
}
/*
word get_cont_desc_obj_size ( asf_header_type *pasfh )
{
    return sizeof (pasfh->cont_desc_obj) +
                  (g_cTitle + g_cAuthor + g_cCopyright
                  + g_cDescription + g_cRating ) * sizeof( word );
}
*/
//extern I64 g_nAudioDelaySizeMs;

void write_asf_file_header ( ASFParams *pAsfParams,asf_header_type *pasfh )
{

    qword file_len,stream_len,ext_len,codec_len;

    rfioSeek(pRawOutput,0,0);

    // Write the header object
    rfioWrite(pRawOutput, (ASF_UINT8*)&(pasfh->header_obj), sizeof(pasfh->header_obj) );

    // Write the file object
    ASF_MemCopy(&file_len,(const void *)&pasfh->file_obj.fheader.len,sizeof(qword));

    rfioWrite(pRawOutput, (ASF_UINT8*)&(pasfh->file_obj), (int) file_len);

    // Write the stream object
    ASF_MemCopy(&stream_len,(const void *)&pasfh->stream_obj.sheader.len,sizeof(qword));

    rfioWrite(pRawOutput, (ASF_UINT8*)&(pasfh->stream_obj), (int) stream_len);

    // Write the header extension object
    ASF_MemCopy(&ext_len,(const void *)&pasfh->ext_obj.extheader.len,sizeof(qword));

    rfioWrite(pRawOutput, (ASF_UINT8*)&(pasfh->ext_obj), (int) ext_len);

    // Write the codec list object
    ASF_MemCopy(&codec_len,(const void *)&pasfh->codec_obj.codecheader.len,sizeof(qword));

    rfioWrite(pRawOutput, (ASF_UINT8*)&(pasfh->codec_obj), (int) codec_len);

    // Write the content description object
    rfioWrite(pRawOutput, (ASF_UINT8*)&(pasfh->cont_desc_obj), sizeof(pasfh->cont_desc_obj) );

    // There is a check in rfioWrite for NULL source pointers, so no harm if
    // any of the content description fields are not specified.

    rfioWrite(pRawOutput, (ASF_UINT8*)pAsfParams->g_wszTitle, pasfh->cont_desc_obj.title_len);

    rfioWrite(pRawOutput, (ASF_UINT8*)pAsfParams->g_wszAuthor, pasfh->cont_desc_obj.author_len);

    rfioWrite(pRawOutput, (ASF_UINT8*)pAsfParams->g_wszCopyright, pasfh->cont_desc_obj.copyright_len);

    rfioWrite(pRawOutput, (ASF_UINT8*)pAsfParams->g_wszDescription, pasfh->cont_desc_obj.description_len);

    rfioWrite(pRawOutput, (ASF_UINT8*)pAsfParams->g_wszRating, pasfh->cont_desc_obj.rating_len);

    // Write the data object
    rfioWrite(pRawOutput, (ASF_UINT8*)&(pasfh->data_obj), sizeof(pasfh->data_obj) );

#ifdef DEBUG_DUMP
    {
        extern FILE *fAsf;
        I32 i;
        U8 *temp = (ASF_UINT8*)&(pasfh->header_obj);

        fprintf(fAsf, "header_obj:\n");
        for(i=0; i<sizeof(pasfh->header_obj); i++)
            fprintf(fAsf, "%x\n", temp[i]);

        temp = (ASF_UINT8*)&(pasfh->file_obj);

        fprintf(fAsf, "file_obj:\n");
        for(i=0; i<pasfh->file_obj.fheader.len; i++)
            fprintf(fAsf, "%x\n", temp[i]);

        temp = (ASF_UINT8*)&(pasfh->stream_obj);

        fprintf(fAsf, "stream_obj:\n");
        for(i=0; i<pasfh->stream_obj.sheader.len; i++)
            fprintf(fAsf, "%x\n", temp[i]);

        temp = (ASF_UINT8*)&(pasfh->ext_obj);

        fprintf(fAsf, "ext_obj:\n");
        for(i=0; i<pasfh->ext_obj.extheader.len; i++)
            fprintf(fAsf, "%x\n", temp[i]);

        temp = (ASF_UINT8*)&(pasfh->codec_obj);

        fprintf(fAsf, "codec_obj:\n");
        for(i=0; i<pasfh->codec_obj.codecheader.len; i++)
            fprintf(fAsf, "%x\n", temp[i]);

        temp = (ASF_UINT8*)&(pasfh->cont_desc_obj);

        fprintf(fAsf, "cont_desc_obj:\n");
        for(i=0; i<sizeof(pasfh->cont_desc_obj); i++)
            fprintf(fAsf, "%x\n", temp[i]);

        temp = (ASF_UINT8*)g_wszTitle;

        fprintf(fAsf, "g_wszTitle:\n");
        for(i=0; i<pasfh->cont_desc_obj.title_len; i++)
            fprintf(fAsf, "%x\n", temp[i]);

        temp = (ASF_UINT8*)g_wszAuthor;

        fprintf(fAsf, "g_wszAuthor:\n");
        for(i=0; i<pasfh->cont_desc_obj.author_len; i++)
            fprintf(fAsf, "%x\n", temp[i]);

        temp = (ASF_UINT8*)g_wszCopyright;

        fprintf(fAsf, "g_wszCopyright:\n");
        for(i=0; i<pasfh->cont_desc_obj.copyright_len; i++)
            fprintf(fAsf, "%x\n", temp[i]);

        temp = (ASF_UINT8*)g_wszDescription;

        fprintf(fAsf, "g_wszDescription:\n");
        for(i=0; i<pasfh->cont_desc_obj.description_len; i++)
            fprintf(fAsf, "%x\n", temp[i]);

        temp = (ASF_UINT8*)g_wszRating;

        fprintf(fAsf, "g_wszRating:\n");
        for(i=0; i<pasfh->cont_desc_obj.rating_len; i++)
            fprintf(fAsf, "%x\n", temp[i]);

        temp = (ASF_UINT8*)&(pasfh->data_obj);

        fprintf(fAsf, "data_obj:\n");
        for(i=0; i<sizeof(pasfh->data_obj); i++)
            fprintf(fAsf, "%x\n", temp[i]);
    }
#endif
}
#ifdef UNDER_CE
   extern void* alloc_align (int size);
   extern void free_Aligned(void *ptr);
#endif
ASFRESULTS add_asf_file_header (ASFParams *pAsfParams)
{
  //asf_header_type *pasfh = &netasfh.asf_header;
  asf_header_type *pasfh = &pAsfParams->asf_header;
  ASFFormatInfo *pFormat = &pAsfParams->pFormat;
  ASF_INT32 nMaxPacket = pAsfParams->g_asf_packet_size;
  ASF_INT32 nMinPacket = pAsfParams->g_asf_packet_size;
  //  Int nBlockAlign=ASF_PAYLOAD_LENGTH;

  ASF_UINT32 nBlockAlign = pAsfParams->WMAE_packet_byte_length;
  ASF_UINT32 nWmaPacket  = pAsfParams->WMAE_packet_byte_length;

  ASF_INT16   cont_desc_object_len;
  qword asf_file_header_len;

  short nBitsPerSample=8*sizeof(short);
#ifdef NETWORK_OUT
  unsigned char aucDatagram [RAWIP_NETIF_MAXPKTSIZE];		// send to network packet instead of file
#endif
  if(pAsfParams == NULL)
  {
    return cASF_BadArgument;
  }

  ASF_MemCopy(pasfh,&netasfh.asf_header,sizeof(asf_header_type));

  pAsfParams->media_offset=0;
  pAsfParams->asf_packet_count=0;
  pAsfParams->wma_packet_id=1;
  pAsfParams->wma_packet_count=0;

  pAsfParams->nAudioSampleperSec = 0;
  pAsfParams->nMaxBitRate = 0;
  pAsfParams->nSendTime=0;
  pAsfParams->nDuration =0;
  pAsfParams->nAudioSamplesDone = 0;

  //pAsfParams->WMAE_isPacketReady = 0;
  //pAsfParams->g_pulTimeCurr = 0;

  //pAsfParams->pPacketInput = NULL;

  pAsfParams->g_asf_payload_length  = pAsfParams->WMAE_packet_byte_length/ASF_PER_WMA;
  pAsfParams->g_asf_packet_size	  = pAsfParams->g_asf_payload_length+ASF_HEADER;
  pAsfParams->g_space_in_packet	  = pAsfParams->g_asf_payload_length;

  nMaxPacket = pAsfParams->g_asf_packet_size;
  nMinPacket = pAsfParams->g_asf_packet_size;

  pAsfParams->nAudioDelayBuffer = pFormat->nAudioDelaySizeMs;
  pAsfParams->presentation_time = pAsfParams->nAudioDelayBuffer;

  pAsfParams->nAudioSampleperSec= pFormat->nSamplesPerSec;
  pAsfParams->nMaxBitRate=pFormat->nAvgBytesPerSec * 8;

  ASFPUT8 (&pasfh->file_obj.preroll,pAsfParams->nAudioDelayBuffer);
  ASFPUT4 (&pasfh->file_obj.min_packet_size,(ASF_INT32)nMinPacket);
  ASFPUT4 (&pasfh->file_obj.max_packet_size,(ASF_INT32)nMaxPacket);
  ASFPUT4 (&pasfh->file_obj.max_bitrate,(ASF_INT32)pAsfParams->nMaxBitRate);

  ASFPUT2 (&pasfh->stream_obj.audio_media.channel_num,pFormat->nChannels);
  ASFPUT4 (&pasfh->stream_obj.audio_media.samples_per_sec,pFormat->nSamplesPerSec);
  ASFPUT4 (&pasfh->stream_obj.audio_media.bytes_per_sec,pFormat->nAvgBytesPerSec);
  ASFPUT2 (&pasfh->stream_obj.audio_media.block_alignment,(ASF_INT32)nBlockAlign);
  ASFPUT2 (&pasfh->stream_obj.audio_media.bits_per_sample,nBitsPerSample);
  ASFPUT4 (&pasfh->stream_obj.audio_media.samples_per_block,(ASF_INT32)pFormat->nSamplesPerFrame*18);
  ASFPUT2 (&pasfh->stream_obj.audio_media.encode_options,pFormat->wEncodeOptions);
  ASFPUT4 (&pasfh->stream_obj.audio_media.super_block_align,(ASF_INT32)nWmaPacket);
  ASFPUT2 (&pasfh->stream_obj.spread_audio.virtual_packet_len,(ASF_INT16)nWmaPacket);
  ASFPUT2 (&pasfh->stream_obj.spread_audio.virtual_chunk_len,(ASF_INT16)nWmaPacket);
//  ASFPUT2 (&pasfh->stream_obj.spread_audio.silence_data_len,(I16)nWmaPacket);

  ASFPUT2 (&pasfh->cont_desc_obj.title_len, (word)(pAsfParams->g_cTitle * sizeof(word)) );
  ASFPUT2 (&pasfh->cont_desc_obj.author_len, (word)(pAsfParams->g_cAuthor * sizeof(word)) );
  ASFPUT2 (&pasfh->cont_desc_obj.copyright_len, (word)(pAsfParams->g_cCopyright * sizeof(word)) );
  ASFPUT2 (&pasfh->cont_desc_obj.description_len, (word)(pAsfParams->g_cDescription * sizeof(word)) );
  ASFPUT2 (&pasfh->cont_desc_obj.rating_len, (word)(pAsfParams->g_cRating * sizeof(word)) );
  //cont_desc_object_len = get_cont_desc_obj_size( pasfh );
  cont_desc_object_len = (word)(sizeof (pasfh->cont_desc_obj) +
                  (pAsfParams->g_cTitle + pAsfParams->g_cAuthor + pAsfParams->g_cCopyright
                  + pAsfParams->g_cDescription + pAsfParams->g_cRating ) * sizeof( word ));
  ASFPUT2 (&pasfh->cont_desc_obj.contdescheader.len, cont_desc_object_len );

  // Add the codec list object
  charStr2WordStr(pasfh->codec_obj.codec_name, ASF_CODEC_NAME);
  charStr2WordStr(pasfh->codec_obj.codec_descript, ASF_CODEC_DESCRIP);

  asf_file_header_len = get_asf_file_header_size ( pasfh );
  ASFPUT8 (&pasfh->header_obj.header.len, asf_file_header_len);
  pasfh->header_obj.cno[0] = 5; // 5 objects
#ifdef NETWORK_OUT
  // [RV] try to remove this ASF_MemCopy by writing directly to aucDatagram
  ASF_MemCopy((unsigned char*) (aucDatagram+RAWIP_IP_HDRLEN_BYTES+RAWIP_DATAGRAM_HDRLEN_BYTES), (unsigned char*) pasfh,sizeof(struct s_asf_header_type));
  rawip_datagram_send (DSTIPADDR, PORTID, PORTID, aucDatagram, sizeof(struct s_asf_header_type), 0);
#else
  // PushRawData((U8*)pasfh,sizeof(struct s_asf_header_type));
  write_asf_file_header( pAsfParams,pasfh );
#endif
  return cASF_NoErr;
}

//extern U32 nSize,nSR;

// NB: only called for file based asf (i.e. not for streaming)

ASFRESULTS update_asf_file_header(ASFParams *pAsfParams,ASF_UINT32 kbps,ASF_UINT32 kHz,ASF_UINT32 ch,ASF_UINT16 nBlockAlign,ASF_INT32 cFrameSize)
{
    ASF_INT64 mult_const = 10000L;
    ASF_INT64 nTotalSendTime;
    ASF_INT64 nTotalPlayDuration;
#ifdef UNDER_CE
    LPTIME_ZONE_INFORMATION lpTimeZoneInformation;
#endif
    time_t timeCurrent;
    ASF_INT64 creationTime;
    ASF_INT32 nSamples;
    ASF_INT8 codec_descript[26*2];

    asf_header_type *pasfh = &pAsfParams->asf_header;

    ASF_INT64 nFileSize=rfioTell(pRawOutput);

    if(pAsfParams == NULL)
    {
      return cASF_BadArgument;
    }

    //assert( 1000 > kbps && 100 > kHz && 3 > ch );

    // careful with this string - it could overflow the buffer if you change it!
#if 0
    sprintf( codec_descript, "%3i kbps, %2i kHz, %s ",
             kbps, kHz, ( 1 == ch ) ? ( "mono" ) : ( "stereo" ) );
#else
	{
		//sprintf( codec_descript, "%3i kbps, %2i kHz, %s ",
		//            kbps, kHz, ( 1 == ch ) ? ( "mono" ) : ( "stereo" ) );
		char x1[8],x2[8];
		int t_kbps,t_kHz;
		int i = 0,j = 0;
		int k = 0,m = 0, n=0;
		t_kbps = kbps;
		t_kHz  = kHz;
       		while((t_kbps/10)!=0)
		{
			x1[i] = (char)(t_kbps%10);
			t_kbps /=10;
			i++;
		}
		x1[i] = t_kbps%10;
		m = i;

		while((t_kHz/10)!=0)
		{
			x2[j] = (char)(t_kHz%10);
			t_kHz /=10;
			j++;
		}
		x2[j] = t_kHz%10;
		n = j;
		if(ch == 1)
		{
			codec_descript[k] = ' ';
			k++;
		}
		while(m>=0)
		{
			codec_descript[k] = x1[m] +'0';
			m--;
			k++;
		}
		codec_descript[k] = ' ';
		k++;
		codec_descript[k] = 'k';
		k++;
		codec_descript[k] = 'b';
		k++;
		codec_descript[k] = 'p';
		k++;
		codec_descript[k] = 's';
		k++;
		codec_descript[k] = ',';
		k++;
		codec_descript[k] = ' ';
		k++;
		while(n>=0)
		{
			codec_descript[k] = x2[n] +'0';
			n--;
			k++;
		}
		codec_descript[k] = ' ';
		k++;
		codec_descript[k] = 'k';
		k++;
		codec_descript[k] = 'H';
		k++;
		codec_descript[k] = 'z';
		k++;
		codec_descript[k] = ',';
		k++;
		codec_descript[k] = ' ';
		k++;
		if(ch == 1)
		{
			codec_descript[k] = 'm';
			k++;
			codec_descript[k] = 'o';
			k++;
			codec_descript[k] = 'n';
			k++;
			codec_descript[k] = 'o';
			k++;
			codec_descript[k] = ' ';
			k++;
		}
		else
		{
			codec_descript[k] = 's';
			k++;
			codec_descript[k] = 't';
			k++;
			codec_descript[k] = 'e';
			k++;
			codec_descript[k] = 'r';
			k++;
			codec_descript[k] = 'e';
			k++;
			codec_descript[k] = 'o';
			k++;
			codec_descript[k] = ' ';
			k++;
		}
		codec_descript[k] = '\0';

	}
#endif
    charStr2WordStr(pasfh->codec_obj.codec_descript, codec_descript);

#ifndef LITTLE_ENDIAN
    // this is to change to little-endian on big-endian machines
    _swab( pasfh->codec_obj.codec_name    , pasf->codec_obj.codec_name    , 26*2 );
    _swab( pasfh->codec_obj.codec_descript, pasf->codec_obj.codec_descript, 26*2 );
#endif

    //Compute send time from size of wavefile encoded.
    nSamples = (pAsfParams->nSize + nBlockAlign - 1) / nBlockAlign; // round up
    nSamples = (nSamples + cFrameSize - 1)/cFrameSize * cFrameSize; // round up
    pAsfParams->nSendTime = ((ASF_INT64)nSamples*1000 + pAsfParams->nSR - 1)/(ASF_INT64)pAsfParams->nSR; // round up
#ifdef DEBUG_DUMP
    printf("%d\n",nSendTime);
#endif
    nTotalSendTime = (ASF_INT64)(pAsfParams->nSendTime) * mult_const;
    nTotalPlayDuration = (ASF_INT64)(nTotalSendTime) + mult_const * pAsfParams->nAudioDelayBuffer;
    ASFPUT8(&pasfh->file_obj.send_duration,nTotalSendTime);
    ASFPUT8(&pasfh->file_obj.play_duration,nTotalPlayDuration);
    ASFPUT8(&pasfh->file_obj.file_size,nFileSize);
    ASFPUT8(&pasfh->file_obj.num_packets,pAsfParams->asf_packet_count);
    // nFileSize -= (sizeof(struct s_asf_header_type) - sizeof(struct s_data_obj));
    nFileSize -= get_asf_file_header_size( pasfh );
    ASFPUT8(&pasfh->data_obj.num_data_packets,pAsfParams->asf_packet_count);
    ASFPUT8(&pasfh->data_obj.dataheader.len, nFileSize );

    // Update creation time
#ifndef UNDER_CE
   time(&timeCurrent);         // Gets seconds since 1/1/1970
#else

   lpTimeZoneInformation = alloc_align(sizeof(TIME_ZONE_INFORMATION ));
   GetTimeZoneInformation( lpTimeZoneInformation );
   timeCurrent = lpTimeZoneInformation->Bias;
   free_Aligned(lpTimeZoneInformation);
#endif
	creationTime = (ASF_INT64)timeCurrent;
	creationTime += 11644473600; // num seconds between 1/1/1601 and 1/1/1970
    creationTime *= 10000000;    // convert to 100s of nano seconds
    ASFPUT8(&pasfh->file_obj.creation_time, creationTime);

    // rfioSeek(pRawOutput,0,0);
    // rfioWrite(pRawOutput,(U8*)pasfh,sizeof(struct s_asf_header_type));
    write_asf_file_header(pAsfParams, pasfh );

    return cASF_NoErr;
}



//void asf_packetize(ASFParams *pAsfParams,char *outBuf)
ASFRESULTS asf_packetize (ASFParams *pAsfParams,ASF_INT8 *RawInput, ASF_INT8 *asfOutBuf,ASF_Bool WMAE_isPacketReady,ASF_INT32 WMAE_nEncodeSamplesDone)
{
  //CVarBitrateOutBuf* pvbb = &pauenc->m_vbbOut;
  //CVarBitrateOutBuf* pvbb = &pAsfParams->m_vbbOut;
  ASF_UINT32 nPacketLength = pAsfParams->WMAE_packet_byte_length;
  ASF_INT16 pad;
  ASF_INT32 dst=0;
  ASF_UINT8  *src;

  if(pAsfParams == NULL || RawInput == NULL ||asfOutBuf == NULL || WMAE_nEncodeSamplesDone <0)
  {
    return cASF_BadArgument;
  }

  if(WMAE_isPacketReady == ASF_TRUE)
  {
     ASF_UINT32  bytes_to_send = pAsfParams->WMAE_packet_byte_length;
     // src = (U8*)pvbb->m_pbOutputHead;
     src = (ASF_UINT8 *)asfOutBuf;

     pAsfParams->nAudioSamplesDone += WMAE_nEncodeSamplesDone;

     if (pAsfParams->wma_packet_count == 0)
        pAsfParams->nDuration = (unsigned short) ((ASF_INT64)nPacketLength  *  8000 /(ASF_INT64) pAsfParams->nMaxBitRate);
     else
        pAsfParams->nSendTime+=pAsfParams->nDuration;



     dst +=ASF_HEADER;  	/* make room for header */

      pAsfParams->media_offset=0;
      pad=0;


    while( bytes_to_send > 0 )
  	{
  	  if( bytes_to_send >= pAsfParams->g_space_in_packet )
  	    {
  	      add_asf_header( pAsfParams,0,(ASF_INT32)pAsfParams->nAudioSamplesDone, src); /* full packet */
  	      ASF_MemCopy((ASF_UINT8 *)(src+ASF_HEADER),RawInput,pAsfParams->g_space_in_packet);
          PushRawData((ASF_UINT8*)src,pAsfParams->g_space_in_packet+ASF_HEADER);
          //PushRawData((U8*)src-ASF_HEADER,pAsfParams->g_space_in_packet+ASF_HEADER);

  	      //dst=store_line(dst, src, g_space_in_packet, (int *)dmaflag);
  	      //	  *dmaflag = dma_move1D(dst, src, g_space_in_packet);
  	      dst += pAsfParams->g_space_in_packet;
  	      src += pAsfParams->g_space_in_packet;
  	      pAsfParams->media_offset += pAsfParams->g_asf_payload_length;
  	      //  asf_header=dst;	/* more bytes to store  */
  	      dst +=ASF_HEADER;		/* make room for header */

  	      bytes_to_send -= pAsfParams->g_space_in_packet;

  	    }
  	  else
  	    {
  	      pad = (ASF_INT16)( pAsfParams->g_space_in_packet - bytes_to_send );
  	      add_asf_header(pAsfParams,pad,(ASF_INT32)pAsfParams->nAudioSamplesDone, src);
  	      //PushRawData((U8*)src-ASF_HEADER,pAsfParams->g_space_in_packet+ASF_HEADER);
  	      ASF_MemCopy((ASF_UINT8 *)(src+ASF_HEADER),RawInput,pAsfParams->g_space_in_packet);
          PushRawData((ASF_UINT8*)src,pAsfParams->g_space_in_packet+ASF_HEADER);

          /* this is just padding */
  	      dst +=pad;
  	      bytes_to_send -= pAsfParams->g_space_in_packet;

  	    }
  	}

      pAsfParams->wma_packet_id++;
      pAsfParams->wma_packet_count++;

      pAsfParams->presentation_time  = ((ASF_INT64)pAsfParams->nAudioSamplesDone * 1000) / pAsfParams->nAudioSampleperSec;
      pAsfParams->presentation_time +=  (ASF_INT64)pAsfParams->nAudioDelayBuffer;


     // pvbb->m_pulTimeOutput++;
     // pvbb->m_pbOutputHead += nPacketLength;
     // if (pvbb->m_pbOutputHead == pvbb->m_pbBufTail)
    //	{
    //	  pvbb->m_pulTimeOutput = pvbb->m_pulTimeHead;
    //	  pvbb->m_pbOutputHead = pvbb->m_pbBufHead; //rotating buffer -> 2)
    //	}

  }
#if 0

  while(pvbb->m_pbOutputHead!=pvbb->m_pbPacketHeadCurr)
    {
     ASF_UINT32  bytes_to_send = pAsfParams->WMAE_packet_byte_length;
      src = (ASF_UINT8*)pvbb->m_pbOutputHead;

      pAsfParams->nAudioSamplesDone += *pvbb->m_pulTimeOutput;

  if (pAsfParams->wma_packet_count == 0)
      pAsfParams->nDuration = (unsigned short) ((ASF_INT64)nPacketLength  *  8000 /(ASF_INT64) nMaxBitRate);
  else
      pAsfParams->nSendTime+=pAsfParams->nDuration;

     dst +=ASF_HEADER;  	/* make room for header */

      pAsfParams->media_offset=0;
      pad=0;

    while( bytes_to_send > 0 )
	{
	  if( bytes_to_send >= pAsfParams->g_space_in_packet )
	    {
	      add_asf_header( pAsfParams,0,(ASF_INT32)pAsfParams->nAudioSamplesDone, src); /* full packet */
	      PushRawData((U8*)src-ASF_HEADER,pAsfParams->g_space_in_packet+ASF_HEADER);

	      //dst=store_line(dst, src, g_space_in_packet, (int *)dmaflag);
	      //	  *dmaflag = dma_move1D(dst, src, g_space_in_packet);
	      dst += pAsfParams->g_space_in_packet;
	      src += pAsfParams->g_space_in_packet;
	      pAsfParams->media_offset += pAsfParams->g_asf_payload_length;
	      //  asf_header=dst;	/* more bytes to store  */
	      dst +=ASF_HEADER;		/* make room for header */

	      bytes_to_send -= pAsfParams->g_space_in_packet;

	    }
	  else
	    {
	      pad = (ASF_INT16)( pAsfParams->g_space_in_packet - bytes_to_send );
	      add_asf_header(pAsfParams, pad,(I32)pAsfParams->nAudioSamplesDone, src);
	      PushRawData((U8*)src-ASF_HEADER,pAsfParams->g_space_in_packet+ASF_HEADER);
	      /* this is just padding */
	      dst +=pad;
	      bytes_to_send -= pAsfParams->g_space_in_packet;
	    }
	}

      pAsfParams->wma_packet_id++;
      pAsfParams->wma_packet_count++;

      presentation_time  = ((ASF_INT64)pAsfParams->nAudioSamplesDone * 1000) / pAsfParams->nAudioSampleperSec;
      presentation_time +=  (ASF_INT64)pAsfParams->nAudioDelayBuffer;

      pvbb->m_pulTimeOutput++;
      pvbb->m_pbOutputHead += nPacketLength;
      if (pvbb->m_pbOutputHead == pvbb->m_pbBufTail)
	{
	  pvbb->m_pulTimeOutput = pvbb->m_pulTimeHead;
	  pvbb->m_pbOutputHead = pvbb->m_pbBufHead; //rotating buffer -> 2)
	}
#if(defined VERBOSE && defined LEVEL1)
 //     fprintf(stderr, "*-----------Up to Frame--------*%d", pauenc->pau->m_iFrameNumber-1);
//      fprintf(stderr, " rlc_count = %d, invq = %d, diff_invq= %d\n",rlc_count,invq_count,diff_count);
#endif //(defined VERBOSE && defined LEVEL1)
    }
#endif
  return cASF_NoErr;
}







