//*@@@+++@@@@******************************************************************
//
// Microsoft Windows Media
// Copyright (C) Microsoft Corporation. All rights reserved.
//
//*@@@---@@@@******************************************************************

#ifndef _EXCT_POW_TBL_H
#define _EXCT_POW_TBL_H

#define c_ExctPowSigBits 11
#define c_ExctPowExpSize 32



const U16 g_rgiExctPow_040Man[ 1 << c_ExctPowSigBits ] =
{
	0x0000,	0x000c,	0x0019,	0x0026,	0x0033,	0x003f,	0x004c,	0x0059,
	0x0066,	0x0073,	0x007f,	0x008c,	0x0099,	0x00a6,	0x00b2,	0x00bf,
	0x00cc,	0x00d9,	0x00e5,	0x00f2,	0x00ff,	0x010b,	0x0118,	0x0125,
	0x0132,	0x013e,	0x014b,	0x0158,	0x0164,	0x0171,	0x017e,	0x018b,
	0x0197,	0x01a4,	0x01b1,	0x01bd,	0x01ca,	0x01d7,	0x01e3,	0x01f0,
	0x01fd,	0x0209,	0x0216,	0x0222,	0x022f,	0x023c,	0x0248,	0x0255,
	0x0262,	0x026e,	0x027b,	0x0287,	0x0294,	0x02a1,	0x02ad,	0x02ba,
	0x02c7,	0x02d3,	0x02e0,	0x02ec,	0x02f9,	0x0305,	0x0312,	0x031f,
	0x032b,	0x0338,	0x0344,	0x0351,	0x035d,	0x036a,	0x0376,	0x0383,
	0x0390,	0x039c,	0x03a9,	0x03b5,	0x03c2,	0x03ce,	0x03db,	0x03e7,
	0x03f4,	0x0400,	0x040d,	0x0419,	0x0426,	0x0432,	0x043f,	0x044b,
	0x0458,	0x0464,	0x0471,	0x047d,	0x048a,	0x0496,	0x04a3,	0x04af,
	0x04bb,	0x04c8,	0x04d4,	0x04e1,	0x04ed,	0x04fa,	0x0506,	0x0513,
	0x051f,	0x052b,	0x0538,	0x0544,	0x0551,	0x055d,	0x0569,	0x0576,
	0x0582,	0x058f,	0x059b,	0x05a7,	0x05b4,	0x05c0,	0x05cd,	0x05d9,
	0x05e5,	0x05f2,	0x05fe,	0x060a,	0x0617,	0x0623,	0x062f,	0x063c,
	0x0648,	0x0655,	0x0661,	0x066d,	0x067a,	0x0686,	0x0692,	0x069e,
	0x06ab,	0x06b7,	0x06c3,	0x06d0,	0x06dc,	0x06e8,	0x06f5,	0x0701,
	0x070d,	0x071a,	0x0726,	0x0732,	0x073e,	0x074b,	0x0757,	0x0763,
	0x076f,	0x077c,	0x0788,	0x0794,	0x07a0,	0x07ad,	0x07b9,	0x07c5,
	0x07d1,	0x07de,	0x07ea,	0x07f6,	0x0802,	0x080f,	0x081b,	0x0827,
	0x0833,	0x083f,	0x084c,	0x0858,	0x0864,	0x0870,	0x087c,	0x0889,
	0x0895,	0x08a1,	0x08ad,	0x08b9,	0x08c5,	0x08d2,	0x08de,	0x08ea,
	0x08f6,	0x0902,	0x090e,	0x091b,	0x0927,	0x0933,	0x093f,	0x094b,
	0x0957,	0x0963,	0x096f,	0x097c,	0x0988,	0x0994,	0x09a0,	0x09ac,
	0x09b8,	0x09c4,	0x09d0,	0x09dc,	0x09e9,	0x09f5,	0x0a01,	0x0a0d,
	0x0a19,	0x0a25,	0x0a31,	0x0a3d,	0x0a49,	0x0a55,	0x0a61,	0x0a6d,
	0x0a79,	0x0a85,	0x0a92,	0x0a9e,	0x0aaa,	0x0ab6,	0x0ac2,	0x0ace,
	0x0ada,	0x0ae6,	0x0af2,	0x0afe,	0x0b0a,	0x0b16,	0x0b22,	0x0b2e,
	0x0b3a,	0x0b46,	0x0b52,	0x0b5e,	0x0b6a,	0x0b76,	0x0b82,	0x0b8e,
	0x0b9a,	0x0ba6,	0x0bb2,	0x0bbe,	0x0bca,	0x0bd6,	0x0be2,	0x0bee,
	0x0bf9,	0x0c05,	0x0c11,	0x0c1d,	0x0c29,	0x0c35,	0x0c41,	0x0c4d,
	0x0c59,	0x0c65,	0x0c71,	0x0c7d,	0x0c89,	0x0c95,	0x0ca1,	0x0cac,
	0x0cb8,	0x0cc4,	0x0cd0,	0x0cdc,	0x0ce8,	0x0cf4,	0x0d00,	0x0d0c,
	0x0d17,	0x0d23,	0x0d2f,	0x0d3b,	0x0d47,	0x0d53,	0x0d5f,	0x0d6a,
	0x0d76,	0x0d82,	0x0d8e,	0x0d9a,	0x0da6,	0x0db2,	0x0dbd,	0x0dc9,
	0x0dd5,	0x0de1,	0x0ded,	0x0df9,	0x0e04,	0x0e10,	0x0e1c,	0x0e28,
	0x0e34,	0x0e3f,	0x0e4b,	0x0e57,	0x0e63,	0x0e6f,	0x0e7a,	0x0e86,
	0x0e92,	0x0e9e,	0x0ea9,	0x0eb5,	0x0ec1,	0x0ecd,	0x0ed9,	0x0ee4,
	0x0ef0,	0x0efc,	0x0f08,	0x0f13,	0x0f1f,	0x0f2b,	0x0f37,	0x0f42,
	0x0f4e,	0x0f5a,	0x0f65,	0x0f71,	0x0f7d,	0x0f89,	0x0f94,	0x0fa0,
	0x0fac,	0x0fb8,	0x0fc3,	0x0fcf,	0x0fdb,	0x0fe6,	0x0ff2,	0x0ffe,
	0x1009,	0x1015,	0x1021,	0x102c,	0x1038,	0x1044,	0x104f,	0x105b,
	0x1067,	0x1072,	0x107e,	0x108a,	0x1095,	0x10a1,	0x10ad,	0x10b8,
	0x10c4,	0x10d0,	0x10db,	0x10e7,	0x10f2,	0x10fe,	0x110a,	0x1115,
	0x1121,	0x112d,	0x1138,	0x1144,	0x114f,	0x115b,	0x1167,	0x1172,
	0x117e,	0x1189,	0x1195,	0x11a1,	0x11ac,	0x11b8,	0x11c3,	0x11cf,
	0x11da,	0x11e6,	0x11f2,	0x11fd,	0x1209,	0x1214,	0x1220,	0x122b,
	0x1237,	0x1242,	0x124e,	0x125a,	0x1265,	0x1271,	0x127c,	0x1288,
	0x1293,	0x129f,	0x12aa,	0x12b6,	0x12c1,	0x12cd,	0x12d8,	0x12e4,
	0x12ef,	0x12fb,	0x1306,	0x1312,	0x131d,	0x1329,	0x1334,	0x1340,
	0x134b,	0x1357,	0x1362,	0x136e,	0x1379,	0x1385,	0x1390,	0x139b,
	0x13a7,	0x13b2,	0x13be,	0x13c9,	0x13d5,	0x13e0,	0x13ec,	0x13f7,
	0x1402,	0x140e,	0x1419,	0x1425,	0x1430,	0x143c,	0x1447,	0x1452,
	0x145e,	0x1469,	0x1475,	0x1480,	0x148b,	0x1497,	0x14a2,	0x14ae,
	0x14b9,	0x14c4,	0x14d0,	0x14db,	0x14e7,	0x14f2,	0x14fd,	0x1509,
	0x1514,	0x151f,	0x152b,	0x1536,	0x1542,	0x154d,	0x1558,	0x1564,
	0x156f,	0x157a,	0x1586,	0x1591,	0x159c,	0x15a8,	0x15b3,	0x15be,
	0x15ca,	0x15d5,	0x15e0,	0x15ec,	0x15f7,	0x1602,	0x160e,	0x1619,
	0x1624,	0x162f,	0x163b,	0x1646,	0x1651,	0x165d,	0x1668,	0x1673,
	0x167e,	0x168a,	0x1695,	0x16a0,	0x16ac,	0x16b7,	0x16c2,	0x16cd,
	0x16d9,	0x16e4,	0x16ef,	0x16fa,	0x1706,	0x1711,	0x171c,	0x1727,
	0x1733,	0x173e,	0x1749,	0x1754,	0x1760,	0x176b,	0x1776,	0x1781,
	0x178c,	0x1798,	0x17a3,	0x17ae,	0x17b9,	0x17c4,	0x17d0,	0x17db,
	0x17e6,	0x17f1,	0x17fc,	0x1808,	0x1813,	0x181e,	0x1829,	0x1834,
	0x1840,	0x184b,	0x1856,	0x1861,	0x186c,	0x1877,	0x1883,	0x188e,
	0x1899,	0x18a4,	0x18af,	0x18ba,	0x18c5,	0x18d1,	0x18dc,	0x18e7,
	0x18f2,	0x18fd,	0x1908,	0x1913,	0x191f,	0x192a,	0x1935,	0x1940,
	0x194b,	0x1956,	0x1961,	0x196c,	0x1977,	0x1983,	0x198e,	0x1999,
	0x19a4,	0x19af,	0x19ba,	0x19c5,	0x19d0,	0x19db,	0x19e6,	0x19f1,
	0x19fc,	0x1a08,	0x1a13,	0x1a1e,	0x1a29,	0x1a34,	0x1a3f,	0x1a4a,
	0x1a55,	0x1a60,	0x1a6b,	0x1a76,	0x1a81,	0x1a8c,	0x1a97,	0x1aa2,
	0x1aad,	0x1ab8,	0x1ac3,	0x1ace,	0x1ad9,	0x1ae4,	0x1aef,	0x1afa,
	0x1b05,	0x1b10,	0x1b1c,	0x1b27,	0x1b32,	0x1b3d,	0x1b48,	0x1b53,
	0x1b5d,	0x1b68,	0x1b73,	0x1b7e,	0x1b89,	0x1b94,	0x1b9f,	0x1baa,
	0x1bb5,	0x1bc0,	0x1bcb,	0x1bd6,	0x1be1,	0x1bec,	0x1bf7,	0x1c02,
	0x1c0d,	0x1c18,	0x1c23,	0x1c2e,	0x1c39,	0x1c44,	0x1c4f,	0x1c5a,
	0x1c65,	0x1c70,	0x1c7a,	0x1c85,	0x1c90,	0x1c9b,	0x1ca6,	0x1cb1,
	0x1cbc,	0x1cc7,	0x1cd2,	0x1cdd,	0x1ce8,	0x1cf2,	0x1cfd,	0x1d08,
	0x1d13,	0x1d1e,	0x1d29,	0x1d34,	0x1d3f,	0x1d4a,	0x1d54,	0x1d5f,
	0x1d6a,	0x1d75,	0x1d80,	0x1d8b,	0x1d96,	0x1da1,	0x1dab,	0x1db6,
	0x1dc1,	0x1dcc,	0x1dd7,	0x1de2,	0x1ded,	0x1df7,	0x1e02,	0x1e0d,
	0x1e18,	0x1e23,	0x1e2e,	0x1e38,	0x1e43,	0x1e4e,	0x1e59,	0x1e64,
	0x1e6e,	0x1e79,	0x1e84,	0x1e8f,	0x1e9a,	0x1ea5,	0x1eaf,	0x1eba,
	0x1ec5,	0x1ed0,	0x1edb,	0x1ee5,	0x1ef0,	0x1efb,	0x1f06,	0x1f10,
	0x1f1b,	0x1f26,	0x1f31,	0x1f3c,	0x1f46,	0x1f51,	0x1f5c,	0x1f67,
	0x1f71,	0x1f7c,	0x1f87,	0x1f92,	0x1f9c,	0x1fa7,	0x1fb2,	0x1fbd,
	0x1fc7,	0x1fd2,	0x1fdd,	0x1fe8,	0x1ff2,	0x1ffd,	0x2008,	0x2012,
	0x201d,	0x2028,	0x2033,	0x203d,	0x2048,	0x2053,	0x205d,	0x2068,
	0x2073,	0x207e,	0x2088,	0x2093,	0x209e,	0x20a8,	0x20b3,	0x20be,
	0x20c8,	0x20d3,	0x20de,	0x20e8,	0x20f3,	0x20fe,	0x2108,	0x2113,
	0x211e,	0x2128,	0x2133,	0x213e,	0x2148,	0x2153,	0x215e,	0x2168,
	0x2173,	0x217e,	0x2188,	0x2193,	0x219e,	0x21a8,	0x21b3,	0x21be,
	0x21c8,	0x21d3,	0x21dd,	0x21e8,	0x21f3,	0x21fd,	0x2208,	0x2213,
	0x221d,	0x2228,	0x2232,	0x223d,	0x2248,	0x2252,	0x225d,	0x2267,
	0x2272,	0x227d,	0x2287,	0x2292,	0x229c,	0x22a7,	0x22b1,	0x22bc,
	0x22c7,	0x22d1,	0x22dc,	0x22e6,	0x22f1,	0x22fb,	0x2306,	0x2311,
	0x231b,	0x2326,	0x2330,	0x233b,	0x2345,	0x2350,	0x235a,	0x2365,
	0x236f,	0x237a,	0x2385,	0x238f,	0x239a,	0x23a4,	0x23af,	0x23b9,
	0x23c4,	0x23ce,	0x23d9,	0x23e3,	0x23ee,	0x23f8,	0x2403,	0x240d,
	0x2418,	0x2422,	0x242d,	0x2437,	0x2442,	0x244c,	0x2457,	0x2461,
	0x246c,	0x2476,	0x2481,	0x248b,	0x2496,	0x24a0,	0x24ab,	0x24b5,
	0x24c0,	0x24ca,	0x24d4,	0x24df,	0x24e9,	0x24f4,	0x24fe,	0x2509,
	0x2513,	0x251e,	0x2528,	0x2533,	0x253d,	0x2547,	0x2552,	0x255c,
	0x2567,	0x2571,	0x257c,	0x2586,	0x2590,	0x259b,	0x25a5,	0x25b0,
	0x25ba,	0x25c5,	0x25cf,	0x25d9,	0x25e4,	0x25ee,	0x25f9,	0x2603,
	0x260d,	0x2618,	0x2622,	0x262d,	0x2637,	0x2641,	0x264c,	0x2656,
	0x2660,	0x266b,	0x2675,	0x2680,	0x268a,	0x2694,	0x269f,	0x26a9,
	0x26b3,	0x26be,	0x26c8,	0x26d3,	0x26dd,	0x26e7,	0x26f2,	0x26fc,
	0x2706,	0x2711,	0x271b,	0x2725,	0x2730,	0x273a,	0x2744,	0x274f,
	0x2759,	0x2763,	0x276e,	0x2778,	0x2782,	0x278d,	0x2797,	0x27a1,
	0x27ac,	0x27b6,	0x27c0,	0x27ca,	0x27d5,	0x27df,	0x27e9,	0x27f4,
	0x27fe,	0x2808,	0x2813,	0x281d,	0x2827,	0x2831,	0x283c,	0x2846,
	0x2850,	0x285b,	0x2865,	0x286f,	0x2879,	0x2884,	0x288e,	0x2898,
	0x28a2,	0x28ad,	0x28b7,	0x28c1,	0x28cb,	0x28d6,	0x28e0,	0x28ea,
	0x28f4,	0x28ff,	0x2909,	0x2913,	0x291d,	0x2928,	0x2932,	0x293c,
	0x2946,	0x2951,	0x295b,	0x2965,	0x296f,	0x297a,	0x2984,	0x298e,
	0x2998,	0x29a2,	0x29ad,	0x29b7,	0x29c1,	0x29cb,	0x29d5,	0x29e0,
	0x29ea,	0x29f4,	0x29fe,	0x2a08,	0x2a13,	0x2a1d,	0x2a27,	0x2a31,
	0x2a3b,	0x2a45,	0x2a50,	0x2a5a,	0x2a64,	0x2a6e,	0x2a78,	0x2a82,
	0x2a8d,	0x2a97,	0x2aa1,	0x2aab,	0x2ab5,	0x2abf,	0x2aca,	0x2ad4,
	0x2ade,	0x2ae8,	0x2af2,	0x2afc,	0x2b06,	0x2b11,	0x2b1b,	0x2b25,
	0x2b2f,	0x2b39,	0x2b43,	0x2b4d,	0x2b58,	0x2b62,	0x2b6c,	0x2b76,
	0x2b80,	0x2b8a,	0x2b94,	0x2b9e,	0x2ba8,	0x2bb3,	0x2bbd,	0x2bc7,
	0x2bd1,	0x2bdb,	0x2be5,	0x2bef,	0x2bf9,	0x2c03,	0x2c0d,	0x2c18,
	0x2c22,	0x2c2c,	0x2c36,	0x2c40,	0x2c4a,	0x2c54,	0x2c5e,	0x2c68,
	0x2c72,	0x2c7c,	0x2c86,	0x2c90,	0x2c9a,	0x2ca5,	0x2caf,	0x2cb9,
	0x2cc3,	0x2ccd,	0x2cd7,	0x2ce1,	0x2ceb,	0x2cf5,	0x2cff,	0x2d09,
	0x2d13,	0x2d1d,	0x2d27,	0x2d31,	0x2d3b,	0x2d45,	0x2d4f,	0x2d59,
	0x2d63,	0x2d6d,	0x2d77,	0x2d81,	0x2d8b,	0x2d95,	0x2d9f,	0x2da9,
	0x2db3,	0x2dbd,	0x2dc7,	0x2dd1,	0x2ddb,	0x2de5,	0x2def,	0x2df9,
	0x2e03,	0x2e0d,	0x2e17,	0x2e21,	0x2e2b,	0x2e35,	0x2e3f,	0x2e49,
	0x2e53,	0x2e5d,	0x2e67,	0x2e71,	0x2e7b,	0x2e85,	0x2e8f,	0x2e99,
	0x2ea3,	0x2ead,	0x2eb7,	0x2ec1,	0x2ecb,	0x2ed5,	0x2edf,	0x2ee9,
	0x2ef2,	0x2efc,	0x2f06,	0x2f10,	0x2f1a,	0x2f24,	0x2f2e,	0x2f38,
	0x2f42,	0x2f4c,	0x2f56,	0x2f60,	0x2f6a,	0x2f74,	0x2f7e,	0x2f87,
	0x2f91,	0x2f9b,	0x2fa5,	0x2faf,	0x2fb9,	0x2fc3,	0x2fcd,	0x2fd7,
	0x2fe1,	0x2fea,	0x2ff4,	0x2ffe,	0x3008,	0x3012,	0x301c,	0x3026,
	0x3030,	0x303a,	0x3043,	0x304d,	0x3057,	0x3061,	0x306b,	0x3075,
	0x307f,	0x3089,	0x3092,	0x309c,	0x30a6,	0x30b0,	0x30ba,	0x30c4,
	0x30ce,	0x30d7,	0x30e1,	0x30eb,	0x30f5,	0x30ff,	0x3109,	0x3112,
	0x311c,	0x3126,	0x3130,	0x313a,	0x3144,	0x314d,	0x3157,	0x3161,
	0x316b,	0x3175,	0x317f,	0x3188,	0x3192,	0x319c,	0x31a6,	0x31b0,
	0x31b9,	0x31c3,	0x31cd,	0x31d7,	0x31e1,	0x31eb,	0x31f4,	0x31fe,
	0x3208,	0x3212,	0x321b,	0x3225,	0x322f,	0x3239,	0x3243,	0x324c,
	0x3256,	0x3260,	0x326a,	0x3274,	0x327d,	0x3287,	0x3291,	0x329b,
	0x32a4,	0x32ae,	0x32b8,	0x32c2,	0x32cb,	0x32d5,	0x32df,	0x32e9,
	0x32f2,	0x32fc,	0x3306,	0x3310,	0x3319,	0x3323,	0x332d,	0x3337,
	0x3340,	0x334a,	0x3354,	0x335e,	0x3367,	0x3371,	0x337b,	0x3384,
	0x338e,	0x3398,	0x33a2,	0x33ab,	0x33b5,	0x33bf,	0x33c8,	0x33d2,
	0x33dc,	0x33e6,	0x33ef,	0x33f9,	0x3403,	0x340c,	0x3416,	0x3420,
	0x3429,	0x3433,	0x343d,	0x3447,	0x3450,	0x345a,	0x3464,	0x346d,
	0x3477,	0x3481,	0x348a,	0x3494,	0x349e,	0x34a7,	0x34b1,	0x34bb,
	0x34c4,	0x34ce,	0x34d8,	0x34e1,	0x34eb,	0x34f5,	0x34fe,	0x3508,
	0x3512,	0x351b,	0x3525,	0x352e,	0x3538,	0x3542,	0x354b,	0x3555,
	0x355f,	0x3568,	0x3572,	0x357c,	0x3585,	0x358f,	0x3598,	0x35a2,
	0x35ac,	0x35b5,	0x35bf,	0x35c9,	0x35d2,	0x35dc,	0x35e5,	0x35ef,
	0x35f9,	0x3602,	0x360c,	0x3615,	0x361f,	0x3629,	0x3632,	0x363c,
	0x3645,	0x364f,	0x3659,	0x3662,	0x366c,	0x3675,	0x367f,	0x3689,
	0x3692,	0x369c,	0x36a5,	0x36af,	0x36b8,	0x36c2,	0x36cc,	0x36d5,
	0x36df,	0x36e8,	0x36f2,	0x36fb,	0x3705,	0x370e,	0x3718,	0x3722,
	0x372b,	0x3735,	0x373e,	0x3748,	0x3751,	0x375b,	0x3764,	0x376e,
	0x3778,	0x3781,	0x378b,	0x3794,	0x379e,	0x37a7,	0x37b1,	0x37ba,
	0x37c4,	0x37cd,	0x37d7,	0x37e0,	0x37ea,	0x37f3,	0x37fd,	0x3806,
	0x3810,	0x3819,	0x3823,	0x382c,	0x3836,	0x383f,	0x3849,	0x3852,
	0x385c,	0x3865,	0x386f,	0x3878,	0x3882,	0x388b,	0x3895,	0x389e,
	0x38a8,	0x38b1,	0x38bb,	0x38c4,	0x38ce,	0x38d7,	0x38e1,	0x38ea,
	0x38f4,	0x38fd,	0x3907,	0x3910,	0x391a,	0x3923,	0x392c,	0x3936,
	0x393f,	0x3949,	0x3952,	0x395c,	0x3965,	0x396f,	0x3978,	0x3982,
	0x398b,	0x3994,	0x399e,	0x39a7,	0x39b1,	0x39ba,	0x39c4,	0x39cd,
	0x39d6,	0x39e0,	0x39e9,	0x39f3,	0x39fc,	0x3a06,	0x3a0f,	0x3a18,
	0x3a22,	0x3a2b,	0x3a35,	0x3a3e,	0x3a47,	0x3a51,	0x3a5a,	0x3a64,
	0x3a6d,	0x3a77,	0x3a80,	0x3a89,	0x3a93,	0x3a9c,	0x3aa6,	0x3aaf,
	0x3ab8,	0x3ac2,	0x3acb,	0x3ad4,	0x3ade,	0x3ae7,	0x3af1,	0x3afa,
	0x3b03,	0x3b0d,	0x3b16,	0x3b1f,	0x3b29,	0x3b32,	0x3b3c,	0x3b45,
	0x3b4e,	0x3b58,	0x3b61,	0x3b6a,	0x3b74,	0x3b7d,	0x3b86,	0x3b90,
	0x3b99,	0x3ba3,	0x3bac,	0x3bb5,	0x3bbf,	0x3bc8,	0x3bd1,	0x3bdb,
	0x3be4,	0x3bed,	0x3bf7,	0x3c00,	0x3c09,	0x3c13,	0x3c1c,	0x3c25,
	0x3c2f,	0x3c38,	0x3c41,	0x3c4b,	0x3c54,	0x3c5d,	0x3c67,	0x3c70,
	0x3c79,	0x3c82,	0x3c8c,	0x3c95,	0x3c9e,	0x3ca8,	0x3cb1,	0x3cba,
	0x3cc4,	0x3ccd,	0x3cd6,	0x3cdf,	0x3ce9,	0x3cf2,	0x3cfb,	0x3d05,
	0x3d0e,	0x3d17,	0x3d21,	0x3d2a,	0x3d33,	0x3d3c,	0x3d46,	0x3d4f,
	0x3d58,	0x3d61,	0x3d6b,	0x3d74,	0x3d7d,	0x3d87,	0x3d90,	0x3d99,
	0x3da2,	0x3dac,	0x3db5,	0x3dbe,	0x3dc7,	0x3dd1,	0x3dda,	0x3de3,
	0x3dec,	0x3df6,	0x3dff,	0x3e08,	0x3e11,	0x3e1b,	0x3e24,	0x3e2d,
	0x3e36,	0x3e40,	0x3e49,	0x3e52,	0x3e5b,	0x3e64,	0x3e6e,	0x3e77,
	0x3e80,	0x3e89,	0x3e93,	0x3e9c,	0x3ea5,	0x3eae,	0x3eb7,	0x3ec1,
	0x3eca,	0x3ed3,	0x3edc,	0x3ee6,	0x3eef,	0x3ef8,	0x3f01,	0x3f0a,
	0x3f14,	0x3f1d,	0x3f26,	0x3f2f,	0x3f38,	0x3f41,	0x3f4b,	0x3f54,
	0x3f5d,	0x3f66,	0x3f6f,	0x3f79,	0x3f82,	0x3f8b,	0x3f94,	0x3f9d,
	0x3fa7,	0x3fb0,	0x3fb9,	0x3fc2,	0x3fcb,	0x3fd4,	0x3fde,	0x3fe7,
	0x3ff0,	0x3ff9,	0x4002,	0x400b,	0x4014,	0x401e,	0x4027,	0x4030,
	0x4039,	0x4042,	0x404b,	0x4055,	0x405e,	0x4067,	0x4070,	0x4079,
	0x4082,	0x408b,	0x4095,	0x409e,	0x40a7,	0x40b0,	0x40b9,	0x40c2,
	0x40cb,	0x40d4,	0x40de,	0x40e7,	0x40f0,	0x40f9,	0x4102,	0x410b,
	0x4114,	0x411d,	0x4126,	0x4130,	0x4139,	0x4142,	0x414b,	0x4154,
	0x415d,	0x4166,	0x416f,	0x4178,	0x4181,	0x418b,	0x4194,	0x419d,
	0x41a6,	0x41af,	0x41b8,	0x41c1,	0x41ca,	0x41d3,	0x41dc,	0x41e5,
	0x41ef,	0x41f8,	0x4201,	0x420a,	0x4213,	0x421c,	0x4225,	0x422e,
	0x4237,	0x4240,	0x4249,	0x4252,	0x425b,	0x4264,	0x426d,	0x4276,
	0x4280,	0x4289,	0x4292,	0x429b,	0x42a4,	0x42ad,	0x42b6,	0x42bf,
	0x42c8,	0x42d1,	0x42da,	0x42e3,	0x42ec,	0x42f5,	0x42fe,	0x4307,
	0x4310,	0x4319,	0x4322,	0x432b,	0x4334,	0x433d,	0x4346,	0x434f,
	0x4358,	0x4361,	0x436a,	0x4373,	0x437c,	0x4385,	0x438e,	0x4397,
	0x43a0,	0x43a9,	0x43b2,	0x43bb,	0x43c4,	0x43cd,	0x43d6,	0x43df,
	0x43e8,	0x43f1,	0x43fa,	0x4403,	0x440c,	0x4415,	0x441e,	0x4427,
	0x4430,	0x4439,	0x4442,	0x444b,	0x4454,	0x445d,	0x4466,	0x446f,
	0x4478,	0x4481,	0x448a,	0x4493,	0x449c,	0x44a5,	0x44ae,	0x44b7,
	0x44c0,	0x44c9,	0x44d2,	0x44db,	0x44e4,	0x44ed,	0x44f6,	0x44ff,
	0x4508,	0x4510,	0x4519,	0x4522,	0x452b,	0x4534,	0x453d,	0x4546,
	0x454f,	0x4558,	0x4561,	0x456a,	0x4573,	0x457c,	0x4585,	0x458e,
	0x4596,	0x459f,	0x45a8,	0x45b1,	0x45ba,	0x45c3,	0x45cc,	0x45d5,
	0x45de,	0x45e7,	0x45f0,	0x45f9,	0x4601,	0x460a,	0x4613,	0x461c,
	0x4625,	0x462e,	0x4637,	0x4640,	0x4649,	0x4652,	0x465a,	0x4663,
	0x466c,	0x4675,	0x467e,	0x4687,	0x4690,	0x4699,	0x46a2,	0x46aa,
	0x46b3,	0x46bc,	0x46c5,	0x46ce,	0x46d7,	0x46e0,	0x46e9,	0x46f1,
	0x46fa,	0x4703,	0x470c,	0x4715,	0x471e,	0x4727,	0x472f,	0x4738,
	0x4741,	0x474a,	0x4753,	0x475c,	0x4765,	0x476d,	0x4776,	0x477f,
	0x4788,	0x4791,	0x479a,	0x47a3,	0x47ab,	0x47b4,	0x47bd,	0x47c6,
	0x47cf,	0x47d8,	0x47e0,	0x47e9,	0x47f2,	0x47fb,	0x4804,	0x480d,
	0x4815,	0x481e,	0x4827,	0x4830,	0x4839,	0x4841,	0x484a,	0x4853,
	0x485c,	0x4865,	0x486d,	0x4876,	0x487f,	0x4888,	0x4891,	0x489a,
	0x48a2,	0x48ab,	0x48b4,	0x48bd,	0x48c6,	0x48ce,	0x48d7,	0x48e0,
	0x48e9,	0x48f1,	0x48fa,	0x4903,	0x490c,	0x4915,	0x491d,	0x4926,
	0x492f,	0x4938,	0x4940,	0x4949,	0x4952,	0x495b,	0x4964,	0x496c,
	0x4975,	0x497e,	0x4987,	0x498f,	0x4998,	0x49a1,	0x49aa,	0x49b2,
	0x49bb,	0x49c4,	0x49cd,	0x49d5,	0x49de,	0x49e7,	0x49f0,	0x49f8,
	0x4a01,	0x4a0a,	0x4a13,	0x4a1b,	0x4a24,	0x4a2d,	0x4a36,	0x4a3e,
	0x4a47,	0x4a50,	0x4a59,	0x4a61,	0x4a6a,	0x4a73,	0x4a7c,	0x4a84,
	0x4a8d,	0x4a96,	0x4a9e,	0x4aa7,	0x4ab0,	0x4ab9,	0x4ac1,	0x4aca,
	0x4ad3,	0x4adb,	0x4ae4,	0x4aed,	0x4af6,	0x4afe,	0x4b07,	0x4b10,
	0x4b18,	0x4b21,	0x4b2a,	0x4b32,	0x4b3b,	0x4b44,	0x4b4d,	0x4b55,
	0x4b5e,	0x4b67,	0x4b6f,	0x4b78,	0x4b81,	0x4b89,	0x4b92,	0x4b9b,
	0x4ba3,	0x4bac,	0x4bb5,	0x4bbd,	0x4bc6,	0x4bcf,	0x4bd8,	0x4be0,
	0x4be9,	0x4bf2,	0x4bfa,	0x4c03,	0x4c0c,	0x4c14,	0x4c1d,	0x4c26,
	0x4c2e,	0x4c37,	0x4c40,	0x4c48,	0x4c51,	0x4c59,	0x4c62,	0x4c6b,
	0x4c73,	0x4c7c,	0x4c85,	0x4c8d,	0x4c96,	0x4c9f,	0x4ca7,	0x4cb0,
	0x4cb9,	0x4cc1,	0x4cca,	0x4cd2,	0x4cdb,	0x4ce4,	0x4cec,	0x4cf5,
	0x4cfe,	0x4d06,	0x4d0f,	0x4d18,	0x4d20,	0x4d29,	0x4d31,	0x4d3a,
	0x4d43,	0x4d4b,	0x4d54,	0x4d5c,	0x4d65,	0x4d6e,	0x4d76,	0x4d7f,
	0x4d88,	0x4d90,	0x4d99,	0x4da1,	0x4daa,	0x4db3,	0x4dbb,	0x4dc4,
	0x4dcc,	0x4dd5,	0x4dde,	0x4de6,	0x4def,	0x4df7,	0x4e00,	0x4e08,
	0x4e11,	0x4e1a,	0x4e22,	0x4e2b,	0x4e33,	0x4e3c,	0x4e45,	0x4e4d,
	0x4e56,	0x4e5e,	0x4e67,	0x4e6f,	0x4e78,	0x4e81,	0x4e89,	0x4e92,
	0x4e9a,	0x4ea3,	0x4eab,	0x4eb4,	0x4ebd,	0x4ec5,	0x4ece,	0x4ed6,
	0x4edf,	0x4ee7,	0x4ef0,	0x4ef8,	0x4f01,	0x4f0a,	0x4f12,	0x4f1b,
	0x4f23,	0x4f2c,	0x4f34,	0x4f3d,	0x4f45,	0x4f4e,	0x4f56,	0x4f5f,
	0x4f68,	0x4f70,	0x4f79,	0x4f81,	0x4f8a,	0x4f92,	0x4f9b,	0x4fa3,
	0x4fac,	0x4fb4,	0x4fbd,	0x4fc5,	0x4fce,	0x4fd6,	0x4fdf,	0x4fe7,
	0x4ff0,	0x4ff8,	0x5001,	0x5009,	0x5012,	0x501a,	0x5023,	0x502b,
	0x5034,	0x503c,	0x5045,	0x504d,	0x5056,	0x505e,	0x5067,	0x506f,
	0x5078,	0x5080,	0x5089,	0x5091,	0x509a,	0x50a2,	0x50ab,	0x50b3,
	0x50bc,	0x50c4,	0x50cd,	0x50d5,	0x50de,	0x50e6,	0x50ef,	0x50f7,
	0x5100,	0x5108,	0x5111,	0x5119,	0x5122,	0x512a,	0x5133,	0x513b,
	0x5143,	0x514c,	0x5154,	0x515d,	0x5165,	0x516e,	0x5176,	0x517f,
	0x5187,	0x5190,	0x5198,	0x51a1,	0x51a9,	0x51b1,	0x51ba,	0x51c2,
};


const U16 g_rgiExctPow_008Man[ 1 << c_ExctPowSigBits ] =
{
	0x0000,	0x0002,	0x0005,	0x0007,	0x000a,	0x000c,	0x000f,	0x0011,
	0x0014,	0x0016,	0x0019,	0x001c,	0x001e,	0x0021,	0x0023,	0x0026,
	0x0028,	0x002b,	0x002d,	0x0030,	0x0032,	0x0035,	0x0038,	0x003a,
	0x003d,	0x003f,	0x0042,	0x0044,	0x0047,	0x0049,	0x004c,	0x004e,
	0x0051,	0x0053,	0x0056,	0x0058,	0x005b,	0x005d,	0x0060,	0x0062,
	0x0065,	0x0068,	0x006a,	0x006d,	0x006f,	0x0072,	0x0074,	0x0077,
	0x0079,	0x007c,	0x007e,	0x0081,	0x0083,	0x0086,	0x0088,	0x008b,
	0x008d,	0x0090,	0x0092,	0x0095,	0x0097,	0x009a,	0x009c,	0x009f,
	0x00a1,	0x00a4,	0x00a6,	0x00a8,	0x00ab,	0x00ad,	0x00b0,	0x00b2,
	0x00b5,	0x00b7,	0x00ba,	0x00bc,	0x00bf,	0x00c1,	0x00c4,	0x00c6,
	0x00c9,	0x00cb,	0x00ce,	0x00d0,	0x00d3,	0x00d5,	0x00d8,	0x00da,
	0x00dc,	0x00df,	0x00e1,	0x00e4,	0x00e6,	0x00e9,	0x00eb,	0x00ee,
	0x00f0,	0x00f3,	0x00f5,	0x00f7,	0x00fa,	0x00fc,	0x00ff,	0x0101,
	0x0104,	0x0106,	0x0109,	0x010b,	0x010d,	0x0110,	0x0112,	0x0115,
	0x0117,	0x011a,	0x011c,	0x011f,	0x0121,	0x0123,	0x0126,	0x0128,
	0x012b,	0x012d,	0x0130,	0x0132,	0x0134,	0x0137,	0x0139,	0x013c,
	0x013e,	0x0141,	0x0143,	0x0145,	0x0148,	0x014a,	0x014d,	0x014f,
	0x0151,	0x0154,	0x0156,	0x0159,	0x015b,	0x015e,	0x0160,	0x0162,
	0x0165,	0x0167,	0x016a,	0x016c,	0x016e,	0x0171,	0x0173,	0x0176,
	0x0178,	0x017a,	0x017d,	0x017f,	0x0182,	0x0184,	0x0186,	0x0189,
	0x018b,	0x018d,	0x0190,	0x0192,	0x0195,	0x0197,	0x0199,	0x019c,
	0x019e,	0x01a1,	0x01a3,	0x01a5,	0x01a8,	0x01aa,	0x01ac,	0x01af,
	0x01b1,	0x01b4,	0x01b6,	0x01b8,	0x01bb,	0x01bd,	0x01bf,	0x01c2,
	0x01c4,	0x01c6,	0x01c9,	0x01cb,	0x01ce,	0x01d0,	0x01d2,	0x01d5,
	0x01d7,	0x01d9,	0x01dc,	0x01de,	0x01e0,	0x01e3,	0x01e5,	0x01e7,
	0x01ea,	0x01ec,	0x01ef,	0x01f1,	0x01f3,	0x01f6,	0x01f8,	0x01fa,
	0x01fd,	0x01ff,	0x0201,	0x0204,	0x0206,	0x0208,	0x020b,	0x020d,
	0x020f,	0x0212,	0x0214,	0x0216,	0x0219,	0x021b,	0x021d,	0x0220,
	0x0222,	0x0224,	0x0227,	0x0229,	0x022b,	0x022e,	0x0230,	0x0232,
	0x0235,	0x0237,	0x0239,	0x023b,	0x023e,	0x0240,	0x0242,	0x0245,
	0x0247,	0x0249,	0x024c,	0x024e,	0x0250,	0x0253,	0x0255,	0x0257,
	0x025a,	0x025c,	0x025e,	0x0260,	0x0263,	0x0265,	0x0267,	0x026a,
	0x026c,	0x026e,	0x0271,	0x0273,	0x0275,	0x0277,	0x027a,	0x027c,
	0x027e,	0x0281,	0x0283,	0x0285,	0x0287,	0x028a,	0x028c,	0x028e,
	0x0291,	0x0293,	0x0295,	0x0297,	0x029a,	0x029c,	0x029e,	0x02a1,
	0x02a3,	0x02a5,	0x02a7,	0x02aa,	0x02ac,	0x02ae,	0x02b0,	0x02b3,
	0x02b5,	0x02b7,	0x02ba,	0x02bc,	0x02be,	0x02c0,	0x02c3,	0x02c5,
	0x02c7,	0x02c9,	0x02cc,	0x02ce,	0x02d0,	0x02d2,	0x02d5,	0x02d7,
	0x02d9,	0x02db,	0x02de,	0x02e0,	0x02e2,	0x02e4,	0x02e7,	0x02e9,
	0x02eb,	0x02ed,	0x02f0,	0x02f2,	0x02f4,	0x02f6,	0x02f9,	0x02fb,
	0x02fd,	0x02ff,	0x0302,	0x0304,	0x0306,	0x0308,	0x030b,	0x030d,
	0x030f,	0x0311,	0x0313,	0x0316,	0x0318,	0x031a,	0x031c,	0x031f,
	0x0321,	0x0323,	0x0325,	0x0328,	0x032a,	0x032c,	0x032e,	0x0330,
	0x0333,	0x0335,	0x0337,	0x0339,	0x033b,	0x033e,	0x0340,	0x0342,
	0x0344,	0x0347,	0x0349,	0x034b,	0x034d,	0x034f,	0x0352,	0x0354,
	0x0356,	0x0358,	0x035a,	0x035d,	0x035f,	0x0361,	0x0363,	0x0365,
	0x0368,	0x036a,	0x036c,	0x036e,	0x0370,	0x0373,	0x0375,	0x0377,
	0x0379,	0x037b,	0x037e,	0x0380,	0x0382,	0x0384,	0x0386,	0x0389,
	0x038b,	0x038d,	0x038f,	0x0391,	0x0393,	0x0396,	0x0398,	0x039a,
	0x039c,	0x039e,	0x03a1,	0x03a3,	0x03a5,	0x03a7,	0x03a9,	0x03ab,
	0x03ae,	0x03b0,	0x03b2,	0x03b4,	0x03b6,	0x03b8,	0x03bb,	0x03bd,
	0x03bf,	0x03c1,	0x03c3,	0x03c5,	0x03c8,	0x03ca,	0x03cc,	0x03ce,
	0x03d0,	0x03d2,	0x03d5,	0x03d7,	0x03d9,	0x03db,	0x03dd,	0x03df,
	0x03e1,	0x03e4,	0x03e6,	0x03e8,	0x03ea,	0x03ec,	0x03ee,	0x03f1,
	0x03f3,	0x03f5,	0x03f7,	0x03f9,	0x03fb,	0x03fd,	0x0400,	0x0402,
	0x0404,	0x0406,	0x0408,	0x040a,	0x040c,	0x040f,	0x0411,	0x0413,
	0x0415,	0x0417,	0x0419,	0x041b,	0x041d,	0x0420,	0x0422,	0x0424,
	0x0426,	0x0428,	0x042a,	0x042c,	0x042e,	0x0431,	0x0433,	0x0435,
	0x0437,	0x0439,	0x043b,	0x043d,	0x043f,	0x0442,	0x0444,	0x0446,
	0x0448,	0x044a,	0x044c,	0x044e,	0x0450,	0x0452,	0x0455,	0x0457,
	0x0459,	0x045b,	0x045d,	0x045f,	0x0461,	0x0463,	0x0465,	0x0468,
	0x046a,	0x046c,	0x046e,	0x0470,	0x0472,	0x0474,	0x0476,	0x0478,
	0x047a,	0x047d,	0x047f,	0x0481,	0x0483,	0x0485,	0x0487,	0x0489,
	0x048b,	0x048d,	0x048f,	0x0491,	0x0494,	0x0496,	0x0498,	0x049a,
	0x049c,	0x049e,	0x04a0,	0x04a2,	0x04a4,	0x04a6,	0x04a8,	0x04aa,
	0x04ad,	0x04af,	0x04b1,	0x04b3,	0x04b5,	0x04b7,	0x04b9,	0x04bb,
	0x04bd,	0x04bf,	0x04c1,	0x04c3,	0x04c5,	0x04c8,	0x04ca,	0x04cc,
	0x04ce,	0x04d0,	0x04d2,	0x04d4,	0x04d6,	0x04d8,	0x04da,	0x04dc,
	0x04de,	0x04e0,	0x04e2,	0x04e4,	0x04e6,	0x04e9,	0x04eb,	0x04ed,
	0x04ef,	0x04f1,	0x04f3,	0x04f5,	0x04f7,	0x04f9,	0x04fb,	0x04fd,
	0x04ff,	0x0501,	0x0503,	0x0505,	0x0507,	0x0509,	0x050b,	0x050d,
	0x0510,	0x0512,	0x0514,	0x0516,	0x0518,	0x051a,	0x051c,	0x051e,
	0x0520,	0x0522,	0x0524,	0x0526,	0x0528,	0x052a,	0x052c,	0x052e,
	0x0530,	0x0532,	0x0534,	0x0536,	0x0538,	0x053a,	0x053c,	0x053e,
	0x0540,	0x0542,	0x0544,	0x0546,	0x0548,	0x054a,	0x054d,	0x054f,
	0x0551,	0x0553,	0x0555,	0x0557,	0x0559,	0x055b,	0x055d,	0x055f,
	0x0561,	0x0563,	0x0565,	0x0567,	0x0569,	0x056b,	0x056d,	0x056f,
	0x0571,	0x0573,	0x0575,	0x0577,	0x0579,	0x057b,	0x057d,	0x057f,
	0x0581,	0x0583,	0x0585,	0x0587,	0x0589,	0x058b,	0x058d,	0x058f,
	0x0591,	0x0593,	0x0595,	0x0597,	0x0599,	0x059b,	0x059d,	0x059f,
	0x05a1,	0x05a3,	0x05a5,	0x05a7,	0x05a9,	0x05ab,	0x05ad,	0x05af,
	0x05b1,	0x05b3,	0x05b5,	0x05b7,	0x05b9,	0x05bb,	0x05bd,	0x05bf,
	0x05c1,	0x05c3,	0x05c5,	0x05c7,	0x05c9,	0x05cb,	0x05cd,	0x05cf,
	0x05d0,	0x05d2,	0x05d4,	0x05d6,	0x05d8,	0x05da,	0x05dc,	0x05de,
	0x05e0,	0x05e2,	0x05e4,	0x05e6,	0x05e8,	0x05ea,	0x05ec,	0x05ee,
	0x05f0,	0x05f2,	0x05f4,	0x05f6,	0x05f8,	0x05fa,	0x05fc,	0x05fe,
	0x0600,	0x0602,	0x0604,	0x0606,	0x0608,	0x060a,	0x060b,	0x060d,
	0x060f,	0x0611,	0x0613,	0x0615,	0x0617,	0x0619,	0x061b,	0x061d,
	0x061f,	0x0621,	0x0623,	0x0625,	0x0627,	0x0629,	0x062b,	0x062d,
	0x062f,	0x0631,	0x0633,	0x0634,	0x0636,	0x0638,	0x063a,	0x063c,
	0x063e,	0x0640,	0x0642,	0x0644,	0x0646,	0x0648,	0x064a,	0x064c,
	0x064e,	0x0650,	0x0652,	0x0653,	0x0655,	0x0657,	0x0659,	0x065b,
	0x065d,	0x065f,	0x0661,	0x0663,	0x0665,	0x0667,	0x0669,	0x066b,
	0x066d,	0x066e,	0x0670,	0x0672,	0x0674,	0x0676,	0x0678,	0x067a,
	0x067c,	0x067e,	0x0680,	0x0682,	0x0684,	0x0686,	0x0687,	0x0689,
	0x068b,	0x068d,	0x068f,	0x0691,	0x0693,	0x0695,	0x0697,	0x0699,
	0x069b,	0x069c,	0x069e,	0x06a0,	0x06a2,	0x06a4,	0x06a6,	0x06a8,
	0x06aa,	0x06ac,	0x06ae,	0x06b0,	0x06b1,	0x06b3,	0x06b5,	0x06b7,
	0x06b9,	0x06bb,	0x06bd,	0x06bf,	0x06c1,	0x06c3,	0x06c4,	0x06c6,
	0x06c8,	0x06ca,	0x06cc,	0x06ce,	0x06d0,	0x06d2,	0x06d4,	0x06d5,
	0x06d7,	0x06d9,	0x06db,	0x06dd,	0x06df,	0x06e1,	0x06e3,	0x06e5,
	0x06e6,	0x06e8,	0x06ea,	0x06ec,	0x06ee,	0x06f0,	0x06f2,	0x06f4,
	0x06f6,	0x06f7,	0x06f9,	0x06fb,	0x06fd,	0x06ff,	0x0701,	0x0703,
	0x0705,	0x0706,	0x0708,	0x070a,	0x070c,	0x070e,	0x0710,	0x0712,
	0x0714,	0x0715,	0x0717,	0x0719,	0x071b,	0x071d,	0x071f,	0x0721,
	0x0722,	0x0724,	0x0726,	0x0728,	0x072a,	0x072c,	0x072e,	0x0730,
	0x0731,	0x0733,	0x0735,	0x0737,	0x0739,	0x073b,	0x073d,	0x073e,
	0x0740,	0x0742,	0x0744,	0x0746,	0x0748,	0x074a,	0x074b,	0x074d,
	0x074f,	0x0751,	0x0753,	0x0755,	0x0756,	0x0758,	0x075a,	0x075c,
	0x075e,	0x0760,	0x0762,	0x0763,	0x0765,	0x0767,	0x0769,	0x076b,
	0x076d,	0x076e,	0x0770,	0x0772,	0x0774,	0x0776,	0x0778,	0x077a,
	0x077b,	0x077d,	0x077f,	0x0781,	0x0783,	0x0785,	0x0786,	0x0788,
	0x078a,	0x078c,	0x078e,	0x0790,	0x0791,	0x0793,	0x0795,	0x0797,
	0x0799,	0x079b,	0x079c,	0x079e,	0x07a0,	0x07a2,	0x07a4,	0x07a5,
	0x07a7,	0x07a9,	0x07ab,	0x07ad,	0x07af,	0x07b0,	0x07b2,	0x07b4,
	0x07b6,	0x07b8,	0x07ba,	0x07bb,	0x07bd,	0x07bf,	0x07c1,	0x07c3,
	0x07c4,	0x07c6,	0x07c8,	0x07ca,	0x07cc,	0x07ce,	0x07cf,	0x07d1,
	0x07d3,	0x07d5,	0x07d7,	0x07d8,	0x07da,	0x07dc,	0x07de,	0x07e0,
	0x07e1,	0x07e3,	0x07e5,	0x07e7,	0x07e9,	0x07ea,	0x07ec,	0x07ee,
	0x07f0,	0x07f2,	0x07f3,	0x07f5,	0x07f7,	0x07f9,	0x07fb,	0x07fc,
	0x07fe,	0x0800,	0x0802,	0x0804,	0x0805,	0x0807,	0x0809,	0x080b,
	0x080d,	0x080e,	0x0810,	0x0812,	0x0814,	0x0816,	0x0817,	0x0819,
	0x081b,	0x081d,	0x081e,	0x0820,	0x0822,	0x0824,	0x0826,	0x0827,
	0x0829,	0x082b,	0x082d,	0x082f,	0x0830,	0x0832,	0x0834,	0x0836,
	0x0837,	0x0839,	0x083b,	0x083d,	0x083f,	0x0840,	0x0842,	0x0844,
	0x0846,	0x0847,	0x0849,	0x084b,	0x084d,	0x084f,	0x0850,	0x0852,
	0x0854,	0x0856,	0x0857,	0x0859,	0x085b,	0x085d,	0x085f,	0x0860,
	0x0862,	0x0864,	0x0866,	0x0867,	0x0869,	0x086b,	0x086d,	0x086e,
	0x0870,	0x0872,	0x0874,	0x0875,	0x0877,	0x0879,	0x087b,	0x087c,
	0x087e,	0x0880,	0x0882,	0x0884,	0x0885,	0x0887,	0x0889,	0x088b,
	0x088c,	0x088e,	0x0890,	0x0892,	0x0893,	0x0895,	0x0897,	0x0899,
	0x089a,	0x089c,	0x089e,	0x08a0,	0x08a1,	0x08a3,	0x08a5,	0x08a7,
	0x08a8,	0x08aa,	0x08ac,	0x08ae,	0x08af,	0x08b1,	0x08b3,	0x08b5,
	0x08b6,	0x08b8,	0x08ba,	0x08bb,	0x08bd,	0x08bf,	0x08c1,	0x08c2,
	0x08c4,	0x08c6,	0x08c8,	0x08c9,	0x08cb,	0x08cd,	0x08cf,	0x08d0,
	0x08d2,	0x08d4,	0x08d6,	0x08d7,	0x08d9,	0x08db,	0x08dc,	0x08de,
	0x08e0,	0x08e2,	0x08e3,	0x08e5,	0x08e7,	0x08e9,	0x08ea,	0x08ec,
	0x08ee,	0x08ef,	0x08f1,	0x08f3,	0x08f5,	0x08f6,	0x08f8,	0x08fa,
	0x08fc,	0x08fd,	0x08ff,	0x0901,	0x0902,	0x0904,	0x0906,	0x0908,
	0x0909,	0x090b,	0x090d,	0x090e,	0x0910,	0x0912,	0x0914,	0x0915,
	0x0917,	0x0919,	0x091a,	0x091c,	0x091e,	0x0920,	0x0921,	0x0923,
	0x0925,	0x0926,	0x0928,	0x092a,	0x092c,	0x092d,	0x092f,	0x0931,
	0x0932,	0x0934,	0x0936,	0x0937,	0x0939,	0x093b,	0x093d,	0x093e,
	0x0940,	0x0942,	0x0943,	0x0945,	0x0947,	0x0949,	0x094a,	0x094c,
	0x094e,	0x094f,	0x0951,	0x0953,	0x0954,	0x0956,	0x0958,	0x0959,
	0x095b,	0x095d,	0x095f,	0x0960,	0x0962,	0x0964,	0x0965,	0x0967,
	0x0969,	0x096a,	0x096c,	0x096e,	0x096f,	0x0971,	0x0973,	0x0975,
	0x0976,	0x0978,	0x097a,	0x097b,	0x097d,	0x097f,	0x0980,	0x0982,
	0x0984,	0x0985,	0x0987,	0x0989,	0x098a,	0x098c,	0x098e,	0x098f,
	0x0991,	0x0993,	0x0994,	0x0996,	0x0998,	0x099a,	0x099b,	0x099d,
	0x099f,	0x09a0,	0x09a2,	0x09a4,	0x09a5,	0x09a7,	0x09a9,	0x09aa,
	0x09ac,	0x09ae,	0x09af,	0x09b1,	0x09b3,	0x09b4,	0x09b6,	0x09b8,
	0x09b9,	0x09bb,	0x09bd,	0x09be,	0x09c0,	0x09c2,	0x09c3,	0x09c5,
	0x09c7,	0x09c8,	0x09ca,	0x09cc,	0x09cd,	0x09cf,	0x09d1,	0x09d2,
	0x09d4,	0x09d6,	0x09d7,	0x09d9,	0x09db,	0x09dc,	0x09de,	0x09e0,
	0x09e1,	0x09e3,	0x09e4,	0x09e6,	0x09e8,	0x09e9,	0x09eb,	0x09ed,
	0x09ee,	0x09f0,	0x09f2,	0x09f3,	0x09f5,	0x09f7,	0x09f8,	0x09fa,
	0x09fc,	0x09fd,	0x09ff,	0x0a01,	0x0a02,	0x0a04,	0x0a05,	0x0a07,
	0x0a09,	0x0a0a,	0x0a0c,	0x0a0e,	0x0a0f,	0x0a11,	0x0a13,	0x0a14,
	0x0a16,	0x0a18,	0x0a19,	0x0a1b,	0x0a1c,	0x0a1e,	0x0a20,	0x0a21,
	0x0a23,	0x0a25,	0x0a26,	0x0a28,	0x0a2a,	0x0a2b,	0x0a2d,	0x0a2e,
	0x0a30,	0x0a32,	0x0a33,	0x0a35,	0x0a37,	0x0a38,	0x0a3a,	0x0a3c,
	0x0a3d,	0x0a3f,	0x0a40,	0x0a42,	0x0a44,	0x0a45,	0x0a47,	0x0a49,
	0x0a4a,	0x0a4c,	0x0a4d,	0x0a4f,	0x0a51,	0x0a52,	0x0a54,	0x0a56,
	0x0a57,	0x0a59,	0x0a5a,	0x0a5c,	0x0a5e,	0x0a5f,	0x0a61,	0x0a63,
	0x0a64,	0x0a66,	0x0a67,	0x0a69,	0x0a6b,	0x0a6c,	0x0a6e,	0x0a70,
	0x0a71,	0x0a73,	0x0a74,	0x0a76,	0x0a78,	0x0a79,	0x0a7b,	0x0a7c,
	0x0a7e,	0x0a80,	0x0a81,	0x0a83,	0x0a85,	0x0a86,	0x0a88,	0x0a89,
	0x0a8b,	0x0a8d,	0x0a8e,	0x0a90,	0x0a91,	0x0a93,	0x0a95,	0x0a96,
	0x0a98,	0x0a99,	0x0a9b,	0x0a9d,	0x0a9e,	0x0aa0,	0x0aa1,	0x0aa3,
	0x0aa5,	0x0aa6,	0x0aa8,	0x0aa9,	0x0aab,	0x0aad,	0x0aae,	0x0ab0,
	0x0ab1,	0x0ab3,	0x0ab5,	0x0ab6,	0x0ab8,	0x0ab9,	0x0abb,	0x0abd,
	0x0abe,	0x0ac0,	0x0ac1,	0x0ac3,	0x0ac5,	0x0ac6,	0x0ac8,	0x0ac9,
	0x0acb,	0x0acd,	0x0ace,	0x0ad0,	0x0ad1,	0x0ad3,	0x0ad5,	0x0ad6,
	0x0ad8,	0x0ad9,	0x0adb,	0x0adc,	0x0ade,	0x0ae0,	0x0ae1,	0x0ae3,
	0x0ae4,	0x0ae6,	0x0ae8,	0x0ae9,	0x0aeb,	0x0aec,	0x0aee,	0x0aef,
	0x0af1,	0x0af3,	0x0af4,	0x0af6,	0x0af7,	0x0af9,	0x0afb,	0x0afc,
	0x0afe,	0x0aff,	0x0b01,	0x0b02,	0x0b04,	0x0b06,	0x0b07,	0x0b09,
	0x0b0a,	0x0b0c,	0x0b0d,	0x0b0f,	0x0b11,	0x0b12,	0x0b14,	0x0b15,
	0x0b17,	0x0b18,	0x0b1a,	0x0b1c,	0x0b1d,	0x0b1f,	0x0b20,	0x0b22,
	0x0b23,	0x0b25,	0x0b27,	0x0b28,	0x0b2a,	0x0b2b,	0x0b2d,	0x0b2e,
	0x0b30,	0x0b32,	0x0b33,	0x0b35,	0x0b36,	0x0b38,	0x0b39,	0x0b3b,
	0x0b3d,	0x0b3e,	0x0b40,	0x0b41,	0x0b43,	0x0b44,	0x0b46,	0x0b47,
	0x0b49,	0x0b4b,	0x0b4c,	0x0b4e,	0x0b4f,	0x0b51,	0x0b52,	0x0b54,
	0x0b55,	0x0b57,	0x0b59,	0x0b5a,	0x0b5c,	0x0b5d,	0x0b5f,	0x0b60,
	0x0b62,	0x0b63,	0x0b65,	0x0b67,	0x0b68,	0x0b6a,	0x0b6b,	0x0b6d,
	0x0b6e,	0x0b70,	0x0b71,	0x0b73,	0x0b74,	0x0b76,	0x0b78,	0x0b79,
	0x0b7b,	0x0b7c,	0x0b7e,	0x0b7f,	0x0b81,	0x0b82,	0x0b84,	0x0b85,
	0x0b87,	0x0b89,	0x0b8a,	0x0b8c,	0x0b8d,	0x0b8f,	0x0b90,	0x0b92,
	0x0b93,	0x0b95,	0x0b96,	0x0b98,	0x0b99,	0x0b9b,	0x0b9d,	0x0b9e,
	0x0ba0,	0x0ba1,	0x0ba3,	0x0ba4,	0x0ba6,	0x0ba7,	0x0ba9,	0x0baa,
	0x0bac,	0x0bad,	0x0baf,	0x0bb1,	0x0bb2,	0x0bb4,	0x0bb5,	0x0bb7,
	0x0bb8,	0x0bba,	0x0bbb,	0x0bbd,	0x0bbe,	0x0bc0,	0x0bc1,	0x0bc3,
	0x0bc4,	0x0bc6,	0x0bc7,	0x0bc9,	0x0bca,	0x0bcc,	0x0bce,	0x0bcf,
	0x0bd1,	0x0bd2,	0x0bd4,	0x0bd5,	0x0bd7,	0x0bd8,	0x0bda,	0x0bdb,
	0x0bdd,	0x0bde,	0x0be0,	0x0be1,	0x0be3,	0x0be4,	0x0be6,	0x0be7,
	0x0be9,	0x0bea,	0x0bec,	0x0bed,	0x0bef,	0x0bf1,	0x0bf2,	0x0bf4,
	0x0bf5,	0x0bf7,	0x0bf8,	0x0bfa,	0x0bfb,	0x0bfd,	0x0bfe,	0x0c00,
	0x0c01,	0x0c03,	0x0c04,	0x0c06,	0x0c07,	0x0c09,	0x0c0a,	0x0c0c,
	0x0c0d,	0x0c0f,	0x0c10,	0x0c12,	0x0c13,	0x0c15,	0x0c16,	0x0c18,
	0x0c19,	0x0c1b,	0x0c1c,	0x0c1e,	0x0c1f,	0x0c21,	0x0c22,	0x0c24,
	0x0c25,	0x0c27,	0x0c28,	0x0c2a,	0x0c2b,	0x0c2d,	0x0c2e,	0x0c30,
	0x0c31,	0x0c33,	0x0c34,	0x0c36,	0x0c37,	0x0c39,	0x0c3a,	0x0c3c,
	0x0c3d,	0x0c3f,	0x0c40,	0x0c42,	0x0c43,	0x0c45,	0x0c46,	0x0c48,
	0x0c49,	0x0c4b,	0x0c4c,	0x0c4e,	0x0c4f,	0x0c51,	0x0c52,	0x0c54,
	0x0c55,	0x0c57,	0x0c58,	0x0c5a,	0x0c5b,	0x0c5d,	0x0c5e,	0x0c60,
	0x0c61,	0x0c63,	0x0c64,	0x0c66,	0x0c67,	0x0c69,	0x0c6a,	0x0c6b,
	0x0c6d,	0x0c6e,	0x0c70,	0x0c71,	0x0c73,	0x0c74,	0x0c76,	0x0c77,
	0x0c79,	0x0c7a,	0x0c7c,	0x0c7d,	0x0c7f,	0x0c80,	0x0c82,	0x0c83,
	0x0c85,	0x0c86,	0x0c88,	0x0c89,	0x0c8b,	0x0c8c,	0x0c8e,	0x0c8f,
	0x0c90,	0x0c92,	0x0c93,	0x0c95,	0x0c96,	0x0c98,	0x0c99,	0x0c9b,
	0x0c9c,	0x0c9e,	0x0c9f,	0x0ca1,	0x0ca2,	0x0ca4,	0x0ca5,	0x0ca7,
	0x0ca8,	0x0caa,	0x0cab,	0x0cac,	0x0cae,	0x0caf,	0x0cb1,	0x0cb2,
	0x0cb4,	0x0cb5,	0x0cb7,	0x0cb8,	0x0cba,	0x0cbb,	0x0cbd,	0x0cbe,
	0x0cc0,	0x0cc1,	0x0cc2,	0x0cc4,	0x0cc5,	0x0cc7,	0x0cc8,	0x0cca,
	0x0ccb,	0x0ccd,	0x0cce,	0x0cd0,	0x0cd1,	0x0cd3,	0x0cd4,	0x0cd5,
	0x0cd7,	0x0cd8,	0x0cda,	0x0cdb,	0x0cdd,	0x0cde,	0x0ce0,	0x0ce1,
	0x0ce3,	0x0ce4,	0x0ce5,	0x0ce7,	0x0ce8,	0x0cea,	0x0ceb,	0x0ced,
	0x0cee,	0x0cf0,	0x0cf1,	0x0cf3,	0x0cf4,	0x0cf5,	0x0cf7,	0x0cf8,
	0x0cfa,	0x0cfb,	0x0cfd,	0x0cfe,	0x0d00,	0x0d01,	0x0d02,	0x0d04,
	0x0d05,	0x0d07,	0x0d08,	0x0d0a,	0x0d0b,	0x0d0d,	0x0d0e,	0x0d0f,
	0x0d11,	0x0d12,	0x0d14,	0x0d15,	0x0d17,	0x0d18,	0x0d1a,	0x0d1b,
	0x0d1c,	0x0d1e,	0x0d1f,	0x0d21,	0x0d22,	0x0d24,	0x0d25,	0x0d27,
	0x0d28,	0x0d29,	0x0d2b,	0x0d2c,	0x0d2e,	0x0d2f,	0x0d31,	0x0d32,
	0x0d33,	0x0d35,	0x0d36,	0x0d38,	0x0d39,	0x0d3b,	0x0d3c,	0x0d3e,
	0x0d3f,	0x0d40,	0x0d42,	0x0d43,	0x0d45,	0x0d46,	0x0d48,	0x0d49,
	0x0d4a,	0x0d4c,	0x0d4d,	0x0d4f,	0x0d50,	0x0d52,	0x0d53,	0x0d54,
	0x0d56,	0x0d57,	0x0d59,	0x0d5a,	0x0d5c,	0x0d5d,	0x0d5e,	0x0d60,
	0x0d61,	0x0d63,	0x0d64,	0x0d66,	0x0d67,	0x0d68,	0x0d6a,	0x0d6b,
	0x0d6d,	0x0d6e,	0x0d6f,	0x0d71,	0x0d72,	0x0d74,	0x0d75,	0x0d77,
	0x0d78,	0x0d79,	0x0d7b,	0x0d7c,	0x0d7e,	0x0d7f,	0x0d81,	0x0d82,
	0x0d83,	0x0d85,	0x0d86,	0x0d88,	0x0d89,	0x0d8a,	0x0d8c,	0x0d8d,
	0x0d8f,	0x0d90,	0x0d92,	0x0d93,	0x0d94,	0x0d96,	0x0d97,	0x0d99,
	0x0d9a,	0x0d9b,	0x0d9d,	0x0d9e,	0x0da0,	0x0da1,	0x0da2,	0x0da4,
	0x0da5,	0x0da7,	0x0da8,	0x0da9,	0x0dab,	0x0dac,	0x0dae,	0x0daf,
	0x0db1,	0x0db2,	0x0db3,	0x0db5,	0x0db6,	0x0db8,	0x0db9,	0x0dba,
	0x0dbc,	0x0dbd,	0x0dbf,	0x0dc0,	0x0dc1,	0x0dc3,	0x0dc4,	0x0dc6,
	0x0dc7,	0x0dc8,	0x0dca,	0x0dcb,	0x0dcd,	0x0dce,	0x0dcf,	0x0dd1,
	0x0dd2,	0x0dd4,	0x0dd5,	0x0dd6,	0x0dd8,	0x0dd9,	0x0ddb,	0x0ddc,
	0x0ddd,	0x0ddf,	0x0de0,	0x0de2,	0x0de3,	0x0de4,	0x0de6,	0x0de7,
	0x0de9,	0x0dea,	0x0deb,	0x0ded,	0x0dee,	0x0def,	0x0df1,	0x0df2,
	0x0df4,	0x0df5,	0x0df6,	0x0df8,	0x0df9,	0x0dfb,	0x0dfc,	0x0dfd,
	0x0dff,	0x0e00,	0x0e02,	0x0e03,	0x0e04,	0x0e06,	0x0e07,	0x0e08,
	0x0e0a,	0x0e0b,	0x0e0d,	0x0e0e,	0x0e0f,	0x0e11,	0x0e12,	0x0e14,
	0x0e15,	0x0e16,	0x0e18,	0x0e19,	0x0e1a,	0x0e1c,	0x0e1d,	0x0e1f,
	0x0e20,	0x0e21,	0x0e23,	0x0e24,	0x0e25,	0x0e27,	0x0e28,	0x0e2a,
	0x0e2b,	0x0e2c,	0x0e2e,	0x0e2f,	0x0e31,	0x0e32,	0x0e33,	0x0e35,
	0x0e36,	0x0e37,	0x0e39,	0x0e3a,	0x0e3c,	0x0e3d,	0x0e3e,	0x0e40,
	0x0e41,	0x0e42,	0x0e44,	0x0e45,	0x0e47,	0x0e48,	0x0e49,	0x0e4b,
	0x0e4c,	0x0e4d,	0x0e4f,	0x0e50,	0x0e51,	0x0e53,	0x0e54,	0x0e56,
	0x0e57,	0x0e58,	0x0e5a,	0x0e5b,	0x0e5c,	0x0e5e,	0x0e5f,	0x0e61,
	0x0e62,	0x0e63,	0x0e65,	0x0e66,	0x0e67,	0x0e69,	0x0e6a,	0x0e6b,
	0x0e6d,	0x0e6e,	0x0e70,	0x0e71,	0x0e72,	0x0e74,	0x0e75,	0x0e76,
	0x0e78,	0x0e79,	0x0e7a,	0x0e7c,	0x0e7d,	0x0e7e,	0x0e80,	0x0e81,
	0x0e83,	0x0e84,	0x0e85,	0x0e87,	0x0e88,	0x0e89,	0x0e8b,	0x0e8c,
	0x0e8d,	0x0e8f,	0x0e90,	0x0e91,	0x0e93,	0x0e94,	0x0e96,	0x0e97,
};


const U32 g_rgiExctPow_040Exp[ c_ExctPowExpSize ] =
{
	0x00024c22,	0x0003080c,
	0x00040000,	0x0005472d,
	0x0006f6e3,	0x00093088,
	0x000c2030,	0x00100000,
	0x00151cb4,	0x001bdb8c,
	0x0024c223,	0x003080c0,
	0x00400000,	0x005472d1,
	0x006f6e33,	0x0093088c,
	0x00c20300,	0x01000000,
	0x0151cb45,	0x01bdb8cd,
	0x024c2230,	0x03080c00,
	0x04000000,	0x05472d14,
	0x06f6e336,	0x093088c3,
	0x0c203001,	0x10000000,
	0x151cb453,	0x1bdb8cda,
	0x24c2230d,	0x3080c007,
};


const U32 g_rgiExctPow_008Exp[ c_ExctPowExpSize ] =
{
	0x0e5205cf,	0x0f230d57,
	0x10000000,	0x10e98bbf,
	0x11e0687a,	0x12e5588f,
	0x13f92974,	0x151cb453,
	0x1650debc,	0x17969b51,
	0x18eeea8e,	0x1a5adb8c,
	0x1bdb8cda,	0x1d722d5f,
	0x1f1ffd44,	0x20e64ef7,
	0x22c68830,	0x24c2230d,
	0x26daaf3a,	0x2911d330,
	0x2b694d7a,	0x2de2f61d,
	0x3080c007,	0x3344ba97,
	0x36311340,	0x3948173c,
	0x3c8c355f,	0x40000000,
	0x43a62efe,	0x4781a1e9,
	0x4b95623e,	0x4fe4a5d0,
};

/*

U16 g_rgiExctPow_040Man[ (1 << c_ExctPowSigBits) ] = { 0 };
U16 g_rgiExctPow_008Man[ (1 << c_ExctPowSigBits) ] = { 0 };

U32 g_rgiExctPow_040Exp[ c_ExctPowExpSize ] = { 0 };
U32 g_rgiExctPow_008Exp[ c_ExctPowExpSize ] = { 0 };

void gen_exct_tables()
{
    const U32 max = 1 << c_ExctPowSigBits;
    const I32 offset = -2;

    U32 man; // mantissa
    I32 exp; // exponent

    for( man = 0; man < max; ++man )
    {
        g_rgiExctPow_040Man[ man ] = (U16)( (1<<16) * (
          pow( (float)( man + max ) / max, 0.40 ) - 1));
    }

    for( man = 0; man < max; ++man )
    {
        g_rgiExctPow_008Man[ man ] = (U16)( (1<<16) * (
          pow( (float)( man + max ) / max, 0.08 ) - 1));
    }

    for( exp = 0; exp < c_ExctPowExpSize; ++exp )
    {
        g_rgiExctPow_040Exp[ exp ] = (U32)( (1<<18) *
          pow( 2, 0.40 * ( exp + offset )));
    }

    for( exp = 0; exp < c_ExctPowExpSize; ++exp )
    {
        g_rgiExctPow_008Exp[ exp ] = (U32)( (1<<28) * 
          pow( 2, 0.08 * ( exp + offset )));
    }
}

void print_exct_tables()
{
    int i;

    printf( "const U16 g_rgiExctPow_040Man[ 1 << c_ExctPowSigBits ] =\n{\n" );

    for( i=0; i<(1<<c_ExctPowSigBits); ++i )
    {
        printf( "\t0x%04x,", g_rgiExctPow_040Man[i] );
        if( 0 == (i+1)%8 ) printf("\n");
    }

    printf( "};\n\n\n" );
    printf( "const U16 g_rgiExctPow_008Man[ 1 << c_ExctPowSigBits ] =\n{\n" );

    for( i=0; i<(1<<c_ExctPowSigBits); ++i )
    {
        printf( "\t0x%04x,", g_rgiExctPow_008Man[i] );
        if( 0 == (i+1)%8 ) printf("\n");
    }

    printf( "};\n\n\n" );
    printf( "const U32 g_rgiExctPow_040Exp[ c_ExctPowExpSize ] =\n{\n" );

    for( i=0; i<c_ExctPowExpSize; ++i )
    {
        printf( "\t0x%08x,", g_rgiExctPow_040Exp[i] );
        if( 0 == (i+1)%2 ) printf("\n");
    }

    printf( "};\n\n\n" );
    printf( "const U32 g_rgiExctPow_008Exp[ c_ExctPowExpSize ] =\n{\n" );

    for( i=0; i<c_ExctPowExpSize; ++i )
    {
        printf( "\t0x%08x,", g_rgiExctPow_008Exp[i] );
        if( 0 == (i+1)%2 ) printf("\n");
    }

    printf( "};\n\n\n" );
}

*/

#endif // _EXCT_POW_TBL_H
