//*@@@+++@@@@******************************************************************
//
// Microsoft Windows Media
// Copyright (C) Microsoft Corporation. All rights reserved.
//
//*@@@---@@@@******************************************************************

/*************************************************************************

Copyright (C) 1996, 1997  Microsoft Corporation

Module Name:

	strmenc.h

Abstract:

	BitStream for encoder

Author:

	Ming-Chieh Lee (mingcl@microsoft.com) 10-December-1996
	Wei-ge Chen (wchen@microsoft.com) 10-December-1996
	Bruce Lin (blin@microsoft.com) 10-December-1996

Revision History:

*************************************************************************/

#ifndef __STRMENC_HPP_
#define __STRMENC_HPP_

typedef struct COutBitStream
{
	I8* m_pchBuffer;
	UInt m_iBuffer;
	I8* m_pchBufferRun;
	UInt m_uintEncBuffer;
	UInt m_uEncNumEmptyBits;
	I8* m_pchBufferSave;
	UInt m_iBufferSave;
	I8* m_pchBufferRunSave;
	UInt m_uintEncBufferSave;
	UInt m_uEncNumEmptyBitsSave;
} COutBitStream;


#ifdef __cplusplus
extern "C" {
#endif


COutBitStream *ostrmNew(I8* pchBuffer, Int iBitPosition);
void ostrmDelete(COutBitStream *pobs);

// attributes
static INLINE I8* ostrmStr(const COutBitStream *pobs) {return pobs->m_pchBuffer;}
static INLINE UInt ostrmPcount(const COutBitStream *pobs) {return pobs->m_iBuffer;}
static INLINE Int ostrmBitCount(const COutBitStream *pobs)
{
    if (pobs->m_uEncNumEmptyBits==32)
        return (pobs->m_iBuffer<<3);
    else
        return (((pobs->m_iBuffer & ~0x3)<<3) + 32 - pobs->m_uEncNumEmptyBits);
} 

static INLINE Int ostrmCBitInBuffer(const COutBitStream *pobs)
{
    return (32 - pobs->m_uEncNumEmptyBits);
}

// Operations
Void ostrmPutBits(COutBitStream *pobs, Int data, UInt numBits);//put bits into the stream
Void ostrmAttach(COutBitStream *pobs, I8* pchBuffer, Int iBitPosition);
Void ostrmFlush(COutBitStream *pobs);//flush remaing bits in the COutBitStream into the attached ostream
Void ostrmFlushByte(COutBitStream *pobs);//flush remaing full bytes
Void ostrmReset(COutBitStream *pobs); // reset ostream to the beginning
Void ostrmSaveStreamStatus(COutBitStream *pobs);
Void ostrmRestoreStreamStatus(COutBitStream *pobs);
Int ostrmGetBitsPerFrame(COutBitStream *pobs);
Void ostrmFlushMPEG4(COutBitStream *pobs);//flush remaing bits in the COutBitStream into the attached ostream, using MPEG4 method

#ifdef __cplusplus
}
#endif

#endif // __STRMENC_HPP_
