/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote;

import HTTPClient.AuthorizationInfo;
import HTTPClient.Cookie;
import HTTPClient.CookieModule;
import HTTPClient.CookiePolicyHandler;
import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.ProtocolNotSuppException;
import HTTPClient.RoRequest;
import HTTPClient.RoResponse;
import com.gallery.GalleryRemote.AuthorizePopup;
import com.gallery.GalleryRemote.GalleryComm2;
import com.gallery.GalleryRemote.GalleryComm2_5;
import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.StatusUpdate;
import com.gallery.GalleryRemote.model.Album;
import com.gallery.GalleryRemote.model.Gallery;
import com.gallery.GalleryRemote.model.Picture;
import com.gallery.GalleryRemote.prefs.GalleryProperties;
import com.gallery.GalleryRemote.prefs.PreferenceNames;
import com.gallery.GalleryRemote.prefs.PropertiesFile;
import com.gallery.GalleryRemote.util.GRI18n;
import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.JOptionPane;

public abstract class GalleryComm
implements PreferenceNames {
    private static final String MODULE = "GalComm";
    int[] capabilities = null;
    private static int lastRespCode = 0;
    protected boolean isLoggedIn = false;
    protected boolean triedLogin = false;

    public void uploadFiles(StatusUpdate su, boolean async) {
        throw new RuntimeException("This method is not available on this protocol");
    }

    public void fetchAlbums(StatusUpdate su, boolean async) {
        throw new RuntimeException("This method is not available on this protocol");
    }

    public void albumInfo(StatusUpdate su, Album a, boolean async) {
        throw new RuntimeException("This method is not available on this protocol");
    }

    public String newAlbum(StatusUpdate su, Album parentAlbum, String newAlbumName, String newAlbumTitle, String newAlbumDesc, boolean async) {
        throw new RuntimeException("This method is not available on this protocol");
    }

    public void fetchAlbumImages(StatusUpdate su, Album a, boolean recusive, boolean async, int maxPictures, boolean random) {
        throw new RuntimeException("This method is not available on this protocol");
    }

    public boolean moveAlbum(StatusUpdate su, Album a, Album newParent, boolean async) {
        throw new RuntimeException("This method is not available on this protocol");
    }

    public void login(StatusUpdate su) {
        throw new RuntimeException("This method is not available on this protocol");
    }

    public void incrementViewCount(StatusUpdate su, Picture p) {
        throw new RuntimeException("This method is not available on this protocol");
    }

    public void logOut() {
        Log.log(2, MODULE, "Logging out and clearing cookies");
        this.isLoggedIn = false;
        CookieModule.discardAllCookies();
    }

    public boolean isLoggedIn() {
        return this.isLoggedIn;
    }

    public boolean hasCapability(StatusUpdate su, int capability) {
        if (!this.isLoggedIn() && !this.triedLogin) {
            this.login(su);
        }
        return Arrays.binarySearch(this.capabilities, capability) >= 0;
    }

    public static boolean wasAuthFailure() {
        return lastRespCode == 401;
    }

    public static GalleryComm getCommInstance(StatusUpdate su, URL url, Gallery g) {
        block32: {
            try {
                Object proxyHelper;
                PropertiesFile p = GalleryRemote._().properties;
                String proxyList = System.getProperty("javaplugin.proxy.config.list");
                String proxyHost = null;
                int proxyPort = 80;
                String proxyUsername = null;
                String proxyPassword = null;
                Class<?> proxyHelperClass = null;
                Class<?> proxyInfoClass = null;
                Object proxyInfo = null;
                try {
                    Log.log(3, MODULE, "Trying Java 5 and 6 proxy class (sun.plugin.net.proxy.PluginAutoProxyHandler)");
                    proxyHelperClass = Class.forName("sun.plugin.net.proxy.PluginAutoProxyHandler");
                    proxyInfoClass = Class.forName("com.sun.deploy.net.proxy.ProxyInfo");
                    proxyHelper = proxyHelperClass.newInstance();
                    Object[] proxyInfoArray = (Object[])proxyHelperClass.getMethod("getProxyInfo", URL.class).invoke(proxyHelper, url);
                    if (proxyInfoArray != null && proxyInfoArray.length != 0) {
                        proxyInfo = proxyInfoArray[0];
                    }
                }
                catch (Throwable e) {
                    Log.log(3, MODULE, "Failed instanciation" + e);
                }
                if (proxyHelperClass == null) {
                    try {
                        Log.log(3, MODULE, "Trying Java 4 proxy class (sun.plugin.net.proxy.PluginProxyManager)");
                        proxyHelperClass = Class.forName("sun.plugin.net.proxy.PluginProxyManager");
                        proxyInfoClass = Class.forName("sun.plugin.net.proxy.ProxyInfo");
                        proxyHelper = proxyHelperClass.newInstance();
                        proxyInfo = proxyHelperClass.getMethod("getProxyInfo", URL.class).invoke(proxyHelper, url);
                    }
                    catch (Throwable e) {
                        Log.log(3, MODULE, "Failed instanciation" + e);
                    }
                }
                if (proxyInfo != null) {
                    try {
                        Log.log(3, MODULE, "Got proxy info from Java plugin: " + proxyInfo);
                        proxyPort = (Integer)proxyInfoClass.getMethod("getPort", null).invoke(proxyInfo, null);
                        try {
                            proxyHost = (String)proxyInfoClass.getMethod("getProxy", null).invoke(proxyInfo, null);
                        }
                        catch (NoSuchMethodException e) {
                            proxyHost = (String)proxyInfoClass.getMethod("getHost", null).invoke(proxyInfo, null);
                        }
                    }
                    catch (Throwable e) {
                        Log.log(3, MODULE, "Failed instanciation" + e);
                    }
                }
                if (proxyHost == null && proxyList != null && proxyList.length() != 0) {
                    try {
                        proxyList = proxyList.toUpperCase();
                        Log.log(3, MODULE, "Plugin Proxy Config List Property: " + proxyList);
                        proxyHost = proxyList.indexOf("HTTP=") != -1 ? proxyList.substring(proxyList.indexOf("HTTP=") + 5, proxyList.indexOf(":")) : proxyList.substring(0, proxyList.indexOf(":"));
                        int endOfPort = proxyList.indexOf(",");
                        if (endOfPort < 1) {
                            endOfPort = proxyList.length();
                        }
                        proxyPort = Integer.parseInt(proxyList.substring(proxyList.indexOf(":") + 1, endOfPort));
                        Log.log(3, MODULE, "proxy " + proxyHost + " port " + proxyPort);
                    }
                    catch (Exception e) {
                        Log.log(3, MODULE, "Exception during failover auto proxy detection");
                        Log.logException(1, MODULE, e);
                        proxyHost = null;
                    }
                } else if (p.getBooleanProperty("useProxy")) {
                    proxyHost = ((GalleryProperties)p).getProperty("proxyHost");
                    try {
                        proxyPort = p.getIntProperty("proxyPort");
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    proxyUsername = ((GalleryProperties)p).getProperty("proxyUsername");
                    if (proxyUsername != null && proxyUsername.length() > 0) {
                        proxyPassword = p.getBase64Property("proxyPassword");
                    }
                }
                if (proxyHost != null) {
                    Log.log(3, MODULE, "Setting proxy to " + proxyHost + ":" + proxyPort);
                    HTTPConnection.setProxyServer((String)proxyHost, (int)proxyPort);
                    if (proxyUsername != null && proxyUsername.length() > 0) {
                        Log.log(3, MODULE, "Setting proxy auth to " + proxyUsername + ":" + proxyPassword);
                        AuthorizationInfo.addBasicAuthorization((String)proxyHost, (int)proxyPort, (String)"", (String)proxyUsername, (String)proxyPassword);
                    }
                    Properties sprops = System.getProperties();
                    sprops.setProperty("http.proxySet", "true");
                    sprops.setProperty("http.proxyHost", proxyHost);
                    sprops.setProperty("http.proxyPort", "" + proxyPort);
                } else {
                    HTTPConnection.setProxyServer(null, (int)0);
                    Log.log(3, MODULE, "No proxy");
                }
                HTTPConnection mConnection = new HTTPConnection(url);
                GalleryComm.addUserInfo(url);
                String userAgent = g.getUserAgent();
                if (userAgent != null) {
                    mConnection.setDefaultHeaders(new NVPair[]{new NVPair("User-Agent", userAgent)});
                }
                if (g.getType() == 0) {
                    String urlPath = url.getFile();
                    if (g.forceGalleryVersion == 0 || g.forceGalleryVersion == 1) {
                        Log.log(3, MODULE, "Trying protocol 2 for " + url);
                        String urlPath2 = urlPath + (urlPath.endsWith("/") ? "gallery_remote2.php" : "/gallery_remote2.php");
                        if (GalleryComm.tryComm(su, mConnection, urlPath2, null)) {
                            Log.log(3, MODULE, "Server has protocol 2");
                            return new GalleryComm2(g);
                        }
                    }
                    if (g.forceGalleryVersion == 0 || g.forceGalleryVersion == 2) {
                        Log.log(3, MODULE, "Trying protocol 2.5 for " + url);
                        String urlPath2_5 = urlPath + (urlPath.endsWith("/") ? "main.php?g2_controller=remote.GalleryRemote&g2_form[cmd]=no-op" : "/main.php?g2_controller=remote.GalleryRemote&g2_form[cmd]=no-op");
                        StringBuffer sb = new StringBuffer();
                        if (GalleryComm.tryComm(su, mConnection, urlPath2_5, sb)) {
                            if (sb != null && sb.indexOf("ERROR_PERMISSION_DENIED") == -1) {
                                Log.log(3, MODULE, "Server has protocol 2.5");
                                return new GalleryComm2_5(g);
                            }
                            su.error(GRI18n.getString(MODULE, "g2.moduleDisabled"));
                        }
                    }
                    break block32;
                }
                return new GalleryComm2(g);
            }
            catch (ProtocolNotSuppException e) {
                Log.logException(1, MODULE, e);
            }
        }
        return null;
    }

    public static void addUserInfo(URL url) {
        StringTokenizer st;
        String userInfo = url.getUserInfo();
        if (userInfo != null && (st = new StringTokenizer(userInfo, ":")).countTokens() == 2) {
            String username = st.nextToken();
            String password = st.nextToken();
            Log.log(3, MODULE, "Added basic auth params: " + username + " - " + password);
            AuthorizePopup.hackUsername = username;
            AuthorizePopup.hackPassword = password;
            return;
        }
        AuthorizePopup.hackUsername = null;
        AuthorizePopup.hackPassword = null;
    }

    private static boolean tryComm(StatusUpdate su, HTTPConnection mConnection, String urlPath, StringBuffer content) {
        try {
            int rspCode;
            HTTPResponse rsp = content == null ? mConnection.Head(urlPath) : mConnection.Get(urlPath);
            lastRespCode = rspCode = rsp.getStatusCode();
            if (rspCode >= 300 && rspCode < 400) {
                rsp = content == null ? mConnection.Head(urlPath) : mConnection.Get(urlPath);
                rspCode = rsp.getStatusCode();
            }
            if (content != null) {
                content.append(rsp.getText());
            }
            Log.log(3, MODULE, "tryComm " + urlPath + ": " + rspCode);
            return rspCode == 200;
        }
        catch (UnknownHostException uhe) {
            su.error("Unknown host: " + mConnection.getHost());
        }
        catch (IOException ioe) {
            try {
                if (ioe instanceof SSLPeerUnverifiedException) {
                    Log.logException(1, MODULE, ioe);
                    JOptionPane.showMessageDialog((Component)((Object)su), GRI18n.getString(MODULE, "noAuth"), GRI18n.getString(MODULE, "error"), 0);
                }
                Log.logException(1, MODULE, ioe);
            }
            catch (NoClassDefFoundError ncdfe) {
                Log.logException(1, MODULE, ioe);
            }
        }
        catch (ModuleException me) {
            Log.logException(1, MODULE, me);
        }
        catch (ParseException pe) {
            Log.logException(1, MODULE, pe);
        }
        catch (Exception e) {
            Log.logException(1, MODULE, e);
        }
        return false;
    }

    static {
        AuthorizePopup.enable();
        CookieModule.setCookiePolicyHandler((CookiePolicyHandler)new CookiePolicyHandler(){

            public boolean acceptCookie(Cookie cookie, RoRequest req, RoResponse resp) {
                Log.log(3, GalleryComm.MODULE, "Accepting cookie: " + cookie);
                return true;
            }

            public boolean sendCookie(Cookie cookie, RoRequest req) {
                Log.log(3, GalleryComm.MODULE, "Sending cookie: " + cookie);
                return true;
            }
        });
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                Log.log(2, GalleryComm.MODULE, "TrustManager.getAcceptedIssuers");
                return new X509Certificate[0];
            }

            public void checkClientTrusted(X509Certificate[] certs, String authType) {
                Log.log(2, GalleryComm.MODULE, "TrustManager.checkClientTrusted");
            }

            public void checkServerTrusted(X509Certificate[] certs, String authType) {
                Log.log(2, GalleryComm.MODULE, "TrustManager.checkServerTrusted");
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            Log.logException(1, MODULE, e);
        }
    }
}

