#!/bin/sh

# GENPO build script

# This script simply checks that the prerequites are in place and then 
# runs the build sequence.  We do not try to guess where things might
# be - that way lies madness! 

# IF YOU ARE HAVING PROBLEMS DO NOT TRY TO FIX THEM BY ALTERING THIS SCRIPT!

echo "GENPO Build Starting"
echo
echo "Stage 1 - Checking environment is sane..."

if [ -z "$QTDIR" ]; then
    if [ -d "/usr/share/qt3" ]; then
        echo "  QTDIR was not set - but I found QT"
        export QTDIR=/usr/share/qt3
    else
        echo "Error - QTDIR is not set, please ensure QT is properly configured"
	echo "        and that the QTDIR environment variable points to the QT installation"
	echo "        directory.  Then re-run this script."
	exit 1
    fi
else
    echo " QTDIR is set ($QTDIR)"
fi

if ! which qmake  2> /dev/null 1>/dev/null; then
    echo "Error - qmake is not on PATH, please ensure QT is properly configured"
    echo "        and that the 'qmake' utility is on your PATH. "
    echo "        Then re-run this script."
    exit 1
else
    echo " qmake is found (`which qmake`)"
fi

if ! [ -d "src" ]; then
    echo "Error - src directory not found, GENPO package is corrupt"
    exit 1
else
    echo " src directory found (`ls -d src`)"
fi

if ! which gcc  2> /dev/null 1>/dev/null; then
    echo "Error - gcc compiler is not on PATH"
    exit 1
else
    echo " gcc compiler is found (`which gcc`)"
fi

if ! which make  2> /dev/null 1>/dev/null; then
    echo "Error - make is not on PATH"
    exit 1
else
    echo " make is found (`which make`)"
fi

echo "Stage 2 - Preparing Makefile..."

cd src
qmake -makefile genpo.pro

if ! [ -e "Makefile" ]; then
    echo "Error - Makefile not generated by qmake"
    exit 1
else
    echo " Makefile generated"
fi

echo "Stage 3 - Compiling and Linking..."

make

if ! [ -e "genpo" ]; then
    echo "Error - There was some error compiling or linking GENPO"
    echo "        Look at the output above for an explanation"
    exit 1
else
    echo " genpo executable built"
fi

echo 
echo "GENPO Build Complete.  The 'genpo' program is currently in the 'src' 
directory.  Sample organ configurations are in the 'organs' directory.

Have fun!"

exit 0

