-------------------------------------------------------------------------------
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/lista4/data_bind.ads,v $
--  Description     : binding package
--  Author          : Julio Cano                                             --
--  Created         : 8.8.2001                                               --
--  Last Modified By: $Author: merdmann $
--  Last Modified On: $Date: 2002/01/08 19:58:50 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000 Julio Cano                                            --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Julio Cano  <julius_bip@yahoo.com>                               --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
-------------------------------------------------------------------------------

with Gnu.Db.Sqlcli;
use Gnu.Db.Sqlcli;
with Gnu.Db.Sqlcli.Bind;

with Ada.Strings.Unbounded;
use Ada.Strings.Unbounded;

package Data_Bind is

   type Data_List is tagged private;
   type Base_Data is private;
   procedure DataFix (Elem : access Data_List);
   procedure Binddata (Data : access Data_List; Stmt : Sqlhstmt);

   type String_Data is private;
   type String_Data_Ptr is private;
   procedure DataFix (Elem : access String_Data);
   procedure Binddata (Data : access String_Data; Stmt : Sqlhstmt);

   -- This limits string data lenght to 256!!!!!
   subtype sql_str is String(1..256);
   type sql_str_access is access all sql_str;


   function Name2col (Stmt   : Sqlhstmt; Column : Unbounded_String ) return Sql_Column_Number;



--   procedure DataListFix ( List : access Data_List'Class);
   procedure DataListFix ( List : Base_Data);

   procedure RegisterData (List : in out Base_Data; Data : String_access; Column : String);

   procedure UnRegisterData (List : in out Base_Data; Column : String);

   procedure UnRegisterAll (List : in out Base_Data);

   procedure Binddatalist (List : Base_Data; Stmt : Sqlhstmt);

private

   type Base_Data is access all Data_List'Class;
   type Data_List is tagged
      record
         Field : Unbounded_String;
         Next  : Base_Data;
      end record;



   package String_Binding is new Gnu.Db.Sqlcli.Bind (Sql_Str,
                                                     Sql_Str_Access);
   package Sb renames String_Binding;

   type String_Data is new Data_List with
      record
         Data        : String_access;
         Data_Length : aliased Sqlinteger;
         Binded : Sql_Str_Access;
      end record;
   type String_Data_Ptr is access all String_Data;



end Data_Bind;
