/*
 * Copyright (C) 2005-2010 Freescale Semiconductor, Inc. All rights reserved.
 *
 */
 
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
 
/*
 * Module Name:    mfw_gst_mp4demuxer.h
 *
 * Description: This Header file contains all the declarations 
 *              of mp4 Demuxer Plugin for GStreamer.                         
 * Portability:    This code is written for Linux OS and Gstreamer
 */  
 
/*
 * Changelog: 
 *
 */

/*=============================================================================
                            INCLUDE FILES
=============================================================================*/
#include "mp4_parser_v2/MP4ParserAPI.h"

#ifndef _MFW_GST_MP4_DEMUXER_H
#define _MFW_GST_MP4_DEMUXER_H


/* drm divx support definition */
#define MONO 1
#define STEREO 2

#define LIMIT_MAX_MP4_SAMPLESIZE   (1024*512)
#define DEFAULT_MAX_MP4_SAMPLESIZE (8192*4)
#define DEFAULT_MIN_MP4_SAMPLESIZE 1024
#define MP4_BITMAPINFOSIZE             0

/* below used to indicate totally how many usr data items need to trace */
#define MP4_USRDATA_NUM       16
#define MP4_REMAIN_THUNK_DATA_SIZE (10*1024)

#define MP4_PARSER_ERROR_CODE gint32
/*=============================================================================
                              CONSTANTS
=============================================================================*/

/* None. */

/*=============================================================================
                               ENUMS
=============================================================================*/
/* None */

/*=============================================================================
                               MACROS
=============================================================================*/

#define MAX_SRC_PADS  2
#define MAX_TRACK_NUM MAX_MP4_TRACKS
G_BEGIN_DECLS
#define MFW_GST_TYPE_MP4_DEMUXER (mfw_gst_type_mp4_demuxer_get_type())
#define MFW_GST_MP4_DEMUXER(obj) \
	(G_TYPE_CHECK_INSTANCE_CAST((obj), MFW_GST_TYPE_MP4_DEMUXER, MFW_GST_MP4DEMUX_INFO_T))
#define MFW_GST_MP4_DEMUXER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), MFW_GST_TYPE_MP4_DEMUXER, MFW_GST_MP4DEMUX_INFO_CLASS_T))
#define MFW_GST_IS_MP4_DEMUXER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), MFW_GST_TYPE_MP4_DEMUXER))
#define MFW_GST_IS_MP4_DEMUXER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), MFW_GST_TYPE_MP4_DEMUXER))
/*=============================================================================
                            STRUCTURES AND OTHER TYPEDEFS
=============================================================================*/
/*  This structure is used by the parser library to give information to the plug-in.
    This structure contains lot of variables which are similar to the above strcture, 
    but the reason why this is separate is because we wanted to maintain clean interface
    between parser library and the gstreamer plug-in.
*/

typedef struct _mp4_input_file_info {
    guint64 length;		                               /* Length of the file/buffer */
    guint64 offset;	                                   /* Present location.         */
    guint64 buf_offset;

} mp4_input_file_info;

typedef struct {
    GstBuffer * gstbuf;          /* gstbuffer used to get sample */
    gint offset;                 /* offset to no used space in gstbuf */
    gint cachesize;              /* default allocate size of gstbuf */
}MP4PadCache;

typedef struct{
	guint32 id;                   /* title, artist etc */
	guint8 *data_ptr;
	guint32 data_size;           /* data size in byte */   
}MP4_UsrData;

typedef struct{
	gint32 trackindex;
	MediaType trackType;     /* used to indicate audio or video*/
}Pad2Trackindex;
typedef struct{
	gint32 audiotrack[MAX_TRACK_NUM];
	gint32 videotrack[MAX_TRACK_NUM];
	gint32 audio_track_num;
	gint32 video_track_num;
}TrackReorder;


typedef struct 
{
    MediaType mediaType;
    gboolean isCbr;
    guint64 usSampleDuration;                /* sample duration for VBR stream. 0 for CBR stream*/
    guint32 bitrate;                         /* bitrate for CBR stream, 0 for VBR stream */
    guint32 maxSampleSize;

    guint64 usReadingDuration;               /* accumulated duration of samples */
    guint32 sampleCount;
    gboolean eos; 

    VideoCodecType videoCodec;
    AudioCodecType audioCodec;
    guint32 width;
	guint32 height;
	double   video_framerate;
    guint32 numChannels;
    guint32 sampleRate;	
    guint32 bitRate;
	guint32 pcm_width;
	guint32 decoderType;
	guint32 decoderSubtype;
    guint32 language;                        /* three byte language code */
    GstBuffer *decoderSpecificInfo;
}Track;



typedef struct _MFW_GST_MP4DEMUX_INFO_T {
    GstElement element;		                            /* instance of base class      */
    GstPad *sinkpad;		                            /* sink pad of element         */
    GstPad *srcpad[MAX_SRC_PADS];	                    /* src pads for output data    */
    guint32 total_src_pad;	                            /* number of src pads          */
	guint32 total_tracks;                               /* total number of tracks      */
    mp4_input_file_info file_info;	                    /* file information            */
    GstSegment segment;		                            /* configured play segment     */
    gboolean stop_request;	                            /* stop request flag           */
    gboolean new_seg_flag_video;
	gboolean new_seg_flag_audio;
    GstCaps *caps[MAX_SRC_PADS];	                    /* src pad capability          */
    GstBuffer *tmpbuf;		                            /* buffer to store block of  input data            */

	file_stream_t stream;
    ParserMemoryOps memOps;	
	MP4ParserHandle  parserHandle;
	void *context;
																 
    guint buf_size;		                                /* temparory buffer size       */
    guint8 *inbuff;
	gboolean seek_flag;
	gboolean eos_flag[MAX_SRC_PADS];
	GMutex *media_file_lock;//lock for v4ldevice operation
	gboolean do_seek_flag;
    gboolean videosent;
	Pad2Trackindex srcpadnum2trackindex[MAX_SRC_PADS];
    MP4PadCache padcache[MAX_SRC_PADS];                 /* srcpad cache control to use sub gstbuffer to improve buffer usage efficiency */
	/* below var added for mp4 core parser */

	Track tracks[MAX_TRACK_NUM];
    guint64 usDuration;
	MP4_UsrData usrdata[MP4_USRDATA_NUM];	
	gboolean seekable;
	
	/* below two var used for configed audio or video track decode, default value is 0 */
    gint32  audio_track_decode;
    gint32  video_track_decode;	
	TrackReorder reorder_track;
    gchar *accurate_seek;

} MFW_GST_MP4DEMUX_INFO_T;


typedef struct _MFW_GST_MP4DEMUX_INFO_CLASS_T {
    GstElementClass parent_class;

} MFW_GST_MP4DEMUX_INFO_CLASS_T;

/*=============================================================================
                           GLOBAL VARIABLE DECLARATIONS
=============================================================================*/

/* None. */

/*=============================================================================
                            FUNCTION PROTOTYPES
=============================================================================*/
GType mfw_gst_type_mp4_demuxer_get_type(void);

/*===========================================================================*/
G_END_DECLS
#endif /*_MFW_GST_MP4_DEMUXER_H*/
