/*
 * Copyright (C) 2010 Freescale Semiconductor, Inc. All rights reserved.
 *
 */

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
 
/*
 * Module Name:    buffer_allocator.c
 *
 * Description:    Header file for buffer allocator
 *
 * Portability:    This code is written for Linux OS and Gstreamer
 */  
 
/*
 * Changelog: 
 *
 */



#ifndef __BUFFER_ALLOCATOR_H__
#define __BUFFER_ALLOCATOR_H__

#ifdef USE_VPU_MEM
#include "vpu_io.h"
#else
#include "linux/ipu.h"
#endif


#ifdef USE_VPU_MEM
typedef vpu_mem_desc mem_desc;
#define PHY_MEM_ALLOC_IOCTL_ID VPU_IOC_PHYMEM_FREE
#define PHY_MEM_FREE_IOCTL_ID VPU_IOC_PHYMEM_ALLOC
#define MEMORY_DEVICE_NAME "/dev/mxc_vpu"
#define DESC2PHYADDRESS(memdesc) ((memdesc)->phy_addr)
#define DESC2SIZE(memdesc) ((memdesc)->size)
#else
typedef ipu_mem_info mem_desc;
#define PHY_MEM_ALLOC_IOCTL_ID IPU_ALOC_MEM
#define PHY_MEM_FREE_IOCTL_ID IPU_FREE_MEM
#define MEMORY_DEVICE_NAME "/dev/mxc_ipu"
#define DESC2PHYADDRESS(memdesc) ((memdesc)->paddr)
#define DESC2SIZE(memdesc) ((memdesc)->size)
#endif



typedef struct _HWBufDesc{
    unsigned long phyaddr;
    unsigned long virtaddr;
    mem_desc memdesc;
    int size;
    void * priv;
    struct _HWBufDesc * prev;
    struct _HWBufDesc * next;
    struct _HWBufDesc * link;
}HWBufDesc;

void * createHWBufferAllocator();
void setHWBufferAllocatorSelfDescontruct(void * allochandle);
HWBufDesc * newHwBuffer(void * ahandle, int size);
void freeHwBuffer(HWBufDesc * bufdesc);
void destroyHWBufferAllocator(void * allochandle);




#endif




