import time
from datetime import datetime, timedelta

import os, unittest
from gi.repository import Gwibber
from hashlib import sha1

class TimeStringTestCase (unittest.TestCase):
    def setUp (self):
        os.environ["XDG_DATA_HOME"] = os.path.realpath (os.path.join (os.path.curdir, "..", "data"))
        os.environ["XDG_CACHE_HOME"] = os.path.realpath (os.path.join (os.path.curdir, "..", "data"))
        self.utils = Gwibber.Utils ()
        self.now = datetime.utcnow()

    def _ago(self, **kws):
        # Convert keywords into a timedelta, subtract that from utcnow, and
        # return seconds since epoch.
        timetup = (self.now - timedelta(**kws)).timetuple()
        return time.mktime(timetup)

    def test_time_string_seconds (self):
        ts = self.utils.generate_time_string(self._ago(seconds=59))
        self.assertEqual (ts, 'a few seconds ago')

    def test_time_string_minute (self):
        ts = self.utils.generate_time_string(self._ago(seconds=60))
        self.assertEqual (ts, '1 minute ago')

    def test_time_string_minutes (self):
        ts = self.utils.generate_time_string(self._ago(seconds=3559))
        self.assertIn ('minutes ago', ts)

    def test_time_string_hour (self):
        ts = self.utils.generate_time_string(self._ago(seconds=3601))
        self.assertEqual (ts, '1 hour ago')

    def test_time_string_hours (self):
        ts = self.utils.generate_time_string(self._ago(seconds=7201))
        self.assertIn ('hours ago', ts)

    def test_time_string_day (self):
        ts = self.utils.generate_time_string(self._ago(seconds=86400))
        self.assertEqual (ts, '1 day ago')

    def test_time_string_days (self):
        ts = self.utils.generate_time_string(self._ago(days=2))
        self.assertIn ('days ago', ts)

class AvatarPathTestCase (unittest.TestCase):

    def setUp (self):
        os.environ["XDG_DATA_HOME"] = os.path.realpath (os.path.join (os.path.curdir, "..", "data"))
        os.environ["XDG_CACHE_HOME"] = os.path.realpath (os.path.join (os.path.curdir, "..", "data"))
        self.utils = Gwibber.Utils ()

    def test_avatar_path (self):
        url = "http://test.com/avatar"
        avatar_path = self.utils.avatar_path (url)
        self.assertEqual (avatar_path, os.path.join (os.environ["XDG_CACHE_HOME"], "gwibber", "avatars", sha1(url).hexdigest()))

test_cases = (TimeStringTestCase, AvatarPathTestCase)

def load_tests(loader, tests, pattern):
    suite = unittest.TestSuite()
    for test_class in test_cases:
        tests = loader.loadTestsFromTestCase(test_class)
        suite.addTests(tests)
    return suite

