/*
 * xfce4-hedley-plugins plugin for Xfce4.
 *
 * Copyright (c) 2010 Ying-Chun Liu (PaulLiu) <paul.liu@canonical.com>
 *
 * Some code was used as a starter, but is mostly gone. Nevertheless, this code
 * was:
 * 
 * Copyright (c) 2003 Nicholas Penwarden <toth64@yahoo.com>
 * Copyright (c) 2003 Benedikt Meurer <benedikt.meurer@unix-ag.uni-siegen.de>
 * Copyright (c) 2003 edscott wilson garcia <edscott@users.sourceforge.net>
 * Copyright (c) 2005 Joshua Kwan <joshk@triplehelix.org>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef RUNCMD
    #define RUNCMD "/usr/bin/hedley-show-connections"
#endif
#ifndef ICON
    #define ICON "hedley-home"
#endif

#define GETTEXT_PACKAGE "xfce4-hedley-show-connections"
#define PACKAGE_LOCALE_DIR "/usr/share/locale"

#include <ctype.h>
#include <stdlib.h>
#include <string.h>

#include <libxfce4util/libxfce4util.h>
#include <libxfce4panel/libxfce4panel.h>
#include <libxfcegui4/libxfcegui4.h>

#include <libxfce4panel/xfce-panel-plugin.h>

struct plugin_data
{
	GtkWidget* button;
	GtkWidget* vbox;
	GtkWidget* ebox;

	GtkOrientation orientation;

	XfcePanelPlugin *plugin;
};

static void
plugin_data_free (XfcePanelPlugin *plugin, struct plugin_data *c)
{
	g_free(c);
}

static void button_clicked(GtkButton *button, gpointer user_data) {
    int result;
    result = system(RUNCMD);
}

static void
setup_plugin_data (XfcePanelPlugin *plugin, struct plugin_data *c)
{
        GtkImage *button_image;
	c->button = xfce_create_panel_button();
        g_signal_connect(c->button, "clicked", G_CALLBACK(button_clicked), c);
	xfce_panel_plugin_add_action_widget(plugin,c->button);
        button_image = GTK_IMAGE(gtk_image_new_from_pixbuf(xfce_themed_icon_load(ICON, 48)));
        gtk_button_set_image(GTK_BUTTON(c->button), GTK_WIDGET(button_image));
        gtk_widget_set_tooltip_text(c->button,xfce_panel_plugin_get_display_name(plugin));

	if (!c->ebox)
	{
		c->ebox = gtk_event_box_new();
		gtk_container_add(GTK_CONTAINER(plugin), c->ebox);
		gtk_widget_show(c->ebox);
	}

	if (c->vbox) {
		gtk_widget_destroy(c->vbox);
        }
	
	if (c->orientation == GTK_ORIENTATION_HORIZONTAL) {
		c->vbox = gtk_hbox_new(FALSE, 0);
	} else if (c->orientation == GTK_ORIENTATION_VERTICAL) {
		c->vbox = gtk_vbox_new(FALSE, 0);
	}

	gtk_box_pack_start(GTK_BOX(c->vbox), c->button, FALSE, FALSE, 0);
	
	gtk_container_add(GTK_CONTAINER(c->ebox), c->vbox);

	gtk_widget_show(c->vbox);
	gtk_widget_show(c->button);

	return;
}

static void
plugin_data_set_orientation (XfcePanelPlugin *plugin, GtkOrientation orientation,
	struct plugin_data *c)
{
	if (c->orientation == orientation)
		return;
	
	c->orientation = orientation;

	gtk_container_remove(GTK_CONTAINER(plugin), c->vbox);

	setup_plugin_data(plugin, c);
}

static void
plugin_data_read_config (XfcePanelPlugin *plugin, struct plugin_data *c)
{
	char *file;
	XfceRc *rc;

	if ((file = xfce_panel_plugin_lookup_rc_file(plugin)) == NULL)
	{
		return;
	}
	
	rc = xfce_rc_simple_open(file, FALSE);
	g_free(file);
	/* read configuration here */
	xfce_rc_close (rc);
}

static void
plugin_data_write_config (XfcePanelPlugin *plugin, struct plugin_data *c)
{
	char *file;
	XfceRc *rc;

	if (!(file = xfce_panel_plugin_save_location(plugin, TRUE)))
		return;

	rc = xfce_rc_simple_open(file, FALSE);

	g_free(file);

	if (!rc)
		return;

        /* write data here */
	xfce_rc_close (rc);
}

static void
plugin_data_set_size (XfcePanelPlugin *plugin, int size, struct plugin_data *c)
{
	if (c->orientation == GTK_ORIENTATION_VERTICAL)
		gtk_widget_set_size_request(GTK_WIDGET(plugin), size, -1);
	else
		gtk_widget_set_size_request(GTK_WIDGET(plugin), -1, size);
}

static struct plugin_data* plugin_data_new (XfcePanelPlugin *plugin)
{
	struct plugin_data* c = calloc(1, sizeof(struct plugin_data));

	c->plugin = plugin;
	c->orientation = xfce_panel_plugin_get_orientation(plugin);
	
	/* possibly feed config in here */
	plugin_data_read_config(plugin, c);

	return c;
}

void hedley_plugins_construct(XfcePanelPlugin *plugin)
{
#ifdef ENABLE_NLS
    /* This is required for UTF-8 at least - Please don't remove it */
    bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
    bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
    textdomain (GETTEXT_PACKAGE);
#endif

	struct plugin_data *plugin_data = plugin_data_new(plugin);

	g_signal_connect(plugin, "free-data", G_CALLBACK(plugin_data_free), plugin_data);
	g_signal_connect(plugin, "size-changed", G_CALLBACK(plugin_data_set_size), plugin_data);
	g_signal_connect(plugin, "orientation-changed", G_CALLBACK(plugin_data_set_orientation), plugin_data);
	g_signal_connect(plugin, "save", G_CALLBACK(plugin_data_write_config), plugin_data);
	
	setup_plugin_data(plugin, plugin_data);
}

XFCE_PANEL_PLUGIN_REGISTER_EXTERNAL(hedley_plugins_construct);
