#include "qtbindingsplugin.h"
#include "qfilesystemmodelqml.h"
#include "qsortfilterproxymodelqml.h"
#include <QDesktopServices>
#include <QDeclarativeEngine>
#include <QDeclarativeContext>
#include <QtDeclarative/qdeclarative.h>
#include <QTimer>

void QtBindingsPlugin::registerTypes(const char *uri)
{
    qmlRegisterType<QFileSystemModelQML>(uri, 0, 1, "QFileSystemModelQML");
    qmlRegisterType<QSortFilterProxyModelQML>(uri, 0, 1, "QSortFilterProxyModelQML");
    qmlRegisterType<QTimer>(uri, 0, 1, "QTimer");
}

void QtBindingsPlugin::initializeEngine(QDeclarativeEngine *engine, const char *uri)
{
    QString homeDirectory = QDesktopServices::storageLocation(QDesktopServices::HomeLocation);
    engine->rootContext()->setContextProperty("home_directory", homeDirectory);
}

Q_EXPORT_PLUGIN2(qtbindingsplugin, QtBindingsPlugin);
