#ifndef __HRN_SOURCE_H__
#define __HRN_SOURCE_H__

#include <bickley/bkl.h>
#include <bickley/bkl-source-client.h>

#include <glib-object.h>

#include "hrn-cluster-tree.h"

G_BEGIN_DECLS

#define HRN_TYPE_SOURCE                                                \
  (hrn_source_get_type ())
#define HRN_SOURCE(obj)                                                \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj),                                  \
                               HRN_TYPE_SOURCE,                        \
                               HrnSource))
#define HRN_SOURCE_CLASS(klass)                                        \
  (G_TYPE_CHECK_CLASS_CAST ((klass),                                   \
                            HRN_TYPE_SOURCE,                           \
                            HrnSourceClass))
#define IS_HRN_SOURCE(obj)                                             \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                                  \
                               HRN_TYPE_SOURCE))
#define IS_HRN_SOURCE_CLASS(klass)                                     \
  (G_TYPE_CHECK_CLASS_TYPE ((klass),                                   \
                            HRN_TYPE_SOURCE))
#define HRN_SOURCE_GET_CLASS(obj)                                      \
  (G_TYPE_INSTANCE_GET_CLASS ((obj),                                   \
                              HRN_TYPE_SOURCE,                         \
                              HrnSourceClass))

typedef struct _HrnSourcePrivate HrnSourcePrivate;
typedef struct _HrnSource HrnSource;
typedef struct _HrnSourceClass HrnSourceClass;

struct _HrnSource
{
  GObject parent;

  HrnSourcePrivate *priv;
};

struct _HrnSourceClass
{
  GObjectClass parent_class;
};

GType       hrn_source_get_type (void) G_GNUC_CONST;

HrnSource * hrn_source_new             (BklSourceClient *client);
const char *hrn_source_get_object_path (HrnSource   *source);
const char *hrn_source_get_name        (HrnSource   *source);
GSequence * hrn_source_get_index       (HrnSource   *source);
BklDB *     hrn_source_get_db          (HrnSource   *source);
BklItem *   hrn_source_get_item        (HrnSource   *source,
                                        const char  *uri);
void hrn_source_filter           (HrnSource   *source,
                                  const gchar *text);
HrnClusterTree *hrn_source_get_cluster_tree (HrnSource *source);

G_END_DECLS

#endif
