/*
 * Hornsey - Moblin Media Player.
 * Copyright © 2009 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _HRN_ITEM_H
#define _HRN_ITEM_H

#include <clutter/clutter.h>

G_BEGIN_DECLS

#define HRN_TYPE_ITEM    hrn_item_get_type ()

#define HRN_ITEM(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), HRN_TYPE_ITEM, HrnItem))

#define HRN_ITEM_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), HRN_TYPE_ITEM, HrnItemClass))

#define HRN_IS_ITEM(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), HRN_TYPE_ITEM))

#define HRN_IS_ITEM_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), HRN_TYPE_ITEM))

#define HRN_ITEM_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), HRN_TYPE_ITEM, HrnItemClass))

typedef struct _HrnItem HrnItem;
typedef struct _HrnItemClass HrnItemClass;
typedef struct _HrnItemPrivate HrnItemPrivate;

struct _HrnItem
{
  HrnSwitcher parent_instance;
  BklItem    *item;

  NbtkWidget *title;
  NbtkWidget *meta;

  NbtkWidget *title2;
  NbtkWidget *meta2;
#if 0
  gchar *title;          /* The title of the item (falls back to basename) */
  gchar *meta1;          /* primary meta data for item (author/origin) */
#endif
  HrnItemPrivate *priv;
  gint            no;
};

struct _HrnItemClass
{
  /*< private >*/
  HrnSwitcherClass parent_class;
};

gboolean hrn_item_can_drop (ClutterActor *actor,
                            ClutterActor *dropped_on,
                            gint          x,
                            gint          y,
                            gpointer      userdata);

gboolean hrn_item_drop     (ClutterActor *actor,
                            ClutterActor *dropped_on,
                            gint          x,
                            gint          y,
                            gpointer      userdata);

GType hrn_item_get_type (void) G_GNUC_CONST;





gboolean hrn_item_get_selected (HrnItem *item);
void     hrn_item_set_selected (HrnItem *item,
                                gboolean selected);






/* should be in utils instead */

/* returns allocated strings with what hornsey considers
 * the title of the item and the string that contains hornseys
 * view of the metadata line.
 */
gchar *       hrn_item_get_title (BklItem *item);
gchar *       hrn_item_get_meta (BklItem *item);
gchar *       bkl_item_uri_to_title (BklItem *item);
gchar *       hrn_item_uri_parent_to_meta (BklItem *item);

ClutterActor *hrn_play_button_new (HrnSwitcher  *switcher,
                                   ClutterActor *group,
                                   BklItem      *item);
HrnView *     hrn_item_get_view (ClutterActor *actor);

/* this causes item mode to be activated */

G_END_DECLS

#endif
