/*
 * Hornsey - Moblin Media Player.
 * Copyright © 2009 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _HRN_SIDEBAR_H
#define _HRN_SIDEBAR_H

#include <clutter/clutter.h>

G_BEGIN_DECLS

#define HRN_TYPE_SIDEBAR    hrn_sidebar_get_type ()

#define HRN_SIDEBAR(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), HRN_TYPE_SIDEBAR, HrnSidebar))

#define HRN_SIDEBAR_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), HRN_TYPE_SIDEBAR, HrnSidebarClass))

#define HRN_IS_SIDEBAR(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), HRN_TYPE_SIDEBAR))

#define HRN_IS_SIDEBAR_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), HRN_TYPE_SIDEBAR))

#define HRN_SIDEBAR_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), HRN_TYPE_SIDEBAR, HrnSidebarClass))

typedef struct _HrnSidebar HrnSidebar;
typedef struct _HrnSidebarClass HrnSidebarClass;
typedef struct _HrnSidebarPrivate HrnSidebarPrivate;

struct _HrnSidebar
{
  NbtkBin            parent_instance;
  HrnSidebarPrivate *priv;
};

struct _HrnSidebarClass
{
  /*< private >*/
  NbtkBinClass parent_class;
};

GType       hrn_sidebar_get_type (void) G_GNUC_CONST;

HrnSidebar *hrn_sidebar_new            (void);
void        hrn_sidebar_update_sources (HrnSidebar *sidebar);
gboolean    hrn_sidebar_visible        (void);

G_END_DECLS

#endif
