#ifndef __HRN_TOOLBAR_GROUP_H__
#define __HRN_TOOLBAR_GROUP_H__

#include <clutter/clutter.h>
#include "hrn-toolbar.h"
#include "hrn-toolbar-theatre.h"

G_BEGIN_DECLS

#define HRN_TYPE_TOOLBAR_GROUP                                          \
  (hrn_toolbar_group_get_type ())
#define HRN_TOOLBAR_GROUP(obj)                                          \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj),                                  \
                               HRN_TYPE_TOOLBAR_GROUP,                 \
                               HrnToolbarGroup))
#define HRN_TOOLBAR_GROUP_CLASS(klass)                                  \
  (G_TYPE_CHECK_CLASS_CAST ((klass),                                   \
                            HRN_TYPE_TOOLBAR_GROUP,                    \
                            HrnToolbarGroupClass))
#define IS_HRN_TOOLBAR_GROUP(obj)                                       \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                                  \
                               HRN_TYPE_TOOLBAR_GROUP))
#define IS_HRN_TOOLBAR_GROUP_CLASS(klass)                               \
  (G_TYPE_CHECK_CLASS_TYPE ((klass),                                   \
                            HRN_TYPE_TOOLBAR_GROUP))
#define HRN_TOOLBAR_GROUP_GET_CLASS(obj)                                \
  (G_TYPE_INSTANCE_GET_CLASS ((obj),                                   \
                              HRN_TYPE_TOOLBAR_GROUP,                  \
                              HrnToolbarGroupClass))


typedef struct _HrnToolbarGroupPrivate HrnToolbarGroupPrivate;
typedef struct _HrnToolbarGroup HrnToolbarGroup;
typedef struct _HrnToolbarGroupClass HrnToolbarGroupClass;

struct _HrnToolbarGroup
{
  ClutterGroup parent;

  HrnToolbarGroupPrivate *priv;
};

struct _HrnToolbarGroupClass
{
  ClutterGroupClass parent_class;
};

GType              hrn_toolbar_group_get_type   (void) G_GNUC_CONST;
HrnToolbarGroup *  hrn_toolbar_group_new        (void);
void               hrn_toolbar_group_set_mode   (HrnToolbarGroup    *group,
                                                 HrnToolbarGroupMode mode);
void               hrn_toolbar_group_set_pinned (HrnToolbarGroup    *group,
                                                 gboolean            pinned);
HrnToolbar *       hrn_toolbar_group_get_view_toolbar (HrnToolbarGroup *group);
HrnToolbarTheatre *hrn_toolbar_group_get_theatre_toolbar (HrnToolbarGroup *group);

G_END_DECLS

#endif /* __HRN_TOOLBAR_GROUP_H__ */
