/*
 * Hornsey - Moblin Media Player.
 * Copyright © 2009 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */


#ifndef _HRN_TOOLBAR_THEATRE_H
#define _HRN_TOOLBAR_THEATRE_H

#include <glib-object.h>
#include <clutter/clutter.h>
#include <nbtk/nbtk.h>
#include "hrn.h"

G_BEGIN_DECLS

#define HRN_TYPE_TOOLBAR_THEATRE    hrn_toolbar_theatre_get_type ()

#define HRN_TOOLBAR_THEATRE(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), HRN_TYPE_TOOLBAR_THEATRE, HrnToolbarTheatre))

#define HRN_TOOLBAR_THEATRE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), HRN_TYPE_TOOLBAR_THEATRE, HrnToolbarTheatreClass))

#define HRN_IS_TOOLBAR_THEATRE(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), HRN_TYPE_TOOLBAR_THEATRE))

#define HRN_IS_TOOLBAR_THEATRE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), HRN_TYPE_TOOLBAR_THEATRE))

#define HRN_TOOLBAR_THEATRE_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), HRN_TYPE_TOOLBAR_THEATRE, HrnToolbarTheatreClass))

typedef struct _HrnToolbarTheatrePrivate HrnToolbarTheatrePrivate;

typedef struct
{
  NbtkTable parent;

  HrnToolbarTheatrePrivate *priv;
} HrnToolbarTheatre;

typedef struct
{
  NbtkTableClass parent_class;

  void (*travel)(HrnToolbarTheatre *toolbar_theatre,
                 gint               direction);
  void (*settings)(HrnToolbarTheatre *toolbar_theatre);
  void (*quit)(HrnToolbarTheatre *toolbar_theatre);
} HrnToolbarTheatreClass;

GType       hrn_toolbar_theatre_get_type (void);

NbtkWidget* hrn_toolbar_theatre_new (void);

NbtkWidget *hrn_toolbar_theatre_get_zoom_bar (
  HrnToolbarTheatre *toolbar_theatre);

NbtkWidget *hrn_toolbar_theatre_get_search (HrnToolbarTheatre *toolbar_theatre);
void        hrn_toolbar_theatre_focused    (ClutterActor *toolbar);

G_END_DECLS

#endif /* _HRN_TOOLBAR_THEATRE_H */

