/*
 * Hornsey - Moblin Media Player.
 * Copyright © 2009 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _HORNSEY_H__
#define _HORNSEY_H__

/* XXX: bickley should have a single header include policy */

#include <bickley/bkl-item.h>
#include <bickley/bkl-item-image.h>
#include <bickley/bkl-item-video.h>
#include <bickley/bkl-item-audio.h>
#include <bickley/bkl-db.h>
#include <bickley/bkl-utils.h>
#include <bickley/bkl-source-client.h>
#include <bickley/bkl-source-manager-client.h>

/* XXX: nbtk should have a single header include policy */

#include <nbtk/nbtk.h>
#include <gtk/gtk.h>
#include <libnotify/notify.h>

#include "hrn-button.h"
#include "hrn-source.h"
#include "hrn-switcher.h"
#include "hrn-view.h"
#include "hrn-queue.h"
#include "hrn-sidebar.h"
#include "hrn-theatre.h"
#include "hrn-cluster.h"
#include "hrn-item.h"
#include "hrn-item-image.h"
#include "hrn-item-audio.h"
#include "hrn-item-video.h"
#include "hrn-drag-n-drop.h"
#include "hrn-searchbar.h"
#include "hrn-texture-cache.h"
#include "hrn-disclaimer.h"
#include "hrn-toolbar.h"
#include "hrn-popup.h"
#include "hrn-square-clone.h"
#include "hrn-queue-group.h"
#include "hrn-texture-frame.h"
#include "hrn-controls.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <clutter-gst/clutter-gst.h>
#include <gio/gio.h>
#include <glib/gprintf.h>

#include <glib/gi18n.h>
#include <config.h>

extern gint  DIM;

#define HRN_STARTUP_NOTIFICATION 1

#define INITIAL_SCALE   0.5
#define HRN_START_ITEM  0
#define HRN_X_OFFSET    30  /* needs to be affected by scale where used */

#define HRN_TO_THEATRE_DURATION   500
#define HRN_FROM_THEATRE_DURATION 500

#define HRN_SLIDESHOW_DELAY   10000

#define HRN_ZOOM_HOLD_THRESHOLD 6
#define HRN_ZOOM_HOLD_TIMEOUT   200

#define HRN_ITEM_USE_FRAME    1   /* use frames around items */
#define HRN_JUST_RECTANGLES   0   /* only use rectangles, not real textures
                                     for items. */
#define HRN_LOAD_SIZE_ASYNC   1  /* hornsey doesn't cope fully with textures
                                    * changing sizes on the fly, this needs
                                    * to be made fully functional as part of
                                    * not blocking in transitions.
                                    */

#define HRN_PURGE_UNUSED        1
#define HRN_MAX_CLUSTERS        1000 /* bail out when this many clusters
                                       have been created
                                     */
#define HRN_CLUSTER_COUNT       5  /* how many items shown in cluster view */
#define HRN_ELEMENT_LOAD_FULL   0   /* load full size images (in thumbview)*/

#define HRN_CLUSTER_TRANS_START 16 /* how many item the cluster intitially
                                       expands into */

#define HRN_ROW_SPACING       1.25  /* differnt values here cause variations
                                       in the minimal jitter found between
                                       HrnView and HrnClusters accumulated
                                       positions, the value is tuned to give
                                       reasonable results for the netbook
                                       resolution.
                                     */


#define HRN_FRAME_USE_RECTANGLE 0
#define HRN_STAGE_COLOR       0xff,0xff,0xff,0xff
/*#define HRN_STAGE_COLOR       0x00,0x00,0x00,0xff*/
#define HRN_VIEW_FPS          60

#define HRN_CACHE_MAX_SIZE    (1024*1024*128) /* 128mb texture memory */

#define HRN_ZOOM_RATE         1.0015/* 1.0015 seems good the rate of zooming */
#define HRN_OFF_STAGE_FUDGE   0.1   /* how many stage sizes to include above
                          00          and below the stage to be considered
                                       "on-stage" (this will act as a
                                       preloading area for asynchronous loading
                                     */

#define HRN_DEBUG_OFF_STAGE   0     /* push actual stage back, and draw off stage actors as
                                       transparent red rectangles.
                                     */
#define HRN_DEBUG_DEPTH      -9500  /* the depth used for off stage debugging */

#define HRN_SIDEBAR_TIMEOUT   2000  /* msec before controls go away */


#define HRN_CONTROLS_TIMEOUT  1000  /* msec before controls go away */
#define CONTROLS_IN_DURATION  250

#define CONTROLS_OUT_DURATION 250      /* length of transition to half transparent state */
#define CONTROLS_OUT_DURATION2 3000    /* time spent in half transparent state */
#define CONTROLS_OUT_DURATION3 250

#define HRN_HIDE_LABEL_ON_GRAB 0

#define SIDEBAR_IN_DURATION  CONTROLS_IN_DURATION
#define SIDEBAR_OUT_DURATION CONTROLS_OUT_DURATION

#define HRN_DROP_MASK_QUEUE    (1<<0)
#define HRN_DROP_MASK_SIDEBAR  (1<<1)

#define HRN_CLEAR_QUERY_ON_FILTER_CHANGE 0

#define HRN_USE_NORMAL_LABELS    1
#define HRN_OFF_STAGE_COUNT   0     /* how many times to be allocated off stage before being considered off stage*/

/* these are just ClutterGroups setting up a fixed hierachy
 * of containers to organize "toplevel" ui elements in.
 */
extern ClutterActor *hrn_controls;

#if 0
extern ClutterActor   *hrn_theatre_toolbar;
extern ClutterActor   *hrn_normal_toolbar;
#endif

extern ClutterActor *hrn_search_entry;
extern ClutterActor *hrn_toolbar;
extern ClutterActor *hrn_sidebar;
extern ClutterActor *hrn_scrollbar;
extern ClutterActor *hrn_queues;
extern ClutterActor *hrn_controls_frame;

extern ClutterActor *hrn_content_area;
extern ClutterActor *hrn_theatre_lowlight;
extern ClutterActor *hrn_theatre_parent;
extern ClutterActor   *hrn_theatre;
extern ClutterActor   *hrn_theatre_underlay;
extern ClutterActor *hrn_view_parent;
extern ClutterActor    *hrn_view;

extern BklSourceManagerClient *manager;
extern NbtkAdjustment *zoom_adjustment;

extern GKeyFile *pinned_searches;
extern HrnQueue *master_queue;
extern gboolean hrn_in_preload;
extern gboolean hrn_auto_zoom;

enum {
   HRN_SQUARE    = 1,
   HRN_PINCHABLE = 2
};

ClutterActor *hrn_make_element (BklItem *element, gint flags);
ClutterActor *hrn_make_item    (BklItem *item, gint flags);

ClutterActor *hrn_make_cluster (GList *results);

gint hrn_cluster_get_cells     (ClutterActor *cluster);
void hrn_controls_wake         (void);
void hrn_sidebar_wake          (void);
void hrn_play_now              (BklItem *item);
void hrn_play_uri_now          (const gchar *uri);

HrnSource *hrn_get_local_source (void);
GList *hrn_get_transient_sources (void);
HrnSource *hrn_get_source_for_path (const char *path);
BklItem * hrn_get_item_for_uri (const char *uri);
gchar *hrn_resolve_mimetype (const gchar *uri);

extern gboolean hrn_controls_can_has_fade;
extern gboolean hrn_smooth_scroll;

/*
#define LIN(start,end) (((start)*(1.0-(progress))) + ((end) * (progress)))
#define LINU(a,b) (CLUTTER_UNITS_FROM_FLOAT(LIN((a),(b))))
*/

#define LIN(start,end) (((start)*(1.0-(pow(progress,1.0)))) + ((end) * (pow(progress,1.0))))
#define LINU(a,b)      (CLUTTER_UNITS_FROM_FLOAT(LIN((a),(b))))



#define HRN_DRAG_THRESHOLD 8   /* if we don't move more than this many pixels
                                * we didn't really start dragging
                                */

void hrn_set_theatre (void);
void
hrn_actor_get_geom (ClutterActor *actor,
                    gfloat *ox, gfloat *oy,
                    gfloat *owidth, gfloat *oheight, gdouble *oscalex, gdouble *oscaley);

void hrn_sidebar_hide (void);


/* globals used to determine when at exact zoom levels
 * for showing labels
 */
enum
{
  ZOOM_NONE,
  ZOOM_CLUSTERS,
  ZOOM_CLUSTERS_GROUPED,
  ZOOM_ITEMS_8,
  ZOOM_ITEMS_4,
  ZOOM_ITEMS_3,
};
gdouble hrn_get_scale (void);
gdouble hrn_get_pinch (void);
BrQueue *hrn_get_default_queue (void);
void hrn_store_state (void);
void hrn_retrieve_query (const gchar *qname);
void hrn_quit (void);

#define hrn_restore_state() hrn_retrieve_query("hrn-last-state")

#endif
