#ifndef __HRN_WINDOW_H__
#define __HRN_WINDOW_H__

#include <gtk/gtk.h>
#include "hrn-state-manager.h"

G_BEGIN_DECLS

#define HRN_TYPE_WINDOW                                                 \
   (hrn_window_get_type())
#define HRN_WINDOW(obj)                                                 \
   (G_TYPE_CHECK_INSTANCE_CAST ((obj),                                  \
                                HRN_TYPE_WINDOW,                        \
                                HrnWindow))
#define HRN_WINDOW_CLASS(klass)                                         \
   (G_TYPE_CHECK_CLASS_CAST ((klass),                                   \
                             HRN_TYPE_WINDOW,                           \
                             HrnWindowClass))
#define IS_HRN_WINDOW(obj)                                              \
   (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                                  \
                                HRN_TYPE_WINDOW))
#define IS_HRN_WINDOW_CLASS(klass)                                      \
   (G_TYPE_CHECK_CLASS_TYPE ((klass),                                   \
                             HRN_TYPE_WINDOW))
#define HRN_WINDOW_GET_CLASS(obj)                                       \
   (G_TYPE_INSTANCE_GET_CLASS ((obj),                                   \
                               HRN_TYPE_WINDOW,                         \
                               HrnWindowClass))

typedef struct _HrnWindowPrivate HrnWindowPrivate;
typedef struct _HrnWindow      HrnWindow;
typedef struct _HrnWindowClass HrnWindowClass;

struct _HrnWindow
{
    GtkWindow parent;

    HrnWindowPrivate *priv;
};

struct _HrnWindowClass
{
    GtkWindowClass parent_class;
};

GType hrn_window_get_type (void) G_GNUC_CONST;

HrnWindow *hrn_window_new (HrnStateManager *manager);
void hrn_window_fullscreen (HrnWindow *self);
ClutterActor *hrn_window_get_stage (HrnWindow *self);
void hrn_window_set_internal_actor (HrnWindow    *self,
                                    ClutterActor *actor);
void hrn_window_present (HrnWindow *window);



G_END_DECLS

#endif /* __HRN_WINDOW_H__ */
