/*
 * Hornsey - Moblin Media Player.
 * Copyright © 2009 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _HORNSEY_H__
#define _HORNSEY_H__

#include "config.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <bickley/bkl-item.h>
#include <bickley/bkl-item-image.h>
#include <bickley/bkl-item-video.h>
#include <bickley/bkl-item-audio.h>
#include <bickley/bkl-db.h>
#include <bickley/bkl-utils.h>
#include <bickley/bkl-source-client.h>
#include <bickley/bkl-source-manager-client.h>

#include <nbtk/nbtk.h>
#include <gtk/gtk.h>
#include <libnotify/notify.h>

#include "hrn-button.h"
#include "hrn-source.h"
#include "hrn-queue.h"
#include "hrn-theatre.h"
#include "hrn-drag-n-drop.h"
#include "hrn-popup.h"
#include "hrn-controls.h"
#include "hrn-window.h"

#ifdef USE_HELIX
#include <clutter-helix/clutter-helix.h>
#else
#include <clutter-gst/clutter-gst.h>
#endif

#define HRN_STARTUP_NOTIFICATION 1

#define TOOLBAR_HEIGHT 63.0

#define ITEM_WIDTH 140.0
#define ITEM_HEIGHT 150.0
#define THUMBNAIL_WIDTH ITEM_WIDTH
#define THUMBNAIL_HEIGHT 111.0

#define COL_GAP 10.0
#define ROW_GAP 10.0

#define HRN_START_ITEM  0
#define HRN_X_OFFSET    30  /* needs to be affected by scale where used */

#define HRN_TO_THEATRE_DURATION   500
#define HRN_FROM_THEATRE_DURATION 500

#define HRN_SLIDESHOW_DELAY   10000

#define HRN_ZOOM_HOLD_THRESHOLD 6
#define HRN_ZOOM_HOLD_TIMEOUT   200

#define HRN_LOAD_SIZE_ASYNC   1  /* hornsey doesn't cope fully with textures
                                    * changing sizes on the fly, this needs
                                    * to be made fully functional as part of
                                    * not blocking in transitions.
                                    */

#define HRN_PURGE_UNUSED        1

#define HRN_CACHE_MAX_SIZE    (1024*1024*128) /* 128mb texture memory */

#define HRN_SIDEBAR_TIMEOUT   2000  /* msec before controls go away */


#define HRN_CONTROLS_TIMEOUT  1000  /* msec before controls go away */
#define CONTROLS_IN_DURATION  250

#define CONTROLS_OUT_DURATION 250      /* length of transition to half transparent state */
#define CONTROLS_OUT_DURATION2 3000    /* time spent in half transparent state */
#define CONTROLS_OUT_DURATION3 250

#define HRN_HIDE_LABEL_ON_GRAB 0

#define SIDEBAR_IN_DURATION  CONTROLS_IN_DURATION
#define SIDEBAR_OUT_DURATION CONTROLS_OUT_DURATION

extern HrnWindow *window;

extern ClutterActor *hrn_content_area;

extern BklSourceManagerClient *manager;

extern HrnQueue *master_queue;

void hrn_play_uri_now          (const gchar *uri);

char *hrn_resolve_mimetype (const char *uri);

#define HRN_DRAG_THRESHOLD 8   /* if we don't move more than this many pixels
                                * we didn't really start dragging
                                */

void hrn_quit (void);
char *hrn_make_config_file (const char *filename);
void hrn_add_recent_uri (const char *uri,
                         const char *mimetype);


#endif
