#ifndef __HRN_TILE_H__
#define __HRN_TILE_H__

#include <nbtk/nbtk.h>


G_BEGIN_DECLS

#define HRN_TYPE_TILE                                                   \
   (hrn_tile_get_type())
#define HRN_TILE(obj)                                                   \
   (G_TYPE_CHECK_INSTANCE_CAST ((obj),                                  \
                                HRN_TYPE_TILE,                          \
                                HrnTile))
#define HRN_TILE_CLASS(klass)                                           \
   (G_TYPE_CHECK_CLASS_CAST ((klass),                                   \
                             HRN_TYPE_TILE,                             \
                             HrnTileClass))
#define IS_HRN_TILE(obj)                                                \
   (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                                  \
                                HRN_TYPE_TILE))
#define IS_HRN_TILE_CLASS(klass)                                        \
   (G_TYPE_CHECK_CLASS_TYPE ((klass),                                   \
                             HRN_TYPE_TILE))
#define HRN_TILE_GET_CLASS(obj)                                         \
   (G_TYPE_INSTANCE_GET_CLASS ((obj),                                   \
                               HRN_TYPE_TILE,                           \
                               HrnTileClass))

typedef struct _HrnTilePrivate HrnTilePrivate;
typedef struct _HrnTile      HrnTile;
typedef struct _HrnTileClass HrnTileClass;

struct _HrnTile
{
    NbtkTable parent;

    HrnTilePrivate *priv;
};

struct _HrnTileClass
{
    NbtkTableClass parent_class;

    HrnClusterNode *(*get_node) (HrnTile *tile);
    const char *(*get_label) (HrnTile *tile);
};

GType hrn_tile_get_type (void) G_GNUC_CONST;

const char *hrn_tile_get_label (HrnTile *tile);

G_END_DECLS

#endif /* __HRN_TILE_H__ */
