#include <glib.h>
#include <glib/gi18n.h>

#include "hrn-cluster-node.h"
#include "hrn-tileable.h"
#include "hrn-video-tile.h"

enum {
    PROP_0,
    PROP_NODE
};

struct _HrnVideoTilePrivate {
    HrnClusterNode *node;
    guint32 visibility_id;
};

#define GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj), HRN_TYPE_VIDEO_TILE, HrnVideoTilePrivate))
G_DEFINE_TYPE (HrnVideoTile, hrn_video_tile, HRN_TYPE_TILE);

static void
hrn_video_tile_finalize (GObject *object)
{
    HrnVideoTile *tile = (HrnVideoTile *) object;
    HrnVideoTilePrivate *priv = tile->priv;

    if (priv->visibility_id) {
        g_signal_handler_disconnect (priv->node, priv->visibility_id);
        priv->visibility_id = 0;
    }

    G_OBJECT_CLASS (hrn_video_tile_parent_class)->finalize (object);
}

static void
hrn_video_tile_dispose (GObject *object)
{
    G_OBJECT_CLASS (hrn_video_tile_parent_class)->dispose (object);
}

static void
node_visibility_changed (HrnClusterNode *node,
                         gboolean        hidden,
                         HrnVideoTile   *tile)
{
    g_print ("[video] %s %s\n", node->name, hidden ? "hidden" : "shown");
    hrn_tileable_visibility_changed ((HrnTileable *) tile, hidden);
}

static void
hrn_video_tile_set_property (GObject      *object,
                             guint         prop_id,
                             const GValue *value,
                             GParamSpec   *pspec)
{
    HrnVideoTile *self = (HrnVideoTile *) object;
    HrnVideoTilePrivate *priv = self->priv;
    VideoCluster *video_cluster;

    switch (prop_id) {
    case PROP_NODE:
        priv->node = g_value_get_pointer (value);
        priv->visibility_id = g_signal_connect
            (priv->node, "visibility-changed",
             G_CALLBACK (node_visibility_changed), self);
        clutter_actor_set_name ((ClutterActor *) self, priv->node->name);

        video_cluster = (VideoCluster *) priv->node->data;
        g_object_set (self,
                      "item", video_cluster->item,
                      NULL);
        break;
    default:
        break;
    }
}

static void
hrn_video_tile_get_property (GObject    *object,
                             guint       prop_id,
                             GValue     *value,
                             GParamSpec *pspec)
{
    switch (prop_id) {

    default:
        break;
    }
}

static HrnClusterNode *
hrn_video_tile_get_node (HrnTile *tile)
{
    HrnVideoTile *video = (HrnVideoTile *) tile;
    HrnVideoTilePrivate *priv = video->priv;

    return priv->node;
}

static const char *
hrn_video_tile_get_label (HrnTile *tile)
{
    return _("Play Video");
}

static void
hrn_video_tile_class_init (HrnVideoTileClass *klass)
{
    GObjectClass *o_class = (GObjectClass *) klass;
    HrnTileClass *t_class = (HrnTileClass *) klass;

    o_class->dispose = hrn_video_tile_dispose;
    o_class->finalize = hrn_video_tile_finalize;
    o_class->set_property = hrn_video_tile_set_property;
    o_class->get_property = hrn_video_tile_get_property;

    t_class->get_node = hrn_video_tile_get_node;
    t_class->get_label = hrn_video_tile_get_label;

    g_type_class_add_private (klass, sizeof (HrnVideoTilePrivate));

    g_object_class_override_property (o_class, PROP_NODE, "node");
}

static void
hrn_video_tile_init (HrnVideoTile *self)
{
    HrnVideoTilePrivate *priv = GET_PRIVATE (self);
    self->priv = priv;
}

