/* ***** BEGIN LICENSE BLOCK *****
 * Version: RCSL 1.0/RPSL 1.0 
 *
 * Portions Copyright (c) 1995-2008 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _HX_THUMBNAIL_H_
#define _HX_THUMBNAIL_H_

#define HELIX_TAG_TITLE                 "Title"
#define HELIX_TAG_AUTHOR                "Author"
#define HELIX_TAG_ABSTRACT              "Abstract"
#define HELIX_TAG_GENRE                 "Genre"
#define HELIX_TAG_DURATION              "Duration"
#define HELIX_TAG_COPYRIGHT             "Copyright"
#define HELIX_TAG_MIMETYPE              "MimeType"
#define HELIX_TAG_CHANNELS              "NumChannels"
#define HELIX_TAG_BITSPERSAMPLE         "SrcBitsPerSample"
#define HELIX_TAG_SAMPLERATE            "SampleRate"

typedef enum {
    eDtdrUnknown,
    eDtdrInt32,
    eDtdrUInt32,
    eDtdrString,
} eDtdrMediainfoType;
typedef void (*DtdriverMediainfoProcPtr)(void *user_data, eDtdrMediainfoType media_info_type, char* media_info_name, void* media_info_value);
#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

  int GetVideoFrame(const char* uri, const char* file, unsigned int * pWidth, unsigned int * pHeight, unsigned int position);
  const char* GetMetaData(const char* uri, DtdriverMediainfoProcPtr dtdr_mediainfo_callback, void* user_data);
#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
