/* ***** BEGIN LICENSE BLOCK ***** 
 * Version: RCSL 1.0/RPSL 1.0 
 *  
 * Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved.
 *
 * Media Sink Implementation:
 * Copyright 2008 Intel Corp.
 *      
 * The contents of this file, and the files included with this file, are 
 * subject to the current version of the RealNetworks Public Source License 
 * Version 1.0 (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the RealNetworks Community Source License Version 1.0 
 * (the "RCSL") available at http://www.helixcommunity.org/content/rcsl, 
 * in which case the RCSL will apply. You may also obtain the license terms 
 * directly from RealNetworks.  You may not use this file except in 
 * compliance with the RPSL or, if you have a valid RCSL with RealNetworks 
 * applicable to this file, the RCSL.  Please see the applicable RPSL or 
 * RCSL for the rights, obligations and limitations governing use of the 
 * contents of the file.  
 *  
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the portions 
 * it created. 
 *  
 * This file, and the files included with this file, is distributed and made 
 * available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER 
 * EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES, 
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS 
 * FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. 
 * 
 * Technology Compatibility Kit Test Suite(s) Location: 
 *    http://www.helixcommunity.org/content/tck 
 * 
 * Contributor(s):
 * Long Bu <long.bu@intel.com>
 * Rusty Lynch <rusty.lynch@intel.com>
 *  
 * ***** END LICENSE BLOCK ***** */ 

#ifndef _PLAYER_H_
#define _PLAYER_H_

#ifdef __cplusplus
#define PLAYER_API    extern "C"
#else
#define PLAYER_API
#endif

/* The same as EHXClientState. 
 * Don't want clutter-helix lib to bother including any other header file */
typedef enum _EHXPlayerState
{
    PLAYER_STATE_READY = 0,  // uninitialized
    PLAYER_STATE_CONNECTING, // attempting to connect to sources
    PLAYER_STATE_CONNECTED,  // connected to sources (realized)
    PLAYER_STATE_OPENING,    // opening sources
    PLAYER_STATE_OPENED,     // opened sources
    PLAYER_STATE_PREFETCHING,    // obtaining resources, buffering, etc.
    PLAYER_STATE_PREFETCHED, // ready for playback at time zero
    PLAYER_STATE_PLAYING,    // currently playing
    PLAYER_STATE_PAUSED,     // paused
    PLAYER_STATE_SEEKING     // seeking
} EHXPlayerState;

/* duplicate definition. Defined also in ciddefs.h */
#define CID_ARGB32      11  /* RGB32 with Alpha Channel.            */
#define CID_I420      0  /* Planar YCrCb 4:2:0.            */
#define CID_LIBVA       24  /* LIBVA color space, use a refId only */

typedef struct {
    int left;
    int top;
    int right;
    int bottom;
}PlayerRect;

typedef struct {
    PlayerRect Rect;
    unsigned int  cx;
    unsigned int cy;
    int cid;
} PlayerImgInfo;

typedef void (*on_pos_length_cb_t)(unsigned int, unsigned int, void *);
typedef void (*on_buffering_cb_t)(unsigned int, unsigned short, void *);
typedef void (*on_state_change_cb_t)(unsigned short, unsigned short, void *);
typedef void (*on_new_frame_cb_t)(unsigned char *p, unsigned int size, PlayerImgInfo *rect, void *context);
typedef void (*on_error_cb_t)(unsigned long code, char *message, void *context);

typedef struct {
    on_pos_length_cb_t   on_pos_length_cb;
    on_buffering_cb_t    on_buffering_cb;
    on_state_change_cb_t on_state_change_cb;
    on_new_frame_cb_t    on_new_frame_cb;
    on_error_cb_t        on_error_cb;
} PlayerCallbacks;

PLAYER_API int init_main();
PLAYER_API int deinit_main();
PLAYER_API int get_player(void **ppPlayerHandle, PlayerCallbacks *pCallbacks, void *context);
PLAYER_API int player_openurl( void *pPlayerHandle, char *pszRawURL);
PLAYER_API int put_player( void *pPlayerHandle);
PLAYER_API int player_geturl( void *pPlayerHandle, char **pszURL);
PLAYER_API int player_begin( void *pPlayerHandle );
PLAYER_API int player_stop( void *pPlayerHandle );
PLAYER_API int player_pause( void *pPlayerHandle );
PLAYER_API unsigned int get_curr_playtime(void *pPlayerHandle);
PLAYER_API int player_seek(void *pPlayerHandle, int pos);
PLAYER_API int player_getvolume(void *pPlayerHandle);
PLAYER_API int player_setvolume(void *pPlayerHandle, unsigned short volumn);
PLAYER_API int player_canseek(void *pPlayerHandle);

#endif // _PLAYER_H_

