#
# Copyright 2009 Canonical Ltd.
#
# Written by:
#     Gustavo Niemeyer <gustavo.niemeyer@canonical.com>
#     Sidnei da Silva <sidnei.da.silva@canonical.com>
#
# This file is part of the Image Store Proxy.
#
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
#
import logging

try:
    from pysqlite2 import dbapi2 as sqlite
except ImportError:
    from sqlite3 import dbapi2 as sqlite

from twisted.trial.unittest import TestCase as TrialTestCase

from imagestore.lib.tests.mocker import MockerTestCase


class TestCase(MockerTestCase, TrialTestCase):

    def __new__(cls, *args, **kwargs):
        # Do not spew off logging messages generated by tests.
        logging.getLogger().setLevel(logging.CRITICAL)
        return object.__new__(cls)


class SQLiteTestBase(TestCase):

    def setUp(self):
        self.filename = self.makeFile()
        self.connection = None
        self.cursor = None

    def tearDown(self):
        self.close()

    def execute(self, query, params=()):
        if self.connection is None:
            self.connection = sqlite.connect(self.filename)
            self.cursor = self.connection.cursor()
        self.cursor.execute(query, params)
        return self.cursor

    def close(self, commit=True):
        if self.cursor is not None:
            if commit:
                self.connection.commit()
            self.cursor.close()
            self.connection.close()
            self.cursor = None
            self.connection = None


