/*
 * indicator-network
 * Copyright 2012 Canonical Ltd.
 *
 * Authors:
 * Antti Kaijanmäki <antti.kaijanmaki@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/** @todo security combobox is commented out as the security
          bits are not implemented ATM
*/

#include "connection-information-dialog.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <glib.h>
#include <glib-object.h>
#include <glib/gi18n.h>
#include <gtk/gtk.h>
#include <locale.h>
#include <string.h>

G_DEFINE_TYPE(ConnectionInformationDialog, connection_information_dialog, GTK_TYPE_DIALOG);

typedef struct _ConnectionInformationDialogPriv ConnectionInformationDialogPriv;

struct _ConnectionInformationDialogPriv
{
  GtkWidget *network_name;
  GtkWidget *ipv4_address;
  GtkWidget *ipv4_netmask;
  GtkWidget *ipv4_gateway;
  GtkWidget *ipv4_dns1;
  GtkWidget *ipv4_dns2;
  GtkWidget *ipv4_lease;
};

#define GET_PRIVATE(o)                                                  \
  (G_TYPE_INSTANCE_GET_PRIVATE((o),					\
			       CONNECTION_INFORMATION_DIALOG_TYPE,	\
			       ConnectionInformationDialogPriv))

static void
connection_information_dialog_init(ConnectionInformationDialog *self)
{
  ConnectionInformationDialogPriv *priv = GET_PRIVATE(self);

}

static void
connection_information_dialog_dispose(GObject *object)
{
  ConnectionInformationDialog     *self = CONNECTION_INFORMATION_DIALOG(object);
  ConnectionInformationDialogPriv *priv = GET_PRIVATE(self);

  /* all the gtkwidgets are destroyed at the same time as this dialog */

  G_OBJECT_CLASS(connection_information_dialog_parent_class)->dispose(object);
}

static void
connection_information_dialog_finalize(GObject *object)
{
  G_OBJECT_CLASS(connection_information_dialog_parent_class)->finalize(object);
}

static void
connection_information_dialog_class_init(ConnectionInformationDialogClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);

  g_type_class_add_private(object_class,
			   sizeof(ConnectionInformationDialogPriv));

  object_class->dispose  = connection_information_dialog_dispose;
  object_class->finalize = connection_information_dialog_finalize;
}

void connection_information_dialog_show(ConnectionInformationDialog *self,
					GHashTable *information)
{
  ConnectionInformationDialogPriv *priv = GET_PRIVATE(self);

  GHashTableIter iter;
  gpointer key_ptr;
  gpointer value_ptr;

  gchar *key;
  gchar *value;

  g_hash_table_iter_init(&iter, information);
  while (g_hash_table_iter_next(&iter, &key_ptr, &value_ptr)) {
    key = key_ptr;
    value = value_ptr;

    if (g_strcmp0(key, "network-name") == 0) {
      gtk_label_set_text(GTK_LABEL(priv->network_name), value);
    } else if (g_strcmp0(key, "ipv4-address") == 0) {
      gtk_label_set_text(GTK_LABEL(priv->ipv4_address), value);
    } else if (g_strcmp0(key, "ipv4-netmask") == 0) {
      gtk_label_set_text(GTK_LABEL(priv->ipv4_netmask), value);
    } else if (g_strcmp0(key, "ipv4-gateway") == 0) {
      gtk_label_set_text(GTK_LABEL(priv->ipv4_gateway), value);
    } else if (g_strcmp0(key, "ipv4-dns1") == 0) {
      gtk_label_set_text(GTK_LABEL(priv->ipv4_dns1), value);
    } else if (g_strcmp0(key, "ipv4-dns2") == 0) {
      gtk_label_set_text(GTK_LABEL(priv->ipv4_dns2), value);
    } else if (g_strcmp0(key, "ipv4-lease") == 0) {
      gtk_label_set_text(GTK_LABEL(priv->ipv4_lease), value);
    }
  }

  gtk_widget_show_all(GTK_WIDGET(self));
}

ConnectionInformationDialog *connection_information_dialog_new(void)
{
  ConnectionInformationDialog     *self;
  ConnectionInformationDialogPriv *priv;

  GtkWidget *vbox, *grid, *label;

  self = g_object_new(CONNECTION_INFORMATION_DIALOG_TYPE, NULL);
  priv = GET_PRIVATE(self);

  gtk_window_set_title(GTK_WINDOW(self), _("Connection Information"));
  gtk_window_set_icon_name(GTK_WINDOW(self), "nm-signal-100");
  gtk_window_set_position(GTK_WINDOW(self), GTK_WIN_POS_CENTER);
  gtk_window_set_deletable(GTK_WINDOW(self), FALSE);
  
  gtk_container_set_border_width(GTK_CONTAINER(self), 12);

  gtk_dialog_add_buttons(GTK_DIALOG(self),
			 GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE,
			 NULL);

  gtk_dialog_set_default_response(GTK_DIALOG(self), GTK_RESPONSE_CLOSE);

  vbox = gtk_dialog_get_content_area(GTK_DIALOG(self));
  gtk_box_set_spacing(GTK_BOX(vbox), 6);

  grid = gtk_grid_new();
  gtk_orientable_set_orientation(GTK_ORIENTABLE(grid),
				 GTK_ORIENTATION_VERTICAL);
  gtk_grid_set_column_spacing(GTK_GRID(grid), 12);
  gtk_grid_set_column_homogeneous(GTK_GRID(grid), TRUE);
  
  gtk_box_pack_start(GTK_BOX(vbox), GTK_WIDGET(grid), TRUE, TRUE, 5);

  label = gtk_label_new("");
  gtk_label_set_use_markup(GTK_LABEL(label), TRUE);
  gtk_label_set_markup(GTK_LABEL(label), _("<b>Network</b>"));
  gtk_misc_set_alignment(GTK_MISC(label), 0, 1);
  gtk_misc_set_padding(GTK_MISC(label), 0, 6);
  gtk_container_add(GTK_CONTAINER(grid), label);


  label = gtk_label_new(_("Name:"));
  gtk_misc_set_alignment(GTK_MISC(label), 1, 0.5);
  gtk_container_add(GTK_CONTAINER(grid), label);
		  
  priv->network_name = gtk_label_new("");
  gtk_misc_set_alignment(GTK_MISC(priv->network_name), 0, 0.5);
  gtk_grid_attach_next_to(GTK_GRID(grid),
			  priv->network_name,
			  label,
			  GTK_POS_RIGHT,
			  1,
			  1);  

  label = gtk_label_new("");
  gtk_label_set_use_markup(GTK_LABEL(label), TRUE);
  gtk_label_set_markup(GTK_LABEL(label), _("<b>IPv4</b>"));
  gtk_misc_set_alignment(GTK_MISC(label), 0, 1);
  gtk_misc_set_padding(GTK_MISC(label), 0, 6);
  gtk_container_add(GTK_CONTAINER(grid), label);

  label = gtk_label_new(_("Address:"));
  gtk_misc_set_alignment(GTK_MISC(label), 1, 0.5);
  gtk_container_add(GTK_CONTAINER(grid), label);
		  
  priv->ipv4_address = gtk_label_new("");
  gtk_misc_set_alignment(GTK_MISC(priv->ipv4_address), 0, 0.5);
  gtk_grid_attach_next_to(GTK_GRID(grid),
			  priv->ipv4_address,
			  label,
			  GTK_POS_RIGHT,
			  1,
			  1);  

  label = gtk_label_new(_("Netmask:"));
  gtk_misc_set_alignment(GTK_MISC(label), 1, 0.5);
  gtk_container_add(GTK_CONTAINER(grid), label);
		  
  priv->ipv4_netmask = gtk_label_new("");
  gtk_misc_set_alignment(GTK_MISC(priv->ipv4_netmask), 0, 0.5);
  gtk_grid_attach_next_to(GTK_GRID(grid),
			  priv->ipv4_netmask,
			  label,
			  GTK_POS_RIGHT,
			  1,
			  1);  

  label = gtk_label_new(_("Gateway:"));
  gtk_misc_set_alignment(GTK_MISC(label), 1, 0.5);
  gtk_container_add(GTK_CONTAINER(grid), label);
		  
  priv->ipv4_gateway = gtk_label_new("");
  gtk_misc_set_alignment(GTK_MISC(priv->ipv4_gateway), 0, 0.5);
  gtk_grid_attach_next_to(GTK_GRID(grid),
			  priv->ipv4_gateway,
			  label,
			  GTK_POS_RIGHT,
			  1,
			  1);  

  label = gtk_label_new("");
  gtk_label_set_use_markup(GTK_LABEL(label), TRUE);
  gtk_label_set_markup(GTK_LABEL(label), _("<b>DNS</b>"));
  gtk_misc_set_alignment(GTK_MISC(label), 0, 1);
  gtk_misc_set_padding(GTK_MISC(label), 0, 6);
  gtk_container_add(GTK_CONTAINER(grid), label);

  label = gtk_label_new(_("Primary:"));
  gtk_misc_set_alignment(GTK_MISC(label), 1, 0.5);
  gtk_container_add(GTK_CONTAINER(grid), label);
		  
  priv->ipv4_dns1 = gtk_label_new("");
  gtk_misc_set_alignment(GTK_MISC(priv->ipv4_dns1), 0, 0.5);
  gtk_grid_attach_next_to(GTK_GRID(grid),
			  priv->ipv4_dns1,
			  label,
			  GTK_POS_RIGHT,
			  1,
			  1);  

  label = gtk_label_new(_("Secondary:"));
  gtk_misc_set_alignment(GTK_MISC(label), 1, 0.5);
  gtk_container_add(GTK_CONTAINER(grid), label);
		  
  priv->ipv4_dns2 = gtk_label_new("");
  gtk_misc_set_alignment(GTK_MISC(priv->ipv4_dns2), 0, 0.5);
  gtk_grid_attach_next_to(GTK_GRID(grid),
			  priv->ipv4_dns2,
			  label,
			  GTK_POS_RIGHT,
			  1,
			  1);  

  label = gtk_label_new(_("Lease Time:"));
  gtk_misc_set_alignment(GTK_MISC(label), 1, 0.5);
  gtk_container_add(GTK_CONTAINER(grid), label);
		  
  priv->ipv4_lease = gtk_label_new("");
  gtk_misc_set_alignment(GTK_MISC(priv->ipv4_lease), 0, 0.5);
  gtk_grid_attach_next_to(GTK_GRID(grid),
			  priv->ipv4_lease,
			  label,
			  GTK_POS_RIGHT,
			  1,
			  1);
  return self;
}
