/*
 * indicator-network
 * Copyright 2012 Canonical Ltd.
 *
 * Authors:
 * Antti Kaijanmäki <antti.kaijanmaki@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __CONNECTION_INFORMATION_DIALOG_H__
#define __CONNECTION_INFORMATION_DIALOG_H__

#include <glib-object.h>
#include <gtk/gtk.h>

#define CONNECTION_INFORMATION_DIALOG_TYPE (connection_information_dialog_get_type())
#define CONNECTION_INFORMATION_DIALOG(o)			        \
  (G_TYPE_CHECK_INSTANCE_CAST ((o),				        \
			       CONNECTION_INFORMATION_DIALOG_TYPE,      \
			       ConnectionInformationDialog))
#define CONNECTION_INFORMATION_DIALOG_CLASS(k)		 	        \
  (G_TYPE_CHECK_CLASS_CAST((k),					        \
			   CONNECTION_INFORMATION_DIALOG_TYPE,	        \
			   ConnectionInformationDialogClass))
#define IS_CONNECTION_INFORMATION_DIALOG(o)			        \
  (G_TYPE_CHECK_INSTANCE_TYPE((o),				        \
			      CONNECTION_INFORMATION_DIALOG_TYPE))
#define IS_CONNECTION_INFORMATION_DIALOG_CLASS(k)	  	        \
  (G_TYPE_CHECK_CLASS_TYPE((k),					        \
			   CONNECTION_INFORMATION_DIALOG_TYPE))
#define CONNECTION_INFORMATION_DIALOG_GET_CLASS(o)			\
  (G_TYPE_INSTANCE_GET_CLASS((o),					\
			     CONNECTION_INFORMATION_DIALOG_TYPE,	\
			     ConnectionInformationDialogClass))

typedef struct _ConnectionInformationDialog ConnectionInformationDialog;
typedef struct _ConnectionInformationDialogClass ConnectionInformationDialogClass;

struct _ConnectionInformationDialog
{
  GtkDialog parent;
};

struct _ConnectionInformationDialogClass
{
  GtkDialogClass parent_class;
};

GType connection_information_dialog_get_type(void) G_GNUC_CONST;

ConnectionInformationDialog *connection_information_dialog_new(void);
void connection_information_dialog_show(ConnectionInformationDialog *self,
					GHashTable *information);

#endif
