/* metadata-menu-item.c generated by valac 0.14.2, the Vala compiler
 * generated from metadata-menu-item.vala, do not modify */

/*
Copyright 2010 Canonical Ltd.

Authors:
    Conor Curran <conor.curran@canonical.com>

This program is free software: you can redistribute it and/or modify it 
under the terms of the GNU General Public License version 3, as published 
by the Free Software Foundation.

This program is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranties of 
MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along 
with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <libdbusmenu-glib/client.h>
#include <libdbusmenu-glib/dbusmenu-glib.h>
#include <libdbusmenu-glib/enum-types.h>
#include <libdbusmenu-glib/menuitem-proxy.h>
#include <libdbusmenu-glib/menuitem.h>
#include <libdbusmenu-glib/server.h>
#include <libdbusmenu-glib/types.h>
#include <stdlib.h>
#include <string.h>
#include <common-defs.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <glib/gstdio.h>
#include <gee.h>


#define TYPE_PLAYER_ITEM (player_item_get_type ())
#define PLAYER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAYER_ITEM, PlayerItem))
#define PLAYER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLAYER_ITEM, PlayerItemClass))
#define IS_PLAYER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAYER_ITEM))
#define IS_PLAYER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLAYER_ITEM))
#define PLAYER_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLAYER_ITEM, PlayerItemClass))

typedef struct _PlayerItem PlayerItem;
typedef struct _PlayerItemClass PlayerItemClass;
typedef struct _PlayerItemPrivate PlayerItemPrivate;

#define TYPE_METADATA_MENUITEM (metadata_menuitem_get_type ())
#define METADATA_MENUITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_METADATA_MENUITEM, MetadataMenuitem))
#define METADATA_MENUITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_METADATA_MENUITEM, MetadataMenuitemClass))
#define IS_METADATA_MENUITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_METADATA_MENUITEM))
#define IS_METADATA_MENUITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_METADATA_MENUITEM))
#define METADATA_MENUITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_METADATA_MENUITEM, MetadataMenuitemClass))

typedef struct _MetadataMenuitem MetadataMenuitem;
typedef struct _MetadataMenuitemClass MetadataMenuitemClass;
typedef struct _MetadataMenuitemPrivate MetadataMenuitemPrivate;

#define TYPE_FETCH_FILE (fetch_file_get_type ())
#define FETCH_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FETCH_FILE, FetchFile))
#define FETCH_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FETCH_FILE, FetchFileClass))
#define IS_FETCH_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FETCH_FILE))
#define IS_FETCH_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FETCH_FILE))
#define FETCH_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FETCH_FILE, FetchFileClass))

typedef struct _FetchFile FetchFile;
typedef struct _FetchFileClass FetchFileClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PLAYER_CONTROLLER (player_controller_get_type ())
#define PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAYER_CONTROLLER, PlayerController))
#define PLAYER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLAYER_CONTROLLER, PlayerControllerClass))
#define IS_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAYER_CONTROLLER))
#define IS_PLAYER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLAYER_CONTROLLER))
#define PLAYER_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLAYER_CONTROLLER, PlayerControllerClass))

typedef struct _PlayerController PlayerController;
typedef struct _PlayerControllerClass PlayerControllerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _PlayerControllerPrivate PlayerControllerPrivate;

#define TYPE_MPRIS2_CONTROLLER (mpris2_controller_get_type ())
#define MPRIS2_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MPRIS2_CONTROLLER, Mpris2Controller))
#define MPRIS2_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MPRIS2_CONTROLLER, Mpris2ControllerClass))
#define IS_MPRIS2_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MPRIS2_CONTROLLER))
#define IS_MPRIS2_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MPRIS2_CONTROLLER))
#define MPRIS2_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MPRIS2_CONTROLLER, Mpris2ControllerClass))

typedef struct _Mpris2Controller Mpris2Controller;
typedef struct _Mpris2ControllerClass Mpris2ControllerClass;

#define PLAYER_CONTROLLER_TYPE_STATE (player_controller_state_get_type ())

struct _PlayerItem {
	DbusmenuMenuitem parent_instance;
	PlayerItemPrivate * priv;
};

struct _PlayerItemClass {
	DbusmenuMenuitemClass parent_class;
};

struct _MetadataMenuitem {
	PlayerItem parent_instance;
	MetadataMenuitemPrivate * priv;
};

struct _MetadataMenuitemClass {
	PlayerItemClass parent_class;
};

struct _MetadataMenuitemPrivate {
	gchar* previous_temp_album_art_path;
};

struct _PlayerController {
	GObject parent_instance;
	PlayerControllerPrivate * priv;
	gint current_state;
	DbusmenuMenuitem* root_menu;
	GeeArrayList* custom_items;
	Mpris2Controller* mpris_bridge;
	gboolean* use_playlists;
};

struct _PlayerControllerClass {
	GObjectClass parent_class;
};

typedef enum  {
	PLAYER_CONTROLLER_STATE_OFFLINE,
	PLAYER_CONTROLLER_STATE_INSTANTIATING,
	PLAYER_CONTROLLER_STATE_READY,
	PLAYER_CONTROLLER_STATE_CONNECTED,
	PLAYER_CONTROLLER_STATE_DISCONNECTED
} PlayerControllerstate;


static gpointer metadata_menuitem_parent_class = NULL;
extern gchar* metadata_menuitem_album_art_cache_dir;
gchar* metadata_menuitem_album_art_cache_dir = NULL;
static FetchFile* metadata_menuitem_fetcher;
static FetchFile* metadata_menuitem_fetcher = NULL;

GType player_item_get_type (void) G_GNUC_CONST;
GType metadata_menuitem_get_type (void) G_GNUC_CONST;
#define METADATA_MENUITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_METADATA_MENUITEM, MetadataMenuitemPrivate))
enum  {
	METADATA_MENUITEM_DUMMY_PROPERTY
};
GType fetch_file_get_type (void) G_GNUC_CONST;
#define METADATA_MENUITEM_ALBUM_ART_DIR_SUFFIX "indicator/sound/album-art-cache"
GType player_controller_get_type (void) G_GNUC_CONST;
MetadataMenuitem* metadata_menuitem_new (PlayerController* parent);
MetadataMenuitem* metadata_menuitem_construct (GType object_type, PlayerController* parent);
static void metadata_menuitem_clean_album_art_temp_dir (void);
static gboolean metadata_menuitem_delete_album_art_contents (GFile* dir);
static gchar* metadata_menuitem_create_album_art_temp_dir (void);
void metadata_menuitem_fetch_art (MetadataMenuitem* self, const gchar* uri, const gchar* prop);
#define PLAYER_ITEM_EMPTY (-1)
FetchFile* fetch_file_new (const gchar* uri, const gchar* prop);
FetchFile* fetch_file_construct (GType object_type, const gchar* uri, const gchar* prop);
static void __lambda0_ (MetadataMenuitem* self);
static void metadata_menuitem_on_fetcher_failed (MetadataMenuitem* self);
static void ___lambda0__fetch_file_failed (FetchFile* _sender, gpointer self);
static void metadata_menuitem_on_fetcher_completed (MetadataMenuitem* self, GByteArray* update, const gchar* property);
static void _metadata_menuitem_on_fetcher_completed_fetch_file_completed (FetchFile* _sender, GByteArray* data, const gchar* property, gpointer self);
void fetch_file_fetch_data (FetchFile* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void fetch_file_fetch_data_finish (FetchFile* self, GAsyncResult* _res_);
static void metadata_menuitem_real_handle_event (DbusmenuMenuitem* base, const gchar* name, GVariant* input_value, guint timestamp);
PlayerController* player_item_get_owner (PlayerItem* self);
GType mpris2_controller_get_type (void) G_GNUC_CONST;
GType player_controller_state_get_type (void) G_GNUC_CONST;
void player_controller_instantiate (PlayerController* self);
void mpris2_controller_expose (Mpris2Controller* self);
void metadata_menuitem_alter_label (MetadataMenuitem* self, const gchar* new_title);
void metadata_menuitem_toggle_active_triangle (MetadataMenuitem* self, gboolean update);
void metadata_menuitem_should_collapse (MetadataMenuitem* self, gboolean collapse);
GeeHashSet* metadata_menuitem_attributes_format (void);
GeeHashSet* metadata_menuitem_relevant_attributes_for_ui (void);
static GObject * metadata_menuitem_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
GAppInfo* player_controller_get_app_info (PlayerController* self);
const gchar* player_controller_get_icon_name (PlayerController* self);
void player_item_reset (PlayerItem* self, GeeHashSet* attrs);
static void metadata_menuitem_finalize (GObject* obj);


MetadataMenuitem* metadata_menuitem_construct (GType object_type, PlayerController* parent) {
	MetadataMenuitem * self = NULL;
	PlayerController* _tmp0_;
	g_return_val_if_fail (parent != NULL, NULL);
	_tmp0_ = parent;
	self = (MetadataMenuitem*) g_object_new (object_type, "item-type", DBUSMENU_METADATA_MENUITEM_TYPE, "owner", _tmp0_, NULL);
	return self;
}


MetadataMenuitem* metadata_menuitem_new (PlayerController* parent) {
	return metadata_menuitem_construct (TYPE_METADATA_MENUITEM, parent);
}


static void metadata_menuitem_clean_album_art_temp_dir (void) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* path;
	const gchar* _tmp2_;
	GFile* _tmp3_ = NULL;
	GFile* album_art_dir;
	GFile* _tmp4_;
	gboolean _tmp5_ = FALSE;
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, METADATA_MENUITEM_ALBUM_ART_DIR_SUFFIX, NULL);
	path = _tmp1_;
	_tmp2_ = path;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	album_art_dir = _tmp3_;
	_tmp4_ = album_art_dir;
	_tmp5_ = metadata_menuitem_delete_album_art_contents (_tmp4_);
	if (_tmp5_ == FALSE) {
		const gchar* _tmp6_;
		_tmp6_ = path;
		g_warning ("metadata-menu-item.vala:58: could not remove the temp album art files " \
"%s", _tmp6_);
	}
	_g_object_unref0 (album_art_dir);
	_g_free0 (path);
}


static gchar* metadata_menuitem_create_album_art_temp_dir (void) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* path;
	const gchar* _tmp2_;
	gint _tmp3_ = 0;
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, METADATA_MENUITEM_ALBUM_ART_DIR_SUFFIX, NULL);
	path = _tmp1_;
	_tmp2_ = path;
	_tmp3_ = g_mkdir_with_parents (_tmp2_, 0700);
	if (_tmp3_ == (-1)) {
		const gchar* _tmp4_;
		_tmp4_ = path;
		g_warning ("metadata-menu-item.vala:66: could not create temp dir %s for remote al" \
"bum art, it must have been created already", _tmp4_);
	}
	result = path;
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gboolean metadata_menuitem_delete_album_art_contents (GFile* dir) {
	gboolean result = FALSE;
	gboolean _result_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (dir != NULL, FALSE);
	_result_ = TRUE;
	{
		GFile* _tmp0_;
		GFileEnumerator* _tmp1_ = NULL;
		GFileEnumerator* e;
		_tmp0_ = dir;
		_tmp1_ = g_file_enumerate_children (_tmp0_, G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error_);
		e = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
		while (TRUE) {
			GFileEnumerator* _tmp2_;
			GFileInfo* _tmp3_ = NULL;
			GFileInfo* file;
			GFileInfo* _tmp4_;
			GFileInfo* _tmp5_;
			const gchar* _tmp6_ = NULL;
			GFile* _tmp7_;
			GFileInfo* _tmp8_;
			const gchar* _tmp9_ = NULL;
			GFile* _tmp10_ = NULL;
			GFile* child;
			_tmp2_ = e;
			_tmp3_ = g_file_enumerator_next_file (_tmp2_, NULL, &_inner_error_);
			file = _tmp3_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (e);
				goto __catch3_g_error;
			}
			_tmp4_ = file;
			if (_tmp4_ == NULL) {
				_g_object_unref0 (file);
				break;
			}
			_tmp5_ = file;
			_tmp6_ = g_file_info_get_name (_tmp5_);
			g_debug ("metadata-menu-item.vala:85: file name = %s", _tmp6_);
			_tmp7_ = dir;
			_tmp8_ = file;
			_tmp9_ = g_file_info_get_name (_tmp8_);
			_tmp10_ = g_file_get_child (_tmp7_, _tmp9_);
			child = _tmp10_;
			{
				GFile* _tmp11_;
				_tmp11_ = child;
				g_file_delete (_tmp11_, NULL, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch4_g_error;
				}
			}
			goto __finally4;
			__catch4_g_error:
			{
				GError* error_ = NULL;
				GFile* _tmp12_;
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_;
				const gchar* _tmp15_ = NULL;
				GError* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_;
				error_ = _inner_error_;
				_inner_error_ = NULL;
				_tmp12_ = child;
				_tmp13_ = g_file_get_basename (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = string_to_string (_tmp14_);
				_tmp16_ = error_;
				_tmp17_ = _tmp16_->message;
				_tmp18_ = string_to_string (_tmp17_);
				_tmp19_ = g_strconcat ("Unable to delete file '", _tmp15_, ": ", _tmp18_, NULL);
				_tmp20_ = _tmp19_;
				g_warning ("metadata-menu-item.vala:92: %s", _tmp20_);
				_g_free0 (_tmp20_);
				_g_free0 (_tmp14_);
				_result_ = FALSE;
				_g_error_free0 (error_);
			}
			__finally4:
			if (_inner_error_ != NULL) {
				_g_object_unref0 (child);
				_g_object_unref0 (file);
				_g_object_unref0 (e);
				goto __catch3_g_error;
			}
			_g_object_unref0 (child);
			_g_object_unref0 (file);
		}
		_g_object_unref0 (e);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* _error_ = NULL;
		GFile* _tmp21_;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_;
		const gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_;
		GError* _tmp27_;
		const gchar* _tmp28_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp21_ = dir;
		_tmp22_ = g_file_get_basename (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = string_to_string (_tmp23_);
		_tmp25_ = g_strconcat ("Unable to read files from directory '", _tmp24_, "': %s", NULL);
		_tmp26_ = _tmp25_;
		_tmp27_ = _error_;
		_tmp28_ = _tmp27_->message;
		g_warning (_tmp26_, _tmp28_);
		_g_free0 (_tmp26_);
		_g_free0 (_tmp23_);
		_result_ = FALSE;
		_g_error_free0 (_error_);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = _result_;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void __lambda0_ (MetadataMenuitem* self) {
	metadata_menuitem_on_fetcher_failed (self);
}


static void ___lambda0__fetch_file_failed (FetchFile* _sender, gpointer self) {
	__lambda0_ (self);
}


static void _metadata_menuitem_on_fetcher_completed_fetch_file_completed (FetchFile* _sender, GByteArray* data, const gchar* property, gpointer self) {
	metadata_menuitem_on_fetcher_completed (self, data, property);
}


void metadata_menuitem_fetch_art (MetadataMenuitem* self, const gchar* uri, const gchar* prop) {
	const gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* art_file;
	GFile* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	FetchFile* _tmp23_;
	FetchFile* _tmp24_;
	FetchFile* _tmp25_;
	FetchFile* _tmp26_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	g_return_if_fail (prop != NULL);
	_tmp0_ = uri;
	_tmp1_ = g_file_new_for_uri (_tmp0_);
	art_file = _tmp1_;
	_tmp2_ = art_file;
	_tmp3_ = g_file_is_native (_tmp2_);
	if (_tmp3_ == TRUE) {
		GFile* _tmp4_;
		gboolean _tmp5_ = FALSE;
		gchar* path = NULL;
		_tmp4_ = art_file;
		_tmp5_ = g_file_query_exists (_tmp4_, NULL);
		if (_tmp5_ == FALSE) {
			const gchar* _tmp6_;
			_tmp6_ = prop;
			dbusmenu_menuitem_property_set_int ((DbusmenuMenuitem*) self, _tmp6_, PLAYER_ITEM_EMPTY);
			_g_object_unref0 (art_file);
			return;
		}
		{
			const gchar* _tmp7_;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			gchar* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			_tmp7_ = uri;
			_tmp8_ = string_strip (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_filename_from_uri (_tmp9_, NULL, &_inner_error_);
			_tmp11_ = _tmp10_;
			_g_free0 (_tmp9_);
			_tmp12_ = _tmp11_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_CONVERT_ERROR) {
					goto __catch5_g_convert_error;
				}
				_g_free0 (path);
				_g_object_unref0 (art_file);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_g_free0 (path);
			path = _tmp12_;
			_tmp13_ = uri;
			_tmp14_ = string_strip (_tmp13_);
			_tmp15_ = _tmp14_;
			g_debug ("metadata-menu-item.vala:116: Populating the artwork field with %s", _tmp15_);
			_g_free0 (_tmp15_);
			_tmp16_ = prop;
			_tmp17_ = path;
			dbusmenu_menuitem_property_set ((DbusmenuMenuitem*) self, _tmp16_, _tmp17_);
		}
		goto __finally5;
		__catch5_g_convert_error:
		{
			GError* e = NULL;
			const gchar* _tmp18_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp18_ = uri;
			g_warning ("metadata-menu-item.vala:120: Problem converting URI %s to file path", _tmp18_);
			_g_error_free0 (e);
		}
		__finally5:
		if (_inner_error_ != NULL) {
			_g_free0 (path);
			_g_object_unref0 (art_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (path);
		_g_object_unref0 (art_file);
		return;
	}
	_tmp19_ = metadata_menuitem_album_art_cache_dir;
	g_debug ("metadata-menu-item.vala:126: fetch_art -remotely %s", _tmp19_);
	_tmp20_ = metadata_menuitem_album_art_cache_dir;
	if (_tmp20_ == NULL) {
		_g_object_unref0 (art_file);
		return;
	}
	_tmp21_ = uri;
	_tmp22_ = prop;
	_tmp23_ = fetch_file_new (_tmp21_, _tmp22_);
	_g_object_unref0 (metadata_menuitem_fetcher);
	metadata_menuitem_fetcher = _tmp23_;
	_tmp24_ = metadata_menuitem_fetcher;
	g_signal_connect_object (_tmp24_, "failed", (GCallback) ___lambda0__fetch_file_failed, self, 0);
	_tmp25_ = metadata_menuitem_fetcher;
	g_signal_connect_object (_tmp25_, "completed", (GCallback) _metadata_menuitem_on_fetcher_completed_fetch_file_completed, self, 0);
	_tmp26_ = metadata_menuitem_fetcher;
	fetch_file_fetch_data (_tmp26_, NULL, NULL);
	_g_object_unref0 (art_file);
}


static void metadata_menuitem_on_fetcher_failed (MetadataMenuitem* self) {
	g_return_if_fail (self != NULL);
	g_warning ("metadata-menu-item.vala:141: on_fetcher_failed -> could not fetch artw" \
"ork");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void metadata_menuitem_on_fetcher_completed (MetadataMenuitem* self, GByteArray* update, const gchar* property) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (update != NULL);
	g_return_if_fail (property != NULL);
	{
		GdkPixbufLoader* _tmp0_;
		GdkPixbufLoader* loader;
		GdkPixbufLoader* _tmp1_;
		GByteArray* _tmp2_;
		guint8* _tmp3_;
		gint _tmp3__length1;
		GdkPixbufLoader* _tmp4_;
		GdkPixbufLoader* _tmp5_;
		GdkPixbuf* _tmp6_ = NULL;
		GdkPixbuf* _tmp7_;
		GdkPixbuf* icon;
		const gchar* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* path;
		const gchar* _tmp10_;
		gint _tmp11_ = 0;
		gint r;
		gint _tmp12_;
		_tmp0_ = gdk_pixbuf_loader_new ();
		loader = _tmp0_;
		_tmp1_ = loader;
		_tmp2_ = update;
		_tmp3_ = _tmp2_->data;
		_tmp3__length1 = (gint) _tmp2_->len;
		gdk_pixbuf_loader_write (_tmp1_, _tmp3_, (gsize) _tmp3__length1, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (loader);
			goto __catch6_g_error;
		}
		_tmp4_ = loader;
		gdk_pixbuf_loader_close (_tmp4_, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (loader);
			goto __catch6_g_error;
		}
		_tmp5_ = loader;
		_tmp6_ = gdk_pixbuf_loader_get_pixbuf (_tmp5_);
		_tmp7_ = _g_object_ref0 (_tmp6_);
		icon = _tmp7_;
		_tmp8_ = metadata_menuitem_album_art_cache_dir;
		_tmp9_ = g_strconcat (_tmp8_, "/downloaded-coverart-XXXXXX", NULL);
		path = _tmp9_;
		_tmp10_ = path;
		_tmp11_ = g_mkstemp (_tmp10_);
		r = _tmp11_;
		_tmp12_ = r;
		if (_tmp12_ != (-1)) {
			GdkPixbuf* _tmp13_;
			const gchar* _tmp14_;
			GdkPixbufLoader* _tmp15_;
			GdkPixbufFormat* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp13_ = icon;
			_tmp14_ = path;
			_tmp15_ = loader;
			_tmp16_ = gdk_pixbuf_loader_get_format (_tmp15_);
			_tmp17_ = gdk_pixbuf_format_get_name (_tmp16_);
			gdk_pixbuf_save (_tmp13_, _tmp14_, _tmp17_, &_inner_error_, NULL);
			if (_inner_error_ != NULL) {
				_g_free0 (path);
				_g_object_unref0 (icon);
				_g_object_unref0 (loader);
				goto __catch6_g_error;
			}
			_tmp18_ = property;
			_tmp19_ = path;
			dbusmenu_menuitem_property_set ((DbusmenuMenuitem*) self, _tmp18_, _tmp19_);
			_tmp20_ = self->priv->previous_temp_album_art_path;
			if (_tmp20_ != NULL) {
				const gchar* _tmp21_;
				_tmp21_ = self->priv->previous_temp_album_art_path;
				g_remove (_tmp21_);
			}
			_tmp22_ = path;
			_tmp23_ = g_strdup (_tmp22_);
			_g_free0 (self->priv->previous_temp_album_art_path);
			self->priv->previous_temp_album_art_path = _tmp23_;
		}
		_g_free0 (path);
		_g_object_unref0 (icon);
		_g_object_unref0 (loader);
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		GError* _tmp24_;
		const gchar* _tmp25_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp24_ = e;
		_tmp25_ = _tmp24_->message;
		g_warning ("metadata-menu-item.vala:163: Problem creating file from bytearray fetc" \
"hed from the interweb - error: %s", _tmp25_);
		_g_error_free0 (e);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void metadata_menuitem_real_handle_event (DbusmenuMenuitem* base, const gchar* name, GVariant* input_value, guint timestamp) {
	MetadataMenuitem * self;
	PlayerController* _tmp0_;
	PlayerController* _tmp1_;
	gint _tmp2_;
	self = (MetadataMenuitem*) base;
	g_return_if_fail (name != NULL);
	g_return_if_fail (input_value != NULL);
	_tmp0_ = player_item_get_owner ((PlayerItem*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->current_state;
	if (_tmp2_ == ((gint) PLAYER_CONTROLLER_STATE_OFFLINE)) {
		PlayerController* _tmp3_;
		PlayerController* _tmp4_;
		_tmp3_ = player_item_get_owner ((PlayerItem*) self);
		_tmp4_ = _tmp3_;
		player_controller_instantiate (_tmp4_);
	} else {
		PlayerController* _tmp5_;
		PlayerController* _tmp6_;
		gint _tmp7_;
		_tmp5_ = player_item_get_owner ((PlayerItem*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_->current_state;
		if (_tmp7_ == ((gint) PLAYER_CONTROLLER_STATE_CONNECTED)) {
			PlayerController* _tmp8_;
			PlayerController* _tmp9_;
			Mpris2Controller* _tmp10_;
			_tmp8_ = player_item_get_owner ((PlayerItem*) self);
			_tmp9_ = _tmp8_;
			_tmp10_ = _tmp9_->mpris_bridge;
			mpris2_controller_expose (_tmp10_);
		}
	}
}


void metadata_menuitem_alter_label (MetadataMenuitem* self, const gchar* new_title) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = new_title;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = new_title;
	dbusmenu_menuitem_property_set ((DbusmenuMenuitem*) self, DBUSMENU_METADATA_MENUITEM_PLAYER_NAME, _tmp1_);
}


void metadata_menuitem_toggle_active_triangle (MetadataMenuitem* self, gboolean update) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_debug ("metadata-menu-item.vala:189: toggle active triangle");
	_tmp0_ = update;
	dbusmenu_menuitem_property_set_bool ((DbusmenuMenuitem*) self, DBUSMENU_METADATA_MENUITEM_PLAYER_RUNNING, _tmp0_);
}


void metadata_menuitem_should_collapse (MetadataMenuitem* self, gboolean collapse) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = collapse;
	dbusmenu_menuitem_property_set_bool ((DbusmenuMenuitem*) self, DBUSMENU_METADATA_MENUITEM_HIDE_TRACK_DETAILS, _tmp0_);
}


GeeHashSet* metadata_menuitem_attributes_format (void) {
	GeeHashSet* result = NULL;
	GeeHashSet* _tmp0_;
	GeeHashSet* attrs;
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	attrs = _tmp0_;
	gee_abstract_collection_add ((GeeAbstractCollection*) attrs, DBUSMENU_METADATA_MENUITEM_TITLE);
	gee_abstract_collection_add ((GeeAbstractCollection*) attrs, DBUSMENU_METADATA_MENUITEM_ARTIST);
	gee_abstract_collection_add ((GeeAbstractCollection*) attrs, DBUSMENU_METADATA_MENUITEM_ALBUM);
	gee_abstract_collection_add ((GeeAbstractCollection*) attrs, DBUSMENU_METADATA_MENUITEM_ARTURL);
	gee_abstract_collection_add ((GeeAbstractCollection*) attrs, DBUSMENU_METADATA_MENUITEM_PLAYER_NAME);
	gee_abstract_collection_add ((GeeAbstractCollection*) attrs, DBUSMENU_METADATA_MENUITEM_PLAYER_ICON);
	gee_abstract_collection_add ((GeeAbstractCollection*) attrs, DBUSMENU_METADATA_MENUITEM_PLAYER_RUNNING);
	result = attrs;
	return result;
}


GeeHashSet* metadata_menuitem_relevant_attributes_for_ui (void) {
	GeeHashSet* result = NULL;
	GeeHashSet* _tmp0_;
	GeeHashSet* attrs;
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	attrs = _tmp0_;
	gee_abstract_collection_add ((GeeAbstractCollection*) attrs, DBUSMENU_METADATA_MENUITEM_TITLE);
	gee_abstract_collection_add ((GeeAbstractCollection*) attrs, DBUSMENU_METADATA_MENUITEM_ARTIST);
	gee_abstract_collection_add ((GeeAbstractCollection*) attrs, DBUSMENU_METADATA_MENUITEM_ALBUM);
	gee_abstract_collection_add ((GeeAbstractCollection*) attrs, DBUSMENU_METADATA_MENUITEM_ARTURL);
	result = attrs;
	return result;
}


static GObject * metadata_menuitem_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	MetadataMenuitem * self;
	gchar* _tmp0_ = NULL;
	PlayerController* _tmp1_;
	PlayerController* _tmp2_;
	GAppInfo* _tmp3_;
	GAppInfo* _tmp4_;
	const gchar* _tmp5_ = NULL;
	PlayerController* _tmp6_;
	PlayerController* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	GeeHashSet* _tmp10_ = NULL;
	GeeHashSet* _tmp11_;
	parent_class = G_OBJECT_CLASS (metadata_menuitem_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = METADATA_MENUITEM (obj);
	metadata_menuitem_clean_album_art_temp_dir ();
	_g_free0 (self->priv->previous_temp_album_art_path);
	self->priv->previous_temp_album_art_path = NULL;
	_tmp0_ = metadata_menuitem_create_album_art_temp_dir ();
	_g_free0 (metadata_menuitem_album_art_cache_dir);
	metadata_menuitem_album_art_cache_dir = _tmp0_;
	_tmp1_ = player_item_get_owner ((PlayerItem*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = player_controller_get_app_info (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_app_info_get_name (_tmp4_);
	dbusmenu_menuitem_property_set ((DbusmenuMenuitem*) self, DBUSMENU_METADATA_MENUITEM_PLAYER_NAME, _tmp5_);
	_tmp6_ = player_item_get_owner ((PlayerItem*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = player_controller_get_icon_name (_tmp7_);
	_tmp9_ = _tmp8_;
	dbusmenu_menuitem_property_set ((DbusmenuMenuitem*) self, DBUSMENU_METADATA_MENUITEM_PLAYER_ICON, _tmp9_);
	dbusmenu_menuitem_property_set_bool ((DbusmenuMenuitem*) self, DBUSMENU_METADATA_MENUITEM_PLAYER_RUNNING, FALSE);
	dbusmenu_menuitem_property_set_bool ((DbusmenuMenuitem*) self, DBUSMENU_METADATA_MENUITEM_HIDE_TRACK_DETAILS, TRUE);
	_tmp10_ = metadata_menuitem_relevant_attributes_for_ui ();
	_tmp11_ = _tmp10_;
	player_item_reset ((PlayerItem*) self, _tmp11_);
	_g_object_unref0 (_tmp11_);
	return obj;
}


static void metadata_menuitem_class_init (MetadataMenuitemClass * klass) {
	metadata_menuitem_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MetadataMenuitemPrivate));
	DBUSMENU_MENUITEM_CLASS (klass)->handle_event = metadata_menuitem_real_handle_event;
	G_OBJECT_CLASS (klass)->constructor = metadata_menuitem_constructor;
	G_OBJECT_CLASS (klass)->finalize = metadata_menuitem_finalize;
}


static void metadata_menuitem_instance_init (MetadataMenuitem * self) {
	self->priv = METADATA_MENUITEM_GET_PRIVATE (self);
}


static void metadata_menuitem_finalize (GObject* obj) {
	MetadataMenuitem * self;
	self = METADATA_MENUITEM (obj);
	_g_free0 (self->priv->previous_temp_album_art_path);
	G_OBJECT_CLASS (metadata_menuitem_parent_class)->finalize (obj);
}


GType metadata_menuitem_get_type (void) {
	static volatile gsize metadata_menuitem_type_id__volatile = 0;
	if (g_once_init_enter (&metadata_menuitem_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MetadataMenuitemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) metadata_menuitem_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MetadataMenuitem), 0, (GInstanceInitFunc) metadata_menuitem_instance_init, NULL };
		GType metadata_menuitem_type_id;
		metadata_menuitem_type_id = g_type_register_static (TYPE_PLAYER_ITEM, "MetadataMenuitem", &g_define_type_info, 0);
		g_once_init_leave (&metadata_menuitem_type_id__volatile, metadata_menuitem_type_id);
	}
	return metadata_menuitem_type_id__volatile;
}



