
/*
* INTEL CONFIDENTIAL
* Copyright (c) 2024 Intel Corporation
* All Rights Reserved.
*
* The source code contained or described herein and all documents related to
* the source code ("Material") are owned by Intel Corporation or its
* suppliers or licensors. Title to the Material remains with Intel
* Corporation or its suppliers and licensors. The Material may contain trade
* secrets and proprietary and confidential information of Intel Corporation
* and its suppliers and licensors, and is protected by worldwide copyright
* and trade secret laws and treaty provisions. No part of the Material may be
* used, copied, reproduced, modified, published, uploaded, posted,
* transmitted, distributed, or disclosed in any way without Intel's prior
* express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or
* delivery of the Materials, either expressly, by implication, inducement,
* estoppel or otherwise. Any license under such intellectual property rights
* must be express and approved by Intel in writing.
*
* Unless otherwise agreed by Intel in writing, you may not remove or alter
* this notice or any other notice embedded in Materials by Intel or Intels
* suppliers or licensors in any way.
*/

#include "Ipu75xaStaticGraphDataPreloadAutogen.h"

int isSapEnable(char* binaryData)
{
    return ((BinaryHeader*)binaryData)->isSapEnable;
}

void parseTable(char* binaryData, GraphHashCodesTable* table)
{
    char* fileOffset = binaryData;
    uint32_t numOfAvailablePins = 0;
    uint32_t i;

    table->hashCodes = 0;

    //Skipping BinaryHeader

    fileOffset += sizeof(BinaryHeader);

    //Skipping DataRange:
    DataRangeHeader dataRangeHeader = *(DataRangeHeader*)fileOffset;
    for (int j = 0; j < enNumOfOutPins; j++)
        numOfAvailablePins += dataRangeHeader.NumberOfPinResolutions[j];
    fileOffset += sizeof(DataRangeHeader) + sizeof(DriverDesc) * numOfAvailablePins;

    //Parsing table:
    table->numOfGraphs = *(uint32_t*)fileOffset;
    table->hashCodes = (GraphHashCode*)malloc(sizeof(GraphHashCode) * (table->numOfGraphs));

    fileOffset += sizeof(table->numOfGraphs);
    for (i = 0; i < table->numOfGraphs; ++i)
    {
        table->hashCodes[i] = *(GraphHashCode*)fileOffset;
        fileOffset += sizeof(GraphHashCode);
    }
}

int validateHashCodes_aux(GraphHashCodesTable* table)
{
    uint32_t tableIndex, lookupIndex;
    int current;
    int retVal = TRUE;

    for (tableIndex = 0, lookupIndex = 1;
        tableIndex < table->numOfGraphs && lookupIndex < (uint32_t)distinctGraphsCount + 1;)
    {
        if (hashCodeLookup[lookupIndex].key == table->hashCodes[tableIndex].key)
        {
            current = hashCodeLookup[lookupIndex].value == table->hashCodes[tableIndex].value;
            retVal = retVal && current;
            if (!current)
            {
                //Graph exists in binary data & autogenerated code but hash keys don't match.
                printf("FAILURE: graph %d has hash 0x%X in the generated lookup table, 0x%X in the binary data.\n",
                    hashCodeLookup[lookupIndex].key, hashCodeLookup[lookupIndex].value, table->hashCodes[tableIndex].value);
            }
            else
            {
                printf("SUCCESS: graph %d is identical in binary & generated code.\n", hashCodeLookup[lookupIndex].key);
            }
            ++lookupIndex;
            ++tableIndex;
        }
        else if (table->hashCodes[tableIndex].key < hashCodeLookup[lookupIndex].key)
        {
            //Graph exists in binary data but not in autogenerated code.
            printf("FAILURE: graph %d exists in the binary data but not in the generated lookup table.\n", table->hashCodes[tableIndex].key);
            retVal = FALSE;
            ++tableIndex;
        }
        else
        {
            //Graph exists in autogenerated code but not in binary data.
            printf("FAILURE: graph %d exists in the generated lookup table but not in the binary data.\n", hashCodeLookup[lookupIndex].key);
            retVal = FALSE;
            ++lookupIndex;
        }
    }
    for (; tableIndex < table->numOfGraphs; ++tableIndex)
    {
        //Graph exists in binary data but not in autogenerated code.
        printf("FAILURE: graph %d exists in the binary data but not in the generated lookup table.\n", table->hashCodes[tableIndex].key);
        retVal = FALSE;
    }
    for (; lookupIndex < (uint32_t)distinctGraphsCount + 1; ++lookupIndex)
    {
        //Graph exists in autogenerated code but not in binary data.
        printf("FAILURE: graph %d exists in the generated lookup table but not in the binary data.\n", hashCodeLookup[lookupIndex].key);
        retVal = FALSE;
    }
    return retVal;
}

int validateHashCodes(char* binaryData)
{
    int retVal = TRUE;
    GraphHashCodesTable table;
    uint32_t commonHash = ((BinaryHeader*)binaryData)->binaryCommonHashCode;

    parseTable(binaryData, &table);
    if (table.hashCodes == 0)
    {
        printf("Memory allocation error in validateHashCodes.\n");
        return FALSE;
    }

    if (hashCodeLookup[0].value != commonHash)
    {
        retVal = FALSE;
        printf("FAILURE: common hash differs between binary data and the generated code.\n");
    }
    else
    {
        printf("SUCCESS: common hash is identical in binary data and the generated code.\n");
    }

    retVal = validateHashCodes_aux(&table) && retVal;

    free(table.hashCodes);

    return retVal;
}

int GetDataRangeFromBin(char* binaryData, DataRange* dataRange)
{

    char* fileOffset = NULL;
    uint32_t numOfAvailablePins = 0;
    uint32_t j = 0;

    fileOffset = binaryData;
    //Skipping BinaryHeader

    fileOffset += sizeof(BinaryHeader);

    dataRange->dataRangeHeader = *(DataRangeHeader*)fileOffset;

    uint32_t* pinOffset = (uint32_t*)&dataRange->dataRangeHeader;

    for (j = 0; j< enNumOfOutPins; j++)
        if (pinOffset[j])
            numOfAvailablePins++;

    fileOffset += sizeof(DataRangeHeader);

    dataRange->dataRangeMap = (DriverDesc**)malloc(sizeof(DriverDesc*) * numOfAvailablePins);
    if (!dataRange->dataRangeMap)
        return FALSE;

    for (j = 0; j < enNumOfOutPins; j++)
    {
        if (pinOffset[j])
        {
            dataRange->dataRangeMap[j] = (DriverDesc*)malloc(sizeof(DriverDesc) * pinOffset[j]);
            dataRange->dataRangeMap[j] = (DriverDesc*)fileOffset;
            fileOffset += sizeof(DriverDesc) * pinOffset[j];
        }
    }

    return TRUE;
}