package magick;

/**
 * Corresponds to the ImageMagick ExceptionType enumeration.
 *
 * @author Eric Yeo
 */
public interface ExceptionType {

    public static final int UndefinedException = 0;
    public static final int WarningException = 300;
    public static final int ResourceLimitWarning = 300;
    public static final int TypeWarning = 305;
    public static final int OptionWarning = 310;
    public static final int DelegateWarning = 315;
    public static final int MissingDelegateWarning = 320;
    public static final int CorruptImageWarning = 325;
    public static final int FileOpenWarning = 330;
    public static final int BlobWarning = 335;
    public static final int StreamWarning = 340;
    public static final int CacheWarning = 345;
    public static final int CoderWarning = 350;
    public static final int ModuleWarning = 355;
    public static final int DrawWarning = 360;
    public static final int ImageWarning = 365;
    public static final int WandWarning = 370;
    public static final int XServerWarning = 380;
    public static final int MonitorWarning = 385;
    public static final int RegistryWarning = 390;
    public static final int ConfigureWarning = 395;
    public static final int ErrorException = 400;
    public static final int ResourceLimitError = 400;
    public static final int TypeError = 405;
    public static final int OptionError = 410;
    public static final int DelegateError = 415;
    public static final int MissingDelegateError = 420;
    public static final int CorruptImageError = 425;
    public static final int FileOpenError = 430;
    public static final int BlobError = 435;
    public static final int StreamError = 440;
    public static final int CacheError = 445;
    public static final int CoderError = 450;
    public static final int ModuleError = 455;
    public static final int DrawError = 460;
    public static final int ImageError = 465;
    public static final int WandError = 470;
    public static final int XServerError = 480;
    public static final int MonitorError = 485;
    public static final int RegistryError = 490;
    public static final int ConfigureError = 495;
    public static final int FatalErrorException = 700;
    public static final int ResourceLimitFatalError = 700;
    public static final int TypeFatalError = 705;
    public static final int OptionFatalError = 710;
    public static final int DelegateFatalError = 715;
    public static final int MissingDelegateFatalError = 720;
    public static final int CorruptImageFatalError = 725;
    public static final int FileOpenFatalError = 730;
    public static final int BlobFatalError = 735;
    public static final int StreamFatalError = 740;
    public static final int CacheFatalError = 745;
    public static final int CoderFatalError = 750;
    public static final int ModuleFatalError = 755;
    public static final int DrawFatalError = 760;
    public static final int ImageFatalError = 765;
    public static final int WandFatalError = 770;
    public static final int XServerFatalError = 780;
    public static final int MonitorFatalError = 785;
    public static final int RegistryFatalError = 790;
    public static final int ConfigureFatalError = 795;

}
