#!/usr/bin/env python

# (c) 2007 Canonical Ltd.
# Author: Martin Pitt <martin.pitt@ubuntu.com>

# This script needs python-distutils-extra, an extension to the standard
# distutils which provides i18n, icon support, etc.
# https://launchpad.net/python-distutils-extra

from glob import glob
from distutils.core import setup
from DistUtilsExtra.command import *

setup(
    name='jockey',
    version='0.3.3',

    description='UI for managing third-party and non-free drivers',
    url='https://launchpad.net/jockey',
    license='GPL v2 or later',
    author='Martin Pitt',
    author_email='martin.pitt@ubuntu.com',

    packages=['jockey'],

    data_files = [
        ('share/jockey', glob('gtk/*.glade')),
        ('share/jockey', glob('kde/*.ui')),
        ('share/jockey/modaliases', glob('data/modalias-overrides/*')),
        ('share/jockey/handlers', glob('data/handlers/*')),
        ],

    scripts = ['gtk/jockey-gtk', 'kde/jockey-kde'],

    cmdclass = { 'build': build_extra.build_extra,
                 'build_i18n': build_i18n.build_i18n,
                 'build_icons': build_icons.build_icons,
                 'clean': clean_i18n.clean_i18n,
               }
)
