/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: kz-bookmark.h 3699 2009-02-15 03:52:37Z ikezoe $
 */

#ifndef __KZ_BOOKMARK_H__
#define __KZ_BOOKMARK_H__

#include <glib-object.h>
#include "kz-bookmark-objects.h"

G_BEGIN_DECLS

#define KZ_TYPE_BOOKMARK		(kz_bookmark_get_type ())
#define KZ_BOOKMARK(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_BOOKMARK, KzBookmark))
#define KZ_BOOKMARK_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass),  KZ_TYPE_BOOKMARK, KzBookmarkClass))
#define KZ_IS_BOOKMARK(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_BOOKMARK))
#define KZ_IS_BOOKMARK_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass),  KZ_TYPE_BOOKMARK))
#define KZ_BOOKMARK_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj),  KZ_TYPE_BOOKMARK, KzBookmarkClass))

typedef struct _KzBookmarkClass    KzBookmarkClass;

struct _KzBookmark
{
	GObject         parent;
};

struct _KzBookmarkClass
{
	GObjectClass parent_class;
};


/* GType */
GType		kz_bookmark_get_type		(void) G_GNUC_CONST; 

/* boomark item creating functions */
KzBookmark     *kz_bookmark_new			(void);
KzBookmark     *kz_bookmark_new_with_attrs	(const gchar *title,
						 const gchar *uri,
						 const gchar *description);
/* set/get properties */
/*
 * "ID" is md5sum of URI of the parent bookmark file + ":" + ID
 * "title" means user defined title.
 */
const gchar    *kz_bookmark_get_id		(KzBookmark  *bookmark);
const gchar    *kz_bookmark_get_link		(KzBookmark  *bookmark);
const gchar    *kz_bookmark_get_title		(KzBookmark  *bookmark);
const gchar    *kz_bookmark_get_description	(KzBookmark  *bookmark);
guint		kz_bookmark_get_last_modified	(KzBookmark  *bookmark);
guint		kz_bookmark_get_last_visited	(KzBookmark  *bookmark);
guint		kz_bookmark_get_added_time	(KzBookmark  *bookmark);
gboolean        kz_bookmark_is_editable         (KzBookmark  *bookmark);

void		kz_bookmark_set_id		(KzBookmark  *bookmark,
						 const gchar *id);
void		kz_bookmark_set_link		(KzBookmark  *bookmark,
						 const gchar *uri);
void		kz_bookmark_set_title		(KzBookmark  *bookmark,
						 const gchar *title);
void		kz_bookmark_set_description	(KzBookmark  *bookmark,
						 const gchar *description);
void		kz_bookmark_set_last_modified	(KzBookmark  *bookmark,
						 guint        time);
void		kz_bookmark_set_last_visited	(KzBookmark  *bookmark,
						 guint        time);
void		kz_bookmark_set_added_time	(KzBookmark  *bookmark,
						 guint        time);
/* separator interface */
#define kz_bookmark_is_separator        KZ_IS_BOOKMARK_SEPARATOR

/* folder interface */
#define kz_bookmark_is_folder           KZ_IS_BOOKMARK_FOLDER
KzBookmarkFolder*
                kz_bookmark_get_parent		(KzBookmark  *bookmark);
void            kz_bookmark_set_parent          (KzBookmark  *bookmark,
                                                 KzBookmarkFolder *parent);
KzBookmark     *kz_bookmark_get_parent_file	(KzBookmark  *bookmark);
KzBookmark     *kz_bookmark_next		(KzBookmark  *bookmark);
KzBookmark     *kz_bookmark_prev		(KzBookmark  *bookmark);

G_END_DECLS

#endif /* __KZ_BOOKMARK_H__ */
