/*
Copyright (c) 2000 Simon Hausmann <hausmann@kde.org>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
#ifndef __dcopc_marshal_h__
#define __dcopc_marshal_h__

#ifdef __cplusplus
extern "C" {
#endif

#include <X11/ICE/ICElib.h>

#include <dcopc/util.h>
#include <stdlib.h>
    
typedef struct _dcop_data dcop_data;

struct _dcop_data
{
    char *ptr;
    unsigned int size;
    char *cur;
    unsigned int ref;
};

/* remember to call ref() after this one! */
dcop_data *dcop_data_new();

/* do not call directly! use deref! */
void dcop_data_destroy( dcop_data *data );

void dcop_data_assign( dcop_data *data, char *d, unsigned int size );

dcop_data *dcop_data_ref( dcop_data *data );
void dcop_data_deref( dcop_data *data );

dcop_data *dcop_data_copy( dcop_data *data );

void dcop_data_reset( dcop_data *data );

gboolean dcop_marshal_raw( dcop_data *data, const void *ptr, unsigned int size );

gboolean dcop_marshal_uint32( dcop_data *data, unsigned int val );
gboolean dcop_demarshal_uint32( dcop_data *data, unsigned int *val );

gboolean dcop_marshal_string( dcop_data *data, const gchar *str );
gboolean dcop_demarshal_string( dcop_data *data, gchar **str );

/* works only for ascii! */
gboolean dcop_marshal_string16( dcop_data *data, const gchar *str );
gboolean dcop_demarshal_string16( dcop_data *data, gchar **str );

gboolean dcop_marshal_bytearray( dcop_data *data, const gchar *str,  size_t size );
gboolean dcop_demarshal_bytearray( dcop_data *data, gchar **str, size_t *size );
    
gboolean dcop_marshal_data( dcop_data *data, dcop_data *other );
gboolean dcop_demarshal_data( dcop_data *data, dcop_data **other );

gboolean dcop_marshal_stringlist( dcop_data *data, GList *list );
gboolean dcop_demarshal_stringlist( dcop_data *data, GList **list );

gboolean dcop_marshal_stringlist16( dcop_data *data, GList *list );
gboolean dcop_demarshal_stringlist16( dcop_data *data, GList **list );

gboolean dcop_marshal_boolean( dcop_data *data, gboolean val );
gboolean dcop_demarshal_boolean( dcop_data *data, gboolean *val );

gboolean dcop_marshal_uint8( dcop_data *data, guint8 val );
gboolean dcop_demarshal_uint8( dcop_data *data, guint8 *val );

#ifdef __cplusplus
}
#endif


#endif
