/*
 * lftp and utils
 *
 * Copyright (c) 2004 by Alexander V. Lukyanov (lav@yars.free.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* $Id: StringSet.cc,v 1.7 2008/11/27 05:56:31 lav Exp $ */

#include <config.h>
#include "StringSet.h"
#include "misc.h"

#define set_size set.count()

bool StringSet::IsEqual(const char *const *set1,int n1) const
{
   if(set_size!=n1)
      return false;
   int i=0;
   while(i<n1)
   {
      if(strcmp(set[i],set1[i]))
	 return false;
      i++;
   }
   return true;
}
void StringSet::Assign(const char *const *set1,int n1)
{
   Empty();
   while(n1-->0)
      set.append(xstrdup(*set1++));
}
void StringSet::Append(const char *s)
{
   if(!s)
      return;
   set.append(xstrdup(s));
}
void StringSet::Replace(int i,const char *s)
{
   if(i==set_size)
      Append(s);
   else if(i>=0 && i<set_size)
   {
      xstrset(set[i],s);
      if(!s && i==set_size-1)
	 set.set_length(set.count()-1);
   }
}
void StringSet::InsertBefore(int i,const char *s)
{
   if(!s)
      return;
   set.insert(xstrdup(s),i);
}

void StringSet::AppendFormat(const char *f,...)
{
   va_list v;
   va_start(v,f);
   set.append(xvasprintf(f,v));
   va_end(v);
}

void StringSet::MoveHere(StringSet &o)
{
   set.set(o.set);
   o.set.borrow();
}

char *StringSet::Pop(int i)
{
   if(i<0 || i>=set_size)
      return 0;
   char *s=set[i];
   set[i]=0;
   set.remove(i);
   return s;
}
