/*
 * Freescale AUDIOIN Register Definitions
 *
 * Copyright 2008-2010 Freescale Semiconductor, Inc.
 * Copyright 2008 Embedded Alley Solutions, Inc All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * This file is created by xml file. Don't Edit it.
 *
 * Xml Revision: 1.52
 * Template revision: 26195
 */

#ifndef __ARCH_ARM___AUDIOIN_H
#define __ARCH_ARM___AUDIOIN_H

#define REGS_AUDIOIN_BASE  (IO_ADDRESS(AUDIOIN_PHYS_ADDR))

#define HW_AUDIOIN_CTRL	(0x00000000)
#define HW_AUDIOIN_CTRL_SET	(0x00000004)
#define HW_AUDIOIN_CTRL_CLR	(0x00000008)
#define HW_AUDIOIN_CTRL_TOG	(0x0000000c)

#define BM_AUDIOIN_CTRL_SFTRST	0x80000000
#define BM_AUDIOIN_CTRL_CLKGATE	0x40000000
#define BP_AUDIOIN_CTRL_RSRVD3	21
#define BM_AUDIOIN_CTRL_RSRVD3	0x3FE00000
#define BF_AUDIOIN_CTRL_RSRVD3(v)  \
		(((v) << 21) & BM_AUDIOIN_CTRL_RSRVD3)
#define BP_AUDIOIN_CTRL_DMAWAIT_COUNT	16
#define BM_AUDIOIN_CTRL_DMAWAIT_COUNT	0x001F0000
#define BF_AUDIOIN_CTRL_DMAWAIT_COUNT(v)  \
		(((v) << 16) & BM_AUDIOIN_CTRL_DMAWAIT_COUNT)
#define BP_AUDIOIN_CTRL_RSRVD1	11
#define BM_AUDIOIN_CTRL_RSRVD1	0x0000F800
#define BF_AUDIOIN_CTRL_RSRVD1(v)  \
		(((v) << 11) & BM_AUDIOIN_CTRL_RSRVD1)
#define BM_AUDIOIN_CTRL_LR_SWAP	0x00000400
#define BM_AUDIOIN_CTRL_EDGE_SYNC	0x00000200
#define BM_AUDIOIN_CTRL_INVERT_1BIT	0x00000100
#define BM_AUDIOIN_CTRL_OFFSET_ENABLE	0x00000080
#define BM_AUDIOIN_CTRL_HPF_ENABLE	0x00000040
#define BM_AUDIOIN_CTRL_WORD_LENGTH	0x00000020
#define BM_AUDIOIN_CTRL_LOOPBACK	0x00000010
#define BM_AUDIOIN_CTRL_FIFO_UNDERFLOW_IRQ	0x00000008
#define BM_AUDIOIN_CTRL_FIFO_OVERFLOW_IRQ	0x00000004
#define BM_AUDIOIN_CTRL_FIFO_ERROR_IRQ_EN	0x00000002
#define BM_AUDIOIN_CTRL_RUN	0x00000001

#define HW_AUDIOIN_STAT	(0x00000010)
#define HW_AUDIOIN_STAT_SET	(0x00000014)
#define HW_AUDIOIN_STAT_CLR	(0x00000018)
#define HW_AUDIOIN_STAT_TOG	(0x0000001c)

#define BM_AUDIOIN_STAT_ADC_PRESENT	0x80000000
#define BP_AUDIOIN_STAT_RSRVD3	0
#define BM_AUDIOIN_STAT_RSRVD3	0x7FFFFFFF
#define BF_AUDIOIN_STAT_RSRVD3(v)  \
		(((v) << 0) & BM_AUDIOIN_STAT_RSRVD3)

#define HW_AUDIOIN_ADCSRR	(0x00000020)
#define HW_AUDIOIN_ADCSRR_SET	(0x00000024)
#define HW_AUDIOIN_ADCSRR_CLR	(0x00000028)
#define HW_AUDIOIN_ADCSRR_TOG	(0x0000002c)

#define BM_AUDIOIN_ADCSRR_OSR	0x80000000
#define BV_AUDIOIN_ADCSRR_OSR__OSR6  0x0
#define BV_AUDIOIN_ADCSRR_OSR__OSR12 0x1
#define BP_AUDIOIN_ADCSRR_BASEMULT	28
#define BM_AUDIOIN_ADCSRR_BASEMULT	0x70000000
#define BF_AUDIOIN_ADCSRR_BASEMULT(v)  \
		(((v) << 28) & BM_AUDIOIN_ADCSRR_BASEMULT)
#define BV_AUDIOIN_ADCSRR_BASEMULT__SINGLE_RATE 0x1
#define BV_AUDIOIN_ADCSRR_BASEMULT__DOUBLE_RATE 0x2
#define BV_AUDIOIN_ADCSRR_BASEMULT__QUAD_RATE   0x4
#define BM_AUDIOIN_ADCSRR_RSRVD2	0x08000000
#define BP_AUDIOIN_ADCSRR_SRC_HOLD	24
#define BM_AUDIOIN_ADCSRR_SRC_HOLD	0x07000000
#define BF_AUDIOIN_ADCSRR_SRC_HOLD(v)  \
		(((v) << 24) & BM_AUDIOIN_ADCSRR_SRC_HOLD)
#define BP_AUDIOIN_ADCSRR_RSRVD1	21
#define BM_AUDIOIN_ADCSRR_RSRVD1	0x00E00000
#define BF_AUDIOIN_ADCSRR_RSRVD1(v)  \
		(((v) << 21) & BM_AUDIOIN_ADCSRR_RSRVD1)
#define BP_AUDIOIN_ADCSRR_SRC_INT	16
#define BM_AUDIOIN_ADCSRR_SRC_INT	0x001F0000
#define BF_AUDIOIN_ADCSRR_SRC_INT(v)  \
		(((v) << 16) & BM_AUDIOIN_ADCSRR_SRC_INT)
#define BP_AUDIOIN_ADCSRR_RSRVD0	13
#define BM_AUDIOIN_ADCSRR_RSRVD0	0x0000E000
#define BF_AUDIOIN_ADCSRR_RSRVD0(v)  \
		(((v) << 13) & BM_AUDIOIN_ADCSRR_RSRVD0)
#define BP_AUDIOIN_ADCSRR_SRC_FRAC	0
#define BM_AUDIOIN_ADCSRR_SRC_FRAC	0x00001FFF
#define BF_AUDIOIN_ADCSRR_SRC_FRAC(v)  \
		(((v) << 0) & BM_AUDIOIN_ADCSRR_SRC_FRAC)

#define HW_AUDIOIN_ADCVOLUME	(0x00000030)
#define HW_AUDIOIN_ADCVOLUME_SET	(0x00000034)
#define HW_AUDIOIN_ADCVOLUME_CLR	(0x00000038)
#define HW_AUDIOIN_ADCVOLUME_TOG	(0x0000003c)

#define BP_AUDIOIN_ADCVOLUME_RSRVD5	29
#define BM_AUDIOIN_ADCVOLUME_RSRVD5	0xE0000000
#define BF_AUDIOIN_ADCVOLUME_RSRVD5(v) \
		(((v) << 29) & BM_AUDIOIN_ADCVOLUME_RSRVD5)
#define BM_AUDIOIN_ADCVOLUME_VOLUME_UPDATE_LEFT	0x10000000
#define BP_AUDIOIN_ADCVOLUME_RSRVD4	26
#define BM_AUDIOIN_ADCVOLUME_RSRVD4	0x0C000000
#define BF_AUDIOIN_ADCVOLUME_RSRVD4(v)  \
		(((v) << 26) & BM_AUDIOIN_ADCVOLUME_RSRVD4)
#define BM_AUDIOIN_ADCVOLUME_EN_ZCD	0x02000000
#define BM_AUDIOIN_ADCVOLUME_RSRVD3	0x01000000
#define BP_AUDIOIN_ADCVOLUME_VOLUME_LEFT	16
#define BM_AUDIOIN_ADCVOLUME_VOLUME_LEFT	0x00FF0000
#define BF_AUDIOIN_ADCVOLUME_VOLUME_LEFT(v)  \
		(((v) << 16) & BM_AUDIOIN_ADCVOLUME_VOLUME_LEFT)
#define BP_AUDIOIN_ADCVOLUME_RSRVD2	13
#define BM_AUDIOIN_ADCVOLUME_RSRVD2	0x0000E000
#define BF_AUDIOIN_ADCVOLUME_RSRVD2(v)  \
		(((v) << 13) & BM_AUDIOIN_ADCVOLUME_RSRVD2)
#define BM_AUDIOIN_ADCVOLUME_VOLUME_UPDATE_RIGHT	0x00001000
#define BP_AUDIOIN_ADCVOLUME_RSRVD1	8
#define BM_AUDIOIN_ADCVOLUME_RSRVD1	0x00000F00
#define BF_AUDIOIN_ADCVOLUME_RSRVD1(v)  \
		(((v) << 8) & BM_AUDIOIN_ADCVOLUME_RSRVD1)
#define BP_AUDIOIN_ADCVOLUME_VOLUME_RIGHT	0
#define BM_AUDIOIN_ADCVOLUME_VOLUME_RIGHT	0x000000FF
#define BF_AUDIOIN_ADCVOLUME_VOLUME_RIGHT(v)  \
		(((v) << 0) & BM_AUDIOIN_ADCVOLUME_VOLUME_RIGHT)

#define HW_AUDIOIN_ADCDEBUG	(0x00000040)
#define HW_AUDIOIN_ADCDEBUG_SET	(0x00000044)
#define HW_AUDIOIN_ADCDEBUG_CLR	(0x00000048)
#define HW_AUDIOIN_ADCDEBUG_TOG	(0x0000004c)

#define BM_AUDIOIN_ADCDEBUG_ENABLE_ADCDMA	0x80000000
#define BP_AUDIOIN_ADCDEBUG_RSRVD1	4
#define BM_AUDIOIN_ADCDEBUG_RSRVD1	0x7FFFFFF0
#define BF_AUDIOIN_ADCDEBUG_RSRVD1(v)  \
		(((v) << 4) & BM_AUDIOIN_ADCDEBUG_RSRVD1)
#define BM_AUDIOIN_ADCDEBUG_ADC_DMA_REQ_HAND_SHAKE_CLK_CROSS	0x00000008
#define BM_AUDIOIN_ADCDEBUG_SET_INTERRUPT3_HAND_SHAKE	0x00000004
#define BM_AUDIOIN_ADCDEBUG_DMA_PREQ	0x00000002
#define BM_AUDIOIN_ADCDEBUG_FIFO_STATUS	0x00000001

#define HW_AUDIOIN_ADCVOL	(0x00000050)
#define HW_AUDIOIN_ADCVOL_SET	(0x00000054)
#define HW_AUDIOIN_ADCVOL_CLR	(0x00000058)
#define HW_AUDIOIN_ADCVOL_TOG	(0x0000005c)

#define BP_AUDIOIN_ADCVOL_RSRVD4	29
#define BM_AUDIOIN_ADCVOL_RSRVD4	0xE0000000
#define BF_AUDIOIN_ADCVOL_RSRVD4(v) \
		(((v) << 29) & BM_AUDIOIN_ADCVOL_RSRVD4)
#define BM_AUDIOIN_ADCVOL_VOLUME_UPDATE_PENDING	0x10000000
#define BP_AUDIOIN_ADCVOL_RSRVD3	26
#define BM_AUDIOIN_ADCVOL_RSRVD3	0x0C000000
#define BF_AUDIOIN_ADCVOL_RSRVD3(v)  \
		(((v) << 26) & BM_AUDIOIN_ADCVOL_RSRVD3)
#define BM_AUDIOIN_ADCVOL_EN_ADC_ZCD	0x02000000
#define BM_AUDIOIN_ADCVOL_MUTE	0x01000000
#define BP_AUDIOIN_ADCVOL_RSRVD2	14
#define BM_AUDIOIN_ADCVOL_RSRVD2	0x00FFC000
#define BF_AUDIOIN_ADCVOL_RSRVD2(v)  \
		(((v) << 14) & BM_AUDIOIN_ADCVOL_RSRVD2)
#define BP_AUDIOIN_ADCVOL_SELECT_LEFT	12
#define BM_AUDIOIN_ADCVOL_SELECT_LEFT	0x00003000
#define BF_AUDIOIN_ADCVOL_SELECT_LEFT(v)  \
		(((v) << 12) & BM_AUDIOIN_ADCVOL_SELECT_LEFT)
#define BP_AUDIOIN_ADCVOL_GAIN_LEFT	8
#define BM_AUDIOIN_ADCVOL_GAIN_LEFT	0x00000F00
#define BF_AUDIOIN_ADCVOL_GAIN_LEFT(v)  \
		(((v) << 8) & BM_AUDIOIN_ADCVOL_GAIN_LEFT)
#define BP_AUDIOIN_ADCVOL_RSRVD1	6
#define BM_AUDIOIN_ADCVOL_RSRVD1	0x000000C0
#define BF_AUDIOIN_ADCVOL_RSRVD1(v)  \
		(((v) << 6) & BM_AUDIOIN_ADCVOL_RSRVD1)
#define BP_AUDIOIN_ADCVOL_SELECT_RIGHT	4
#define BM_AUDIOIN_ADCVOL_SELECT_RIGHT	0x00000030
#define BF_AUDIOIN_ADCVOL_SELECT_RIGHT(v)  \
		(((v) << 4) & BM_AUDIOIN_ADCVOL_SELECT_RIGHT)
#define BP_AUDIOIN_ADCVOL_GAIN_RIGHT	0
#define BM_AUDIOIN_ADCVOL_GAIN_RIGHT	0x0000000F
#define BF_AUDIOIN_ADCVOL_GAIN_RIGHT(v)  \
		(((v) << 0) & BM_AUDIOIN_ADCVOL_GAIN_RIGHT)

#define HW_AUDIOIN_MICLINE	(0x00000060)
#define HW_AUDIOIN_MICLINE_SET	(0x00000064)
#define HW_AUDIOIN_MICLINE_CLR	(0x00000068)
#define HW_AUDIOIN_MICLINE_TOG	(0x0000006c)

#define BP_AUDIOIN_MICLINE_RSRVD6	30
#define BM_AUDIOIN_MICLINE_RSRVD6	0xC0000000
#define BF_AUDIOIN_MICLINE_RSRVD6(v) \
		(((v) << 30) & BM_AUDIOIN_MICLINE_RSRVD6)
#define BM_AUDIOIN_MICLINE_DIVIDE_LINE1	0x20000000
#define BM_AUDIOIN_MICLINE_DIVIDE_LINE2	0x10000000
#define BP_AUDIOIN_MICLINE_RSRVD5	25
#define BM_AUDIOIN_MICLINE_RSRVD5	0x0E000000
#define BF_AUDIOIN_MICLINE_RSRVD5(v)  \
		(((v) << 25) & BM_AUDIOIN_MICLINE_RSRVD5)
#define BM_AUDIOIN_MICLINE_MIC_SELECT	0x01000000
#define BP_AUDIOIN_MICLINE_RSRVD4	22
#define BM_AUDIOIN_MICLINE_RSRVD4	0x00C00000
#define BF_AUDIOIN_MICLINE_RSRVD4(v)  \
		(((v) << 22) & BM_AUDIOIN_MICLINE_RSRVD4)
#define BP_AUDIOIN_MICLINE_MIC_RESISTOR	20
#define BM_AUDIOIN_MICLINE_MIC_RESISTOR	0x00300000
#define BF_AUDIOIN_MICLINE_MIC_RESISTOR(v)  \
		(((v) << 20) & BM_AUDIOIN_MICLINE_MIC_RESISTOR)
#define BM_AUDIOIN_MICLINE_RSRVD3	0x00080000
#define BP_AUDIOIN_MICLINE_MIC_BIAS	16
#define BM_AUDIOIN_MICLINE_MIC_BIAS	0x00070000
#define BF_AUDIOIN_MICLINE_MIC_BIAS(v)  \
		(((v) << 16) & BM_AUDIOIN_MICLINE_MIC_BIAS)
#define BP_AUDIOIN_MICLINE_RSRVD2	6
#define BM_AUDIOIN_MICLINE_RSRVD2	0x0000FFC0
#define BF_AUDIOIN_MICLINE_RSRVD2(v)  \
		(((v) << 6) & BM_AUDIOIN_MICLINE_RSRVD2)
#define BP_AUDIOIN_MICLINE_MIC_CHOPCLK	4
#define BM_AUDIOIN_MICLINE_MIC_CHOPCLK	0x00000030
#define BF_AUDIOIN_MICLINE_MIC_CHOPCLK(v)  \
		(((v) << 4) & BM_AUDIOIN_MICLINE_MIC_CHOPCLK)
#define BP_AUDIOIN_MICLINE_RSRVD1	2
#define BM_AUDIOIN_MICLINE_RSRVD1	0x0000000C
#define BF_AUDIOIN_MICLINE_RSRVD1(v)  \
		(((v) << 2) & BM_AUDIOIN_MICLINE_RSRVD1)
#define BP_AUDIOIN_MICLINE_MIC_GAIN	0
#define BM_AUDIOIN_MICLINE_MIC_GAIN	0x00000003
#define BF_AUDIOIN_MICLINE_MIC_GAIN(v)  \
		(((v) << 0) & BM_AUDIOIN_MICLINE_MIC_GAIN)

#define HW_AUDIOIN_ANACLKCTRL	(0x00000070)
#define HW_AUDIOIN_ANACLKCTRL_SET	(0x00000074)
#define HW_AUDIOIN_ANACLKCTRL_CLR	(0x00000078)
#define HW_AUDIOIN_ANACLKCTRL_TOG	(0x0000007c)

#define BM_AUDIOIN_ANACLKCTRL_CLKGATE	0x80000000
#define BP_AUDIOIN_ANACLKCTRL_RSRVD4	11
#define BM_AUDIOIN_ANACLKCTRL_RSRVD4	0x7FFFF800
#define BF_AUDIOIN_ANACLKCTRL_RSRVD4(v)  \
		(((v) << 11) & BM_AUDIOIN_ANACLKCTRL_RSRVD4)
#define BM_AUDIOIN_ANACLKCTRL_DITHER_OFF	0x00000400
#define BM_AUDIOIN_ANACLKCTRL_SLOW_DITHER	0x00000200
#define BM_AUDIOIN_ANACLKCTRL_INVERT_ADCCLK	0x00000100
#define BP_AUDIOIN_ANACLKCTRL_RSRVD3	6
#define BM_AUDIOIN_ANACLKCTRL_RSRVD3	0x000000C0
#define BF_AUDIOIN_ANACLKCTRL_RSRVD3(v)  \
		(((v) << 6) & BM_AUDIOIN_ANACLKCTRL_RSRVD3)
#define BP_AUDIOIN_ANACLKCTRL_ADCCLK_SHIFT	4
#define BM_AUDIOIN_ANACLKCTRL_ADCCLK_SHIFT	0x00000030
#define BF_AUDIOIN_ANACLKCTRL_ADCCLK_SHIFT(v)  \
		(((v) << 4) & BM_AUDIOIN_ANACLKCTRL_ADCCLK_SHIFT)
#define BM_AUDIOIN_ANACLKCTRL_RSRVD2	0x00000008
#define BP_AUDIOIN_ANACLKCTRL_ADCDIV	0
#define BM_AUDIOIN_ANACLKCTRL_ADCDIV	0x00000007
#define BF_AUDIOIN_ANACLKCTRL_ADCDIV(v)  \
		(((v) << 0) & BM_AUDIOIN_ANACLKCTRL_ADCDIV)

#define HW_AUDIOIN_DATA	(0x00000080)
#define HW_AUDIOIN_DATA_SET	(0x00000084)
#define HW_AUDIOIN_DATA_CLR	(0x00000088)
#define HW_AUDIOIN_DATA_TOG	(0x0000008c)

#define BP_AUDIOIN_DATA_HIGH	16
#define BM_AUDIOIN_DATA_HIGH	0xFFFF0000
#define BF_AUDIOIN_DATA_HIGH(v) \
		(((v) << 16) & BM_AUDIOIN_DATA_HIGH)
#define BP_AUDIOIN_DATA_LOW	0
#define BM_AUDIOIN_DATA_LOW	0x0000FFFF
#define BF_AUDIOIN_DATA_LOW(v)  \
		(((v) << 0) & BM_AUDIOIN_DATA_LOW)
#endif /* __ARCH_ARM___AUDIOIN_H */
