/*
 * Copyright (C) 2010 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef __MACH_IOMUX_MX53_H__
#define __MACH_IOMUX_MX53_H__

#include <mach/iomux-v3.h>

/*
 * various IOMUX alternate output functions (1-7)
 */
typedef enum iomux_config {
	IOMUX_CONFIG_ALT0,
	IOMUX_CONFIG_ALT1,
	IOMUX_CONFIG_ALT2,
	IOMUX_CONFIG_ALT3,
	IOMUX_CONFIG_ALT4,
	IOMUX_CONFIG_ALT5,
	IOMUX_CONFIG_ALT6,
	IOMUX_CONFIG_ALT7,
	IOMUX_CONFIG_GPIO,	/* added to help user use GPIO mode */
	IOMUX_CONFIG_SION = 0x1 << 4,	/* LOOPBACK:MUX SION bit */
} iomux_pin_cfg_t;

#define IOMUX_TO_IRQ_V3(pin)	(MXC_GPIO_IRQ_START + pin)

#define NON_MUX_I	0x3FF
#define NON_PAD_I	0x7FF

#define MX53_UART_PAD_CTRL	(PAD_CTL_PKE | PAD_CTL_PUE | PAD_CTL_DSE_HIGH | \
				PAD_CTL_SRE_FAST | PAD_CTL_HYS)
#define MX53_SDHC_PAD_CTRL 	(PAD_CTL_DVS | PAD_CTL_PKE | PAD_CTL_PUE | \
				PAD_CTL_PUS_47K_UP | PAD_CTL_DSE_HIGH | \
				PAD_CTL_SRE_FAST)
#define MX53_FEC_PAD_CTRL	(PAD_CTL_HYS | PAD_CTL_PKE | PAD_CTL_PUE | \
			PAD_CTL_PUS_22K_UP | PAD_CTL_ODE | PAD_CTL_DSE_HIGH)
#define MX53_ESAI_PAD_CTRL	(PAD_CTL_DSE_HIGH | PAD_CTL_HYS | PAD_CTL_PKE |\
				PAD_CTL_PUE | PAD_CTL_PUS_100K_UP)
#define MX53_WEIM_PAD_CTRL	(PAD_CTL_PKE | PAD_CTL_PUS_100K_UP | \
				PAD_CTL_DSE_HIGH)
#define PAD_CTRL_1	(PAD_CTL_HYS | PAD_CTL_DSE_HIGH)
#define PAD_CTRL_2	(PAD_CTL_PKE | PAD_CTL_PUE | PAD_CTL_DSE_HIGH)
#define PAD_CTRL_3	(PAD_CTL_PKE | PAD_CTL_PUE | PAD_CTL_DSE_HIGH | \
					PAD_CTL_HYS)
#define PAD_CTRL_4	(PAD_CTL_PKE | PAD_CTL_PUE | PAD_CTL_DSE_HIGH | \
					PAD_CTL_HYS | PAD_CTL_PUS_100K_UP)
#define PAD_CTRL_5	(PAD_CTL_DSE_HIGH | PAD_CTL_SRE_FAST)

#define PAD_CTRL_6	(PAD_CTL_DSE_LOW | PAD_CTL_SRE_SLOW)
#define PAD_CTRL_7	(PAD_CTL_DSE_HIGH | PAD_CTL_SRE_SLOW)
#define PAD_CTRL_8	(PAD_CTL_HYS | PAD_CTL_PKE)

#define PAD_CTRL_9	(PAD_CTL_SRE_FAST | PAD_CTL_ODE | \
				PAD_CTL_DSE_HIGH | PAD_CTL_PUS_100K_UP | \
				PAD_CTL_HYS)

#define PAD_CTRL_10	(PAD_CTL_PKE | PAD_CTL_PUS_100K_UP | PAD_CTL_DSE_HIGH)

#define PAD_CTRL_11	(PAD_CTL_PKE | PAD_CTL_PUE | PAD_CTL_PUS_100K_UP)

#define PAD_CTRL_12	(PAD_CTL_DSE_HIGH | PAD_CTL_PKE | PAD_CTL_SRE_FAST)


#define MX53_PAD_GPIO_19__GPIO_4_5		IOMUX_PAD(0x348, 0x20, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_KEY_COL0__GPIO_4_6		IOMUX_PAD(0x34C, 0x24, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_KEY_ROW0__GPIO_4_7		IOMUX_PAD(0x350, 0x28, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_KEY_COL1__GPIO_4_8		IOMUX_PAD(0x354, 0x2C, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_KEY_ROW1__GPIO_4_9		IOMUX_PAD(0x358, 0x30, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_KEY_COL2__GPIO_4_10		IOMUX_PAD(0x35C, 0x34, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_KEY_ROW2__GPIO_4_11	IOMUX_PAD(0x360, 0x38, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_KEY_COL3__GPIO_4_12		IOMUX_PAD(0x364, 0x3C, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_KEY_ROW3__GPIO_4_13	IOMUX_PAD(0x368, 0x40, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_KEY_COL4__GPIO_4_14		IOMUX_PAD(0x36C, 0x44, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_KEY_ROW4__GPIO_4_15	IOMUX_PAD(0x370, 0x48, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_NVCC_KEYPAD__NVCC_KEYPAD	IOMUX_PAD(0x374, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DI0_DISP_CLK__GPIO_4_16	IOMUX_PAD(0x378, 0x4C, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DI0_PIN15__GPIO_4_17	IOMUX_PAD(0x37C, 0x50, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DI0_PIN2__GPIO_4_18		IOMUX_PAD(0x380, 0x54, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DI0_PIN3__GPIO_4_19		IOMUX_PAD(0x384, 0x58, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DI0_PIN4__GPIO_4_20		IOMUX_PAD(0x388, 0x5C, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DISP0_DAT0__GPIO_4_21	IOMUX_PAD(0x38C, 0x60, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DISP0_DAT1__GPIO_4_22	IOMUX_PAD(0x390, 0x64, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DISP0_DAT2__GPIO_4_23	IOMUX_PAD(0x394, 0x68, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DISP0_DAT3__GPIO_4_24	IOMUX_PAD(0x398, 0x6C, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DISP0_DAT4__GPIO_4_25	IOMUX_PAD(0x39C, 0x70, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DISP0_DAT5__GPIO_4_26	IOMUX_PAD(0x3A0, 0x74, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DISP0_DAT6__GPIO_4_27	IOMUX_PAD(0x3A4, 0x78, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DISP0_DAT7__GPIO_4_28	IOMUX_PAD(0x3A8, 0x7C, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DISP0_DAT8__GPIO_4_29	IOMUX_PAD(0x3AC, 0x80, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DISP0_DAT9__GPIO_4_30	IOMUX_PAD(0x3B0, 0x84, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DISP0_DAT10__GPIO_4_31	IOMUX_PAD(0x3B4, 0x88, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DISP0_DAT11__GPIO_5_5	IOMUX_PAD(0x3B8, 0x8C, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DISP0_DAT12__GPIO_5_6	IOMUX_PAD(0x3BC, 0x90, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DISP0_DAT13__GPIO_5_7	IOMUX_PAD(0x3C0, 0x94, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DISP0_DAT14__GPIO_5_8	IOMUX_PAD(0x3C4, 0x98, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DISP0_DAT15__GPIO_5_9	IOMUX_PAD(0x3C8, 0x9C, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DISP0_DAT16__GPIO_5_10	IOMUX_PAD(0x3CC, 0xA0, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DISP0_DAT17__GPIO_5_11	IOMUX_PAD(0x3D0, 0xA4, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DISP0_DAT18__GPIO_5_12	IOMUX_PAD(0x3D4, 0xA8, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DISP0_DAT19__GPIO_5_13	IOMUX_PAD(0x3D8, 0xAC, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DISP0_DAT20__GPIO_5_14	IOMUX_PAD(0x3DC, 0xB0, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DISP0_DAT21__GPIO_5_15	IOMUX_PAD(0x3E0, 0xB4, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DISP0_DAT22__GPIO_5_16	IOMUX_PAD(0x3E4, 0xB8, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DISP0_DAT23__GPIO_5_17	IOMUX_PAD(0x3E8, 0xBC, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_CSI0_PIXCLK__GPIO_5_18	IOMUX_PAD(0x3EC, 0xC0, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_CSI0_MCLK__GPIO_5_19	IOMUX_PAD(0x3F0, 0xC4, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_CSI0_DATA_EN__GPIO_5_20		IOMUX_PAD(0x3F4, 0xC8, 1, 0x0, 0, PAD_CTRL_12)
#define MX53_PAD_CSI0_VSYNC__GPIO_5_21	IOMUX_PAD(0x3F8, 0xCC, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_CSI0_D4__GPIO_5_22		IOMUX_PAD(0x3FC, 0xD0, 1, 0x0, 0, PAD_CTRL_4)
#define MX53_PAD_CSI0_D5__GPIO_5_23		IOMUX_PAD(0x400, 0xD4, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_CSI0_D6__GPIO_5_24		IOMUX_PAD(0x404, 0xD8, 1, 0x0, 0, PAD_CTRL_4)
#define MX53_PAD_CSI0_D7__GPIO_5_25		IOMUX_PAD(0x408, 0xDC, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_CSI0_D8__GPIO_5_26		IOMUX_PAD(0x40C, 0xE0, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_CSI0_D9__GPIO_5_27		IOMUX_PAD(0x410, 0xE4, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_CSI0_D10__GPIO_5_28		IOMUX_PAD(0x414, 0xE8, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_CSI0_D11__GPIO_5_29		IOMUX_PAD(0x418, 0xEC, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_CSI0_D12__GPIO_5_30		IOMUX_PAD(0x41C, 0xF0, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_CSI0_D13__GPIO_5_31		IOMUX_PAD(0x420, 0xF4, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_CSI0_D14__GPIO_6_0		IOMUX_PAD(0x424, 0xF8, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_CSI0_D15__GPIO_6_1		IOMUX_PAD(0x428, 0xFC, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_CSI0_D16__GPIO_6_2		IOMUX_PAD(0x42C, 0x100, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_CSI0_D17__GPIO_6_3		IOMUX_PAD(0x430, 0x104, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_CSI0_D18__GPIO_6_4		IOMUX_PAD(0x434, 0x108, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_CSI0_D19__GPIO_6_5		IOMUX_PAD(0x438, 0x10C, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_NVCC_CSI0__NVCC_CSI0	IOMUX_PAD(0x43C, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_JTAG_TMS__JTAG_TMS		IOMUX_PAD(0x440, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_JTAG_MOD__JTAG_MOD		IOMUX_PAD(0x444, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_JTAG_TRSTB__JTAG_TRSTB	IOMUX_PAD(0x448, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_JTAG_TDI__JTAG_TDI		IOMUX_PAD(0x44C, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_JTAG_TCK__JTAG_TCK		IOMUX_PAD(0x450, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_JTAG_TDO__JTAG_TDO		IOMUX_PAD(0x454, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_A25__GPIO_5_2		IOMUX_PAD(0x458, 0x110, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_EB2__GPIO_2_30		IOMUX_PAD(0x45C, 0x114, 1, 0x0, 0, PAD_CTRL_4)
#define MX53_PAD_EIM_D16__GPIO_3_16		IOMUX_PAD(0x460, 0x118, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_D17__GPIO_3_17		IOMUX_PAD(0x464, 0x11C, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_D18__GPIO_3_18		IOMUX_PAD(0x468, 0x120, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_D19__GPIO_3_19		IOMUX_PAD(0x46C, 0x124, 1, 0x0, 0, PAD_CTRL_4)
#define MX53_PAD_EIM_D20__GPIO_3_20		IOMUX_PAD(0x470, 0x128, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_D21__GPIO_3_21		IOMUX_PAD(0x474, 0x12C, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_D22__GPIO_3_22		IOMUX_PAD(0x478, 0x130, 1, 0x0, 0, PAD_CTRL_12)
#define MX53_PAD_EIM_D23__GPIO_3_23		IOMUX_PAD(0x47C, 0x134, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_EB3__GPIO_2_31		IOMUX_PAD(0x480, 0x138, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_D24__GPIO_3_24		IOMUX_PAD(0x484, 0x13C, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_D25__GPIO_3_25		IOMUX_PAD(0x488, 0x140, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_D26__GPIO_3_26		IOMUX_PAD(0x48C, 0x144, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_D27__GPIO_3_27		IOMUX_PAD(0x490, 0x148, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_D28__GPIO_3_28		IOMUX_PAD(0x494, 0x14C, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_D29__GPIO_3_29		IOMUX_PAD(0x498, 0x150, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_D30__GPIO_3_30		IOMUX_PAD(0x49C, 0x154, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_D31__GPIO_3_31		IOMUX_PAD(0x4A0, 0x158, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_NVCC_EIM1__NVCC_EIM1	IOMUX_PAD(0x4A4, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_A24__GPIO_5_4		IOMUX_PAD(0x4A8, 0x15C, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_A23__GPIO_6_6		IOMUX_PAD(0x4AC, 0x160, 1, 0x0, 0, PAD_CTRL_12)
#define MX53_PAD_EIM_A22__GPIO_2_16		IOMUX_PAD(0x4B0, 0x164, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_A21__GPIO_2_17		IOMUX_PAD(0x4B4, 0x168, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_A20__GPIO_2_18		IOMUX_PAD(0x4B8, 0x16C, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_A19__GPIO_2_19		IOMUX_PAD(0x4BC, 0x170, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_A18__GPIO_2_20		IOMUX_PAD(0x4C0, 0x174, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_A17__GPIO_2_21		IOMUX_PAD(0x4C4, 0x178, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_A16__GPIO_2_22		IOMUX_PAD(0x4C8, 0x17C, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_CS0__GPIO_2_23		IOMUX_PAD(0x4CC, 0x180, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_CS1__GPIO_2_24		IOMUX_PAD(0x4D0, 0x184, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_OE__GPIO_2_25		IOMUX_PAD(0x4D4, 0x188, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_RW__GPIO_2_26		IOMUX_PAD(0x4D8, 0x18C, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_LBA__GPIO_2_27		IOMUX_PAD(0x4DC, 0x190, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_NVCC_EIM4__NVCC_EIM4	IOMUX_PAD(0x4E0, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_EB0__GPIO_2_28		IOMUX_PAD(0x4E4, 0x194, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_EB1__GPIO_2_29		IOMUX_PAD(0x4E8, 0x198, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_DA0__GPIO_3_0		IOMUX_PAD(0x4EC, 0x19C, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_DA1__GPIO_3_1		IOMUX_PAD(0x4F0, 0x1A0, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_DA2__GPIO_3_2		IOMUX_PAD(0x4F4, 0x1A4, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_DA3__GPIO_3_3		IOMUX_PAD(0x4F8, 0x1A8, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_DA4__GPIO_3_4		IOMUX_PAD(0x4FC, 0x1AC, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_DA5__GPIO_3_5		IOMUX_PAD(0x500, 0x1B0, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_DA6__GPIO_3_6		IOMUX_PAD(0x504, 0x1B4, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_DA7__GPIO_3_7		IOMUX_PAD(0x508, 0x1B8, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_DA8__GPIO_3_8		IOMUX_PAD(0x50C, 0x1BC, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_DA9__GPIO_3_9		IOMUX_PAD(0x510, 0x1C0, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_DA10__GPIO_3_10		IOMUX_PAD(0x514, 0x1C4, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_DA11__GPIO_3_11		IOMUX_PAD(0x518, 0x1C8, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_DA12__GPIO_3_12		IOMUX_PAD(0x51C, 0x1CC, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_DA13__GPIO_3_13		IOMUX_PAD(0x520, 0x1D0, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_DA14__GPIO_3_14		IOMUX_PAD(0x524, 0x1D4, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_DA15__GPIO_3_15		IOMUX_PAD(0x528, 0x1D8, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_NANDF_WE_B__GPIO_6_12	IOMUX_PAD(0x52C, 0x1DC, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_NANDF_RE_B__GPIO_6_13	IOMUX_PAD(0x530, 0x1E0, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_WAIT__GPIO_5_0		IOMUX_PAD(0x534, 0x1E4, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_BCLK__EIM_BCLK		IOMUX_PAD(0x538, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_NVCC_EIM7__NVCC_EIM7	IOMUX_PAD(0x53C, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_LVDS1_TX3_P__GPIO_6_22	IOMUX_PAD(NON_PAD_I, 0x1EC, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_LVDS1_TX2_P__GPIO_6_24	IOMUX_PAD(NON_PAD_I, 0x1F0, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_LVDS1_CLK_P__GPIO_6_26	IOMUX_PAD(NON_PAD_I, 0x1F4, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_LVDS1_TX1_P__GPIO_6_28	IOMUX_PAD(NON_PAD_I, 0x1F8, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_LVDS1_TX0_P__GPIO_6_30	IOMUX_PAD(NON_PAD_I, 0x1FC, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_LVDS0_TX3_P__GPIO_7_22	IOMUX_PAD(NON_PAD_I, 0x200, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_LVDS0_CLK_P__GPIO_7_24	IOMUX_PAD(NON_PAD_I, 0x204, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_LVDS0_TX2_P__GPIO_7_26	IOMUX_PAD(NON_PAD_I, 0x208, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_LVDS0_TX1_P__GPIO_7_28	IOMUX_PAD(NON_PAD_I, 0x20C, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_LVDS0_TX0_P__GPIO_7_30	IOMUX_PAD(NON_PAD_I, 0x210, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_GPIO_10__GPIO_4_0	IOMUX_PAD(0x540, 0x214, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_GPIO_11__GPIO_4_1	IOMUX_PAD(0x544, 0x218, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_GPIO_12__GPIO_4_2	IOMUX_PAD(0x548, 0x21C, 0, 0x0, 0, \
					PAD_CTRL_9 | PAD_CTRL_2)
#define MX53_PAD_GPIO_13__GPIO_4_3	IOMUX_PAD(0x54C, 0x220, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_GPIO_14__GPIO_4_4	IOMUX_PAD(0x550, 0x224, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DRAM_DQM3__DRAM_DQM3	IOMUX_PAD(0x554, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DRAM_SDQS3__DRAM_SDQS3	IOMUX_PAD(0x558, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DRAM_SDCKE1__DRAM_SDCKE1	IOMUX_PAD(0x55C, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DRAM_DQM2__DRAM_DQM2	IOMUX_PAD(0x560, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DRAM_SDODT1__DRAM_SDODT1	IOMUX_PAD(0x564, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DRAM_SDQS2__DRAM_SDQS2	IOMUX_PAD(0x568, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DRAM_RESET__DRAM_RESET	IOMUX_PAD(0x56C, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DRAM_SDCLK1__DRAM_SDCLK1	IOMUX_PAD(0x570, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DRAM_CAS__DRAM_CAS	IOMUX_PAD(0x574, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DRAM_SDCLK0__DRAM_SDCLK0	IOMUX_PAD(0x578, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DRAM_SDQS0__DRAM_SDQS0	IOMUX_PAD(0x57C, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DRAM_SDODT0__DRAM_SDODT0	IOMUX_PAD(0x580, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DRAM_DQM0__DRAM_DQM0	IOMUX_PAD(0x584, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DRAM_RAS__DRAM_RAS	IOMUX_PAD(0x588, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DRAM_SDCKE0__DRAM_SDCKE0	IOMUX_PAD(0x58C, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DRAM_SDQS1__DRAM_SDQS1	IOMUX_PAD(0x590, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_DRAM_DQM1__DRAM_DQM1	IOMUX_PAD(0x594, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_PMIC_ON_REQ__PMIC_ON_REQ	IOMUX_PAD(0x598, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_PMIC_STBY_REQ__PMIC_STBY_REQ	IOMUX_PAD(0x59C, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_NANDF_CLE__GPIO_6_7	IOMUX_PAD(0x5A0, 0x228, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_NANDF_ALE__GPIO_6_8	IOMUX_PAD(0x5A4, 0x22C, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_NANDF_WP_B__GPIO_6_9	IOMUX_PAD(0x5A8, 0x230, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_NANDF_RB0__GPIO_6_10	IOMUX_PAD(0x5AC, 0x234, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_NANDF_CS0__GPIO_6_11	IOMUX_PAD(0x5B0, 0x238, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_NANDF_CS1__GPIO_6_14	IOMUX_PAD(0x5B4, 0x23C, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_NANDF_CS2__GPIO_6_15	IOMUX_PAD(0x5B8, 0x240, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_NANDF_CS3__GPIO_6_16	IOMUX_PAD(0x5BC, 0x244, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_NVCC_NANDF__NVCC_NANDF	IOMUX_PAD(0x5C0, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_FEC_MDIO__GPIO_1_22	IOMUX_PAD(0x5C4, 0x248, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_FEC_REF_CLK__GPIO_1_23	IOMUX_PAD(0x5C8, 0x24C, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_FEC_RX_ER__GPIO_1_24	IOMUX_PAD(0x5CC, 0x250, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_FEC_CRS_DV__GPIO_1_25	IOMUX_PAD(0x5D0, 0x254, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_FEC_RXD1__GPIO_1_26	IOMUX_PAD(0x5D4, 0x258, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_FEC_RXD0__GPIO_1_27	IOMUX_PAD(0x5D8, 0x25C, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_FEC_TX_EN__GPIO_1_28	IOMUX_PAD(0x5DC, 0x260, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_FEC_TXD1__GPIO_1_29	IOMUX_PAD(0x5E0, 0x264, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_FEC_TXD0__GPIO_1_30	IOMUX_PAD(0x5E4, 0x268, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_FEC_MDC__GPIO_1_31	IOMUX_PAD(0x5E8, 0x26C, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_NVCC_FEC__NVCC_FEC	IOMUX_PAD(0x5EC, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_ATA_DIOW__GPIO_6_17	IOMUX_PAD(0x5F0, 0x270, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_ATA_DMACK__GPIO_6_18	IOMUX_PAD(0x5F4, 0x274, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_ATA_DMARQ__GPIO_7_0	IOMUX_PAD(0x5F8, 0x278, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_ATA_BUFFER_EN__GPIO_7_1	IOMUX_PAD(0x5FC, 0x27C, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_ATA_INTRQ__GPIO_7_2	IOMUX_PAD(0x600, 0x280, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_ATA_DIOR__GPIO_7_3	IOMUX_PAD(0x604, 0x284, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_ATA_RESET_B__GPIO_7_4	IOMUX_PAD(0x608, 0x288, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_ATA_IORDY__GPIO_7_5	IOMUX_PAD(0x60C, 0x28C, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_ATA_DA_0__GPIO_7_6	IOMUX_PAD(0x610, 0x290, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_ATA_DA_1__GPIO_7_7	IOMUX_PAD(0x614, 0x294, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_ATA_DA_2__GPIO_7_8	IOMUX_PAD(0x618, 0x298, 1, 0x0, 0, PAD_CTRL_12)
#define MX53_PAD_ATA_CS_0__GPIO_7_9	IOMUX_PAD(0x61C, 0x29C, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_ATA_CS_1__GPIO_7_10	IOMUX_PAD(0x620, 0x2A0, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_NVCC_ATA2__NVCC_ATA2	IOMUX_PAD(0x624, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_ATA_DATA0__GPIO_2_0	IOMUX_PAD(0x628, 0x2A4, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_ATA_DATA1__GPIO_2_1	IOMUX_PAD(0x62C, 0x2A8, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_ATA_DATA2__GPIO_2_2	IOMUX_PAD(0x630, 0x2AC, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_ATA_DATA3__GPIO_2_3	IOMUX_PAD(0x634, 0x2B0, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_ATA_DATA4__GPIO_2_4	IOMUX_PAD(0x638, 0x2B4, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_ATA_DATA5__GPIO_2_5	IOMUX_PAD(0x63C, 0x2B8, 1, 0x0, 0, PAD_CTL_PUS_100K_UP)
#define MX53_PAD_ATA_DATA6__GPIO_2_6	IOMUX_PAD(0x640, 0x2BC, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_ATA_DATA7__GPIO_2_7	IOMUX_PAD(0x644, 0x2C0, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_ATA_DATA8__GPIO_2_8	IOMUX_PAD(0x648, 0x2C4, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_ATA_DATA9__GPIO_2_9	IOMUX_PAD(0x64C, 0x2C8, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_ATA_DATA10__GPIO_2_10	IOMUX_PAD(0x650, 0x2CC, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_ATA_DATA11__GPIO_2_11	IOMUX_PAD(0x654, 0x2D0, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_ATA_DATA12__GPIO_2_12	IOMUX_PAD(0x658, 0x2D4, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_ATA_DATA13__GPIO_2_13	IOMUX_PAD(0x65C, 0x2D8, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_ATA_DATA14__GPIO_2_14	IOMUX_PAD(0x660, 0x2DC, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_ATA_DATA15__GPIO_2_15	IOMUX_PAD(0x664, 0x2E0, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_NVCC_ATA0__NVCC_ATA0	IOMUX_PAD(0x668, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_SD1_DATA0__GPIO_1_16	IOMUX_PAD(0x66C, 0x2E4, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_SD1_DATA1__GPIO_1_17	IOMUX_PAD(0x670, 0x2E8, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_SD1_CMD__GPIO_1_18	IOMUX_PAD(0x674, 0x2EC, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_SD1_DATA2__GPIO_1_19	IOMUX_PAD(0x678, 0x2F0, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_SD1_CLK__GPIO_1_20	IOMUX_PAD(0x67C, 0x2F4, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_SD1_DATA3__GPIO_1_21	IOMUX_PAD(0x680, 0x2F8, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_NVCC_SD1__NVCC_SD1	IOMUX_PAD(0x684, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_SD2_CLK__GPIO_1_10	IOMUX_PAD(0x688, 0x2FC, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_SD2_CMD__GPIO_1_11	IOMUX_PAD(0x68C, 0x300, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_SD2_DATA3__GPIO_1_12	IOMUX_PAD(0x690, 0x304, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_SD2_DATA2__GPIO_1_13	IOMUX_PAD(0x694, 0x308, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_SD2_DATA1__GPIO_1_14	IOMUX_PAD(0x698, 0x30C, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_SD2_DATA0__GPIO_1_15	IOMUX_PAD(0x69C, 0x310, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_NVCC_SD2__NVCC_SD2	IOMUX_PAD(0x6A0, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_GPIO_0__GPIO_1_0	IOMUX_PAD(0x6A4, 0x314, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_GPIO_1__GPIO_1_1	IOMUX_PAD(0x6A8, 0x318, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_GPIO_9__GPIO_1_9	IOMUX_PAD(0x6AC, 0x31C, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_GPIO_3__GPIO_1_3	IOMUX_PAD(0x6B0, 0x320, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_GPIO_6__GPIO_1_6	IOMUX_PAD(0x6B4, 0x324, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_GPIO_2__GPIO_1_2	IOMUX_PAD(0x6B8, 0x328, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_GPIO_4__GPIO_1_4	IOMUX_PAD(0x6BC, 0x32C, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_GPIO_5__GPIO_1_5	IOMUX_PAD(0x6C0, 0x330, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_GPIO_7__GPIO_1_7	IOMUX_PAD(0x6C4, 0x334, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_GPIO_8__GPIO_1_8	IOMUX_PAD(0x6C8, 0x338, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_GPIO_16__GPIO_7_11	IOMUX_PAD(0x6CC, 0x33C, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_GPIO_17__GPIO_7_12	IOMUX_PAD(0x6D0, 0x340, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_GPIO_18__GPIO_7_13	IOMUX_PAD(0x6D4, 0x344, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_NVCC_GPIO__NVCC_GPIO	IOMUX_PAD(0x6D8, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_POR_B__POR_B	IOMUX_PAD(0x6DC, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_BOOT_MODE1__BOOT_MODE1	IOMUX_PAD(0x6E0, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_RESET_IN_B__RESET_IN_B	IOMUX_PAD(0x6E4, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_BOOT_MODE0__BOOT_MODE0	IOMUX_PAD(0x6E8, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_TEST_MODE__TEST_MODE	IOMUX_PAD(0x6EC, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_GRP_ADDDS__GRP_ADDDS	IOMUX_PAD(0x6F0, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_GRP_DDRMODE_CTL__GRP_DDRMODE_CTL	IOMUX_PAD(0x6F4, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_GRP_DDRPKE__GRP_DDRPKE	IOMUX_PAD(0x6FC, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_GRP_DDRPK__GRP_DDRPK	IOMUX_PAD(0x708, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_GRP_TERM_CTL3__GRP_TERM_CTL3	IOMUX_PAD(0x70C, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_GRP_DDRHYS__GRP_DDRHYS	IOMUX_PAD(0x710, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_GRP_DDRMODE__GRP_DDRMODE	IOMUX_PAD(0x714, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_GRP_B0DS__GRP_B0DS	IOMUX_PAD(0x718, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_GRP_B1DS__GRP_B1DS	IOMUX_PAD(0x71C, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_GRP_CTLDS__GRP_CTLDS	IOMUX_PAD(0x720, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_GRP_DDR_TYPE__GRP_DDR_TYPE	IOMUX_PAD(0x724, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_GRP_B2DS__GRP_B2DS	IOMUX_PAD(0x728, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_GRP_B3DS__GRP_B3DS	IOMUX_PAD(0x72C, NON_MUX_I, 0, 0x0, 0, NO_PAD_CTRL)

/* NAND */
#define MX53_PAD_NANDF_CLE__NANDF_CLE	IOMUX_PAD(0x5A0, 0x228, 0, 0x0, 0, PAD_CTL_DSE_HIGH)
#define MX53_PAD_NANDF_ALE__NANDF_ALE		IOMUX_PAD(0x5A4, 0x22C, 0, 0x0, 0, PAD_CTL_DSE_HIGH)
#define MX53_PAD_NANDF_WP_B__NANDF_WP_B	IOMUX_PAD(0x5A8, 0x230, 0, 0x0, 0, PAD_CTRL_11)
#define MX53_PAD_NANDF_WE_B__NANDF_WE_B	IOMUX_PAD(0x52C, 0x1DC, 0, 0x0, 0, PAD_CTL_DSE_HIGH)
#define MX53_PAD_NANDF_RE_B__NANDF_RE_B		IOMUX_PAD(0x530, 0x1E0, 0, 0x0, 0, PAD_CTL_DSE_HIGH)
#define MX53_PAD_NANDF_RB0__NANDF_RB0	IOMUX_PAD(0x5AC, 0x234, 0, 0x0, 0, PAD_CTRL_11)
#define MX53_PAD_NANDF_CS0__NANDF_CS0	IOMUX_PAD(0x5B0, 0x238, 0, 0x0, 0, PAD_CTL_DSE_HIGH)
#define MX53_PAD_NANDF_CS1__NANDF_CS1	IOMUX_PAD(0x5B4, 0x23C, 0, 0x0, 0, PAD_CTL_DSE_HIGH)
#define MX53_PAD_NANDF_CS2__NANDF_CS2	IOMUX_PAD(0x5B8, 0x240, 0, 0x0, 0, PAD_CTL_DSE_HIGH)
#define MX53_PAD_NANDF_CS3__NANDF_CS3	IOMUX_PAD(0x5BC, 0x244, 0, 0x0, 0, PAD_CTL_DSE_HIGH)
#define MX53_PAD_EIM_DA0__EIM_DA0	IOMUX_PAD(0x4EC, 0x19C, 0, 0x0, 0, PAD_CTRL_10)
#define MX53_PAD_EIM_DA1__EIM_DA1	IOMUX_PAD(0x4F0, 0x1A0, 0, 0x0, 0, PAD_CTRL_10)
#define MX53_PAD_EIM_DA2__EIM_DA2	IOMUX_PAD(0x4F4, 0x1A4, 0, 0x0, 0, PAD_CTRL_10)
#define MX53_PAD_EIM_DA3__EIM_DA3	IOMUX_PAD(0x4F8, 0x1A8, 0, 0x0, 0, PAD_CTRL_10)
#define MX53_PAD_EIM_DA4__EIM_DA4	IOMUX_PAD(0x4FC, 0x1AC, 0, 0x0, 0, PAD_CTRL_10)
#define MX53_PAD_EIM_DA5__EIM_DA5	IOMUX_PAD(0x500, 0x1B0, 0, 0x0, 0, PAD_CTRL_10)
#define MX53_PAD_EIM_DA6__EIM_DA6	IOMUX_PAD(0x504, 0x1B4, 0, 0x0, 0, PAD_CTRL_10)
#define MX53_PAD_EIM_DA7__EIM_DA7	IOMUX_PAD(0x508, 0x1B8, 0, 0x0, 0, PAD_CTRL_10)

/* SPI */
#define MX53_PAD_EIM_EB2__CSPI_SS0		IOMUX_PAD(0x45C, 0x114, 4, 0x7A8, 3, PAD_CTRL_1)
#define MX53_PAD_EIM_D19__CSPI_SS1		IOMUX_PAD(0x46C, 0x124, 4, 0x7AC, 3, PAD_CTRL_1)

/* PWM */
#define MX53_PAD_GPIO_1__PWMO	IOMUX_PAD(0x6A8, 0x318, 4, 0x0, 0, NO_PAD_CTRL)

/* Camera */
#define MX53_PAD_CSI0_VSYNC__CSI0_VSYNC	IOMUX_PAD(0x3F8, 0xCC, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_CSI0_PIXCLK__CSI0_PIXCLK	IOMUX_PAD(0x3EC, 0xC0, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_CSI0_MCLK__CSI0_HSYNC	IOMUX_PAD(0x3F0, 0xC4, 0, 0x0, 0, NO_PAD_CTRL)

/* IPU */
#define MX53_PAD_CSI0_D12__CSI0_D12		IOMUX_PAD(0x41C, 0xF0, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_CSI0_D13__CSI0_D13		IOMUX_PAD(0x420, 0xF4, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_CSI0_D14__CSI0_D14		IOMUX_PAD(0x424, 0xF8, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_CSI0_D15__CSI0_D15		IOMUX_PAD(0x428, 0xFC, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_CSI0_D16__CSI0_D16		IOMUX_PAD(0x42C, 0x100, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_CSI0_D17__CSI0_D17		IOMUX_PAD(0x430, 0x104, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_CSI0_D18__CSI0_D18		IOMUX_PAD(0x434, 0x108, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_CSI0_D19__CSI0_D19		IOMUX_PAD(0x438, 0x10C, 0, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_D20__SER_DISP0_CS	IOMUX_PAD(0x470, 0x128, 3, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_D29__DISPB0_SER_RS	IOMUX_PAD(0x498, 0x150, 3, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_D30__DI0_PIN11		IOMUX_PAD(0x49C, 0x154, 4, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_D31__DI0_PIN12		IOMUX_PAD(0x4A0, 0x158, 4, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_D23__DI0_D0_CS		IOMUX_PAD(0x47C, 0x134, 4, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_A25__DI0_D1_CS		IOMUX_PAD(0x458, 0x110, 6, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_OE__DI1_PIN7			IOMUX_PAD(0x4D4, 0x188, 3, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_RW__DI1_PIN8			IOMUX_PAD(0x4D8, 0x18C, 3, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_DA10__DI1_PIN15		IOMUX_PAD(0x514, 0x1C4, 3, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_D21__DISPB0_SER_CLK		IOMUX_PAD(0x474, 0x12C, 3, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_EIM_D22__DISPB0_SER_DIN		IOMUX_PAD(0x478, 0x130, 3, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_CSI0_D4__CSI0_D4		IOMUX_PAD(0x3FC, 0xD0, 0, 0x0, \
							0, NO_PAD_CTRL)
#define MX53_PAD_CSI0_D5__CSI0_D5		IOMUX_PAD(0x400, 0xD4, 0, 0x0, \
							0, NO_PAD_CTRL)
#define MX53_PAD_CSI0_D6__CSI0_D6		IOMUX_PAD(0x404, 0xD8, 0, 0x0, \
							0, NO_PAD_CTRL)
#define MX53_PAD_CSI0_D7__CSI0_D7		IOMUX_PAD(0x408, 0xDC, 0, 0x0, \
							0, NO_PAD_CTRL)
#define MX53_PAD_CSI0_D8__CSI0_D8		IOMUX_PAD(0x40C, 0xE0, 0, 0x0, \
							0, NO_PAD_CTRL)
#define MX53_PAD_CSI0_D9__CSI0_D9		IOMUX_PAD(0x410, 0xE4, 0, 0x0, \
							0, NO_PAD_CTRL)
#define MX53_PAD_CSI0_D10__CSI0_D10	IOMUX_PAD(0x414, 0xE8, 0, 0x0, \
						0, NO_PAD_CTRL)
#define MX53_PAD_CSI0_D11__CSI0_D11		IOMUX_PAD(0x418, 0xEC, 0, 0x0, \
							0, NO_PAD_CTRL)

/* Display */
#define MX53_PAD_DI0_DISP_CLK__DI0_DISP_CLK	IOMUX_PAD(0x378, 0x4C, 0, 0x0, 0, PAD_CTRL_5)
#define MX53_PAD_DI0_PIN15__DI0_PIN15		IOMUX_PAD(0x37C, 0x50, 0, 0x0, 0, PAD_CTRL_5)
#define MX53_PAD_DI0_PIN2__DI0_PIN2		IOMUX_PAD(0x380, 0x54, 0, 0x0, 0, PAD_CTRL_7)
#define MX53_PAD_DI0_PIN3__DI0_PIN3		IOMUX_PAD(0x384, 0x58, 0, 0x0, 0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT0__DISP0_DAT0	IOMUX_PAD(0x38C, 0x60, 0, 0x0, 0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT1__DISP0_DAT1	IOMUX_PAD(0x390, 0x64, 0, 0x0, 0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT2__DISP0_DAT2	IOMUX_PAD(0x394, 0x68, 0, 0x0, 0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT3__DISP0_DAT3	IOMUX_PAD(0x398, 0x6C, 0, 0x0, 0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT4__DISP0_DAT4	IOMUX_PAD(0x39C, 0x70, 0, 0x0, 0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT5__DISP0_DAT5	IOMUX_PAD(0x3A0, 0x74, 0, 0x0, 0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT6__DISP0_DAT6	IOMUX_PAD(0x3A4, 0x78, 0, 0x0, 0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT7__DISP0_DAT7	IOMUX_PAD(0x3A8, 0x7C, 0, 0x0, 0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT8__DISP0_DAT8	IOMUX_PAD(0x3AC, 0x80, 0, 0x0, 0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT9__DISP0_DAT9	IOMUX_PAD(0x3B0, 0x84, 0, 0x0, 0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT10__DISP0_DAT10	IOMUX_PAD(0x3B4, 0x88, 0, 0x0, 0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT11__DISP0_DAT11	IOMUX_PAD(0x3B8, 0x8C, 0, 0x0, 0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT12__DISP0_DAT12	IOMUX_PAD(0x3BC, 0x90, 0, 0x0, 0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT13__DISP0_DAT13	IOMUX_PAD(0x3C0, 0x94, 0, 0x0, 0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT14__DISP0_DAT14	IOMUX_PAD(0x3C4, 0x98, 0, 0x0, 0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT15__DISP0_DAT15	IOMUX_PAD(0x3C8, 0x9C, 0, 0x0, 0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT16__DISP0_DAT16	IOMUX_PAD(0x3CC, 0xA0, 0, 0x0, 0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT17__DISP0_DAT17	IOMUX_PAD(0x3D0, 0xA4, 0, 0x0, 0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT18__DISP0_DAT18	IOMUX_PAD(0x3D4, 0xA8, 0, 0x0, 0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT19__DISP0_DAT19	IOMUX_PAD(0x3D8, 0xAC, 0, 0x0, 0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT20__DISP0_DAT20	IOMUX_PAD(0x3DC, 0xB0, 0, 0x0, 0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT21__DISP0_DAT21	IOMUX_PAD(0x3E0, 0xB4, 0, 0x0, 0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT22__DISP0_DAT22	IOMUX_PAD(0x3E4, 0xB8, 0, 0x0, 0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT23__DISP0_DAT23	IOMUX_PAD(0x3E8, 0xBC, 0, 0x0, 0, PAD_CTRL_7)

#define MX53_PAD_DI0_PIN15__AUD6_TXC		IOMUX_PAD(0x37C, 0x50, 2, 0x0, \
							0, PAD_CTRL_6)
#define MX53_PAD_DI0_PIN3__AUD6_TXFS		IOMUX_PAD(0x384, 0x58, 2, 0x0, \
							0, PAD_CTRL_7)
#define MX53_PAD_DI0_PIN4__AUD6_RXD		IOMUX_PAD(0x388, 0x5C, 2, 0x0, \
							0, PAD_CTRL_7)
#define MX53_PAD_DI0_DISP_CLK__USBH2_DIR	IOMUX_PAD(0x378, 0x4C, 2, 0x0, \
							0, PAD_CTRL_5)
#define MX53_PAD_DISP0_DAT0__USBH2_DAT0	IOMUX_PAD(0x38C, 0x60, 3, 0x0, \
							0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT1__USBH2_DAT1	IOMUX_PAD(0x390, 0x64, 3, 0x0, \
							0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT2__USBH2_DAT2	IOMUX_PAD(0x394, 0x68, 3, 0x0, \
							0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT3__USBH2_DAT3	IOMUX_PAD(0x398, 0x6C, 3, 0x0, \
							0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT4__USBH2_DAT4	IOMUX_PAD(0x39C, 0x70, 3, 0x0, \
							0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT5__USBH2_DAT5	IOMUX_PAD(0x3A0, 0x74, 3, 0x0, \
							0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT6__USBH2_DAT6	IOMUX_PAD(0x3A4, 0x78, 3, 0x0, \
							0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT7__USBH2_DAT7	IOMUX_PAD(0x3A8, 0x7C, 3, 0x0, \
							0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT8__PWM1	IOMUX_PAD(0x3AC, 0x80, 2, 0x0, \
							0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT9__PWM2	IOMUX_PAD(0x3B0, 0x84, 2, 0x0, \
							0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT10__USBH2_STP	IOMUX_PAD(0x3B4, 0x88, 2, 0x0, \
							0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT11__USBH2_NXT	IOMUX_PAD(0x3B8, 0x8C, 2, 0x0, \
							0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT12__USBH2_CLK	IOMUX_PAD(0x3BC, 0x90, 2, 0x0, \
							0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT16__ECSPI2_MOSI	IOMUX_PAD(0x3CC, 0xA0, 2, \
							0x0, 0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT17__ECSPI2_MISO	IOMUX_PAD(0x3D0, 0xA4, 2, \
							0x0, 0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT18__ECSPI2_SS0	IOMUX_PAD(0x3D4, 0xA8, 2, \
							0x0, 0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT19__ECSPI2_SCLK	IOMUX_PAD(0x3D8, 0xAC, 2, \
							0x0, 0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT20__AUD4_TXC		IOMUX_PAD(0x3DC, 0xB0, 3, \
							0x0, 0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT21__AUD4_TXD		IOMUX_PAD(0x3E0, 0xB4, 3, \
							0x0, 0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT22__AUD4_TXFS		IOMUX_PAD(0x3E4, 0xB8, 3, \
							0x0, 0, PAD_CTRL_7)
#define MX53_PAD_DISP0_DAT23__AUD4_SSI_RXD	IOMUX_PAD(0x3E8, 0xBC, 3, \
							0x0, 0, PAD_CTRL_7)

/* CAN*/
#define MX53_PAD_KEY_COL2__TXCAN1			IOMUX_PAD(0x35C, 0x34, 2, 0x0, 0, PAD_CTRL_4)
#define MX53_PAD_KEY_ROW2__RXCAN1		IOMUX_PAD(0x360, 0x38, 2, 0x760, 0, PAD_CTRL_3)
#define MX53_PAD_KEY_COL4__TXCAN2			IOMUX_PAD(0x36C, 0x44, 2, 0x0, 0, PAD_CTRL_4)
#define MX53_PAD_KEY_ROW4__RXCAN2		IOMUX_PAD(0x370, 0x48, 2, 0x764, 0, PAD_CTRL_3)
#define MX53_PAD_ATA_RESET_B__TXCAN2		IOMUX_PAD(0x608, 0x288, 4, \
							0x0, 0, PAD_CTRL_4)
#define MX53_PAD_ATA_IORDY__RXCAN2		IOMUX_PAD(0x60C, 0x28C, 4, \
							0x764, 1, PAD_CTRL_3)

/* AUD5 */
#define MX53_PAD_KEY_COL0__AUD5_TXC		IOMUX_PAD(0x34C, 0x24, 2, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_KEY_ROW0__AUD5_TXD		IOMUX_PAD(0x350, 0x28, 2, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_KEY_COL1__AUD5_TXFS		IOMUX_PAD(0x354, 0x2C, 2, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_KEY_ROW1__AUD5_RXD		IOMUX_PAD(0x358, 0x30, 2, 0x0, 0, NO_PAD_CTRL)

/* I2C1 */
#define MX53_PAD_CSI0_D8__I2C1_SDA		IOMUX_PAD(0x40C, 0xE0, 5 | IOMUX_CONFIG_SION, 0x818, 0, PAD_CTRL_9)
#define MX53_PAD_CSI0_D9__I2C1_SCL		IOMUX_PAD(0x410, 0xE4, 5 | IOMUX_CONFIG_SION, 0x814, 0, PAD_CTRL_9)

/* I2C2 */
#define MX53_PAD_KEY_COL3__I2C2_SCL		IOMUX_PAD(0x364, 0x3C, 4 | IOMUX_CONFIG_SION, 0x81C, 0, PAD_CTRL_9)
#define MX53_PAD_KEY_ROW3__I2C2_SDA		IOMUX_PAD(0x368, 0x40, 4 | IOMUX_CONFIG_SION, 0x820, 0, PAD_CTRL_9)
#define MX53_PAD_EIM_EB2__I2C2_SCL		IOMUX_PAD(0x45C, 0x114, \
							5 | IOMUX_CONFIG_SION, \
							0x81C, 1, PAD_CTRL_9)

/* I2C3 */
#define MX53_PAD_GPIO_3__I2C3_SCL               IOMUX_PAD(0x6B0, 0x320, \
							2 | IOMUX_CONFIG_SION, \
							0x824, 1, PAD_CTRL_9)
#define MX53_PAD_GPIO_16__I2C3_SDA              IOMUX_PAD(0x6CC, 0x33C, \
							6 | IOMUX_CONFIG_SION, \
							0x828, 2, PAD_CTRL_9)

/* UART1 */
#define MX53_PAD_CSI0_D10__UART1_TXD		IOMUX_PAD(0x414, 0xE8, 2, 0x0, 0, MX53_UART_PAD_CTRL)
#define MX53_PAD_CSI0_D11__UART1_RXD		IOMUX_PAD(0x418, 0xEC, 2, 0x878, 1, MX53_UART_PAD_CTRL)
#define MX53_PAD_ATA_DIOW__UART1_TXD	IOMUX_PAD(0x5F0, 0x270, 3, 0x0, \
						0, MX53_UART_PAD_CTRL)
#define MX53_PAD_ATA_DMACK__UART1_RXD	IOMUX_PAD(0x5F4, 0x274, 3, 0x880, \
						3, MX53_UART_PAD_CTRL)

/* UART2 */
#define MX53_PAD_ATA_BUFFER_EN__UART2_RXD	IOMUX_PAD(0x5FC, 0x27C, 3, 0x880, 3, MX53_UART_PAD_CTRL)
#define MX53_PAD_ATA_DMARQ__UART2_TXD	IOMUX_PAD(0x5F8, 0x278, 3, 0x0, 0, MX53_UART_PAD_CTRL)
#define MX53_PAD_ATA_DIOR__UART2_RTS		IOMUX_PAD(0x604, 0x284, 3, 0x87C, 3, MX53_UART_PAD_CTRL)
#define MX53_PAD_ATA_INTRQ__UART2_CTS		IOMUX_PAD(0x600, 0x280, 3, \
						0x0, 0, MX53_UART_PAD_CTRL)

/* UART3 */
#define MX53_PAD_ATA_CS_0__UART3_TXD		IOMUX_PAD(0x61C, 0x29C, 4, 0x0, 0, MX53_UART_PAD_CTRL)
#define MX53_PAD_ATA_CS_1__UART3_RXD		IOMUX_PAD(0x620, 0x2A0, 4, 0x888, 3, MX53_UART_PAD_CTRL)
#define MX53_PAD_ATA_DA_1__UART3_CTS		IOMUX_PAD(0x614, 0x294, 4, \
						0x0, 0, MX53_UART_PAD_CTRL)
#define MX53_PAD_ATA_DA_2__UART3_RTS		IOMUX_PAD(0x618, 0x298, 4, \
						0x884, 5, MX53_UART_PAD_CTRL)
/* CSPI */
#define MX53_PAD_EIM_D16__CSPI1_SCLK		IOMUX_PAD(0x460, 0x118, 4, 0x79C, 3, PAD_CTRL_1)
#define MX53_PAD_EIM_D17__CSPI1_MISO		IOMUX_PAD(0x464, 0x11C, 4, 0x7A0, 3, PAD_CTRL_1)
#define MX53_PAD_EIM_D18__CSPI1_MOSI		IOMUX_PAD(0x468, 0x120, 4, 0x7A4, 3, PAD_CTRL_1)

/* LVDS0 */
#define MX53_PAD_LVDS0_TX3_P__LVDS0_TX3	IOMUX_PAD(NON_PAD_I, 0x200, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_LVDS0_CLK_P__LVDS0_CLK	IOMUX_PAD(NON_PAD_I, 0x204, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_LVDS0_TX2_P__LVDS0_TX2	IOMUX_PAD(NON_PAD_I, 0x208, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_LVDS0_TX1_P__LVDS0_TX1	IOMUX_PAD(NON_PAD_I, 0x20C, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_LVDS0_TX0_P__LVDS0_TX0	IOMUX_PAD(NON_PAD_I, 0x210, 1, 0x0, 0, NO_PAD_CTRL)

/* LVDS1 */
#define MX53_PAD_LVDS1_TX3_P__LVDS1_TX3	IOMUX_PAD(NON_PAD_I, 0x1EC, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_LVDS1_TX2_P__LVDS1_TX2	IOMUX_PAD(NON_PAD_I, 0x1F0, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_LVDS1_CLK_P__LVDS1_CLK	IOMUX_PAD(NON_PAD_I, 0x1F4, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_LVDS1_TX1_P__LVDS1_TX1	IOMUX_PAD(NON_PAD_I, 0x1F8, 1, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_LVDS1_TX0_P__LVDS1_TX0	IOMUX_PAD(NON_PAD_I, 0x1FC, 1, 0x0, 0, NO_PAD_CTRL)

/* SD1 */
#define MX53_PAD_SD1_DATA0__SD1_DATA0	IOMUX_PAD(0x66C, 0x2E4, 0, 0x0, 0, \
						MX53_SDHC_PAD_CTRL)
#define MX53_PAD_SD1_DATA1__SD1_DATA1	IOMUX_PAD(0x670, 0x2E8, 0, 0x0, 0, \
						MX53_SDHC_PAD_CTRL)
#define MX53_PAD_SD1_CMD__SD1_CMD		IOMUX_PAD(0x674, 0x2EC, \
						IOMUX_CONFIG_SION, 0x0, 0, \
						MX53_SDHC_PAD_CTRL)
#define MX53_PAD_SD1_DATA2__SD1_DATA2	IOMUX_PAD(0x678, 0x2F0, 0, 0x0, 0, \
						MX53_SDHC_PAD_CTRL)
#define MX53_PAD_SD1_CLK__SD1_CLK		IOMUX_PAD(0x67C, 0x2F4, \
						IOMUX_CONFIG_SION, 0x0, 0, \
						MX53_SDHC_PAD_CTRL | PAD_CTL_HYS)
#define MX53_PAD_SD1_DATA3__SD1_DATA3	IOMUX_PAD(0x680, 0x2F8, 0, 0x0, 0, \
						MX53_SDHC_PAD_CTRL)
#define MX53_PAD_ATA_DATA8__SD1_DATA4	IOMUX_PAD(0x648, 0x2C4, 2, 0x0, 0, \
						MX53_SDHC_PAD_CTRL)
#define MX53_PAD_ATA_DATA9__SD1_DATA5	IOMUX_PAD(0x64C, 0x2C8, 2, 0x0, 0, \
						MX53_SDHC_PAD_CTRL)
#define MX53_PAD_ATA_DATA10__SD1_DATA6	IOMUX_PAD(0x650, 0x2CC, 2, 0x0, 0, \
						MX53_SDHC_PAD_CTRL)
#define MX53_PAD_ATA_DATA11__SD1_DATA7	IOMUX_PAD(0x654, 0x2D0, 2, 0x0, 0, \
						MX53_SDHC_PAD_CTRL)
/* SD2 */
#define MX53_PAD_SD2_CLK__SD2_CLK		IOMUX_PAD(0x688, 0x2FC, 0, \
						0x0, 0, MX53_SDHC_PAD_CTRL)
#define MX53_PAD_SD2_CMD__SD2_CMD		IOMUX_PAD(0x68C, 0x300, 0, \
						0x0, 0, MX53_SDHC_PAD_CTRL)
#define MX53_PAD_SD2_DATA0__SD2_DAT0		IOMUX_PAD(0x69C, 0x310, 0, \
						0x0, 0, MX53_SDHC_PAD_CTRL)
#define MX53_PAD_SD2_DATA1__SD2_DAT1		IOMUX_PAD(0x698, 0x30C, 0, \
						0x0, 0, MX53_SDHC_PAD_CTRL)
#define MX53_PAD_SD2_DATA2__SD2_DAT2		IOMUX_PAD(0x694, 0x308, 0, \
						0x0, 0, MX53_SDHC_PAD_CTRL)
#define MX53_PAD_SD2_DATA3__SD2_DAT3		IOMUX_PAD(0x690, 0x304, 0, \
						0x0, 0, MX53_SDHC_PAD_CTRL)
#define MX53_PAD_ATA_DATA12__SD2_DAT4	IOMUX_PAD(0x658, 0x2D4, 2, 0x0, \
						0, MX53_SDHC_PAD_CTRL)
#define MX53_PAD_ATA_DATA13__SD2_DAT5	IOMUX_PAD(0x65C, 0x2D8, 2, 0x0, \
						0, MX53_SDHC_PAD_CTRL)
#define MX53_PAD_ATA_DATA14__SD2_DAT6	IOMUX_PAD(0x660, 0x2DC, 2, 0x0, \
						0, MX53_SDHC_PAD_CTRL)
#define MX53_PAD_ATA_DATA15__SD2_DAT7	IOMUX_PAD(0x664, 0x2E0, 2, 0x0, \
						0, MX53_SDHC_PAD_CTRL)

/* SD3 */
#define MX53_PAD_ATA_DATA8__SD3_DAT0		IOMUX_PAD(0x648, 0x2C4, 4, \
						0x0, 0, MX53_SDHC_PAD_CTRL)
#define MX53_PAD_ATA_DATA9__SD3_DAT1		IOMUX_PAD(0x64C, 0x2C8, 4, \
						0x0, 0, MX53_SDHC_PAD_CTRL)
#define MX53_PAD_ATA_DATA10__SD3_DAT2	IOMUX_PAD(0x650, 0x2CC, 4, 0x0, 0, \
						MX53_SDHC_PAD_CTRL)
#define MX53_PAD_ATA_DATA11__SD3_DAT3	IOMUX_PAD(0x654, 0x2D0, 4, 0x0, 0, \
						MX53_SDHC_PAD_CTRL)
#define MX53_PAD_ATA_DATA0__SD3_DAT4		IOMUX_PAD(0x628, 0x2A4, 4, \
						0x0, 0, MX53_SDHC_PAD_CTRL)
#define MX53_PAD_ATA_DATA1__SD3_DAT5		IOMUX_PAD(0x62C, 0x2A8, 4, \
						0x0, 0, MX53_SDHC_PAD_CTRL)
#define MX53_PAD_ATA_DATA2__SD3_DAT6		IOMUX_PAD(0x630, 0x2AC, 4, \
						0x0, 0, MX53_SDHC_PAD_CTRL)
#define MX53_PAD_ATA_DATA3__SD3_DAT7		IOMUX_PAD(0x634, 0x2B0, 4, \
						0x0, 0, MX53_SDHC_PAD_CTRL)
#define MX53_PAD_ATA_RESET_B__SD3_CMD	IOMUX_PAD(0x608, 0x288, 2, 0x0, 0, \
						MX53_SDHC_PAD_CTRL)
#define MX53_PAD_ATA_IORDY__SD3_CLK		IOMUX_PAD(0x60C, 0x28C, 2, \
						0x0, 0, MX53_SDHC_PAD_CTRL | PAD_CTL_HYS)

/* USB */
#define MX53_PAD_EIM_A24__GPIO_5_4		IOMUX_PAD(0x4A8, 0x15C, 1, 0x0, 0, NO_PAD_CTRL)

/* FEC */
#define MX53_PAD_FEC_MDIO__FEC_MDIO		IOMUX_PAD(0x5C4, 0x248, 0, 0x804, 1, MX53_FEC_PAD_CTRL)
#define MX53_PAD_FEC_REF_CLK__FEC_REF_CLK	IOMUX_PAD(0x5C8, 0x24C, 0, 0x0, 0, PAD_CTRL_8)
#define MX53_PAD_FEC_RX_ER__FEC_RX_ER	IOMUX_PAD(0x5CC, 0x250, 0, 0x0, 0, PAD_CTRL_8)
#define MX53_PAD_FEC_CRS_DV__FEC_CRS_DV	IOMUX_PAD(0x5D0, 0x254, 0, 0x0, 0, PAD_CTRL_8)
#define MX53_PAD_FEC_RXD1__FEC_RXD1		IOMUX_PAD(0x5D4, 0x258, 0, 0x0, 0, PAD_CTRL_8)
#define MX53_PAD_FEC_RXD0__FEC_RXD0		IOMUX_PAD(0x5D8, 0x25C, 0, 0x0, 0, PAD_CTRL_8)
#define MX53_PAD_FEC_TX_EN__FEC_TX_EN	IOMUX_PAD(0x5DC, 0x260, 0, 0x0, 0, PAD_CTL_DSE_HIGH)
#define MX53_PAD_FEC_TXD1__FEC_TXD1		IOMUX_PAD(0x5E0, 0x264, 0, 0x0, 0, PAD_CTL_DSE_HIGH)
#define MX53_PAD_FEC_TXD0__FEC_TXD0		IOMUX_PAD(0x5E4, 0x268, 0, 0x0, 0, PAD_CTL_DSE_HIGH)
#define MX53_PAD_FEC_MDC__FEC_MDC		IOMUX_PAD(0x5E8, 0x26C, 0, 0x0, 0, PAD_CTL_DSE_HIGH)

#define MX53_PAD_GPIO_0__SSI_EXT1_CLK		IOMUX_PAD(0x6A4, 0x314, 3, 0x0, 0, NO_PAD_CTRL)
#define MX53_PAD_GPIO_0__CLKO			IOMUX_PAD(0x6A4, 0x314, 0, \
						0x0, 0, NO_PAD_CTRL)

/* MLB */
#define MX53_PAD_GPIO_2__MLBDAT	IOMUX_PAD(0x6B8, 0x328, 7, 0x85C, 2, \
					PAD_CTRL_2 | PAD_CTL_PUS_360K_DOWN | \
					PAD_CTL_HYS)
#define MX53_PAD_GPIO_3__MLBCLK	IOMUX_PAD(0x6B0, 0x320, 7, 0x858, 2, \
					PAD_CTRL_2 | PAD_CTL_PUS_360K_DOWN | \
					PAD_CTL_HYS)
#define MX53_PAD_GPIO_6__MLBSIG	IOMUX_PAD(0x6B4, 0x324, 7, 0x860, 2, \
					PAD_CTRL_2 | PAD_CTL_PUS_360K_DOWN | \
					PAD_CTL_HYS)
#define MX53_PAD_FEC_MDC__MLBDAT	IOMUX_PAD(0x5E8, 0x26C, 3, 0x85C, \
				1, PAD_CTRL_2 | PAD_CTL_PUS_360K_DOWN | \
				PAD_CTL_HYS)
#define MX53_PAD_FEC_TXD1__MLBCLK	IOMUX_PAD(0x5E0, 0x264, 3, 0x858, \
				1, PAD_CTRL_2 | PAD_CTL_PUS_360K_DOWN | \
				PAD_CTL_HYS)

/* SPDIF */
#define MX53_PAD_GPIO_19__SPDIF_TX1	IOMUX_PAD(0x348, 0x20, 3, 0x0, 0, \
					PAD_CTRL_3 | PAD_CTL_PUS_100K_UP)
#define MX53_PAD_KEY_COL3__SPDIF_IN1	IOMUX_PAD(0x364, 0x3C, 3, 0x870, 0, \
					NO_PAD_CTRL)

/* ESAI */
#define MX53_PAD_FEC_MDIO__ESAI_SCKR		IOMUX_PAD(0x5C4, 0x248, 2, \
					    0x7DC, 0, MX53_ESAI_PAD_CTRL)
#define MX53_PAD_FEC_REF_CLK__ESAI_FSR	IOMUX_PAD(0x5C8, 0x24C, 2, \
					    0x7CC, 0, MX53_ESAI_PAD_CTRL)
#define MX53_PAD_FEC_RX_ER__ESAI_HCKR	IOMUX_PAD(0x5CC, 0x250, 2, \
					    0x7D4, 0, MX53_ESAI_PAD_CTRL)
#define MX53_PAD_FEC_CRS_DV__ESAI_SCKT	IOMUX_PAD(0x5D0, 0x254, 2, \
					    0x7E0, 0, MX53_ESAI_PAD_CTRL)
#define MX53_PAD_FEC_RXD1__ESAI_FST		IOMUX_PAD(0x5D4, 0x258, 2, \
					    0x7D0, 0, MX53_ESAI_PAD_CTRL)
#define MX53_PAD_FEC_RXD0__ESAI_HCKT		IOMUX_PAD(0x5D8, 0x25C, 2, \
					    0x7D8, 0, MX53_ESAI_PAD_CTRL)
#define MX53_PAD_FEC_TX_EN__ESAI_TX3_RX2	IOMUX_PAD(0x5DC, 0x260, 2, \
					    0x7F0, 0, MX53_ESAI_PAD_CTRL)
#define MX53_PAD_FEC_TXD1__ESAI_TX2_RX3	IOMUX_PAD(0x5E0, 0x264, 2, \
					    0x7EC, 0, MX53_ESAI_PAD_CTRL)
#define MX53_PAD_FEC_TXD0__ESAI_TX4_RX1	IOMUX_PAD(0x5E4, 0x268, 2, \
					    0x7F4, 0, MX53_ESAI_PAD_CTRL)
#define MX53_PAD_FEC_MDC__ESAI_TX5_RX0	IOMUX_PAD(0x5E8, 0x26C, 2, \
					    0x7F8, 0, MX53_ESAI_PAD_CTRL)
#define MX53_PAD_NANDF_CS2__ESAI_TX0		IOMUX_PAD(0x5B8, 0x240, 3, \
					    0x7E4, 0, MX53_ESAI_PAD_CTRL)
#define MX53_PAD_NANDF_CS3__ESAI_TX1		IOMUX_PAD(0x5BC, 0x244, 3, \
						0x7E8, 0, MX53_ESAI_PAD_CTRL)
#define MX53_PAD_GPIO_5__ESAI_TX2_RX3   IOMUX_PAD(0x6C0, 0x330, 0, \
						0x7EC, 1, MX53_ESAI_PAD_CTRL)
#define MX53_PAD_GPIO_8__ESAI_TX5_RX0   IOMUX_PAD(0x6C8, 0x338, 0, \
						0x7F8, 1, MX53_ESAI_PAD_CTRL)

/* WEIM */
#define MX53_PAD_EIM_D16__EIM_D16	IOMUX_PAD(0x460, 0x118, 0, 0, \
					0, MX53_WEIM_PAD_CTRL)
#define MX53_PAD_EIM_D17__EIM_D17	IOMUX_PAD(0x464, 0x11C, 0, 0, \
					0, MX53_WEIM_PAD_CTRL)
#define MX53_PAD_EIM_D18__EIM_D18	IOMUX_PAD(0x468, 0x120, 0, 0, \
					0, MX53_WEIM_PAD_CTRL)
#define MX53_PAD_EIM_D19__EIM_D19	IOMUX_PAD(0x46C, 0x124, 0, 0, \
					0, MX53_WEIM_PAD_CTRL)
#define MX53_PAD_EIM_D20__EIM_D20	IOMUX_PAD(0x470, 0x128, 0, 0, \
					0, MX53_WEIM_PAD_CTRL)
#define MX53_PAD_EIM_D21__EIM_D21	IOMUX_PAD(0x474, 0x12C, 0, 0, \
					0, MX53_WEIM_PAD_CTRL)
#define MX53_PAD_EIM_D22__EIM_D22	IOMUX_PAD(0x478, 0x130, 0, 0, \
					0, MX53_WEIM_PAD_CTRL)
#define MX53_PAD_EIM_D23__EIM_D23	IOMUX_PAD(0x47C, 0x134, 0, 0, \
					0, MX53_WEIM_PAD_CTRL)
#define MX53_PAD_EIM_D24__EIM_D24	IOMUX_PAD(0x484, 0x13C, 0, 0, \
					0, MX53_WEIM_PAD_CTRL)
#define MX53_PAD_EIM_D25__EIM_D25	IOMUX_PAD(0x488, 0x140, 0, 0, \
					0, MX53_WEIM_PAD_CTRL)
#define MX53_PAD_EIM_D26__EIM_D26	IOMUX_PAD(0x48C, 0x144, 0, 0, \
					0, MX53_WEIM_PAD_CTRL)
#define MX53_PAD_EIM_D27__EIM_D27	IOMUX_PAD(0x490, 0x148, 0, 0, \
					0, MX53_WEIM_PAD_CTRL)
#define MX53_PAD_EIM_D28__EIM_D28	IOMUX_PAD(0x494, 0x14C, 0, 0, \
					0, MX53_WEIM_PAD_CTRL)
#define MX53_PAD_EIM_D29__EIM_D29	IOMUX_PAD(0x498, 0x150, 0, 0, \
					0, MX53_WEIM_PAD_CTRL)
#define MX53_PAD_EIM_D30__EIM_D30	IOMUX_PAD(0x49C, 0x154, 0, 0, \
					0, MX53_WEIM_PAD_CTRL)
#define MX53_PAD_EIM_D31__EIM_D31	IOMUX_PAD(0x4A0, 0x158, 0, 0, \
					0, MX53_WEIM_PAD_CTRL)

#define MX53_PAD_EIM_OE__EIM_OE		IOMUX_PAD(0x4D4, 0x188, 0, 0, \
					0, NO_PAD_CTRL)
#define MX53_PAD_EIM_RW__EIM_RW		IOMUX_PAD(0x4D8, 0x18C, 0, 0, \
					0, NO_PAD_CTRL)
#define MX53_PAD_EIM_CS1__EIM_CS1	IOMUX_PAD(0x4D0, 0x184, 0, 0, \
					0, NO_PAD_CTRL)
#define MX53_PAD_EIM_A23__EIM_A23	IOMUX_PAD(0x4AC, 0x160, 0, 0, \
					0, MX53_WEIM_PAD_CTRL)

#endif /* __MACH_IOMUX_MX53_H__ */
