#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/proc_fs.h>
#include <asm/uaccess.h>

#define SPIDER2_PROC_WIFI  "wlan_sw"
#define SPIDER2_PROC_BT "bt_sw"

#define CSR_WIFI_SETUP_ENABLE 0
#define CSR_BT_SETUP_ENABLE 0

#if CSR_WIFI_SETUP_ENABLE
#define CSR_WIFI_SETUP "/usr/csr_wifi_tool/csr_wifi_setup"
#endif

#define CSR_WIFI_UP "/usr/csr_wifi_tool/csr_wifi_up"
#define CSR_WIFI_DOWN "/usr/csr_wifi_tool/csr_wifi_down"

#if CSR_BT_SETUP_ENABLE
#define CSR_BT_SETUP "/usr/csr_bt_tool/csr_bt_setup"
#endif

#define CSR_BT_UP "/usr/csr_bt_tool/csr_bt_up"
#define CSR_BT_DOWN "/usr/csr_bt_tool/csr_bt_down"


#define SHELL_SCRIPT "/bin/sh" 

static struct proc_dir_entry *proc_entry_wifi = NULL;
static struct proc_dir_entry *proc_entry_bt = NULL;

static int wifi_status = 0;
static int bt_status = 0;


static int proc_entry_wifi_write(struct file *fp, const char __user *buf, unsigned long count, void *data)
{
   char control_str[10];
   int len;
   int ret;
   int enable;
   char *envp[] = {
    "PATH=/sbin:/usr/sbin:/bin:/usr/bin",
     NULL,
    };
   char *argv[] = {
     SHELL_SCRIPT,
     NULL,
     NULL,
    };

   if(count > 10) len = 10;
   else len = count;
   if(copy_from_user(control_str, buf, len))
      return -EFAULT;

   enable = simple_strtol(control_str, NULL, 16);

   if(enable == 1){
      printk("wifi on\n");

      #if CSR_WIFI_SETUP_ENABLE
      printk("csr_wifi_setup run\n");
      argv[1] = CSR_WIFI_SETUP;
      if ((ret =call_usermodehelper(argv[0], argv, envp, /*UMH_WAIT_PROC*/1)) != 0) {
           printk("call_usermodehelper failed to run\n");
           return count;
      }
      #endif

      argv[1] = CSR_WIFI_UP;
      printk("csr_wifi_up run\n");
      if ((ret =call_usermodehelper(argv[0], argv, envp, /*UMH_WAIT_PROC*/1)) != 0) {
         printk("call_usermodehelper failed to run\n");
         return count;
      }
      wifi_status = 1;
      return count;
   }else if(enable == 0){

      printk("wifi off\n");
      printk("csr_wifi_down run\n");
      argv[1] = CSR_WIFI_DOWN;

      if ((ret =call_usermodehelper(argv[0], argv, envp, /*UMH_WAIT_PROC*/1)) != 0) {
           printk("call_usermodehelper failed to run\n");
           return count;
      }
      wifi_status = 0;
      return count;
   }

   return 0;

}

static int proc_entry_wifi_read(char *buf, char **start, off_t offset, int count,
        int *eof, void *data)
{
   int   len;
	char *p = buf;

	p += sprintf(p, "%d\n",  wifi_status);

	len = (p - buf) -offset;
	if (len < 0) {
		len = 0;
	}
	*start = buf + offset;

	return len;
}



static int proc_entry_bt_write(struct file *fp, const char __user *buf, unsigned long count, void *data)
{

   char control_str[10];
   int len;
   int ret;
   int enable;
   char *envp[] = {
    "PATH=/sbin:/usr/sbin:/bin:/usr/bin",
     NULL,
    };
   char *argv[] = {
     SHELL_SCRIPT,
     NULL,
     NULL,
    };

   if(count > 10) len = 10;
   else len = count;
   if(copy_from_user(control_str, buf, len))
      return -EFAULT;

   enable = simple_strtol(control_str , NULL, 16);

   if(enable == 1){
      printk("bt on\n");

      #if CSR_BT_SETUP_ENABLE
      printk("csr_bt_setup run\n");
      argv[1] = CSR_BT_SETUP;
      if ((ret =call_usermodehelper(argv[0], argv, envp, /*UMH_WAIT_PROC*/1)) != 0) {
           printk("call_usermodehelper failed to run\n");
           return count;
      }
      #endif

      argv[1] = CSR_BT_UP;
      printk("csr_bt_up run\n");
      if ((ret =call_usermodehelper(argv[0], argv, envp, /*UMH_WAIT_PROC*/1)) != 0) {
         printk("call_usermodehelper failed to run\n");
         return count;
      }
      bt_status = 1;
      return count;

   }else if(enable == 0){

      printk("bt off\n");
      printk("csr_bt_down run\n");
      argv[1] = CSR_BT_DOWN;

      if ((ret =call_usermodehelper(argv[0], argv, envp, /*UMH_WAIT_PROC*/1)) != 0) {
           printk("call_usermodehelper failed to run\n");
           return count;
      }
      bt_status = 0;
      return count;
   }

   return 0;


}

static int proc_entry_bt_read(char *buf, char **start, off_t offset, int count,
        int *eof, void *data)
{
   int   len;
	char *p = buf;

	p += sprintf(p, "%d\n", bt_status);

	len = (p - buf) -offset;
	if (len < 0) {
		len = 0;
	}
	*start = buf + offset;

	return len;

}



static void interface_create_proc(void)
{
   
    proc_entry_wifi =  create_proc_entry(SPIDER2_PROC_WIFI, 0666, NULL);
    if( proc_entry_wifi == NULL){
        printk("proc_entry_wifi failed\n");
    }
    proc_entry_wifi->owner      = THIS_MODULE;
    proc_entry_wifi->read_proc  = proc_entry_wifi_read;
    proc_entry_wifi->write_proc = proc_entry_wifi_write;
    proc_entry_wifi->data       = (void*)NULL;

    proc_entry_bt =  create_proc_entry(SPIDER2_PROC_BT, 0666, NULL);
    if( proc_entry_bt == NULL){
        printk("proc_entry_bt failed\n");
    }
    proc_entry_bt->owner      = THIS_MODULE;
    proc_entry_bt->read_proc  = proc_entry_bt_read;
    proc_entry_bt->write_proc = proc_entry_bt_write;
    proc_entry_bt->data       = (void*)NULL;

}

static void interface_remove_proc(void)
{
    remove_proc_entry(SPIDER2_PROC_WIFI , proc_entry_wifi);
    remove_proc_entry(SPIDER2_PROC_BT, proc_entry_bt);
}


static int __init interface_init(void)
{
  
   interface_create_proc();
	return 0;
}

static void __exit interface_exit(void)
{
   interface_remove_proc();
   return 0;
}

module_init(interface_init);
module_exit(interface_exit);

MODULE_AUTHOR("Raphael Assenat <raph@8d.com>");
MODULE_DESCRIPTION("interface driver");
MODULE_LICENSE("GPL");
MODULE_ALIAS("platform:vibrator");
