/*---------------------------------------------------------------------------
 * Pegatron Modify History
 *---------------------------------------------------------------------------
 * 2009/12/03  Eric Chou  - create control GPIO driver V1.00
 *---------------------------------------------------------------------------
 *  echo 1 > /proc/ctl_gpio/enable_26mhz
 *  echo 1 > /proc/ctl_gpio/enable_vcc_3v3
 *  echo 1 > /proc/ctl_gpio/enable_vcc_5v2
 *  echo 1 > /proc/ctl_gpio/enable_wifi_reset
 *  echo 1 > /proc/ctl_gpio/enable_bt_reset
 *  echo 1 > /proc/ctl_gpio/enable_bt_en
 *  echo 1 > /proc/ctl_gpio/enable_lcd_power
 *  echo 1 > /proc/ctl_gpio/enable_sound_amp
 *  echo 1 > /proc/ctl_gpio/enable_sound_clock
 *  echo 1 > /proc/ctl_gpio/enable_oj_shutdown
 *  echo 1 > /proc/ctl_gpio/enable_motor
 *  echo 1 > /proc/ctl_gpio/enable_usb_clock
 *---------------------------------------------------------------------------*/

#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/platform_device.h>
#include <linux/proc_fs.h>             // proc
#include <asm/uaccess.h>               // copy_from_user()

#define DEBUG_TRACE        1
#if ( DEBUG_TRACE )
#define DEBUG_PRINTK(x)    printk x
#else
#define DEBUG_PRINTK(x)
#endif

#define num_ctl_enable     12

static struct mxc_ctl_gpio_platform_data *ctl_gpio_platform_data;
static struct proc_dir_entry             *proc_dir_ctl_gpio;
static struct proc_dir_entry             *proc_entry_ctl_gpio[num_ctl_enable];

char ctl_gpio_name[num_ctl_enable][24] =
{
   "enable_26mhz",       // 0
   "enable_vcc_3v3",     // 1
   "enable_vcc_5v2",     // 2
   "enable_wifi_reset",  // 3
   "enable_bt_reset",    // 4
   "enable_bt_en",       // 5
   "enable_lcd_power",   // 6
   "enable_sound_amp",   // 7
   "enable_sound_clock", // 8
   "enable_oj_shutdown", // 9
   "enable_motor",       // 10
   "enable_usb_clock"    // 11
};

static int ctl_gpio_proc_write(struct file *fp, const char __user *buf, unsigned long count, void *data)
{
   int i;
   int len;
   int enable;
   char str[10];

   for ( i = 0 ; i < num_ctl_enable ; i++ )
   {
      if ( strcmp(data, ctl_gpio_name[i]) == 0 )
      {
         if ( count > 10 )
            len = 10;
         else
            len = count;

         if ( copy_from_user(str, buf, len) )
            return -EFAULT;

         enable = simple_strtol(str, NULL, 16);
         ctl_gpio_platform_data->enable_clt[i](enable);
	     return count;
      }
    }
    return 0;
}

static int ctl_gpio_proc_read(char *buf, char **start, off_t offset, int count, int *eof, void *data)
{
   return 0;
}

static void ctl_gpio_create_proc(void)
{
   int i;

   proc_dir_ctl_gpio = proc_mkdir("ctl_gpio", NULL);
   if ( proc_dir_ctl_gpio == NULL)
      printk("ctl_gpio proc dir failed \n");

   for ( i = 0 ; i < num_ctl_enable ; i++ )
   {
      proc_entry_ctl_gpio[i] = create_proc_entry(ctl_gpio_name[i], 0644, proc_dir_ctl_gpio);

      if ( proc_entry_ctl_gpio[i] == NULL )
         printk("%s proc entry enable failed \n", ctl_gpio_name[i]);

      proc_entry_ctl_gpio[i]->owner      = THIS_MODULE;
      proc_entry_ctl_gpio[i]->read_proc  = ctl_gpio_proc_read;
      proc_entry_ctl_gpio[i]->write_proc = ctl_gpio_proc_write;
      proc_entry_ctl_gpio[i]->data       = (void*)ctl_gpio_name[i];
   }
}

static void ctl_gpio_remove_proc(void)
{
   int i;

   for ( i = 0 ; i < num_ctl_enable ; i++ )
      remove_proc_entry(ctl_gpio_name[i], proc_dir_ctl_gpio);
}

static int ctl_gpio_probe(struct platform_device *pdev)
{
   ctl_gpio_platform_data = pdev->dev.platform_data;

   if ( !ctl_gpio_platform_data )
      return -EBUSY;

   ctl_gpio_create_proc();
   return 0;
}

static int __devexit ctl_gpio_remove(struct platform_device *pdev)
{
   ctl_gpio_remove_proc();

   return 0;
}

static struct platform_driver ctl_gpio_driver =
{
   .probe    = ctl_gpio_probe,
   .remove   = __devexit_p(ctl_gpio_remove),
   .driver   =
   {
      .name  = "ctl_gpio",
      .owner = THIS_MODULE,
   },
};

static int __init ctl_gpio_init(void)
{
   return platform_driver_register(&ctl_gpio_driver);
}

static void __exit ctl_gpio_exit(void)
{
   platform_driver_unregister(&ctl_gpio_driver);
}

module_init(ctl_gpio_init);
module_exit(ctl_gpio_exit);

MODULE_AUTHOR("Pegatron Eric Chou");
MODULE_DESCRIPTION("Control Devcie GPIO");
MODULE_LICENSE("GPL");
