#ifndef __COMPAT_COMPLETION_H__
#   define __COMPAT_COMPLETION_H__

/*
 * wait_for_completion and friends did not exist before 2.4.9.
 */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 4, 9)

#include <linux/completion.h>
#define compat_completion struct completion
#define compat_init_completion(comp) init_completion(comp)
#define COMPAT_DECLARE_COMPLETION DECLARE_COMPLETION
#define compat_wait_for_completion(comp) wait_for_completion(comp)

#else

#define compat_completion struct semaphore
#define compat_init_completion(comp) init_MUTEX(comp)
#define COMPAT_DECLARE_COMPLETION(comp) DECLARE_MUTEX_LOCKED(comp)

/*
 * Locking and unlocking the kernel lock here ensures that the thread
 * is no longer running in module code: compat_complete_and_exit
 * performs the sequence { lock_kernel(); up(comp); compat_exit(); }, with
 * the final unlock_kernel performed implicitly by the resident kernel
 * in do_exit.
 */
#define compat_wait_for_completion(comp) do { \
   down(comp); \
   lock_kernel(); \
   unlock_kernel(); \
} while (0)

#endif


#endif /* __COMPAT_COMPLETION_H__ */
