# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

import gobject
import gtk
from library import SMART,SmartRule

class SmartPlaylistWindow(gtk.Dialog):
    
    def __init__(self,pl,new=False):
        assert pl.is_smart()
        self.pl = pl
        if new:
            bouton = (
                        gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,
                        gtk.STOCK_OK, gtk.RESPONSE_ACCEPT)
        else:
            bouton =  gtk.STOCK_CLOSE, gtk.RESPONSE_CLOSE
        gtk.Dialog.__init__(self,_("Edit Automatic playlist"),None,
                 gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
                     bouton
                 )

        self.set_position(gtk.WIN_POS_CENTER_ON_PARENT)
        self.set_resize_mode(False)
        self.set_border_width(6)
        self.set_modal(True)
        self.set_property("skip-taskbar-hint",True)
        self.set_has_separator(False)
        self.set_resizable(False)
        
        
        vbox = gtk.VBox(False,6)
        
        l = gtk.Label(_("Create automatically updating playlist where:"))
        l.set_alignment(0,0.5)
        vbox.pack_start(l,False,False)
        
        
        """ RULES """
        
        self.rules_box = gtk.VBox(False,6)
        vbox.pack_start(self.rules_box,False,False)
        
        
        
        """ UNION """
        
        check = gtk.CheckButton(_("Add if any criteria are matched"))
        check.connect("toggled",self.on_rules_union)
        check.set_property("active",not self.pl.rules_union)
        
        btn_add = gtk.Button(stock=gtk.STOCK_ADD)
        btn_add.connect("clicked",self.on_add_rules)
        
        hbox = gtk.HBox(False,6)
        hbox.pack_start(check,False,False)
        hbox.pack_end(btn_add,False,False)
        vbox.pack_start(hbox,False,False)
        
        """ LIMIT """
        limit_box = gtk.HBox(False,6)
        
        limit = gtk.CheckButton(_("Limit to:"))
        limit.set_property("active",(self.pl.limit!=None))
        
        self.limit_box_state = gtk.HBox(False,6)
        
        spin_limit = gtk.SpinButton(gtk.Adjustment(value=0, lower=0, upper=1000, step_incr=1, page_incr=10, page_size=1000))
        
        spin_limit.set_value(float(self.pl.limit))
        spin_limit.connect("value-changed",self.on_rules_limit_value)
        
        
        combo = gtk.combo_box_new_text()
        combo.append_text(_("Songs"))
        combo.append_text(_("MB"))
        combo.append_text(_("GB"))
        combo.append_text(_("Minutes"))
        combo.connect("changed",self.on_rules_limit_type)
        
        combo.set_active(self.pl.limit_type)
        
        self.limit_box_state.pack_start(spin_limit,False,False)
        self.limit_box_state.pack_start(combo,False,False)
        
        limit_box.pack_start(limit,False,False)
        limit_box.pack_start(self.limit_box_state,False,False)
        
        vbox.pack_start(limit_box, False, False)
        
        limit.connect("toggled",self.on_rules_limit)
        limit.set_property("active",self.pl.has_limit)
        
        """ ORDER """
        vbox_order = gtk.HBox(False,6)
        l = gtk.Label(_("When sorted by:"))
        combo = gtk.ComboBox()
        ordermodel = gtk.ListStore(str,str)
        ordermodel.append(("title",_("Title")))
        ordermodel.append(("artist",_("Artist")))
        ordermodel.append(("album",_("Album")))
        ordermodel.append(("genre",_("Genre")))
        ordermodel.append(("#playcount",_("Play count")))
        ordermodel.append(("#lastplayed",_("Last Played")))
        ordermodel.append(("#track",_("Track Number")))
        ordermodel.append(("#duration",_("Duration")))
        ordermodel.append(("#date",_("Year")))
        combo.set_model(ordermodel)
        cell = gtk.CellRendererText()
        combo.pack_start(cell)
        combo.add_attribute(cell, "text", 1)
        i = 0
        for row in ordermodel:
            if row[0] == self.pl.order_by:
                combo.set_active(i)
                break;
            i += 1
        else:
            combo.set_active(0)
        combo.connect("changed",self.on_rules_order_by)
        
        check = gtk.CheckButton(_("In reverse alphabetical order"))
        check.connect("toggled",self.on_rules_order_reverse)
        check.set_property("active",self.pl.inverse_order_by)
            
        vbox_order.pack_start(l,False,False)
        vbox_order.pack_start(combo,False,False)
        vbox_order.pack_start(check,False,False)
        
        vbox.pack_start(vbox_order, False, False)
        
        
        self.vbox.pack_start(vbox,False,False)
        self.vbox.set_spacing(6)
        
        for r in self.pl.rules:
            self.rules_box.pack_start(SmartRuleWidget(self.pl,r),False,False)
        if new:                
            r = SmartRule()
            self.pl.rules.append(r)
            self.rules_box.pack_start(SmartRuleWidget(self.pl,r),False,False)
        
    def on_rules_order_by(self,w):
        self.pl.order_by = w.get_model()[w.get_active()][0]
        
    def on_rules_order_reverse(self,w):
        self.pl.inverse_order_by = w.get_active()    
        
    def on_rules_limit_type(self,w):
        self.pl.limit_type = w.get_active()
        
    def on_rules_union(self,w):
        self.pl.rules_union = not w.get_property("active")
    
    def on_rules_limit_value(self,w):
        self.pl.limit = int(w.get_value())
        
    def on_rules_limit(self,w):
        self.pl.has_limit = w.get_property("active")
        self.limit_box_state.set_sensitive(self.pl.has_limit)
            
    def run(self):
       self.show_all()    
       res = gtk.Dialog.run(self)
       gobject.idle_add(self.destroy)
       if res==gtk.RESPONSE_CANCEL:
           return None
       else:
           self.pl.refresh_rules()
           self.pl.print_rules()
           return self.pl
    
    def on_add_rules(self,w):
        r = SmartRule()
        self.pl.rules.append(r)
        self.rules_box.pack_start(SmartRuleWidget(self.pl,r),False,False)
    
    
class SmartRuleWidget(gtk.HBox):
    def __init__(self,pl,rule):
        super(SmartRuleWidget,self).__init__(False,6)
        
        self.pl = pl
        self.rule = rule
        
        self.combo_field = gtk.ComboBox()
        ordermodel = gtk.ListStore(str,str)
        ordermodel.append(("title",_("Title")))
        ordermodel.append(("artist",_("Artist")))
        ordermodel.append(("album",_("Album")))
        ordermodel.append(("genre",_("Genre")))
        ordermodel.append(("#playcount",_("Play count")))
        ordermodel.append(("#lastplayed",_("Last Played")))
        ordermodel.append(("#track",_("Track Number")))
        ordermodel.append(("#duration",_("Duration")))
        ordermodel.append(("#date",_("Year")))
        ordermodel.append(("uri",_("Path")))
        self.combo_field.set_model(ordermodel)
        cell = gtk.CellRendererText()
        self.combo_field.pack_start(cell)
        self.combo_field.add_attribute(cell, "text", 1)
        
        self.pack_start(self.combo_field,False,False)
        
        self.combo_action = gtk.combo_box_new_text()
        self.pack_start(self.combo_action,False,False)
        
        
        self.string = gtk.Entry()
        self.pack_start(self.string,True,True)
        self.string.connect("changed",self.on_change_string)     
        self.string.show_all()
        self.string.set_no_show_all(True)
        self.string.hide()
        
        self.number = gtk.SpinButton(gtk.Adjustment(value=0, lower=0, upper=1000, step_incr=1, page_incr=10, page_size=1000))
        self.pack_start(self.number,True,True)
        self.number.connect("value-changed",self.on_change_number)     
        self.number.show_all()
        self.number.set_no_show_all(True)
        self.number.hide()
        
        self.duration1 = gtk.SpinButton(gtk.Adjustment(value=0, lower=0, upper=1000, step_incr=1, page_incr=10, page_size=1000))
        self.pack_start(self.duration1,True,True)
        self.duration1.connect("value-changed",self.on_change_duration)     
        self.duration1.show_all()
        self.duration1.set_no_show_all(True)
        self.duration1.hide()
        
        self.durationl = gtk.Label(":")
        self.pack_start(self.durationl,True,True)
        self.durationl.show_all()
        self.durationl.set_no_show_all(True)
        self.durationl.hide()
        
        self.duration2 = gtk.SpinButton(gtk.Adjustment(value=0, lower=0, upper=1000, step_incr=1, page_incr=10, page_size=1000))
        self.pack_start(self.duration2,True,True)
        self.duration2.connect("value-changed",self.on_change_duration)     
        self.duration2.show_all()
        self.duration2.set_no_show_all(True)
        self.duration2.hide()
        
        self.date1 = gtk.SpinButton(gtk.Adjustment(value=0, lower=0, upper=1000, step_incr=1, page_incr=10, page_size=1000))
        self.pack_start(self.date1,True,True)
        self.date1.connect("value-changed",self.on_change_date)     
        self.date1.show_all()
        self.date1.set_no_show_all(True)
        self.date1.hide()
        
        self.date2 = gtk.combo_box_new_text()
        self.pack_start(self.date2,True,True)
        self.date2.append_text(_("seconds"))
        self.date2.append_text(_("minutes"))
        self.date2.append_text(_("hours"))
        self.date2.append_text(_("days"))
        self.date2.append_text(_("weeks"))
        self.date2.connect("changed",self.on_change_date)  
        self.date2.show_all()
        self.date2.set_no_show_all(True)
        self.date2.hide()
        
        btn_supp = gtk.Button(stock=gtk.STOCK_DELETE)
        
        self.pack_start(btn_supp,False,False)
        btn_supp.connect("clicked",self.on_delete)
        
        
        i = 0
        for row in ordermodel:
            if row[0] == self.rule.field:
                self.combo_field.set_active(i)
                break;
            i += 1
        else:
            self.combo_field.set_active(0)
        self.combo_action.set_active(rule.action) 
        
        self.show_all()
        
        
        self.on_field_change(self.combo_field,True)
        self.combo_action.set_active(self.rule.action)
        
        self.combo_field.connect("changed",self.on_field_change)
        self.combo_action.connect("changed",self.on_action_change)
        
        self.load_value()
        
    def load_value(self):
        if self.rule.type == SMART.RULES_TYPE_STRING:
            self.string.set_text(self.rule.value1)
        elif self.rule.type == SMART.RULES_TYPE_DURATION:  
            self.duration1.set_value(float(self.rule.value1))
            self.duration2.set_value(float(self.rule.value2))     
        elif self.rule.type == SMART.RULES_TYPE_INT:  
            self.number.set_value(float(self.rule.value1))    
        elif self.rule.type == SMART.RULES_TYPE_DATE:  
            self.date1.set_value(float(self.rule.value1))    
            self.date2.set_active(self.rule.value2)        
        
    def on_delete(self,w):
        if self.rule in self.pl.rules:
            del self.pl.rules[self.pl.rules.index(self.rule)]
            self.get_parent().remove(self)
            self.destroy()
            
    def on_action_change(self,w):
        self.rule.action = w.get_active()
        
    def on_change_date(self,w):
        self.rule.set_value(self.date1.get_value(),self.date2.get_active())
        
    def on_change_duration(self,w):
        self.rule.set_value(self.duration1.get_value(),self.duration2.get_value())
        
    def on_change_string(self,w):
        self.rule.set_value(w.get_text())
        
    def on_change_number(self,w):
        self.rule.set_value(int(w.get_value()))
        
    def on_field_change(self,w,dont_delete_value = False):
        self.rule.set_field(w.get_model()[w.get_active()][0],dont_delete_value)
        self.combo_action.get_model().clear()
        self.string.hide()
        self.number.hide()
        self.duration1.hide()
        self.durationl.hide()
        self.duration2.hide()
        self.date1.hide()
        self.date2.hide()
        if self.rule.type == SMART.RULES_TYPE_STRING:
            self.combo_action.append_text(_("contains"))
            self.combo_action.append_text(_("does not contains"))
            self.combo_action.append_text(_("equals"))
            self.combo_action.set_active(0)
            self.string.show()
            
        elif self.rule.type == SMART.RULES_TYPE_DURATION:
            self.combo_action.append_text(_("equals"))
            self.combo_action.append_text(_("at least"))
            self.combo_action.append_text(_("at most"))
            self.combo_action.set_active(0)
            self.duration1.show()
            self.durationl.show()
            self.duration2.show()
        
        elif self.rule.type == SMART.RULES_TYPE_INT:
            self.combo_action.append_text(_("equals"))
            self.combo_action.append_text(_("at least"))
            self.combo_action.append_text(_("at most"))
            self.combo_action.set_active(0)
            self.number.show()
        
        elif self.rule.type == SMART.RULES_TYPE_DATE:
            self.combo_action.append_text(_("in the last"))
            self.combo_action.append_text(_("not in the last"))
            self.combo_action.set_active(0)
            self.date1.show()
            self.date2.show()
        self.load_value()
        