# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###


import os
from helper import Dispatcher

from logger import Logger

from player import Player

class MMKeys(Logger):
    def __init__(self):
        self.application = 'Listen'
        self.use = None
        if "DISABLE_LISTEN_MMKEYS" not in os.environ :
            self.use = self.__use_gnome() or self.__use_mmkeys()
        self.loginfo("MMKeys mode: %s",self.use)
    
    def __use_gnome(self):
        def on_gnome_mmkey(app, key):
            if app == self.application:
                if key == "Play":
                    Player.playpause()
                if key == "PlayPause":
                    Player.playpause()
                if key == "Stop":
                    Player.stop()
                if key == "Next":
                    Player.next()
                if key == "Previous":
                    Player.previous()
        

	try:
		# Gnome >= 2.22.X
        	import dbus
        	bus = dbus.SessionBus()
        	obj = bus.get_object('org.gnome.SettingsDaemon', '/org/gnome/SettingsDaemon/MediaKeys')
        	self.__gnome = dbus.Interface(obj, 'org.gnome.SettingsDaemon.MediaKeys')
        	self.__gnome.GrabMediaPlayerKeys(self.application, 0)
        	self.__gnome.connect_to_signal("MediaPlayerKeyPressed", on_gnome_mmkey)
	except:
		try:
			# Gnome < 2.22.X
			import dbus
			bus = dbus.SessionBus()
			obj = bus.get_object('org.gnome.SettingsDaemon', '/org/gnome/SettingsDaemon')
			self.__gnome = dbus.Interface(obj, 'org.gnome.SettingsDaemon')
			self.__gnome.GrabMediaPlayerKeys(self.application, 0)
			self.__gnome.connect_to_signal("MediaPlayerKeyPressed", on_gnome_mmkey)
		except:
			return None
        
        return 'gnome'
    
    def __use_mmkeys(self):
        try:import mmkeys
        except:
        	return None
        
        self.__keys = mmkeys.MmKeys()
        self.__keys.connect("mm_prev", self.mm_previous)
        self.__keys.connect("mm_next", self.mm_next)
        self.__keys.connect('mm_stop', self.mm_play)
        self.__keys.connect("mm_playpause", self.mm_play)
        
        return 'mmkeys'
        
    def __del__(self):
        #FIXME: too stupid ! I was a bit seedy on that day
    	if self.use == 'gnome':
    		self.__gnome.ReleaseMediaPlayerKeys(self.application)
    
    def mm_play(self,a,b):
    	Player.play()
    	
    def mm_next(self,a,b):
    	Player.next()
    	
    def mm_previous(self,a,b):
    	Player.previous()
    
