

import os
import shutil
import pickle

import time

import utils
from logger import Logger
from xdg_support import get_xdg_config_file, get_xdg_cache_dir

# Warning library is not loaded here
from library import ListenDB

from song import Song

class ObjectWrapper(object):
        pass

class UnpicklerWrapper(pickle.Unpickler):
    def find_class(self, module, name):
        if name == "Song" and module == "song":
            return dict
        else:
            return ObjectWrapper


class Updater(Logger):
    def __init__(self):

        self.update()


    def update(self):
        version = self.get_config_version()
        if hasattr(self, "update_%s"%version):
            updater = getattr(self, "update_%s"%version)
            try: 
                updater()
            except Exception,e: 
                self.logexception(e)
        else:
            self.loginfo("config dir up to date")

    def update_0_5__6(self):
        oldconfigdir = os.path.expanduser("~/.listen-trunk/")
        if not os.path.exists(oldconfigdir):
            oldconfigdir = os.path.expanduser("~/.listen/")
        backupdir = os.path.expanduser("~/listen-0.6-backup/")
        i = 0
        while os.path.exists(backupdir):
            i += 1
            backupdir = os.path.expanduser("~/listen-0.6-backup%d/"%i)
            if i == 10:
                self.logerror("Failed to backup old configdir, don't update")
                return 
        
        # Config
        configfile = get_xdg_config_file("config")
        oldfile = os.path.join(oldconfigdir, "config")
        if os.path.exists(oldfile):
            shutil.copy(oldfile, configfile)

        # Cover Stuff
        cachedir = get_xdg_cache_dir("cover")
        shutil.rmtree(cachedir)
        oldpath = os.path.join(oldconfigdir, "cover")
        if os.path.exists(oldpath):
            shutil.copytree(oldpath, cachedir)
        else:
            os.makedirs(cachedir,755)

        expr = re.compile(r'^[^+]*\+(.*)')
        for file in os.listdir(cachedir):
            m = expr.match(file)
            if m:
                newfile = m.groups()[0]
                shutil.move(file, newfile)


        for file in [ "songs.db", "playlists.db", "playlist_cur.db", "playlist_queue.db"]:
            newfile = get_xdg_config_file(file)
            oldfile = os.path.join(oldconfigdir, file)
            if os.path.exists(oldfile):
                shutil.copy(oldfile, newfile)
        
        self.loginfo("Configdir update done")
        try: shutil.move(oldconfigdir, backupdir)
        except: pass
        self.loginfo("You can safely delete %s directory"%backupdir)
        ListenDB.set_force_sanity_check()

    def update_0_5(self):
        oldconfigdir = os.path.expanduser("~/.listen/")
        backupdir = os.path.expanduser("~/listen-0.5-backup/")
        
        # Config
        configfile = get_xdg_config_file("config")
        oldfile = os.path.join(oldconfigdir, "config")
        if os.path.exists(oldfile):
            shutil.copy(oldfile, configfile)

        # Cover Stuff
        cachedir = get_xdg_cache_dir("cover")
        shutil.rmtree(cachedir)
        oldpath = os.path.join(oldconfigdir, "cover")
        if os.path.exists(oldpath):
            shutil.copytree(oldpath, cachedir)
        else:
            os.makedirs(cachedir,755)

        expr = re.compile(r'^[^+]*\+(.*)')
        for file in os.listdir(cachedir):
            m = expr.match(file)
            if m:
                newfile = m.groups()[0]
                shutil.move(file, newfile)

        # Library Stuff
        oldfile = os.path.join(oldconfigdir,"songs.db")
        if os.path.exists(oldfile):
            fd = file(oldfile)
            unpk = UnpicklerWrapper(fd)
            objs = unpk.load()
            songs_data = []
            for obj in objs.values():
                try: stype = obj["##song_type##"]
                except KeyError: continue

                #FIXME: hum not  clean !!
                if stype == 0: stype = "local"
                elif stype == 1: stype = "podcast"
                elif stype == 2: stype = "webradio"
                elif stype == 10: stype = "lastfmradio"
                elif stype in [3, 4, 5, 6, 7, 8, 9, 11, 12]: 
                    self.logwarn("Failed convert %s, type %d not supported", obj.get("uri"),stype)
                    continue
                else: 
                    self.logwarn("Failed convert %s, type %d incorrect", obj.get("uri"),stype)
                    continue

                s = Song(obj)
                s.set_type(stype)
                songs_data.append(s.get_dict())
        
            utils.save_db(songs_data, get_xdg_config_file("songs.db"))
            fd.close()

        # Playlist Stuff
        pls_data = []
        fd = file(os.path.join(oldconfigdir,"playlists.db"))
        unpk = UnpicklerWrapper(fd)
        objs = unpk.load()
        for obj in objs:
            if obj.playlist_type not in [1, 2 ]: continue
            auto = obj.playlist_type == 2
            name = obj.name
            if not auto:
                # Uris
                infos = obj.songs
            else:
                # Rules
                limit_type = {
                    0:"title",
                    1:"mo",
                    2:"go",
                    3:"duration"
                }
                infos = {
                    "string": "&()",
                    "has_limit": obj.has_limit,
                    "limit": obj.limit,
                    "limit_type": limit_type[obj.limit_type],
                    "order_by": obj.order_by,
                    "inverse_order_by": obj.inverse_order_by
                }
                infos["string"]
                string = (obj.rules_union and "&" or "|" )
                string += "("

                rules = []
                for rule in obj.rules:
                    if rule.type == 0: # String
                        operators = { 0: "%s = %s", 1: "%s != %s", 2: "%s = /^%s$/" }
                        value = rule.value1
                    elif rule.type == 1: # Int
                        operators = { 0: "#(%s = %s)",1: "#(%s > %s)",2: "#(%s < %s)"}
                        value = str(rule.value1)
                    elif rule.type == 2: # Date
                        operators = { 0: "#(%s = %s)",1: "#(%s > %s)",2: "#(%s < %s)"}
                        value = str(rule.value1 * rule.value2)
                    elif rule.type == 3: # Duration
                        value = time.strptime("%d:%d"%(rule.value1,rule.value2),"%M:%S")
                        operators = { 0: "#(%s = %s)",1: "#(%s > %s)",2: "#(%s < %s)"}
                    else:
                        self.logwarn("Unknown rule type %s",rule.type)
                        continue
                    operator = operators[rule.action]
                    rules.append( operator%( rule.field, str(value) ) )

                string += ",".join(rules)

                string += ")"
                infos["string"] = string
            
            pls_data.append((auto, name, infos))

        utils.save_db(pls_data, get_xdg_config_file("playlists.db"))
        fd.close()
        
        self.loginfo("Configdir update done")
        shutil.move(oldconfigdir, backupdir)
        self.loginfo("You can safely delete %s directory"%backupdir)
        ListenDB.set_force_sanity_check()
    
    def get_config_version(self):
        configfile = get_xdg_config_file("config")
        if os.path.exists(configfile):
            return "0_6"
        oldconfigdir = os.path.expanduser("~/.listen-trunk/")
        if os.path.exists(oldconfigdir):
            return "0_5__6"
        oldconfigdir = os.path.expanduser("~/.listen/")
        if os.path.exists(oldconfigdir):
            fd = file(os.path.join(oldconfigdir,"songs.db"))
            unpk = UnpicklerWrapper(fd)
            objs = unpk.load()
            del unpk
            fd.close()
            if isinstance(objs,list):
                return "0_5__6"
            else:
                return "0_5"

        # Nothing found first launch
        return "0_6"


