# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###

import os,stat
import locale
import threading


import gc

from time import time,strptime, mktime

def print_gc(obj):
    gc.collect()
    print gc.get_referrers(obj)


from proxy import discover_http_proxy

def threaded(f):
    def wrapper(*args):
        t = threading.Thread(target=f, args=args)
        t.setDaemon(True)
        t.start()

    return wrapper

def profiling(func):
    def wrapper(*args,**kwargs):
        class_name = ""
        if hasattr(func,'im_class'):
            class_name = func.im_class__name__+":"
        name = class_name+func.func_name
        date = str(time())
        filename = "listen_profiling_"+name+"_"+date
        from hotshot import stats,Profile
        prof = Profile(filename)
        res = prof.runcall(func,*args,**kwargs)
        prof.close()
        s = stats.load(filename)
        print "\n** "+name+" **\n"
        s.sort_stats("time").print_stats()
        os.remove(filename)
        return res
    return wrapper

def print_timing(func):
    def wrapper(*arg):
        t1 = time()
        res = func(*arg)
        t2 = time()
        class_name = ""
        if hasattr(func,'im_class'):
            class_name = func.im_class__name__+":"
        print '%s took %0.3fms' % (class_name+func.func_name, (t2-t1)*1000.0)
        return res
    return wrapper

def format_tag(value):
    if not value:  return ""
    value = value.strip()
    if len(value)>1:
        value = value[:1].upper()+value[1:]
    else:
        value = value.upper()    
    return value

def dbus_service_available(bus,interface,try_start_service=False):
    try: import dbus
    except: return False
    if try_start_service:
        bus.start_service_by_name(interface)
    obj = bus.get_object('org.freedesktop.DBus', '/org/freedesktop/DBus') 
    dbus_iface = dbus.Interface(obj, 'org.freedesktop.DBus') 
    avail = dbus_iface.ListNames() 
    return interface in avail


def export_playlist(list_song,filename,type="m3u"):
    if type=="m3u":
        fileout = open(filename, "w")
        fileout.write("\n".join([song.get_path() for song in list_song if song.get_path() != None]))
        fileout.close()
    elif type=="pls":
        fileout = open(filename, "w")
        [ fileout.write("file%d=%s\n"%(i,song.get_path()))  for i,song in enumerate(list_song)  if song.get_path() != None  ]
        fileout.close()
    else:
        raise TypeError, "Unknow playlist type"


def burn(list_song):
    fn = "/tmp/listenburnpl.m3u"
    export_playlist([s for s in list_song],fn)
    os.spawnlp(os.P_NOWAIT, "serpentine","serpentine","-o",fn)
    
"""
XML simple un/escape caracter
"""

def xmlescape(stri):
    """Escape a string in a manner suitable for XML/Pango."""
    stri = str(stri)
    return stri.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;")

def xmlunescape(stri):
    """Unescape a string in a manner suitable for XML/Pango."""
    stri = str(stri)
    return stri.replace("&lt;", "<").replace("&gt;", ">").replace("&amp;", "&")



""" Remove no need str for web service manipulation """
def filter_info_song(str):
    from config import config
    str = str.lower()
    filters = config.get("webservice","filter").split("<###>")
    for filter in filters:
        filter = filter.lower()
        str = str.replace(" "+filter+" "," ")
        if str.rfind(filter)==len(str)-len(filter):
            str = str.replace(" "+filter,"")
    return str

def str_size(nb,average=0,base=1024):
    if average!=0:
        average +=1
    nb = float(nb)
    size_format = ""
    if base==1024:
        units = _("B KiB MiB GiB").split()
    else:
        units = _("B KB MB GB").split()
    for size_format in units:
        if len("%d"%int(nb))<=3:
            break
        nb = float(nb)/float(base)
    nb = "%f"%round(nb,1)
    nb = nb[:nb.rfind(".")+average]+size_format
    return nb

def duration_to_string(value,default="",i=1000):
    if not value: return default
    duration = "%02d:%02d" % ((value/(60*i))%60, (value/(i))%60)
    if value/(60*i)/60>=1:
        duration = "%d:"%(value/(60*i)/60)+duration
    return duration

""" Parse a date and return a time object """
""" Date like  Thu, 02 02 2005 10:25:21 ... """
def strdate_to_time(odate):
    date = odate
    #removing timezone
    c = date.rfind("-")
    if c!=-1:
        date = date[:c-1]

    c = date.rfind("+")
    if c!=-1:
        date = date[:c-1]

    date = date.strip()

    c = date[-3:]
    if c in ["GMT","CST","EST","PST","EDT","PDT","MST","MDT"]:
        date = date[:-3]
    date = date.strip()

    # Remove day because some times field have incorrect string
    c = date.rfind(",")
    if c!=-1:
        date = date [c+1:]
    date = date.strip()

    #trying multiple date formats
    new_date = None

    #Set locale to C to parse date
    locale.setlocale(locale.LC_TIME, "C")

    formats = ["%d %b %Y %H:%M:%S",#without day, short month
                "%d %B %Y %H:%M:%S",#without day, full month
                "%d %b %Y",#only date , short month
                "%d %B %Y",#only date , full month
                "%b %d %Y %H:%M:%S",#without day, short month
                "%B %d %Y %H:%M:%S",#without day, full month
                "%b %d %Y",#only date , short month
                "%B %d %Y",#only date , full month
                "%b/%d/%Y",#only date
                "%b/%d/%y",#only date
                "%b-%d-%Y",#only date
                "%b-%d-%y",#only date
                "%Y",#only years
                "%y",#only years
                ]
    for format in formats:
        try: new_date = strptime(date,format)
        except : continue

    locale.setlocale(locale.LC_TIME, '')

    if not new_date: return None
    else: 
        try:
            return mktime(new_date)
        except :
            from logger import logger
            logger.exception("problem to convert %s (%s) in date format",odate,new_date)
            return None

import fcntl
import cPickle
def save_db(objs,fn):
    f = file(fn + ".tmp", "w")
    fcntl.flock(f.fileno(), fcntl.LOCK_EX)
    cPickle.dump(objs, f, cPickle.HIGHEST_PROTOCOL)
    f.close()
    os.rename(fn + ".tmp", fn)   

#@profiling
def load_db(fn):   
    objs = None
    if os.path.exists(fn):
        f = file(fn, "rb")
        objs = cPickle.load(f)
        """try: objs = cPickle.load(f)
        except:
            print _("W: %s is not a Listen database.") % fn
            try: shutil.copy(fn, fn + ".not-valid")
            except: pass
            objs = None"""
        f.close()
    return objs




""" Convert apple timestamp for ipod """
def time_unix_to_mac(time):
    return time+2082844800
def time_mac_to_unix(time):
    return time-2082844800


""" Remove accents if unicodedata module is present """
#http://wikipython.flibuste.net/moin.py/JouerAvecUnicode
_reptable = {}
def _fill_reptable():
    _corresp = [
        (u"A",  [0x00C0,0x00C1,0x00C2,0x00C3,0x00C5,0x0100,0x0102,0x0104]),
        (u"AE", [0x00C4,0x00C6]),
        (u"a",  [0x00E0,0x00E1,0x00E2,0x00E3,0x00E5,0x0101,0x0103,0x0105]),
        (u"ae", [0x00E4,0x00E6]),
        (u"C",  [0x00C7,0x0106,0x0108,0x010A,0x010C]),
        (u"c",  [0x00E7,0x0107,0x0109,0x010B,0x010D]),
        (u"D",  [0x00D0,0x010E,0x0110]),
        (u"d",  [0x00F0,0x010F,0x0111]),
        (u"E",  [0x00C8,0x00C9,0x00CA,0x00CB,0x0112,0x0114,0x0116,0x0118,0x011A]),
        (u"e",  [0x00E8,0x00E9,0x00EA,0x00EB,0x0113,0x0115,0x0117,0x0119,0x011B]),
        (u"G",  [0x011C,0x011E,0x0120,0x0122]),
        (u"g",  [0x011D,0x011F,0x0121,0x0123]),
        (u"H",  [0x0124,0x0126]),
        (u"h",  [0x0125,0x0127]),
        (u"I",  [0x00CC,0x00CD,0x00CE,0x00CF,0x0128,0x012A,0x012C,0x012E,0x0130]),
        (u"i",  [0x00EC,0x00ED,0x00EE,0x00EF,0x0129,0x012B,0x012D,0x012F,0x0131]),
        (u"IJ", [0x0132]),
        (u"ij", [0x0133]),
        (u"J",  [0x0134]),
        (u"j",  [0x0135]),
        (u"K",  [0x0136]),
        (u"k",  [0x0137,0x0138]),
        (u"L",  [0x0139,0x013B,0x013D,0x013F,0x0141]),
        (u"l",  [0x013A,0x013C,0x013E,0x0140,0x0142]),
        (u"N",  [0x00D1,0x0143,0x0145,0x0147,0x014A]),
        (u"n",  [0x00F1,0x0144,0x0146,0x0148,0x0149,0x014B]),
        (u"O",  [0x00D2,0x00D3,0x00D4,0x00D5,0x00D8,0x014C,0x014E,0x0150]),
        (u"o",  [0x00F2,0x00F3,0x00F4,0x00F5,0x00F8,0x014D,0x014F,0x0151]),
        (u"OE", [0x00D6,0x0152]),
        (u"oe", [0x00F6,0x0153]),
        (u"R",  [0x0154,0x0156,0x0158]),
        (u"r",  [0x0155,0x0157,0x0159]),
        (u"S",  [0x015A,0x015C,0x015E,0x0160]),
        (u"s",  [0x015B,0x015D,0x015F,0x01610,0x017F]),
        (u"T",  [0x0162,0x0164,0x0166]),
        (u"t",  [0x0163,0x0165,0x0167]),
        (u"U",  [0x00D9,0x00DA,0x00DB,0x0168,0x016A,0x016C,0x016E,0x0170,0x172]),
        (u"UE", [0x00DC]),
        (u"u",  [0x00F9,0x00FA,0x00FB,0x0169,0x016B,0x016D,0x016F,0x0171]),
        (u"ue", [0x00FC]),
        (u"W",  [0x0174]),
        (u"w",  [0x0175]),
        (u"Y",  [0x00DD,0x0176,0x0178]),
        (u"y",  [0x00FD,0x00FF,0x0177]),
        (u"Z",  [0x0179,0x017B,0x017D]),
        (u"z",  [0x017A,0x017C,0x017E])
        ]
    global _reptable
    for repchar,codes in _corresp :
        for code in codes :
            _reptable[code] = repchar
_fill_reptable()
def remove_accents(s):
    """Suppression des accents et autres marques.
    @param s: le texte a nettoyer.
    @type s: str ou unicode
    @return: le texte nettoye de ses marques diacritiques.
    @rtype: unicode
    """
    if isinstance(s,str) :
        s = unicode(s,"utf8","replace")
    res = []
    for c in s :
        res.append(_reptable.get(ord(c),c))
    return u"".join(res)

""" du function in python """
def du(dir, files={}):
    S_IFMT = 0170000
    S_IFDIR = 0040000
    tsz = 0

    try: fns = os.listdir(dir)
    except: return 0

    if not files.has_key(dir): files[dir] = {}
    d = files[dir]

    for fn in fns:
        try:
            fn = os.path.join(dir, fn)
    
            info = os.lstat(fn)

            if info[stat.ST_MODE] & S_IFMT == S_IFDIR:
                sz = du(fn, files) + long(info[stat.ST_SIZE])
            else:
               sz = info[stat.ST_SIZE]
            d[fn] = sz
            tsz = tsz + sz
        except:
            continue
    return tsz

def url_hook(widget,site):
    website(site)

def website(site):
    site = site.replace("\\", "\\\\").replace("\"", "\\\"")
    for s in (["gnome-open","sensible-browser"] +
              os.environ.get("BROWSER","").split(":")):
        if iscommand(s):
            if "%s" in s:
                s = s.replace("%s", '"' + site + '"')
                s = s.replace("%%", "%")
            else: s += " \"%s\"" % site
            if os.system(s + " &") == 0: return True
    else: return False

def iscommand(s):
    """True if 's' exists in the user's path, or is a fully-qualified
    existing path."""

    if s == "" or os.path.sep in s:
        return os.path.exists(s)
    else:
        s = s.split()[0]
        for p in os.environ["PATH"].split(os.path.pathsep):
            p2 = os.path.join(p, s)
            if os.path.exists(p2): return True
        else: return False

# http://aspn.activestate.com/ASPN/Cookbook/Python/Recipe/438823
# for vim dict to odict:
# s/^[[:space:]]*\([^:]*\):\([^,]*\).*/MY_DICT[\1] = \2
class odict(dict):

    def __init__(self, d={}):
        self._keys = d.keys()
        dict.__init__(self, d)

    def __delitem__(self, key):
        dict.__delitem__(self, key)
        self._keys.remove(key)

    def __setitem__(self, key, item):
        dict.__setitem__(self, key, item)
        # a peculiar sharp edge from copy.deepcopy
        # we'll have our set item called without __init__
        if not hasattr(self, '_keys'):
            self._keys = [key,]
        if key not in self._keys:
            self._keys.append(key)

    def clear(self):
        dict.clear(self)
        self._keys = []

    def items(self):
        items = []
        for i in self._keys:
            items.append(i, self[i])
        return items

    def keys(self):
        return self._keys

    def popitem(self):
        if len(self._keys) == 0:
            raise KeyError('dictionary is empty')
        else:
            key = self._keys[-1]
            val = self[key]
            del self[key]
            return key, val

    def setdefault(self, key, failobj = None):
        dict.setdefault(self, key, failobj)
        if key not in self._keys:
            self._keys.append(key)

    def update(self, d):
        for key in d.keys():
            if not self.has_key(key):
                self._keys.append(key)
        dict.update(self, d)

    def values(self):
        v = []
        for i in self._keys:
            v.append(self[i])
        return v

    def move(self, key, index):

        """ Move the specified to key to *before* the specified index. """

        try:
            cur = self._keys.index(key)
        except ValueError:
            raise KeyError(key)
        self._keys.insert(index, key)
        # this may have shifted the position of cur, if it is after index
        if cur >= index: cur = cur + 1
        del self._keys[cur]

    def index(self, key):
        if not self.has_key(key):
            raise KeyError(key)
        return self._keys.index(key)

    def __iter__(self):
        for k in self._keys:
            yield k
