# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###

import gobject, gtk, pango
from time import time

from widget.view import MultiDragTreeview
from widget.song_view import SortableSongView
from widget.misc import ScrolledWindow
from widget.cover import PopupWindowCoverButton, CoverButton
from widget.song_menu import SongMenu
from widget.preference import BrowserColumnDialog

import utils
from config import config

from helper import Dispatcher, SignalContainer
from library import ListenDB, ListenDBQuery
from cover_manager import CoverManager
from logger import Logger

try: import sexy
except: sexy = None

UNKNOWN = "<i>"+utils.xmlescape(_("Unknown"))+"</i>"
KEY_UNKNOWN = u'\xff\xff\xff\xff'
KEY_ALL = u''

class BaseColumnTag(gtk.TreeViewColumn):
    def __init__(self,name):
        gtk.TreeViewColumn.__init__(self)
        label = gtk.Label(name)
        self.set_widget(label)
        label.show()

    def get_button(self):
        return self.get_widget().get_ancestor(gtk.Button)     

class BrowserColumnTag(BaseColumnTag):
    def __init__(self,name):
        BaseColumnTag.__init__(self,name)
        r = gtk.CellRendererText()
        r.set_property("xalign",0)
        r.set_property("ellipsize",pango.ELLIPSIZE_END)
        self.pack_start(r, expand=True)
        self.add_attribute(r,"markup",2)
        self.set_clickable(True)

    
    def get_button(self):
        return self.get_widget().get_ancestor(gtk.Button)

class BrowserColumnPixbuf(BaseColumnTag):
    def __init__(self):
        BaseColumnTag.__init__(self,'')
        r = gtk.CellRendererPixbuf()
        self.pack_start(r)
        self.add_attribute(r,"pixbuf",4)

        

class BrowserTagView(MultiDragTreeview,Logger):
    def __set_model(self):
        if self.__tag == "album":
            self.__model = gtk.ListStore(str,int,str,str,gtk.gdk.Pixbuf)
        else:
            self.__model = gtk.ListStore(str,int,str,str)

    def __set_columns(self):
        if self.__tag == "album":
            self.append_column(BrowserColumnPixbuf())
        self.append_column(BrowserColumnTag(self.__labels))

    def __init__(self,tag,label,labels):
        self.__label = label
        self.__labels = labels
        self.__tag = tag
        super(BrowserTagView,self).__init__()

        self.__set_model()
        self.__set_columns()

        self.set_search_column(3)

        self.set_rules_hint(False)

        self.set_model(self.__model)
        self.get_selection().set_mode(gtk.SELECTION_MULTIPLE)


        iter = self.__model.insert(0, self.__get_tuple(KEY_ALL, "<b>%d %s</b>"%(0,self.__label), 0, None, None, escape = False) )
        self.__ref_rows = {}
        [ self.__ref_rows.update({unicode(row[0]):row.path}) for row in self.__model ]
        
    def __get_tuple(self,key,value,nb,playcount,duration,escape = True):
        if self.__tag == "album":
            extra = CoverManager.get_pixbuf_from_album(value)
            if duration: duration = " - "+utils.duration_to_string(duration)
            else: duration = ""
            if nb == 0 : str_song = _("song")
            else: str_song = _("songs")
            if escape: value = utils.xmlescape(value)
            return (key,nb,"<b>%s</b>\n<i>%d %s%s</i>"%(value,nb,str_song,duration) , value.lower(), extra )
        else:
            if escape: value = utils.xmlescape(value)
            return (key,nb,"%s (%d)"%(value,nb) , value.lower() )
    
    def update_tag_value(self,_dicts):
        if not _dicts: return 

        self.set_model(None)
        path_to_del = []

        for key, value in _dicts.iteritems():
            if value is None:
                try: path_to_del.append(self.__ref_rows[key])
                except KeyError: self.logerror("failed remove %s from %s browser model",key,self.__tag)
            else:
                playcount = None
                duration = None
                if len(value) == 2:
	                value ,nb = value
                else:
                    value , playcount, duration, songs = value
                    nb = len(songs)
                if not value:
                    value = UNKNOWN
                    escape = False
                else:
                    escape = True

                if not self.__ref_rows.has_key(key):
                    self.__model.append( self.__get_tuple(key,value,nb,playcount, duration, escape = escape) )
                else:
                    self.__model[self.__ref_rows[key]] = self.__get_tuple(key,value,nb,playcount,duration, escape = escape)

        path_to_del.sort()
        path_to_del.reverse()
        for path in path_to_del:
            del self.__model[path]

        self.__ref_rows = {}
        new_order = [ (unicode(row[0]) , row.path[0], self.__ref_rows.update({unicode(row[0]):row.path} ))  for row in self.__model ]
        new_order.sort()
        new_order = [ path for __ , path, __ in new_order ]
        self.__model.reorder(new_order)

        self.__ref_rows = {}
        [ self.__ref_rows.update({unicode(row[0]):row.path}) for row in self.__model ]

        total = sum([ row[1] for row in self.__model if row[0] != KEY_ALL])
        nb_keys = len(self.__ref_rows) - 1
        if nb_keys > 1 : label = self.__labels
        else: label = self.__labels

        self.__model[self.__ref_rows[KEY_ALL]] =  self.__get_tuple(KEY_ALL, "<b>%d %s</b>"%(nb_keys, label), total,None,None, escape = False)
        

        self.set_model(self.__model)

    def set_tag_value(self,_dict):
        self.__ref_rows = {}
        self.set_model(None)
        self.__model.clear()

        total = 0
        keys = _dict.keys()
        keys.sort()
        for key in keys:
            playcount = None
            duration = None
            if len(_dict[key]) == 2:
                value, nb = _dict[key]
            else:
                value, playcount, duration, songs = _dict[key]
                nb = len(songs)
            if not value: 
                value = UNKNOWN
                escape = False
            else:
                escape = True
            total += nb
            self.__model.append( self.__get_tuple(key,value,nb,playcount,duration, escape = escape) )
        
        nb_keys = len(_dict)
        if nb_keys > 1 : label = self.__labels
        else: label = self.__label
        self.__model.insert(0, self.__get_tuple(KEY_ALL, "<b>%d %s</b>"%(nb_keys, label), total, None, None, escape = False) )
        [ self.__ref_rows.update({unicode(row[0]):row.path}) for row in self.__model ]

        self.set_model(self.__model)

    def select_tags(self,keys):
        treesel = self.get_selection()
        keys = [ (key,self.__ref_rows[key], treesel.select_path(self.__ref_rows[key] )) for key in keys if self.__ref_rows.has_key(key) ]
        if not keys: 
            treesel.select_path(0)
            self.scroll_to_cell(0)
        else:
            keys.sort()
            self.scroll_to_cell(keys[0][1])
        return [ key for key, __,__ in keys ]


class Browser(gtk.VBox,SignalContainer,Logger):
    have_song_list_notebook = True
    def __init__(self, db_query, tree_song, conf_prefix,cover=False,edit_cover=True):
        gtk.VBox.__init__(self)
        SignalContainer.__init__(self)
        
        self.conf_prefix = conf_prefix

        self.__db_query = db_query

        #self.__db_query.set_cache_func_song_tuple(tree_song.get_model().get_tuple)
        #tree_song.get_model().set_get_tuple_func(self.__db_query.get_song_tuple_from_cache)

        self.connect("destroy",self.on_destroy)
        self.pane = gtk.VPaned()
        hbox = gtk.HBox(True,4)

        self.__id_search = None
        self._labels = {
            "genre": _("Genre"),
            "artist": _("Artist"),
            "album": _("Album"),
            "genres": _("Genres"),
            "artists": _("Artists"),
            "albums": _("Albums")
            }
        self._tree = {}; 
        self.__selected_tag = {}
        self.__id_changed_signal = {}
        self.__scroll_adj = {}

        for col,tag,label,labels in self.get_cols(True):
            self.__selected_tag[tag] = []

            self._tree[tag] = BrowserTagView(tag,label,labels)
            
            self.autoconnect_after(self._tree[tag],"row-activated",self.__on_row_activated,tag)

            self.__id_changed_signal[tag] = self._tree[tag].get_selection().connect("changed", self.__on_selection,tag)

            def save_adjustement(tree, hadjustment, vadjustment):
                if vadjustment: self.__scroll_adj[tag] = vadjustment.get_value()
            self.autoconnect(self._tree[tag],"set-scroll-adjustments",save_adjustement)

            self.autoconnect(self._tree[tag],"popup-menu",self.__popup_menu,tag)
            self.autoconnect(self._tree[tag],"popup-empty-menu",self.__popup_empty_menu,tag)
            targets = [("text/listen-songs", gtk.TARGET_SAME_APP, 1),("text/uri-list", 0, 2)]
            self._tree[tag].drag_source_set(
                gtk.gdk.BUTTON1_MASK, targets,
                gtk.gdk.ACTION_COPY)
            self.autoconnect(self._tree[tag],"drag-data-get", self.__on_drag_data_get, tag)
            #for column in self._tree[tag].get_columns():
            #    button = column.get_button()
            #    button.connect("button-press-event",self.__button_pressed)

            hbox.pack_start(ScrolledWindow(self._tree[tag]))

        hbox.show_all()
        hbox.set_no_show_all(True)

        self._tree["songs"] = tree_song

        if False:
            song_list_notebook = gtk.Notebook()
            song_list_notebook.append_page(ScrolledWindow(self._tree["songs"]),gtk.Label(_("Track list")))

            if self.have_song_list_notebook:
                from widget.webinfo.wikipedia import WikiBox
                self.__wiki_box = WikiBox()
                song_list_notebook.append_page(self.__wiki_box,gtk.Label(_("Wikipedia")))
            else:
                song_list_notebook.set_property("show-tabs",False)
            song_list_notebook.set_property("show-border",False)
            song_list_notebook.set_property("tab-pos",gtk.POS_TOP)
        else:
            song_list_notebook = ScrolledWindow(self._tree["songs"])

        self.pane.pack1(hbox,False,True)
        self.pane.pack2(song_list_notebook,True,False)
        self.pane.child_set_property(hbox,"resize",True)
        self.pane.child_set_property(song_list_notebook,"resize",True)
        self.pane.compute_position(-1,200,250)
        try:
            pos = int(config.get("browser",self.conf_prefix+"_pos"))
            self.pane.set_position(pos)
        except: 
            self.__pane_percent = 50
            self.pane.set_position(120)

        self.pane.connect("notify::position",self.__on_pane_move)

        self.expander = gtk.Expander()

        
        self.autoconnect(self.expander,"notify::expanded",self.on_browser_expand)
        l = gtk.Label(_("Hide browser"))
        l.set_alignment(0,0.5)
        l.set_size_request(-1,22)
        self.expander.set_label_widget(l)

        label_search = gtk.Label(_("Search")+" : ")
        label_search.set_alignment(1,0.5)
        label_search.show()
        
        if sexy:
            self.search_entry = sexy.IconEntry()
            self.search_entry.set_icon(sexy.ICON_ENTRY_PRIMARY,gtk.image_new_from_stock(gtk.STOCK_FIND,gtk.ICON_SIZE_BUTTON))
            self.search_entry.add_clear_button()
        else:
            self.search_entry = gtk.Entry()
            
        self.__cur_query_filter = ""
        self.autoconnect(self.search_entry,"changed",self.on_search_changed)
        self.box_search = gtk.HBox(False,6)
        
        if not sexy:
            self.box_search.pack_start(label_search,False,False)
        self.box_search.pack_start(self.search_entry,True,True)
        if not sexy:
            btn_clear = gtk.Button()
            btn_clear.add(gtk.image_new_from_stock(gtk.STOCK_CLEAR, gtk.ICON_SIZE_MENU))
            btn_clear.set_size_request(28,28)
            btn_clear.set_relief(gtk.RELIEF_NONE)
            self.autoconnect(btn_clear,"clicked",lambda widget:self.search_entry.set_text(""))    
            self.box_search.pack_start(btn_clear,False,False)
        

        top_box = gtk.HBox(False,50)
        top_box.pack_start(self.expander,False,False)
        top_box.pack_start(self.box_search,True,True)
        self.pack_start(top_box,False,False)
        self.pack_start(self.pane,True,True)
        self.set_spacing(6)


        # Configuration
        for tag in ["genre","artist","album"]:
            self.__selected_tag[tag] = []

        for col,tag,label,labels in self.get_cols():
            try: values = config.get("browser",self.conf_prefix+"_"+col+"_last_selected")
            except : values = None
            else: 
                values = values.strip()
                if values and values.find("<#>") != -1: values = values.split("<#>")
                elif values: values = [ values ]
            if values: self.__selected_tag[tag] = values
        
        try:
            expanded = config.get("browser",self.conf_prefix) == "true"
        except :
            self.expander.set_expanded(True)
        else:
            if expanded:
                self.expander.set_expanded(True)
            else:
                self.expander.set_expanded(False)
        self.on_browser_expand(self.expander)
        
        rc_style = self.search_entry.rc_get_style()
        self.entry_active_style = rc_style.copy()
        self.entry_active_style.base[ gtk.STATE_NORMAL] = rc_style.base[gtk.STATE_SELECTED] 
        self.entry_active_style.text[ gtk.STATE_NORMAL] = rc_style.text[gtk.STATE_SELECTED]
        self.entry_active_style.base[ gtk.STATE_ACTIVE] = rc_style.base[gtk.STATE_NORMAL]
        self.entry_active_style.text[ gtk.STATE_ACTIVE] = rc_style.text[gtk.STATE_NORMAL]
        base = rc_style.base[gtk.STATE_ACTIVE]
        text = rc_style.text[gtk.STATE_ACTIVE]
        base.red = min(base.red * 2,65535)
        base.green = min(base.green * 2,65535)
        base.blue = min(base.blue * 2,65535)
        self.entry_active_style.base[ gtk.STATE_SELECTED] = base
        #self.entry_active_style.base[ gtk.STATE_SELECTED] = rc_style.base[gtk.STATE_ACTIVE]
        self.entry_active_style.text[ gtk.STATE_SELECTED] = rc_style.text[gtk.STATE_ACTIVE]

        try: text = config.get("browser",self.conf_prefix+"_last_search")
        except: text = ""
        self.search_entry.set_text(text)

        self.menu = None
        self.empty_menu = None
        self.set_visible_pane(False)

    def __button_pressed(self, widget, event):
        BrowserColumnDialog(self.conf_prefix)    

    def get_cols(self,all=False):
        if all:
            view=2
        else:
            view = int(config.get("browser","view"))
        if view==0:
            tags = ["artist","album"]
        if view==1:
            tags = ["genre","artist"]
        if view==2:
            tags = ["genre","artist","album"]
        cols = [ ("col"+str(i) , tag , _(tag.capitalize()) , _(tag.capitalize()+"s") ) for (i,tag) in enumerate(tags) ]
        return cols

        for index in range(int(config.get("browser",self.conf_prefix+"_num_cols"))):
            prefix = self.conf_prefix+"_col"+str(index)+"_"
            cols.append(("col"+str(index),config.get("browser",prefix+"tag"),config.get("browser",prefix+"label")))
        return cols


    def get_list_tag(self):
        tags = [ tag for col, tag , label, labels in self.get_cols() ]
        return tags

    def __get_next_tag(self,previous_tag):
        tags = self.get_list_tag()
        tag = tags.pop(0)
        while tag!=previous_tag:
            tag = tags.pop(0)
        return tags

    def connect_to_db(self):
        self.autoconnect(self.__db_query,"added",self.__added_song_cb)
        self.autoconnect(self.__db_query,"removed",self.__removed_song_cb)
        self.autoconnect(self.__db_query,"update-tag",self.__update_tag_view)
        self.autoconnect(self.__db_query,"full-update",self.__full_update)
        self.autoconnect(self.__db_query,"quick-update",self.__quick_update)
        self.autoconnect(config, "config-changed",self.config_watcher)    
        self.logdebug("db connected, apply query filter")
        self.__db_query.set_query(self.__cur_query_filter)

    """ save browser configuration """
    def save_config(self):
        if self._tree["songs"]:
            self._tree["songs"].save_config()
 
        for col,tag,label,labels in self.get_cols():
            config.set("browser",self.conf_prefix+"_"+col+"_last_selected","<#>".join(self.__selected_tag[tag]))

    def config_watcher(self,helper,section,option,value):
        if section=="browser" and option == "view":
            self.set_visible_pane()

    def set_visible_pane(self,reload=True):
        tags = self.get_list_tag()
        for tag, tree in self._tree.iteritems():
            if tag!="songs":
                if tag in tags:
                    tree.get_parent().show()
                else:
                    tree.get_parent().hide()
                    self.__selected_tag[tag] = []

        if reload: self.reload_browser()

    def get_infos_from_db(self,tag,values=None):
        extended = ( tag == "album" )
        return self.__db_query.get_info(tag, self.__selected_tag["genre"], self.__selected_tag["artist"],values,extended)

#    @utils.profiling
    def reload_browser(self,tags=None):
        if tags is None: tags = self.get_list_tag()

        for tag in tags:
            #deb = time()
            self._tree[tag].set_tag_value(self.get_infos_from_db(tag))
            #print "get tag, ", time() - deb
            #deb = time()
            self.__block(tag)
            self.__selected_tag[tag] = self._tree[tag].select_tags(self.__selected_tag[tag])
            self.__unblock(tag)
            #print "render tag, ", time() - deb

        if self._tree["songs"] and self._tree["songs"].get_model():
            model = self._tree["songs"].get_model()
            self._tree["songs"].set_model(None)
            model.clear()
            #deb = time()
            songs = self.__get_selected_songs()
            model.append_songs(songs)
            self._tree["songs"].set_model(model)
            #print time() - deb

    def __full_update(self,db_query):
        self.reload_browser()

    def __quick_update(self,db_query,songs):
        if songs: 
            self._tree["songs"].get_model().change_songs(songs)
            return 

            # Not need db_query emit signal update-tag as needed for quick-update
            tags = self.get_list_tag()
            for tag in tags:
                values = [ song.get_sortable(tag) for song in songs ]
                self.__update_tag_view(db_query, tag, values)
        
    def __update_tag_view(self, db_query, tag, values):
        if not self._tree.has_key(tag): return
        self._tree[tag].update_tag_value(self.get_infos_from_db(tag, values))
        self.__block(tag)
        self.__selected_tag[tag] = self._tree[tag].select_tags(self.__selected_tag[tag])
        self.__unblock(tag)

    def __filter_on_selection(self,songs):
        tags = self.get_list_tag()
        filtered_songs = []
        for song in songs:
            for tag in tags:
                if self.__selected_tag[tag] and song.get_sortable(tag) not in self.__selected_tag[tag]:
                    break
            else:
                filtered_songs.append(song)
        return filtered_songs

    def __removed_song_cb(self,db_query,songs):
        if songs: 
            self._tree["songs"].get_model().remove_songs(songs)
        if not len(self._tree["songs"]): 
            gobject.idle_add(self.reload_browser)

    def __added_song_cb(self,db_query, songs):
        songs = self.__filter_on_selection(songs)
        if songs: self._tree["songs"].get_model().append_songs(songs)

    def on_search_changed(self,entry):
        text = entry.get_text()
        if text.strip():
            entry.set_style(self.entry_active_style.copy())
        else: 
            entry.set_style(None)

        config.set("browser",self.conf_prefix+"_last_search",text)

        try: gobject.source_remove(self.__id_search)
        except: pass
        self.__id_search = gobject.timeout_add(500, self.__on_search_changed_cb , text)

    def __on_search_changed_cb(self,text):
        self.__cur_query_filter = text
        #self.__db_query.empty()
        #self.reload_browser()
        self.logdebug("search change, apply new query filter")
        self.__db_query.set_query(self.__cur_query_filter)
        return False

    def __on_selection(self,treesel,tag):
        model,rows = treesel.get_selected_rows()
        if not rows:
            return 

        keys = [unicode(model[row[0]][0]) for row in rows]
        if "" in keys: keys = []
    
        self.__selected_tag[tag] = keys
        #gobject.idle_add(self.__on_selection_cb,tag,keys)
        self.reload_browser(self.__get_next_tag(tag))

    def __on_selection_cb(self,tag,keys):
        self.reload_browser(self.__get_next_tag(tag))

        if self.have_song_list_notebook:
            self.__wiki_box.force_select(None,list(self.__get_selected_songs())[0])

    def __get_selected_songs(self, tag="album"):
        artists = []
        albums = []
        genres = []
        if tag in ["genre","artist","album"]:
            genres = self.__selected_tag["genre"]
        if tag in ["artist","album"]:
            artists = self.__selected_tag["artist"]
        if tag in ["album"]:
            albums = self.__selected_tag["album"]

        return self.__db_query.get_songs(genres, artists, albums)

    def __on_row_activated(self,treeview, path, view_column,tag):
        songs = list(self.__get_selected_songs(tag))
        songs.sort()
        Dispatcher.cur_playlist_play(songs)

    def __on_drag_data_get(self,treeview, context, selection, info, timestamp, tag):
        model,rows = treeview.get_selection().get_selected_rows()
        if len(rows)<0: return
        songs = list(self.__get_selected_songs(tag))
        songs.sort()
        list_uri = list([ song.get("uri") for song in songs])
        selection.set("text/listen-songs", 8, "\n".join(list_uri))
        selection.set_uris(list_uri)

    def __block(self,tag):
        self._tree[tag].get_selection().handler_block(self.__id_changed_signal[tag])
        
    def __unblock(self,tag):
        self._tree[tag].get_selection().handler_unblock(self.__id_changed_signal[tag])

    def __on_pane_move(self,widget,property_spec):
        if self.pane.window:
            pos = self.pane.get_position()
            config.set("browser",self.conf_prefix+"_pos","%d"%pos)

    def set_menu(self,menu,empty_menu=None):
        self.menu = menu
        self.empty_menu = empty_menu
        
    def __popup_empty_menu(self,widget,tag):
         if self.empty_menu:
            self.empty_menu.popup([])    
            
    def __popup_menu(self,widget,tag):
        model,rows = self._tree[tag].get_selection().get_selected_rows()
        if len(rows)<0: return
        songs = self.__get_selected_songs(tag)

        if self.menu and songs:
            self.menu.popup(list(songs),custom_popup=tag, image = {"change_cover": CoverManager.get_cover( list(songs)[0], False)} )
        if self.empty_menu and not songs:
            self.empty_menu.popup([])
            
    def on_browser_expand(self,expander,*param):
        if expander.get_expanded():
            config.set("browser",self.conf_prefix,"true")
        else:
            config.set("browser",self.conf_prefix,"False")

        if expander.get_expanded():
            expander.get_label_widget().set_text(_("Hide browser"))
            self.pane.get_child1().show()
        else:
            expander.get_label_widget().set_text(_("Show browser"))
            self.pane.get_child1().hide()

    def on_destroy(self,widget):
        self.autodisconnect_all()
        for col,tag,label,labels in self.get_cols(True):
            self._tree[tag].get_selection().disconnect(self.__id_changed_signal[tag])
        if self.menu and hasattr(self.menu,"autodisconnect_all") and callable(self.menu.autodisconnect_all):
            self.menu.autodisconnect_all()
        if self.empty_menu and hasattr(self.empty_menu,"autodisconnect_all") and callable(self.empty_menu.autodisconnect_all):
            self.empty_menu.autodisconnect_all()

    def __del__(self):
        pass
        
        #from utils import print_gc
        #print_gc( self._tree["songs"])


class SimpleBrowser(Browser):
    _type = "local"
    _config_code = "local"
    _cover = False

    def __init__(self, **kwargs):
        for key, value in kwargs.items():
            if key in [ "type", "config_code", "cover" ]:
                setattr(self,"_%s"%key, value)

        tree_songs = SortableSongView(self._config_code)
        tree_songs.set_menu(self._get_songs_menu())

        Browser.__init__(self, ListenDBQuery(self._type), tree_songs, self._config_code, self._cover)

        self.set_menu(self._get_menu())
        if ListenDB.isloaded():
            self.__on_db_loaded(ListenDB)
        else:
            self.autoconnect(ListenDB,"loaded",self.__on_db_loaded)

    def _get_menu(self):
        return SongMenu(for_browser=True)

    def _get_songs_menu(self):
        return SongMenu()

    def __on_db_loaded(self,db):
        self.connect_to_db()
        
class AutoPlaylistBrowser(Browser):

    _type = None
    _songview_klass = None   
    def __init__(self,config_code,pl):
        tree_songs = self._songview_klass(config_code)
        tree_songs.set_menu(self._get_songs_menu())

        super(AutoPlaylistBrowser,self).__init__(pl,tree_songs,config_code,True)

        self.set_menu(self._get_menu())
        if ListenDB.isloaded():
            self.connect_to_db()
        else:
            self.autoconnect(ListenDB,"loaded",self.__db_loaded)
    
    def _get_songs_menu(self):
        return SongMenu()

    def _get_menu(self):
        return SongMenu(for_browser=True)

    def __db_loaded(self,db):
        self.connect_to_db()

