
 /************************************************************************
  * Copyright 2005-2006 by Freescale Semiconductor, Inc.
  * All modifications are confidential and proprietary information
  * of Freescale Semiconductor, Inc. ALL RIGHTS RESERVED.
  ************************************************************************/

//+-------------------------------------------------------------------------
//
//  Microsoft Windows Media
//
//  Copyright (C) Microsoft Corporation, 1999 - 1999
//
//  File:       wmftypes.h
//
//--------------------------------------------------------------------------

#ifndef WMATYPES_H
#define WMATYPES_H

#ifdef _MSC_VER
#define USE_PACK_HEADERS
#define PACKED
#elif defined(macintosh) || defined(HITACHI)
#define PACKED
#elif defined (_Embedded_x86)
#include "wmf_types.h"

// #define PACKED __packed

#define PACKED 

#else
// #define PACKED  __packed

#define PACKED  
#endif

#ifdef USE_PACK_HEADERS
#include <pshpack1.h>
#endif


/****************************************************************************/
#ifndef NULL
#ifdef  __cplusplus
#define NULL    0
#else
#define NULL    ((void *)0)
#endif
#endif

#if (defined(_M_MRX000) || defined(_M_ALPHA) || defined(_M_PPC) || defined(UNDER_CE)) && !defined(x86)
#define UNALIGNED __unaligned
#else
#define UNALIGNED
#endif

//#define FALSE 0
//#define TRUE  1


/****************************************************************************/
/*
#if !defined(_Embedded_x86) && !defined(HITACHI)
typedef int Bool_WMF;
typedef unsigned char   U8_WMF;
typedef unsigned short  U16_WMF;
typedef unsigned long   U32_WMF;
#endif
*/
#ifndef __LONG_DEFINED__
#define __LONG_DEFINED__
// typedef long LONG;
#endif

#ifdef _Embedded_x86
typedef unsigned long ULONG;
#define BYTE U8_WMF
#define DWORD U32_WMF
#define BOOL Bool_WMF
#endif
#ifndef __QU16_WMF_DEFINED__
#define __QU16_WMF_DEFINED__
/*
typedef PACKED struct tQU16_WMF
{
    U32_WMF   dwLo;
    U32_WMF   dwHi;

}   QU16_WMF;
*/
#endif

/****************************************************************************/
#ifndef GUID_DEFINED
#define GUID_DEFINED

typedef struct tGUID
{
    U32_WMF Data1;
    U16_WMF Data2;
    U16_WMF Data3;
    U8_WMF  Data4[ 8 ];

}	GUID;

#endif


/****************************************************************************/
#ifndef _WAVEFORMATEX_
#define _WAVEFORMATEX_



typedef struct tWAVEFORMATEX
{
	U16_WMF    	wFormatTag;         /* format type */
	U16_WMF    	nChannels;          /* number of channels (i.e. mono, stereo...) */
	U32_WMF   	nSamplesPerSec;     /* sample rate */
	U32_WMF   	nAvgBytesPerSec;    /* for buffer estimation */
	U16_WMF    	nBlockAlign;        /* block size of data */
	U16_WMF    	wBitsPerSample;     /* number of bits per sample of mono data */
	U16_WMF    	cbSize;             /* the count in bytes of the size of */
	U8_WMF		aExtraData[16];

}   WAVEFORMATEX, *PWAVEFORMATEX, *NPWAVEFORMATEX, *LPWAVEFORMATEX;
typedef const WAVEFORMATEX *LPCWAVEFORMATEX;

#endif


#ifdef _Embedded_x86
#ifndef _BITMAPINFOHEADER
#define _BITMAPINFOHEADER
typedef struct tagBITMAPINFOHEADER{
        U32_WMF      biSize;
        LONG       biWidth;
        LONG       biHeight;
        U16_WMF       biPlanes;
        U16_WMF       biBitCount;
        U32_WMF      biCompression;
        U32_WMF      biSizeImage;
        LONG       biXPelsPerMeter;
        LONG       biYPelsPerMeter;
        U32_WMF      biClrUsed;
        U32_WMF      biClrImportant;
} BITMAPINFOHEADER, *LPBITMAPINFOHEADER;

#endif
#ifndef _COLORSCHEME
#define _COLORSCHEME
#define BI_RGB	0
#define BI_BITFIELDS  3L
#endif
#define INT int
#define LPVOID void*
#define FALSE 0
#define FAILED(Status) ((HRESULT)(Status)<0)

#endif



#define WAVE_FORMAT_MSAUDIO1  0x0160
typedef struct tMSAUDIO1WAVEFORMAT
{
    WAVEFORMATEX wfx;
    U16_WMF         wSamplesPerBlock;
    U16_WMF         wEncodeOptions;

}   MSAUDIO1WAVEFORMAT;

#define WAVE_FORMAT_WMAUDIO2  0x0161
typedef struct tWMAUDIO2WAVEFORMAT
{
    WAVEFORMATEX wfx;
    U32_WMF        dwSamplesPerBlock;
    U16_WMF         wEncodeOptions;
    U32_WMF        dwSuperBlockAlign;

}   WMAUDIO2WAVEFORMAT;

/****************************************************************************/


typedef struct tAsfXAcmAudioErrorMaskingData
{
    U8_WMF    span;
    U16_WMF    virtualPacketLen;
    U16_WMF    virtualChunkLen;
    U16_WMF    silenceLen;
    U8_WMF    silence[1];

}   AsfXAcmAudioErrorMaskingData;


/****************************************************************************/
typedef struct tAsfXSignatureAudioErrorMaskingData
{
    U32_WMF maxObjectSize;
    U16_WMF  chunkLen;
    U16_WMF  signatureLen;
    U8_WMF  signature[1];

}   AsfXSignatureAudioErrorMaskingData;
/****************************************************************************/
// Added by Amit on 02/24/00 for Video Parsing
typedef struct tAsfXGenericImageTypeSpecific
{
 //   enum {
   //     PROGRESSIVE_FIRST_IMAGE = 1,
 //       BITMAPINFO_PRESENT = 2,
 //   };

    U32_WMF       windowWidth;
    U32_WMF       windowHeight;
    U8_WMF        flags;
    U16_WMF        imageInfoLen;
    U8_WMF        imageInfo[1];
}AsfXGenericImageTypeSpecific;

/****************************************************************************/
typedef struct tPACKET_PARSE_INFO_EX
{
    Bool_WMF fParityPacket;
    U32_WMF cbParseOffset;

    Bool_WMF fEccPresent;
    U8_WMF bECLen;

    U8_WMF bPacketLenType;
    U32_WMF cbPacketLenTypeOffset;

    U8_WMF bPadLenType;
    U8_WMF bSequenceLenType;

    Bool_WMF fMultiPayloads;

    U8_WMF bOffsetBytes;

    U8_WMF bOffsetLenType;

    U32_WMF cbPacketLenOffset;

    U32_WMF cbExplicitPacketLength;

    U32_WMF cbSequenceOffset;

    U32_WMF dwSequenceNum;

    U32_WMF cbPadLenOffset;
    U32_WMF cbPadding;

    U32_WMF dwSCR;
    U16_WMF wDuration;

    U8_WMF bPayLenType;
    U8_WMF bPayBytes;
    U32_WMF cbPayLenTypeOffset;

    U32_WMF cPayloads;

}   PACKET_PARSE_INFO_EX;


/****************************************************************************/
typedef struct tPAYLOAD_MAP_ENTRY_EX
{
    U16_WMF cbPacketOffset;
    U16_WMF cbTotalSize;

    U8_WMF bStreamId;
    U8_WMF bObjectId;

    U32_WMF cbObjectOffset;
    U32_WMF cbObjectSize;
    U32_WMF msObjectPres;

    U8_WMF cbRepData;
    U8_WMF bJunk;
    U16_WMF cbPayloadSize;
	U8_WMF bIsKeyFrame;
	U8_WMF bFrameRate;
	U16_WMF wTotalDataBytes;
	U32_WMF dwDeltaPresTime;


}   PAYLOAD_MAP_ENTRY_EX;


#ifdef USE_PACK_HEADERS
#include <poppack.h>
#endif

#endif  /* WMATYPES_H */
