/*
 * Copyright 2009 Canonical Ltd.
 * 
 * This program is free software: you can redistribute it and/or modify it 
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the 
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by 
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the applicable version of the GNU Lesser General Public 
 * License for more details.
 * 
 * You should have received a copy of both the GNU Lesser General Public 
 * License version 3 and version 2.1 along with this program.  If not, see 
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _GADGET_SOURCE_H_
#define _GADGET_SOURCE_H_

#include <glib.h>
#include <glib-object.h>
#include <libgadget/gadget-proxy.h>

G_BEGIN_DECLS

#define GADGET_TYPE_SOURCE (gadget_source_get_type ())

#define GADGET_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
        GADGET_TYPE_SOURCE, GadgetSource))

#define GADGET_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
      	GADGET_TYPE_SOURCE, GadgetSourceClass))

#define GADGET_IS_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
        GADGET_TYPE_SOURCE))

#define GADGET_SOURCE_IS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), \
        GADGET_TYPE_SOURCE))

#define GADGET_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
        GADGET_TYPE_SOURCE, GadgetSourceClass))

typedef struct _GadgetSource        GadgetSource;
typedef struct _GadgetSourceClass   GadgetSourceClass;
typedef struct _GadgetSourcePrivate GadgetSourcePrivate;

#define GADGET_SOURCE_INIT_SYMBOL "gadget_source_module_init"
typedef GadgetSource * (*gadget_source_module_init_t) (void);
 
struct _GadgetSource
{
  GObject parent;	

  GadgetSourcePrivate *priv;
};

struct _GadgetSourceClass
{
  /*< private >*/
  GObjectClass  parent_class;

  /*< public >*/
  
  /* signals, not vfuncs */
  
  /* vtable */
  gboolean      (*can_handle_path) (GadgetSource *self,
                                    const gchar  *path);

  GadgetProxy * (*load_gadget)     (GadgetSource *self,
                                    const gchar  *path,
                                    const gchar  *uid);

  GList       * (*get_available_gadgets) (GadgetSource *self);
  
  /*< private >*/
  /* padding */
  void (*_gadget_source_padding1) (void);
  void (*_gadget_source_padding2) (void);
  void (*_gadget_source_padding3) (void);
  void (*_gadget_source_padding4) (void);
  void (*_gadget_source_padding5) (void);
  void (*_gadget_source_padding6) (void);
};

GType gadget_source_get_type (void) G_GNUC_CONST;

const gchar * gadget_source_get_name (GadgetSource *self);

void          gadget_source_set_name (GadgetSource *self,
                                      const gchar  *name);

const gchar * gadget_source_get_icon (GadgetSource *self);

void          gadget_source_set_icon (GadgetSource *self,
                                      const gchar  *icon_name);

gboolean      gadget_source_can_handle_path (GadgetSource *self,
                                             const gchar  *icon_name);

GadgetProxy  * gadget_source_load_gadget     (GadgetSource *self,
                                             const gchar  *path,
                                             const gchar  *uid);

GList        * gadget_source_get_available_gadgets (GadgetSource *self);

G_END_DECLS

#endif /* _GADGET_SOURCE_H_ */

