/*
 * Copyright(C) 2010 Neil Jagdish Patel
 * Copyright(C) 2010 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 * Authored by Ken VaDine <ken.vandine@canonical.com>
 */

[DBus (name = "com.Gwibber.URLShorten")]
private interface URLShortenInterface : Object {
        public abstract string Shorten (string url) throws DBus.Error;
}

namespace Gwibber
{
    public class URLShorten : Object
    {
        private const string url_name  = "com.Gwibber.URLShorten";
        private const string url_path  = "/com/gwibber/URLShorten";
        private const string url_iface = "com.Gwibber.URLShorten";

        private URLShortenInterface url_service;
	private Gwibber.Utils utils;

	/** 
            URLShorten::is_available:
            @arg0: The current state

            Emitted when com.Gwibber.URLShorten availability state changes
	*/
	public signal void is_available(bool is_up);

	public URLShorten ()
	{
	}

        construct
        {
            try
            {
                var dbus_conn = DBus.Bus.get(DBus.BusType.SESSION);

                this.url_service = (URLShortenInterface) dbus_conn.get_object(this.url_name,
                                                               this.url_path,
                                                               this.url_iface);                                                               
		this.utils = new Gwibber.Utils();
		this.utils.setup(this.url_name);
		this.utils.available.connect(this.url_available);
            }
            catch (GLib.Error e)
            {
                warning ("Unable to get Gwibber URLShorten");
            }
        }


        /**
         * com.Gwibber.URLShorten
         **/
        public string shorten(string url)
        {
            try
            {
                return this.url_service.Shorten(url);
            }
            catch (DBus.Error e)
            {
                warning (e.message);
                return "Failed";
            }
        }   

	public void url_available(bool is_up)
	{
		this.is_available(is_up);
	}
    }
}
