/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.expectation;

import java.lang.reflect.Constructor;
import org.mockito.stubbing.OngoingStubbing;
import org.powermock.api.mockito.expectation.WithOrWithoutExpectedArguments;
import org.powermock.api.mockito.internal.expectation.DefaultConstructorExpectationSetup;

public class ConstructorAwareExpectationSetup<T>
implements WithOrWithoutExpectedArguments<T> {
    private final Constructor<T> ctor;

    public ConstructorAwareExpectationSetup(Constructor<T> constructor) {
        if (constructor == null) {
            throw new IllegalArgumentException("Constructor to expect cannot be null");
        }
        this.ctor = constructor;
    }

    @Override
    public OngoingStubbing<T> withArguments(Object object, Object ... objectArray) throws Exception {
        return this.setupExpectation().withArguments(object, objectArray);
    }

    @Override
    public OngoingStubbing<T> withNoArguments() throws Exception {
        return this.setupExpectation().withNoArguments();
    }

    private DefaultConstructorExpectationSetup<T> setupExpectation() {
        DefaultConstructorExpectationSetup<T> defaultConstructorExpectationSetup = new DefaultConstructorExpectationSetup<T>(this.ctor.getDeclaringClass());
        defaultConstructorExpectationSetup.setParameterTypes(this.ctor.getParameterTypes());
        return defaultConstructorExpectationSetup;
    }
}

