/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.invocationcontrol;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import org.mockito.Mockito;
import org.mockito.exceptions.base.MockitoAssertionError;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.internal.invocationcontrol.InvocationControlAssertionError;
import org.powermock.core.MockRepository;
import org.powermock.core.spi.NewInvocationControl;
import org.powermock.core.spi.support.InvocationSubstitute;
import org.powermock.reflect.internal.WhiteboxImpl;

public class MockitoNewInvocationControl<T>
implements NewInvocationControl<OngoingStubbing<T>> {
    private final InvocationSubstitute<T> substitute;

    public MockitoNewInvocationControl(InvocationSubstitute<T> invocationSubstitute) {
        if (invocationSubstitute == null) {
            throw new IllegalArgumentException("Internal error: substitute cannot be null.");
        }
        this.substitute = invocationSubstitute;
    }

    @Override
    public Object invoke(Class<?> clazz, Object[] objectArray, Class<?>[] classArray) throws Exception {
        Constructor<?> constructor = WhiteboxImpl.getConstructor(clazz, classArray);
        if (constructor.isVarArgs()) {
            Object object = objectArray[objectArray.length - 1];
            int n = Array.getLength(object);
            Object[] objectArray2 = objectArray;
            objectArray = new Object[objectArray.length + n - 1];
            System.arraycopy(objectArray2, 0, objectArray, 0, objectArray2.length - 1);
            int n2 = objectArray2.length - 1;
            int n3 = 0;
            while (n2 < objectArray.length) {
                objectArray[n2] = Array.get(object, n3);
                ++n2;
                ++n3;
            }
        }
        try {
            return this.substitute.performSubstitutionLogic(objectArray);
        }
        catch (MockitoAssertionError mockitoAssertionError) {
            InvocationControlAssertionError.throwAssertionErrorForNewSubstitutionFailure((AssertionError)((Object)mockitoAssertionError), clazz);
            return null;
        }
    }

    @Override
    public OngoingStubbing<T> expectSubstitutionLogic(Object ... objectArray) throws Exception {
        return Mockito.when(this.substitute.performSubstitutionLogic(objectArray));
    }

    public InvocationSubstitute<T> getSubstitute() {
        return this.substitute;
    }

    @Override
    public synchronized Object replay(Object ... objectArray) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized Object verify(Object ... objectArray) {
        VerificationMode verificationMode;
        Object t = MockRepository.getAdditionalState("VerificationMode");
        if (t != null) {
            if (!(t instanceof VerificationMode)) throw new IllegalStateException("Internal error. VerificationMode in MockRepository was not of type " + VerificationMode.class.getName() + ".");
            verificationMode = (VerificationMode)t;
        } else {
            verificationMode = Mockito.times((int)1);
        }
        Mockito.verify(this.substitute, (VerificationMode)verificationMode);
        return null;
    }

    @Override
    public synchronized Object reset(Object ... objectArray) {
        Mockito.reset((Object[])new InvocationSubstitute[]{this.substitute});
        return null;
    }

    public void verifyNoMoreInteractions() {
        try {
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.substitute});
        }
        catch (MockitoAssertionError mockitoAssertionError) {
            InvocationControlAssertionError.updateErrorMessageForVerifyNoMoreInteractions((AssertionError)((Object)mockitoAssertionError));
            throw mockitoAssertionError;
        }
    }
}

