/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.support.membermodification;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.powermock.api.support.SuppressCode;
import org.powermock.api.support.membermodification.MemberMatcher;
import org.powermock.api.support.membermodification.strategy.MethodReplaceStrategy;
import org.powermock.api.support.membermodification.strategy.MethodStubStrategy;
import org.powermock.api.support.membermodification.strategy.impl.MethodReplaceStrategyImpl;
import org.powermock.api.support.membermodification.strategy.impl.MethodStubStrategyImpl;

public class MemberModifier
extends MemberMatcher {
    public static void suppress(Method method) {
        SuppressCode.suppressMethod(method);
    }

    public static void suppress(Method[] methodArray) {
        SuppressCode.suppressMethod(methodArray);
    }

    public static void suppress(Constructor<?> constructor) {
        SuppressCode.suppressConstructor(constructor);
    }

    public static void suppress(Constructor<?>[] constructorArray) {
        SuppressCode.suppressConstructor(constructorArray);
    }

    public static void suppress(Field field) {
        SuppressCode.suppressField(field);
    }

    public static void suppress(Field[] fieldArray) {
        SuppressCode.suppressField(fieldArray);
    }

    public static void suppress(AccessibleObject[] accessibleObjectArray) {
        if (accessibleObjectArray == null) {
            throw new IllegalArgumentException("accessibleObjects cannot be null");
        }
        for (AccessibleObject accessibleObject : accessibleObjectArray) {
            if (accessibleObject instanceof Constructor) {
                SuppressCode.suppressConstructor((Constructor)accessibleObject);
                continue;
            }
            if (accessibleObject instanceof Field) {
                SuppressCode.suppressField((Field)accessibleObject);
                continue;
            }
            if (!(accessibleObject instanceof Method)) continue;
            SuppressCode.suppressMethod((Method)accessibleObject);
        }
    }

    public static <T> MethodStubStrategy<T> stub(Method method) {
        return new MethodStubStrategyImpl(method);
    }

    public static MethodReplaceStrategy replace(Method method) {
        return new MethodReplaceStrategyImpl(method);
    }
}

