/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.cglib.core;

import java.util.HashMap;
import java.util.Map;
import org.mockito.asm.ClassAdapter;
import org.mockito.asm.ClassVisitor;
import org.mockito.asm.FieldVisitor;
import org.mockito.asm.MethodAdapter;
import org.mockito.asm.MethodVisitor;
import org.mockito.asm.Type;
import org.mockito.cglib.core.ClassInfo;
import org.mockito.cglib.core.CodeEmitter;
import org.mockito.cglib.core.Constants;
import org.mockito.cglib.core.Signature;
import org.mockito.cglib.core.TypeUtils;

public class ClassEmitter
extends ClassAdapter {
    private ClassInfo classInfo;
    private Map fieldInfo;
    private static int hookCounter;
    private MethodVisitor rawStaticInit;
    private CodeEmitter staticInit;
    private CodeEmitter staticHook;
    private Signature staticHookSig;

    public ClassEmitter(ClassVisitor classVisitor) {
        super(null);
        this.setTarget(classVisitor);
    }

    public ClassEmitter() {
        super(null);
    }

    public void setTarget(ClassVisitor classVisitor) {
        this.cv = classVisitor;
        this.fieldInfo = new HashMap();
        this.staticHook = null;
        this.staticInit = null;
        this.staticHookSig = null;
    }

    private static synchronized int getNextHook() {
        return ++hookCounter;
    }

    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    public void begin_class(int n, final int n2, String string, final Type type, final Type[] typeArray, String string2) {
        final Type type2 = Type.getType("L" + string.replace('.', '/') + ";");
        this.classInfo = new ClassInfo(){

            @Override
            public Type getType() {
                return type2;
            }

            @Override
            public Type getSuperType() {
                return type != null ? type : Constants.TYPE_OBJECT;
            }

            @Override
            public Type[] getInterfaces() {
                return typeArray;
            }

            @Override
            public int getModifiers() {
                return n2;
            }
        };
        this.cv.visit(n, n2, this.classInfo.getType().getInternalName(), null, this.classInfo.getSuperType().getInternalName(), TypeUtils.toInternalNames(typeArray));
        if (string2 != null) {
            this.cv.visitSource(string2, null);
        }
        this.init();
    }

    public CodeEmitter getStaticHook() {
        if (TypeUtils.isInterface(this.getAccess())) {
            throw new IllegalStateException("static hook is invalid for this class");
        }
        if (this.staticHook == null) {
            this.staticHookSig = new Signature("CGLIB$STATICHOOK" + ClassEmitter.getNextHook(), "()V");
            this.staticHook = this.begin_method(8, this.staticHookSig, null);
            if (this.staticInit != null) {
                this.staticInit.invoke_static_this(this.staticHookSig);
            }
        }
        return this.staticHook;
    }

    protected void init() {
    }

    public int getAccess() {
        return this.classInfo.getModifiers();
    }

    public Type getClassType() {
        return this.classInfo.getType();
    }

    public Type getSuperType() {
        return this.classInfo.getSuperType();
    }

    public void end_class() {
        if (this.staticHook != null && this.staticInit == null) {
            this.begin_static();
        }
        if (this.staticInit != null) {
            this.staticHook.return_value();
            this.staticHook.end_method();
            this.rawStaticInit.visitInsn(177);
            this.rawStaticInit.visitMaxs(0, 0);
            this.staticHook = null;
            this.staticInit = null;
            this.staticHookSig = null;
        }
        this.cv.visitEnd();
    }

    public CodeEmitter begin_method(int n, Signature signature, Type[] typeArray) {
        if (this.classInfo == null) {
            throw new IllegalStateException("classInfo is null! " + this);
        }
        MethodVisitor methodVisitor = this.cv.visitMethod(n, signature.getName(), signature.getDescriptor(), null, TypeUtils.toInternalNames(typeArray));
        if (signature.equals(Constants.SIG_STATIC) && !TypeUtils.isInterface(this.getAccess())) {
            this.rawStaticInit = methodVisitor;
            MethodAdapter methodAdapter = new MethodAdapter(methodVisitor){

                @Override
                public void visitMaxs(int n, int n2) {
                }

                @Override
                public void visitInsn(int n) {
                    if (n != 177) {
                        super.visitInsn(n);
                    }
                }
            };
            this.staticInit = new CodeEmitter(this, methodAdapter, n, signature, typeArray);
            if (this.staticHook == null) {
                this.getStaticHook();
            } else {
                this.staticInit.invoke_static_this(this.staticHookSig);
            }
            return this.staticInit;
        }
        if (signature.equals(this.staticHookSig)) {
            return new CodeEmitter(this, methodVisitor, n, signature, typeArray){

                @Override
                public boolean isStaticHook() {
                    return true;
                }
            };
        }
        return new CodeEmitter(this, methodVisitor, n, signature, typeArray);
    }

    public CodeEmitter begin_static() {
        return this.begin_method(8, Constants.SIG_STATIC, null);
    }

    public void declare_field(int n, String string, Type type, Object object) {
        FieldInfo fieldInfo = (FieldInfo)this.fieldInfo.get(string);
        FieldInfo fieldInfo2 = new FieldInfo(n, string, type, object);
        if (fieldInfo != null) {
            if (!fieldInfo2.equals(fieldInfo)) {
                throw new IllegalArgumentException("Field \"" + string + "\" has been declared differently");
            }
        } else {
            this.fieldInfo.put(string, fieldInfo2);
            this.cv.visitField(n, string, type.getDescriptor(), null, object);
        }
    }

    boolean isFieldDeclared(String string) {
        return this.fieldInfo.get(string) != null;
    }

    FieldInfo getFieldInfo(String string) {
        FieldInfo fieldInfo = (FieldInfo)this.fieldInfo.get(string);
        if (fieldInfo == null) {
            throw new IllegalArgumentException("Field " + string + " is not declared in " + this.getClassType().getClassName());
        }
        return fieldInfo;
    }

    @Override
    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        this.begin_class(n, n2, string.replace('/', '.'), TypeUtils.fromInternalName(string3), TypeUtils.fromInternalNames(stringArray), null);
    }

    @Override
    public void visitEnd() {
        this.end_class();
    }

    @Override
    public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
        this.declare_field(n, string, Type.getType(string2), object);
        return null;
    }

    @Override
    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        return this.begin_method(n, new Signature(string, string2), TypeUtils.fromInternalNames(stringArray));
    }

    static class FieldInfo {
        int access;
        String name;
        Type type;
        Object value;

        public FieldInfo(int n, String string, Type type, Object object) {
            this.access = n;
            this.name = string;
            this.type = type;
            this.value = object;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof FieldInfo)) {
                return false;
            }
            FieldInfo fieldInfo = (FieldInfo)object;
            if (this.access != fieldInfo.access || !this.name.equals(fieldInfo.name) || !this.type.equals(fieldInfo.type)) {
                return false;
            }
            if (this.value == null ^ fieldInfo.value == null) {
                return false;
            }
            return this.value == null || this.value.equals(fieldInfo.value);
        }

        public int hashCode() {
            return this.access ^ this.name.hashCode() ^ this.type.hashCode() ^ (this.value == null ? 0 : this.value.hashCode());
        }
    }
}

